"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataLakeBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
/**
 * @experimental
 */
class DataLakeBucket extends cdk.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.bucket = new s3.Bucket(this, 'datalake-bucket', {
            bucketName: props.bucketName,
            ...props.s3Properties,
            serverAccessLogsBucket: props.logBucket,
        });
        if (props.crossAccount) {
            this.bucket.addToResourcePolicy(new iam.PolicyStatement({
                resources: [
                    this.bucket.arnForObjects('*'),
                    this.bucket.bucketArn,
                ],
                actions: ['s3:List*', 's3:Get*'],
                principals: [
                    new iam.ArnPrincipal(`arn:aws:iam::${props.dataCatalogAccountId}:root`),
                ],
            }));
        }
    }
}
exports.DataLakeBucket = DataLakeBucket;
_a = JSII_RTTI_SYMBOL_1;
DataLakeBucket[_a] = { fqn: "@randyridgley/cdk-datalake-constructs.DataLakeBucket", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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