# mypy-boto3-swf

[![PyPI - mypy-boto3-swf](https://img.shields.io/pypi/v/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SWF 1.17.49](https://boto3.amazonaws.com/v1/documentation/api/1.17.49/reference/services/swf.html#SWF) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-swf](#mypy-boto3-swf)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `SWF` service.

```bash
python -m pip install boto3-stubs[swf]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[swf]` in your environment: `python -m pip install 'boto3-stubs[swf]'`

Both type checking and auto-complete should work for `SWF` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[swf]` in your environment: `python -m pip install 'boto3-stubs[swf]'`

Both type checking and auto-complete should work for `SWF` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[swf]` in your environment: `python -m pip install 'boto3-stubs[swf]'`
- Run `mypy` as usual

Type checking should work for `SWF` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[swf]` in your environment: `python -m pip install 'boto3-stubs[swf]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SWF` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SWFClient` provides annotations for `boto3.client("swf")`.

```python
import boto3

from mypy_boto3_swf import SWFClient

client: SWFClient = boto3.client("swf")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SWFClient = session.client("swf")
```

### Paginators annotations

`mypy_boto3_swf.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_swf import SWFClient
from mypy_boto3_swf.paginator import (
    GetWorkflowExecutionHistoryPaginator,
    ListActivityTypesPaginator,
    ListClosedWorkflowExecutionsPaginator,
    ListDomainsPaginator,
    ListOpenWorkflowExecutionsPaginator,
    ListWorkflowTypesPaginator,
    PollForDecisionTaskPaginator,
)

client: SWFClient = boto3.client("swf")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_workflow_execution_history_paginator: GetWorkflowExecutionHistoryPaginator = client.get_paginator("get_workflow_execution_history")
list_activity_types_paginator: ListActivityTypesPaginator = client.get_paginator("list_activity_types")
list_closed_workflow_executions_paginator: ListClosedWorkflowExecutionsPaginator = client.get_paginator("list_closed_workflow_executions")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_open_workflow_executions_paginator: ListOpenWorkflowExecutionsPaginator = client.get_paginator("list_open_workflow_executions")
list_workflow_types_paginator: ListWorkflowTypesPaginator = client.get_paginator("list_workflow_types")
poll_for_decision_task_paginator: PollForDecisionTaskPaginator = client.get_paginator("poll_for_decision_task")
```







### Typed dictionations

`mypy_boto3_swf.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_swf.type_defs import (
    ActivityTaskCancelRequestedEventAttributesTypeDef,
    ActivityTaskCanceledEventAttributesTypeDef,
    ActivityTaskCompletedEventAttributesTypeDef,
    ActivityTaskFailedEventAttributesTypeDef,
    ActivityTaskScheduledEventAttributesTypeDef,
    ActivityTaskStartedEventAttributesTypeDef,
    ActivityTaskTimedOutEventAttributesTypeDef,
    ActivityTypeConfigurationTypeDef,
    ActivityTypeInfoTypeDef,
    ActivityTypeTypeDef,
    CancelTimerDecisionAttributesTypeDef,
    CancelTimerFailedEventAttributesTypeDef,
    CancelWorkflowExecutionDecisionAttributesTypeDef,
    CancelWorkflowExecutionFailedEventAttributesTypeDef,
    ChildWorkflowExecutionCanceledEventAttributesTypeDef,
    ChildWorkflowExecutionCompletedEventAttributesTypeDef,
    ChildWorkflowExecutionFailedEventAttributesTypeDef,
    ChildWorkflowExecutionStartedEventAttributesTypeDef,
    ChildWorkflowExecutionTerminatedEventAttributesTypeDef,
    ChildWorkflowExecutionTimedOutEventAttributesTypeDef,
    CompleteWorkflowExecutionDecisionAttributesTypeDef,
    CompleteWorkflowExecutionFailedEventAttributesTypeDef,
    ContinueAsNewWorkflowExecutionDecisionAttributesTypeDef,
    ContinueAsNewWorkflowExecutionFailedEventAttributesTypeDef,
    DecisionTaskCompletedEventAttributesTypeDef,
    DecisionTaskScheduledEventAttributesTypeDef,
    DecisionTaskStartedEventAttributesTypeDef,
    DecisionTaskTimedOutEventAttributesTypeDef,
    DomainConfigurationTypeDef,
    DomainInfoTypeDef,
    ExternalWorkflowExecutionCancelRequestedEventAttributesTypeDef,
    ExternalWorkflowExecutionSignaledEventAttributesTypeDef,
    FailWorkflowExecutionDecisionAttributesTypeDef,
    FailWorkflowExecutionFailedEventAttributesTypeDef,
    HistoryEventTypeDef,
    LambdaFunctionCompletedEventAttributesTypeDef,
    LambdaFunctionFailedEventAttributesTypeDef,
    LambdaFunctionScheduledEventAttributesTypeDef,
    LambdaFunctionStartedEventAttributesTypeDef,
    LambdaFunctionTimedOutEventAttributesTypeDef,
    MarkerRecordedEventAttributesTypeDef,
    RecordMarkerDecisionAttributesTypeDef,
    RecordMarkerFailedEventAttributesTypeDef,
    RequestCancelActivityTaskDecisionAttributesTypeDef,
    RequestCancelActivityTaskFailedEventAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionDecisionAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionFailedEventAttributesTypeDef,
    RequestCancelExternalWorkflowExecutionInitiatedEventAttributesTypeDef,
    ResourceTagTypeDef,
    ResponseMetadata,
    ScheduleActivityTaskDecisionAttributesTypeDef,
    ScheduleActivityTaskFailedEventAttributesTypeDef,
    ScheduleLambdaFunctionDecisionAttributesTypeDef,
    ScheduleLambdaFunctionFailedEventAttributesTypeDef,
    SignalExternalWorkflowExecutionDecisionAttributesTypeDef,
    SignalExternalWorkflowExecutionFailedEventAttributesTypeDef,
    SignalExternalWorkflowExecutionInitiatedEventAttributesTypeDef,
    StartChildWorkflowExecutionDecisionAttributesTypeDef,
    StartChildWorkflowExecutionFailedEventAttributesTypeDef,
    StartChildWorkflowExecutionInitiatedEventAttributesTypeDef,
    StartLambdaFunctionFailedEventAttributesTypeDef,
    StartTimerDecisionAttributesTypeDef,
    StartTimerFailedEventAttributesTypeDef,
    TaskListTypeDef,
    TimerCanceledEventAttributesTypeDef,
    TimerFiredEventAttributesTypeDef,
    TimerStartedEventAttributesTypeDef,
    WorkflowExecutionCancelRequestedEventAttributesTypeDef,
    WorkflowExecutionCanceledEventAttributesTypeDef,
    WorkflowExecutionCompletedEventAttributesTypeDef,
    WorkflowExecutionConfigurationTypeDef,
    WorkflowExecutionContinuedAsNewEventAttributesTypeDef,
    WorkflowExecutionFailedEventAttributesTypeDef,
    WorkflowExecutionInfoTypeDef,
    WorkflowExecutionOpenCountsTypeDef,
    WorkflowExecutionSignaledEventAttributesTypeDef,
    WorkflowExecutionStartedEventAttributesTypeDef,
    WorkflowExecutionTerminatedEventAttributesTypeDef,
    WorkflowExecutionTimedOutEventAttributesTypeDef,
    WorkflowExecutionTypeDef,
    WorkflowTypeConfigurationTypeDef,
    WorkflowTypeInfoTypeDef,
    WorkflowTypeTypeDef,
    ActivityTaskStatusTypeDef,
    ActivityTaskTypeDef,
    ActivityTypeDetailTypeDef,
    ActivityTypeInfosTypeDef,
    CloseStatusFilterTypeDef,
    DecisionTaskTypeDef,
    DecisionTypeDef,
    DomainDetailTypeDef,
    DomainInfosTypeDef,
    ExecutionTimeFilterTypeDef,
    HistoryTypeDef,
    ListTagsForResourceOutputTypeDef,
    PaginatorConfigTypeDef,
    PendingTaskCountTypeDef,
    RunTypeDef,
    TagFilterTypeDef,
    WorkflowExecutionCountTypeDef,
    WorkflowExecutionDetailTypeDef,
    WorkflowExecutionFilterTypeDef,
    WorkflowExecutionInfosTypeDef,
    WorkflowTypeDetailTypeDef,
    WorkflowTypeFilterTypeDef,
    WorkflowTypeInfosTypeDef,
)

def get_structure() -> ActivityTaskCancelRequestedEventAttributesTypeDef:
    return {
      ...
    }
```
