# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['hikvision_isapi_cli',
 'hikvision_isapi_cli.api',
 'hikvision_isapi_cli.api.default',
 'hikvision_isapi_cli.api.isapi',
 'hikvision_isapi_cli.models',
 'hikvision_isapi_sk']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.15.4,<0.24.0',
 'numpy>=1.19.3',
 'opencv-python>=4.7.0',
 'pytest-asyncio>=0.20.3',
 'pytest-socket>=0.5.1',
 'pytest>=7.2.0',
 'python-dateutil>=2.8.0,<3.0.0',
 'xmltodict>=0.13.0']

setup_kwargs = {
    'name': 'hikvision-isapi-cli',
    'version': '1.0.14',
    'description': 'A client library for accessing Hikvision ISAPI and mores',
    'long_description': '[![PyPI current version](https://img.shields.io/pypi/v/hikvision-isapi-cli.svg)](https://pypi.python.org/pypi/hikvision-isapi-cli)\n[![Python Support](https://img.shields.io/pypi/pyversions/hikvision-isapi-cli.svg)](https://pypi.python.org/pypi/hikvision-isapi-cli)\n\n\n# hikvision-isapi-cli\nA client library for accessing Hikvision ISAPI\n\n### OpenAPI Generator\n\n```bash\nrm -fr .history/;cd ..;openapi-python-client update --path hikvision-isapi-cli/openapi.json --custom-template-path=hikvision-isapi-cli/templates/ --config=hikvision-isapi-cli/.config.yaml;cd hikvision-isapi-cli\n```\n\n## Usage\nFirst, create a client:\n\n```python\nfrom hikvision_isapi_cli import Client\n\nclient = Client(base_url="https://api.example.com", username="username", password="SuperSecretPassword")\n```\n\nNow call your endpoint and use your models:\n\n```python\nfrom hikvision_isapi_cli.models import MyDataModel\nfrom hikvision_isapi_cli.api.my_tag import get_my_data_model\nfrom hikvision_isapi_cli.types import Response\n\nmy_data: MyDataModel = get_my_data_model.sync(client=client)\n# or if you need more info (e.g. status_code)\nresponse: Response[MyDataModel] = get_my_data_model.sync_detailed(client=client)\n```\n\nOr do the same thing with an async version:\n\n```python\nfrom hikvision_isapi_cli.models import MyDataModel\nfrom hikvision_isapi_cli.api.my_tag import get_my_data_model\nfrom hikvision_isapi_cli.types import Response\n\nmy_data: MyDataModel = await get_my_data_model.asyncio(client=client)\nresponse: Response[MyDataModel] = await get_my_data_model.asyncio_detailed(client=client)\n```\n\nBy default, when you\'re calling an HTTPS API it will attempt to verify that SSL is working correctly. Using certificate verification is highly recommended most of the time, but sometimes you may need to authenticate to a server (especially an internal server) using a custom certificate bundle.\n\n```python\nclient = Client(\n    base_url="https://internal_api.example.com", \n    verify_ssl="/path/to/certificate_bundle.pem",\n)\n```\n\nYou can also disable certificate validation altogether, but beware that **this is a security risk**.\n\n```python\nclient = Client(\n    base_url="https://internal_api.example.com",  \n    verify_ssl=False\n)\n```\n\nThere are more settings on the generated `Client` class which let you control more runtime behavior, check out the docstring on that class for more info.\n\nThings to know:\n1. Every path/method combo becomes a Python module with four functions:\n    1. `sync`: Blocking request that returns parsed data (if successful) or `None`\n    1. `sync_detailed`: Blocking request that always returns a `Request`, optionally with `parsed` set if the request was successful.\n    1. `asyncio`: Like `sync` but async instead of blocking\n    1. `asyncio_detailed`: Like `sync_detailed` but async instead of blocking\n\n1. All path/query params, and bodies become method arguments.\n1. If your endpoint had any tags on it, the first tag will be used as a module name for the function (my_tag above)\n1. Any endpoint which did not have a tag will be in `hikvision_isapi_cli.api.default`\n\n## Building / publishing this Client\nThis project uses [Poetry](https://python-poetry.org/) to manage dependencies  and packaging.  Here are the basics:\n1. Update the metadata in pyproject.toml (e.g. authors, version)\n1. If you\'re using a private repository, configure it with Poetry\n    1. `poetry config repositories.<your-repository-name> <url-to-your-repository>`\n    1. `poetry config http-basic.<your-repository-name> <username> <password>`\n1. Publish the client with `poetry publish --build -r <your-repository-name>` or, if for public PyPI, just `poetry publish --build`\n\nIf you want to install this client into another project without publishing it (e.g. for development) then:\n1. If that project **is using Poetry**, you can simply do `poetry add <path-to-this-client>` from that project\n1. If that project is not using Poetry:\n    1. Build a wheel with `poetry build -f wheel`\n    1. Install that wheel from the other project `pip install <path-to-wheel>`\n',
    'author': 'mmascia',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
