"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.obtainScope = exports.cloudAssemblyBuildSpecDir = exports.embeddedAsmPath = exports.pipelineSynth = exports.assemblyBuilderOf = exports.appOf = void 0;
/**
 * Get access to construct internals that we need but got removed from the Stages PR.
 */
const path = require("path");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
// eslint-disable-next-line no-duplicate-imports,import/order
const core_2 = require("../../../core");
function appOf(construct) {
    const root = constructs_1.Node.of(construct).root;
    if (!core_1.App.isApp(root)) {
        throw new Error(`Construct must be created under an App, but is not: ${constructs_1.Node.of(construct).path}`);
    }
    return root;
}
exports.appOf = appOf;
function assemblyBuilderOf(stage) {
    return stage._assemblyBuilder;
}
exports.assemblyBuilderOf = assemblyBuilderOf;
function pipelineSynth(stage) {
    return stage.synth({ validateOnSynthesis: true });
}
exports.pipelineSynth = pipelineSynth;
/**
 * Return the relative path from the app assembly to the scope's (nested) assembly
 */
function embeddedAsmPath(scope) {
    const appAsmRoot = assemblyBuilderOf(appOf(scope)).outdir;
    const stage = core_1.Stage.of(scope) ?? appOf(scope);
    const stageAsmRoot = assemblyBuilderOf(stage).outdir;
    return path.relative(appAsmRoot, stageAsmRoot) || '.';
}
exports.embeddedAsmPath = embeddedAsmPath;
/**
 * Determine the directory where the cloud assembly will be written, for use in a BuildSpec
 */
function cloudAssemblyBuildSpecDir(scope) {
    return assemblyBuilderOf(appOf(scope)).outdir;
}
exports.cloudAssemblyBuildSpecDir = cloudAssemblyBuildSpecDir;
function obtainScope(parent, id) {
    const existing = constructs_1.Node.of(parent).tryFindChild(id);
    if (existing) {
        return existing;
    }
    return new core_2.Construct(parent, id);
}
exports.obtainScope = obtainScope;
//# sourceMappingURL=data:application/json;base64,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