"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineBase = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const blueprint_1 = require("../blueprint");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../core");
/**
 * A generic CDK Pipelines pipeline
 *
 * Different deployment systems will provide subclasses of `Pipeline` that generate
 * the deployment infrastructure necessary to deploy CDK apps, specific to that system.
 *
 * This library comes with the `CodePipeline` class, which uses AWS CodePipeline
 * to deploy CDK apps.
 *
 * The actual pipeline infrastructure is constructed (by invoking the engine)
 * when `buildPipeline()` is called, or when `app.synth()` is called (whichever
 * happens first).
 */
class PipelineBase extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.built = false;
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_PipelineBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PipelineBase);
            }
            throw error;
        }
        if (props.synth instanceof blueprint_1.ShellStep && !props.synth.primaryOutput) {
            props.synth.primaryOutputDirectory('cdk.out');
        }
        if (!props.synth.primaryOutput) {
            throw new Error(`synthStep ${props.synth} must produce a primary output, but is not producing anything. Configure the Step differently or use a different Step type.`);
        }
        this.synth = props.synth;
        this.waves = [];
        this.cloudAssemblyFileSet = props.synth.primaryOutput;
        core_1.Aspects.of(this).add({ visit: () => this.buildJustInTime() });
    }
    /**
     * Deploy a single Stage by itself
     *
     * Add a Stage to the pipeline, to be deployed in sequence with other
     * Stages added to the pipeline. All Stacks in the stage will be deployed
     * in an order automatically determined by their relative dependencies.
     */
    addStage(stage, options) {
        try {
            jsiiDeprecationWarnings.monocdk_Stage(stage);
            jsiiDeprecationWarnings.monocdk_pipelines_AddStageOpts(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        if (this.built) {
            throw new Error('addStage: can\'t add Stages anymore after buildPipeline() has been called');
        }
        return this.addWave(stage.stageName).addStage(stage, options);
    }
    /**
     * Add a Wave to the pipeline, for deploying multiple Stages in parallel
     *
     * Use the return object of this method to deploy multiple stages in parallel.
     *
     * Example:
     *
     * ```ts
     * declare const pipeline: pipelines.CodePipeline;
     *
     * const wave = pipeline.addWave('MyWave');
     * wave.addStage(new MyApplicationStage(this, 'Stage1'));
     * wave.addStage(new MyApplicationStage(this, 'Stage2'));
     * ```
     */
    addWave(id, options) {
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_WaveOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addWave);
            }
            throw error;
        }
        if (this.built) {
            throw new Error('addWave: can\'t add Waves anymore after buildPipeline() has been called');
        }
        const wave = new blueprint_1.Wave(id, options);
        this.waves.push(wave);
        return wave;
    }
    /**
     * Send the current pipeline definition to the engine, and construct the pipeline
     *
     * It is not possible to modify the pipeline after calling this method.
     */
    buildPipeline() {
        if (this.built) {
            throw new Error('build() has already been called: can only call it once');
        }
        this.doBuildPipeline();
        this.built = true;
    }
    /**
     * Automatically call 'build()' just before synthesis if the user hasn't explicitly called it yet
     */
    buildJustInTime() {
        if (!this.built) {
            this.buildPipeline();
        }
    }
}
exports.PipelineBase = PipelineBase;
_a = JSII_RTTI_SYMBOL_1;
PipelineBase[_a] = { fqn: "monocdk.pipelines.PipelineBase", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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