import * as codebuild from '../../../../aws-codebuild';
import * as codepipeline from '../../../../aws-codepipeline';
import * as ec2 from '../../../../aws-ec2';
import * as events from '../../../../aws-events';
import * as iam from '../../../../aws-iam';
import { StackOutput } from '../stage';
import { Construct } from '../../../../core';
/**
 * Properties for ShellScriptAction
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface ShellScriptActionProps {
    /**
     * Name of the validation action in the pipeline
     */
    readonly actionName: string;
    /**
     * Stack outputs to make available as environment variables
     *
     * @default - No outputs used
     */
    readonly useOutputs?: Record<string, StackOutput>;
    /**
     * Commands to run
     */
    readonly commands: string[];
    /**
     * Bash options to set at the start of the script
     *
     * @default '-eu' (errexit and nounset)
     */
    readonly bashOptions?: string;
    /**
     * Additional artifacts to use as input for the CodeBuild project
     *
     * You can use these files to load more complex test sets into the
     * shellscript build environment.
     *
     * The files artifact given here will be unpacked into the current
     * working directory, the other ones will be unpacked into directories
     * which are available through the environment variables
     * $CODEBUILD_SRC_DIR_<artifactName>.
     *
     * The CodeBuild job must have at least one input artifact, so you
     * must provide either at least one additional artifact here or one
     * stack output using `useOutput`.
     *
     * @default - No additional artifacts
     */
    readonly additionalArtifacts?: codepipeline.Artifact[];
    /**
     * The CodeBuild environment where scripts are executed.
     *
     * @default LinuxBuildImage.STANDARD_5_0
     */
    readonly environment?: codebuild.BuildEnvironment;
    /**
     * Environment variables to send into build
     *
     * @default - No additional environment variables
     */
    readonly environmentVariables?: Record<string, codebuild.BuildEnvironmentVariable>;
    /**
     * RunOrder for this action
     *
     * Use this to sequence the shell script after the deployments.
     *
     * The default value is 100 so you don't have to supply the value if you just
     * want to run this after the application stacks have been deployed, and you
     * don't have more than 100 stacks.
     *
     * @default 100
     */
    readonly runOrder?: number;
    /**
     * Additional policy statements to add to the execution role
     *
     * @default - No policy statements
     */
    readonly rolePolicyStatements?: iam.PolicyStatement[];
    /**
     * The VPC where to execute the specified script.
     *
     * @default - No VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * Which security group to associate with the script's project network interfaces.
     * If no security group is identified, one will be created automatically.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - Security group will be automatically created.
     *
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
}
/**
 * Validate a revision using shell commands
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export declare class ShellScriptAction implements codepipeline.IAction, iam.IGrantable {
    private readonly props;
    private _project?;
    private _action?;
    private _actionProperties;
    constructor(props: ShellScriptActionProps);
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
    /**
     * Exists to implement IAction
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * Project generated to run the shell script in
     */
    get project(): codebuild.IProject;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
}
