import * as codebuild from '../../../../aws-codebuild';
import * as codepipeline from '../../../../aws-codepipeline';
import * as ec2 from '../../../../aws-ec2';
import * as events from '../../../../aws-events';
import * as iam from '../../../../aws-iam';
import { DockerCredential } from '../../docker-credentials';
import { Construct } from '../../../../core';
/**
 * Configuration options for a SimpleSynth
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface SimpleSynthOptions {
    /**
     * The source artifact of the CodePipeline
     */
    readonly sourceArtifact: codepipeline.Artifact;
    /**
     * The artifact where the CloudAssembly should be emitted
     */
    readonly cloudAssemblyArtifact: codepipeline.Artifact;
    /**
     * Environment variables to send into build
     *
     * NOTE: You may run into the 1000-character limit for the Action configuration if you have a large
     * number of variables or if their names or values are very long.
     * If you do, pass them to the underlying CodeBuild project directly in `environment` instead.
     * However, you will not be able to use CodePipeline Variables in this case.
     *
     * @default - No additional environment variables
     */
    readonly environmentVariables?: Record<string, codebuild.BuildEnvironmentVariable>;
    /**
     * Environment variables to copy over from parent env
     *
     * These are environment variables that are being used by the build.
     *
     * @default - No environment variables copied
     */
    readonly copyEnvironmentVariables?: string[];
    /**
     * Name of the build action
     *
     * @default 'Synth'
     */
    readonly actionName?: string;
    /**
     * Name of the CodeBuild project
     *
     * @default - Automatically generated
     */
    readonly projectName?: string;
    /**
     * Build environment to use for CodeBuild job
     *
     * @default BuildEnvironment.LinuxBuildImage.STANDARD_5_0
     */
    readonly environment?: codebuild.BuildEnvironment;
    /**
     * Directory inside the source where package.json and cdk.json are located
     *
     * @default - Repository root
     */
    readonly subdirectory?: string;
    /**
     * Produce additional output artifacts after the build based on the given directories
     *
     * Can be used to produce additional artifacts during the build step,
     * separate from the cloud assembly, which can be used further on in the
     * pipeline.
     *
     * Directories are evaluated with respect to `subdirectory`.
     *
     * @default - No additional artifacts generated
     */
    readonly additionalArtifacts?: AdditionalArtifact[];
    /**
     * Policy statements to add to role used during the synth
     *
     * Can be used to add acces to a CodeArtifact repository etc.
     *
     * @default - No policy statements added to CodeBuild Project Role
     */
    readonly rolePolicyStatements?: iam.PolicyStatement[];
    /**
     * The VPC where to execute the SimpleSynth.
     *
     * @default - No VPC
     */
    readonly vpc?: ec2.IVpc;
    /**
     * Which subnets to use.
     *
     * Only used if 'vpc' is supplied.
     *
     * @default - All private subnets.
     */
    readonly subnetSelection?: ec2.SubnetSelection;
    /**
     * custom BuildSpec that is merged with the generated one
     *
     * @default - none
     */
    readonly buildSpec?: codebuild.BuildSpec;
}
/**
 * Construction props for SimpleSynthAction
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface SimpleSynthActionProps extends SimpleSynthOptions {
    /**
     * The synth command
     */
    readonly synthCommand: string;
    /**
     * The install command
     *
     * If not provided by the build image or another dependency
     * management tool, at least install the CDK CLI here using
     * `npm install -g aws-cdk`.
     *
     * @default - No install required
     * @deprecated Use `installCommands` instead
     */
    readonly installCommand?: string;
    /**
     * The build command
     *
     * If your programming language requires a compilation step, put the
     * compilation command here.
     *
     * @default - No build required
     * @deprecated Use `buildCommands` instead
     */
    readonly buildCommand?: string;
    /**
     * Install commands
     *
     * If not provided by the build image or another dependency
     * management tool, at least install the CDK CLI here using
     * `npm install -g aws-cdk`.
     *
     * @default - No install required
     */
    readonly installCommands?: string[];
    /**
     * The build commands
     *
     * If your programming language requires a compilation step, put the
     * compilation command here.
     *
     * @default - No build required
     */
    readonly buildCommands?: string[];
    /**
     * Test commands
     *
     * These commands are run after the build commands but before the
     * synth command.
     *
     * @default - No test commands
     */
    readonly testCommands?: string[];
}
/**
 * Specification of an additional artifact to generate
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface AdditionalArtifact {
    /**
     * Directory to be packaged
     */
    readonly directory: string;
    /**
     * Artifact to represent the build directory in the pipeline
     */
    readonly artifact: codepipeline.Artifact;
}
/**
 * A standard synth with a generated buildspec
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export declare class SimpleSynthAction implements codepipeline.IAction, iam.IGrantable {
    private readonly props;
    /**
     * Create a standard NPM synth action
     *
     * Uses `npm ci` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'npm run build'`.
     */
    static standardNpmSynth(options: StandardNpmSynthOptions): SimpleSynthAction;
    /**
     * Create a standard Yarn synth action
     *
     * Uses `yarn install --frozen-lockfile` to install dependencies and `npx cdk synth` to synthesize.
     *
     * If you need a build step, add `buildCommand: 'yarn build'`.
     */
    static standardYarnSynth(options: StandardYarnSynthOptions): SimpleSynthAction;
    private _action?;
    private _actionProperties;
    private _project?;
    private _dockerCredentials?;
    constructor(props: SimpleSynthActionProps);
    /**
     * Exists to implement IAction
     */
    get actionProperties(): codepipeline.ActionProperties;
    /**
     * Project generated to run the synth command
     */
    get project(): codebuild.IProject;
    /**
     * Exists to implement IAction
     */
    bind(scope: Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * The CodeBuild Project's principal
     */
    get grantPrincipal(): iam.IPrincipal;
    /**
     * Exists to implement IAction
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * Associate one or more Docker registries and associated credentials with the synth action.
     * This will be used to inject installation commands to set up `cdk-assets`,
     * and grant read access to the credentials.
     * @internal
     */
    _addDockerCredentials(dockerCredentials: DockerCredential[]): void;
}
/**
 * Options for a convention-based synth using NPM
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface StandardNpmSynthOptions extends SimpleSynthOptions {
    /**
     * The install command
     *
     * @default 'npm ci'
     */
    readonly installCommand?: string;
    /**
     * The build command
     *
     * By default, we assume NPM projects are either written in JavaScript or are
     * using `ts-node`, so don't need a build command.
     *
     * Otherwise, put the build command here, for example `npm run build`.
     *
     * @default - No build required
     */
    readonly buildCommand?: string;
    /**
     * The synth command
     *
     * @default 'npx cdk synth'
     */
    readonly synthCommand?: string;
    /**
     * Test commands
     *
     * These commands are run after the build commands but before the
     * synth command.
     *
     * @default - No test commands
     */
    readonly testCommands?: string[];
}
/**
 * Options for a convention-based synth using Yarn
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
export interface StandardYarnSynthOptions extends SimpleSynthOptions {
    /**
     * The install command
     *
     * @default 'yarn install --frozen-lockfile'
     */
    readonly installCommand?: string;
    /**
     * The build command
     *
     * By default, we assume NPM projects are either written in JavaScript or are
     * using `ts-node`, so don't need a build command.
     *
     * Otherwise, put the build command here, for example `npm run build`.
     *
     * @default - No build required
     */
    readonly buildCommand?: string;
    /**
     * The synth command
     *
     * @default 'npx cdk synth'
     */
    readonly synthCommand?: string;
    /**
     * Test commands
     *
     * These commands are run after the build commands but before the
     * synth command.
     *
     * @default - No test commands
     */
    readonly testCommands?: string[];
}
