"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StackOutput = exports.CdkStage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../aws-codebuild");
const cpactions = require("../../../aws-codepipeline-actions");
const aws_codepipeline_actions_1 = require("../../../aws-codepipeline-actions");
const core_1 = require("../../../core");
const constructs_1 = require("constructs");
const asset_type_1 = require("../blueprint/asset-type");
const application_security_check_1 = require("../private/application-security-check");
const asset_manifest_1 = require("../private/asset-manifest");
const construct_internals_1 = require("../private/construct-internals");
const toposort_1 = require("../private/toposort");
const actions_1 = require("./actions");
const pipeline_1 = require("./pipeline");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../core");
/**
 * Stage in a CdkPipeline
 *
 * You don't need to instantiate this class directly. Use
 * `cdkPipeline.addStage()` instead.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class CdkStage extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this._nextSequentialRunOrder = 1; // Must start at 1 eh
        this._manualApprovalCounter = 1;
        this.stacksToDeploy = new Array();
        this._prepared = false;
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_CdkStageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CdkStage);
            }
            throw error;
        }
        if (scope instanceof pipeline_1.CdkPipeline) {
            this.pipeline = scope;
        }
        this.stageName = props.stageName;
        this.pipelineStage = props.pipelineStage;
        this.cloudAssemblyArtifact = props.cloudAssemblyArtifact;
        this.host = props.host;
        this.confirmBroadeningPermissions = props.confirmBroadeningPermissions ?? false;
        this.securityNotificationTopic = props.securityNotificationTopic;
        core_1.Aspects.of(this).add({ visit: () => this.prepareStage() });
    }
    /**
     * Add all stacks in the application Stage to this stage
     *
     * The application construct should subclass `Stage` and can contain any
     * number of `Stacks` inside it that may have dependency relationships
     * on one another.
     *
     * All stacks in the application will be deployed in the appropriate order,
     * and all assets found in the application will be added to the asset
     * publishing stage.
     */
    addApplication(appStage, options = {}) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addApplication", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_Stage(appStage);
            jsiiDeprecationWarnings.monocdk_pipelines_AddStageOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addApplication);
            }
            throw error;
        }
        const asm = construct_internals_1.pipelineSynth(appStage);
        const extraRunOrderSpace = options.extraRunOrderSpace ?? 0;
        if (options.confirmBroadeningPermissions ?? this.confirmBroadeningPermissions) {
            this.addSecurityCheck(appStage, options);
        }
        if (asm.stacks.length === 0) {
            // If we don't check here, a more puzzling "stage contains no actions"
            // error will be thrown come deployment time.
            throw new Error(`The given Stage construct ('${appStage.node.path}') should contain at least one Stack`);
        }
        const sortedTranches = toposort_1.topologicalSort(asm.stacks, stack => stack.id, stack => stack.dependencies.map(d => d.id));
        for (const stacks of sortedTranches) {
            const runOrder = this.nextSequentialRunOrder(extraRunOrderSpace + 2); // 2 actions for Prepare/Execute ChangeSet
            let executeRunOrder = runOrder + extraRunOrderSpace + 1;
            // If we need to insert a manual approval action, then what's the executeRunOrder
            // now is where we add a manual approval step, and we allocate 1 more runOrder
            // for the execute.
            if (options.manualApprovals) {
                this.addManualApprovalAction({ runOrder: runOrder + 1 });
                executeRunOrder = this.nextSequentialRunOrder();
            }
            // These don't have a dependency on each other, so can all be added in parallel
            for (const stack of stacks) {
                this.addStackArtifactDeployment(stack, { runOrder, executeRunOrder });
            }
        }
    }
    /**
     * Get a cached version of an ApplicationSecurityCheck, which consists of:
     *  - CodeBuild Project to check for security changes in a stage
     *  - Lambda Function that approves the manual approval if no security changes are detected
     *
     * The ApplicationSecurityCheck is cached from the pipeline **if** this stage is scoped
     * to a CDK Pipeline. If this stage **is not** scoped to a pipeline, create an ApplicationSecurityCheck
     * scoped to the stage itself.
     *
     * @internal
     */
    getApplicationSecurityCheck() {
        if (this._applicationSecurityCheck) {
            return this._applicationSecurityCheck;
        }
        this._applicationSecurityCheck = this.pipeline
            ? this.pipeline._getApplicationSecurityCheck()
            : new application_security_check_1.ApplicationSecurityCheck(this, 'StageApplicationSecurityCheck', {
                codePipeline: this.pipelineStage.pipeline,
            });
        return this._applicationSecurityCheck;
    }
    /**
     * Add a deployment action based on a stack artifact
     */
    addStackArtifactDeployment(stackArtifact, options = {}) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addStackArtifactDeployment", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_cx_api_CloudFormationStackArtifact(stackArtifact);
            jsiiDeprecationWarnings.monocdk_pipelines_AddStackOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStackArtifactDeployment);
            }
            throw error;
        }
        // Get all assets manifests and add the assets in 'em to the asset publishing stage.
        this.publishAssetDependencies(stackArtifact);
        // Remember for later, see 'prepare()'
        // We know that deploying a stack is going to take up 2 runorder slots later on.
        const runOrder = options.runOrder ?? this.nextSequentialRunOrder(2);
        const executeRunOrder = options.executeRunOrder ?? runOrder + 1;
        this.stacksToDeploy.push({
            prepareRunOrder: runOrder,
            executeRunOrder,
            stackArtifact,
        });
        this.advanceRunOrderPast(runOrder);
        this.advanceRunOrderPast(executeRunOrder);
    }
    /**
     * Add a manual approval action
     *
     * If you need more flexibility than what this method offers,
     * use `addAction` with a `ManualApprovalAction`.
     */
    addManualApprovalAction(options = {}) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addManualApprovalAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_AddManualApprovalOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addManualApprovalAction);
            }
            throw error;
        }
        let actionName = options.actionName;
        if (!actionName) {
            actionName = `ManualApproval${this._manualApprovalCounter > 1 ? this._manualApprovalCounter : ''}`;
            this._manualApprovalCounter += 1;
        }
        this.addActions(new cpactions.ManualApprovalAction({
            actionName,
            runOrder: options.runOrder ?? this.nextSequentialRunOrder(),
        }));
    }
    /**
     * Add one or more CodePipeline Actions
     *
     * You need to make sure it is created with the right runOrder. Call `nextSequentialRunOrder()`
     * for every action to get actions to execute in sequence.
     */
    addActions(...actions) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#addActions", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IAction(actions);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addActions);
            }
            throw error;
        }
        for (const action of actions) {
            this.pipelineStage.addAction(action);
        }
    }
    /**
     * Return the runOrder number necessary to run the next Action in sequence with the rest
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    nextSequentialRunOrder(count = 1) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#nextSequentialRunOrder", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.nextSequentialRunOrder);
            }
            throw error;
        }
        const ret = this._nextSequentialRunOrder;
        this._nextSequentialRunOrder += count;
        return ret;
    }
    /**
     * Whether this Stage contains an action to deploy the given stack, identified by its artifact ID
     */
    deploysStack(artifactId) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.CdkStage#deploysStack", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.deploysStack);
            }
            throw error;
        }
        return this.stacksToDeploy.map(s => s.stackArtifact.id).includes(artifactId);
    }
    /**
     * Actually add all the DeployStack actions to the stage.
     *
     * We do this late because before we can render the actual DeployActions,
     * we need to know whether or not we need to capture the stack outputs.
     *
     * FIXME: This is here because Actions are immutable and can't be reordered
     * after creation, nor is there a way to specify relative priorities, which
     * is a limitation that we should take away in the base library.
     */
    prepareStage() {
        // FIXME: Make sure this only gets run once. There seems to be an issue in the reconciliation
        // loop that may trigger this more than once if it throws an error somewhere, and the exception
        // that gets thrown here will then override the actual failure.
        if (this._prepared) {
            return;
        }
        this._prepared = true;
        for (const { prepareRunOrder, stackArtifact, executeRunOrder } of this.stacksToDeploy) {
            const artifact = this.host.stackOutputArtifact(stackArtifact.id);
            this.pipelineStage.addAction(actions_1.DeployCdkStackAction.fromStackArtifact(this, stackArtifact, {
                baseActionName: this.simplifyStackName(stackArtifact.stackName),
                cloudAssemblyInput: this.cloudAssemblyArtifact,
                output: artifact,
                outputFileName: artifact ? 'outputs.json' : undefined,
                prepareRunOrder,
                executeRunOrder,
            }));
        }
    }
    /**
     * Advance the runorder counter so that the next sequential number is higher than the given one
     */
    advanceRunOrderPast(lastUsed) {
        this._nextSequentialRunOrder = Math.max(lastUsed + 1, this._nextSequentialRunOrder);
    }
    /**
     * Simplify the stack name by removing the `Stage-` prefix if it exists.
     */
    simplifyStackName(s) {
        return stripPrefix(s, `${this.stageName}-`);
    }
    /**
     * Add a security check before the prepare/deploy actions of an CDK stage.
     * The security check consists of two actions:
     *  - CodeBuild Action to check for security changes in a stage
     *  - Manual Approval Action that is auto approved via a Lambda if no security changes detected
     */
    addSecurityCheck(appStage, options) {
        const { cdkDiffProject } = this.getApplicationSecurityCheck();
        const notificationTopic = options?.securityNotificationTopic ?? this.securityNotificationTopic;
        notificationTopic?.grantPublish(cdkDiffProject);
        const appStageName = appStage.stageName;
        const approveActionName = `${appStageName}ManualApproval`;
        const diffAction = new aws_codepipeline_actions_1.CodeBuildAction({
            runOrder: this.nextSequentialRunOrder(),
            actionName: `${appStageName}SecurityCheck`,
            input: this.cloudAssemblyArtifact,
            project: cdkDiffProject,
            variablesNamespace: `${appStageName}SecurityCheck`,
            environmentVariables: {
                STAGE_PATH: {
                    value: constructs_1.Node.of(appStage).path,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                STAGE_NAME: {
                    value: this.stageName,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                ACTION_NAME: {
                    value: approveActionName,
                    type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                },
                ...notificationTopic ? {
                    NOTIFICATION_ARN: {
                        value: notificationTopic.topicArn,
                        type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                    },
                    NOTIFICATION_SUBJECT: {
                        value: `Confirm permission broadening in ${appStageName}`,
                        type: codebuild.BuildEnvironmentVariableType.PLAINTEXT,
                    },
                } : {},
            },
        });
        const approve = new cpactions.ManualApprovalAction({
            actionName: approveActionName,
            runOrder: this.nextSequentialRunOrder(),
            additionalInformation: `#{${appStageName}SecurityCheck.MESSAGE}`,
            externalEntityLink: `#{${appStageName}SecurityCheck.LINK}`,
        });
        this.addActions(diffAction, approve);
    }
    /**
     * Make sure all assets depended on by this stack are published in this pipeline
     *
     * Taking care to exclude the stack template itself -- it is being published
     * as an asset because the CLI needs to know the asset publishing role when
     * pushing the template to S3, but in the case of CodePipeline we always
     * reference the template from the artifact bucket.
     *
     * (NOTE: this is only true for top-level stacks, not nested stacks. Nested
     * Stack templates are always published as assets).
     */
    publishAssetDependencies(stackArtifact) {
        const assetManifests = stackArtifact.dependencies.filter(isAssetManifest);
        for (const manifestArtifact of assetManifests) {
            const manifest = asset_manifest_1.AssetManifestReader.fromFile(manifestArtifact.file);
            for (const entry of manifest.entries) {
                let assetType;
                if (entry instanceof asset_manifest_1.DockerImageManifestEntry) {
                    assetType = asset_type_1.AssetType.DOCKER_IMAGE;
                }
                else if (entry instanceof asset_manifest_1.FileManifestEntry) {
                    // Don't publish the template for this stack
                    if (entry.source.packaging === 'file' && entry.source.path === stackArtifact.templateFile) {
                        continue;
                    }
                    assetType = asset_type_1.AssetType.FILE;
                }
                else {
                    throw new Error(`Unrecognized asset type: ${entry.type}`);
                }
                if (!entry.destination.assumeRoleArn) {
                    throw new Error('assumeRoleArn is missing on asset and required');
                }
                this.host.publishAsset({
                    assetManifestPath: manifestArtifact.file,
                    assetId: entry.id.assetId,
                    assetSelector: entry.id.toString(),
                    assetType,
                    assetPublishingRoleArn: entry.destination.assumeRoleArn,
                });
            }
        }
    }
}
exports.CdkStage = CdkStage;
_a = JSII_RTTI_SYMBOL_1;
CdkStage[_a] = { fqn: "monocdk.pipelines.CdkStage", version: "1.185.0" };
/**
 * A single output of a Stack
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class StackOutput {
    /**
     * Build a StackOutput from a known artifact and an output name
     */
    constructor(artifactFile, outputName) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.StackOutput", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ArtifactPath(artifactFile);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StackOutput);
            }
            throw error;
        }
        this.artifactFile = artifactFile;
        this.outputName = outputName;
    }
}
exports.StackOutput = StackOutput;
_b = JSII_RTTI_SYMBOL_1;
StackOutput[_b] = { fqn: "monocdk.pipelines.StackOutput", version: "1.185.0" };
function stripPrefix(s, prefix) {
    return s.startsWith(prefix) ? s.slice(prefix.length) : s;
}
function isAssetManifest(s) {
    // instanceof is too risky, and we're at a too late stage to properly fix.
    // return s instanceof cxapi.AssetManifestArtifact;
    return s.constructor.name === 'AssetManifestArtifact';
}
//# sourceMappingURL=data:application/json;base64,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