"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdatePipelineAction = void 0;
const jsiiDeprecationWarnings = require("../../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codebuild = require("../../../../aws-codebuild");
const cpactions = require("../../../../aws-codepipeline-actions");
const iam = require("../../../../aws-iam");
const core_1 = require("../../../../core");
const docker_credentials_1 = require("../../docker-credentials");
const construct_internals_1 = require("../../private/construct-internals");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("../../../../core");
/**
 * Action to self-mutate the pipeline
 *
 * Creates a CodeBuild project which will use the CDK CLI
 * to deploy the pipeline stack.
 *
 * You do not need to instantiate this action -- it will automatically
 * be added by the pipeline.
 *
 * @deprecated This class is part of the old API. Use the API based on the `CodePipeline` class instead
 */
class UpdatePipelineAction extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_pipelines_UpdatePipelineActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, UpdatePipelineAction);
            }
            throw error;
        }
        const installSuffix = props.cdkCliVersion ? `@${props.cdkCliVersion}` : '';
        const stackIdentifier = props.pipelineStackHierarchicalId ?? props.pipelineStackName;
        const buildSpec = codebuild.BuildSpec.fromObject({
            version: '0.2',
            phases: {
                install: {
                    commands: [
                        `npm install -g aws-cdk${installSuffix}`,
                        ...docker_credentials_1.dockerCredentialsInstallCommands(docker_credentials_1.DockerCredentialUsage.SELF_UPDATE, props.dockerCredentials),
                    ],
                },
                build: {
                    commands: [
                        // Cloud Assembly is in *current* directory.
                        `cdk -a ${construct_internals_1.embeddedAsmPath(scope)} deploy ${stackIdentifier} --require-approval=never --verbose`,
                    ],
                },
            },
        });
        const selfMutationProject = new codebuild.PipelineProject(this, 'SelfMutation', {
            projectName: props.projectName,
            environment: {
                buildImage: codebuild.LinuxBuildImage.STANDARD_5_0,
                privileged: props.privileged ?? false,
            },
            buildSpec: props.buildSpec ? codebuild.mergeBuildSpecs(props.buildSpec, buildSpec) : buildSpec,
        });
        // allow the self-mutating project permissions to assume the bootstrap Action role
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['sts:AssumeRole'],
            resources: [`arn:*:iam::${core_1.Stack.of(this).account}:role/*`],
            conditions: {
                'ForAnyValue:StringEquals': {
                    'iam:ResourceTag/aws-cdk:bootstrap-role': ['image-publishing', 'file-publishing', 'deploy'],
                },
            },
        }));
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['cloudformation:DescribeStacks'],
            resources: ['*'],
        }));
        // S3 checks for the presence of the ListBucket permission
        selfMutationProject.addToRolePolicy(new iam.PolicyStatement({
            actions: ['s3:ListBucket'],
            resources: ['*'],
        }));
        (props.dockerCredentials ?? []).forEach(reg => reg.grantRead(selfMutationProject, docker_credentials_1.DockerCredentialUsage.SELF_UPDATE));
        this.action = new cpactions.CodeBuildAction({
            actionName: 'SelfMutate',
            input: props.cloudAssemblyInput,
            project: selfMutationProject,
            // Add this purely so that the pipeline will selfupdate if the CLI version changes
            environmentVariables: props.cdkCliVersion ? {
                CDK_CLI_VERSION: { value: props.cdkCliVersion },
            } : undefined,
        });
    }
    /**
     * Exists to implement IAction
     */
    bind(scope, stage, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#bind", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
            jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return this.action.bind(scope, stage, options);
    }
    /**
     * Exists to implement IAction
     */
    onStateChange(name, target, options) {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#onStateChange", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
            jsiiDeprecationWarnings.monocdk_aws_events_IRuleTarget(target);
            jsiiDeprecationWarnings.monocdk_aws_events_RuleProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.onStateChange);
            }
            throw error;
        }
        return this.action.onStateChange(name, target, options);
    }
    /**
     * Exists to implement IAction
     */
    get actionProperties() {
        try {
            jsiiDeprecationWarnings.print("monocdk.pipelines.UpdatePipelineAction#actionProperties", "This class is part of the old API. Use the API based on the `CodePipeline` class instead");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "actionProperties").get);
            }
            throw error;
        }
        // FIXME: I have had to make this class a Construct, because:
        //
        // - It needs access to the Construct tree, because it is going to add a `PipelineProject`.
        // - I would have liked to have done that in bind(), however,
        // - `actionProperties` (this method) is called BEFORE bind() is called, and by that point I
        //   don't have the "inner" Action yet to forward the call to.
        //
        // I've therefore had to construct the inner CodeBuildAction in the constructor, which requires making this
        // Action a Construct.
        //
        // Combined with how non-intuitive it is to make the "StackDeployAction", I feel there is something
        // wrong with the Action abstraction here.
        return this.action.actionProperties;
    }
}
exports.UpdatePipelineAction = UpdatePipelineAction;
_a = JSII_RTTI_SYMBOL_1;
UpdatePipelineAction[_a] = { fqn: "monocdk.pipelines.UpdatePipelineAction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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