"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wave = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stage_deployment_1 = require("./stage-deployment");
/**
 * Multiple stages that are deployed in parallel
 */
class Wave {
    constructor(
    /** Identifier for this Wave */
    id, props = {}) {
        this.id = id;
        /**
         * The stages that are deployed in this wave
         */
        this.stages = [];
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_WaveProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Wave);
            }
            throw error;
        }
        this.pre = props.pre ?? [];
        this.post = props.post ?? [];
    }
    /**
     * Add a Stage to this wave
     *
     * It will be deployed in parallel with all other stages in this
     * wave.
     */
    addStage(stage, options = {}) {
        try {
            jsiiDeprecationWarnings.monocdk_Stage(stage);
            jsiiDeprecationWarnings.monocdk_pipelines_AddStageOpts(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addStage);
            }
            throw error;
        }
        const ret = stage_deployment_1.StageDeployment.fromStage(stage, options);
        this.stages.push(ret);
        return ret;
    }
    /**
     * Add an additional step to run before any of the stages in this wave
     */
    addPre(...steps) {
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_Step(steps);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPre);
            }
            throw error;
        }
        this.pre.push(...steps);
    }
    /**
     * Add an additional step to run after all of the stages in this wave
     */
    addPost(...steps) {
        try {
            jsiiDeprecationWarnings.monocdk_pipelines_Step(steps);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addPost);
            }
            throw error;
        }
        this.post.push(...steps);
    }
}
exports.Wave = Wave;
_a = JSII_RTTI_SYMBOL_1;
Wave[_a] = { fqn: "monocdk.pipelines.Wave", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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