"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertionHandler = void 0;
/* eslint-disable no-console */
// eslint-disable-next-line import/no-extraneous-dependencies
const helpers_internal_1 = require("../../../../../assertions/lib/helpers-internal");
const base_1 = require("./base");
class AssertionHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        let actual = decodeCall(request.actual);
        const expected = decodeCall(request.expected);
        let result;
        const matcher = new MatchCreator(expected).getMatcher();
        console.log(`Testing equality between ${JSON.stringify(request.actual)} and ${JSON.stringify(request.expected)}`);
        const matchResult = matcher.test(actual);
        matchResult.finished();
        if (matchResult.hasFailed()) {
            result = {
                data: JSON.stringify({
                    status: 'fail',
                    message: [
                        ...matchResult.toHumanStrings(),
                        JSON.stringify(matchResult.target, undefined, 2),
                    ].join('\n'),
                }),
            };
            if (request.failDeployment) {
                throw new Error(result.data);
            }
        }
        else {
            result = {
                data: JSON.stringify({
                    status: 'pass',
                }),
            };
        }
        return result;
    }
}
exports.AssertionHandler = AssertionHandler;
class MatchCreator {
    constructor(obj) {
        this.parsedObj = {
            matcher: obj,
        };
    }
    /**
     * Return a Matcher that can be tested against the actual results.
     * This will convert the encoded matchers into their corresponding
     * assertions matcher.
     *
     * For example:
     *
     * ExpectedResult.objectLike({
     *   Messages: [{
     *     Body: Match.objectLike({
     *       Elements: Match.arrayWith([{ Asdf: 3 }]),
     *     }),
     *   }],
     * });
     *
     * Will be encoded as:
     * {
     *   $ObjectLike: {
     *     Messages: [{
     *       Body: {
     *         $ObjectLike: {
     *           Elements: {
     *             $ArrayWith: [{ Asdf: 3 }],
     *           },
     *         },
     *       },
     *     }],
     *   },
     * }
     *
     * Which can then be parsed by this function. For each key (recursively)
     * the parser will check if the value has one of the encoded matchers as a key
     * and if so, it will set the value as the Matcher. So,
     *
     * {
     *   Body: {
     *     $ObjectLike: {
     *       Elements: {
     *         $ArrayWith: [{ Asdf: 3 }],
     *       },
     *     },
     *   },
     * }
     *
     * Will be converted to
     * {
     *   Body: Match.objectLike({
     *     Elements: Match.arrayWith([{ Asdf: 3 }]),
     *   }),
     * }
     */
    getMatcher() {
        try {
            const final = JSON.parse(JSON.stringify(this.parsedObj), function (_k, v) {
                const nested = Object.keys(v)[0];
                switch (nested) {
                    case '$ArrayWith':
                        return helpers_internal_1.Match.arrayWith(v[nested]);
                    case '$ObjectLike':
                        return helpers_internal_1.Match.objectLike(v[nested]);
                    case '$StringLike':
                        return helpers_internal_1.Match.stringLikeRegexp(v[nested]);
                    default:
                        return v;
                }
            });
            if (helpers_internal_1.Matcher.isMatcher(final.matcher)) {
                return final.matcher;
            }
            return helpers_internal_1.Match.exact(final.matcher);
        }
        catch {
            return helpers_internal_1.Match.exact(this.parsedObj.matcher);
        }
    }
}
function decodeCall(call) {
    if (!call) {
        return undefined;
    }
    try {
        const parsed = JSON.parse(call);
        return parsed;
    }
    catch (e) {
        return call;
    }
}
//# sourceMappingURL=data:application/json;base64,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