import { Construct } from 'constructs';
import { ExpectedResult, ActualResult } from './common';
import { Construct as CoreConstruct } from '../../../core';
/**
 * Options for an EqualsAssertion
 */
export interface EqualsAssertionProps {
    /**
     * The actual results to compare
     */
    readonly actual: ActualResult;
    /**
     * The expected result to assert
     */
    readonly expected: ExpectedResult;
    /**
     * Set this to true if a failed assertion should
     * result in a CloudFormation deployment failure
     *
     * This is only necessary if assertions are being
     * executed outside of `integ-runner`.
     *
     * @default false
     */
    readonly failDeployment?: boolean;
}
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
export declare class EqualsAssertion extends CoreConstruct {
    /**
     * The result of the assertion
     */
    readonly result: string;
    constructor(scope: Construct, id: string, props: EqualsAssertionProps);
}
