"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationStackArtifact = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cxschema = require("../../../cloud-assembly-schema");
const cloud_artifact_1 = require("../cloud-artifact");
const environment_1 = require("../environment");
class CloudFormationStackArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        try {
            jsiiDeprecationWarnings.monocdk_cx_api_CloudAssembly(assembly);
            jsiiDeprecationWarnings.monocdk_cloud_assembly_schema_ArtifactManifest(artifact);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudFormationStackArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.templateFile) {
            throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        }
        if (!artifact.environment) {
            throw new Error('Invalid CloudFormation stack artifact. Missing environment');
        }
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment);
        this.templateFile = properties.templateFile;
        this.parameters = properties.parameters ?? {};
        // We get the tags from 'properties' if available (cloud assembly format >= 6.0.0), otherwise
        // from the stack metadata
        this.tags = properties.tags ?? this.tagsFromMetadata();
        this.assumeRoleArn = properties.assumeRoleArn;
        this.assumeRoleExternalId = properties.assumeRoleExternalId;
        this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn;
        this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl;
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
        this.terminationProtection = properties.terminationProtection;
        this.validateOnSynth = properties.validateOnSynth;
        this.lookupRole = properties.lookupRole;
        this.stackName = properties.stackName || artifactId;
        this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map(e => e.data);
        this.displayName = this.stackName === artifactId
            ? this.hierarchicalId
            : `${this.hierarchicalId} (${this.stackName})`;
        this.name = this.stackName; // backwards compat
        this.originalName = this.stackName;
    }
    /**
     * Full path to the template file
     */
    get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
    }
    /**
     * The CloudFormation template for this stack.
     */
    get template() {
        if (this._template === undefined) {
            this._template = JSON.parse(fs.readFileSync(this.templateFullPath, 'utf-8'));
        }
        return this._template;
    }
    tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS)) {
            for (const tag of (metadataEntry.data ?? [])) {
                ret[tag.key] = tag.value;
            }
        }
        return ret;
    }
}
exports.CloudFormationStackArtifact = CloudFormationStackArtifact;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationStackArtifact[_a] = { fqn: "monocdk.cx_api.CloudFormationStackArtifact", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmb3JtYXRpb24tYXJ0aWZhY3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZvcm1hdGlvbi1hcnRpZmFjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLDJEQUEyRDtBQUMzRCxzREFBa0Q7QUFFbEQsZ0RBQStEO0FBRS9ELE1BQWEsMkJBQTRCLFNBQVEsOEJBQWE7SUFpSDVELFlBQVksUUFBdUIsRUFBRSxVQUFrQixFQUFFLFFBQW1DO1FBQzFGLEtBQUssQ0FBQyxRQUFRLEVBQUUsVUFBVSxFQUFFLFFBQVEsQ0FBQyxDQUFDOzs7Ozs7OytDQWxIN0IsMkJBQTJCOzs7O1FBb0hwQyxNQUFNLFVBQVUsR0FBRyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxJQUFJLEVBQUUsQ0FBOEMsQ0FBQztRQUNqRyxJQUFJLENBQUMsVUFBVSxDQUFDLFlBQVksRUFBRTtZQUM1QixNQUFNLElBQUksS0FBSyxDQUFDLG1HQUFtRyxDQUFDLENBQUM7U0FDdEg7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsRUFBRTtZQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLDREQUE0RCxDQUFDLENBQUM7U0FDL0U7UUFDRCxJQUFJLENBQUMsV0FBVyxHQUFHLDhCQUFnQixDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7UUFDaEUsSUFBSSxDQUFDLFlBQVksR0FBRyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQzVDLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7UUFFOUMsNkZBQTZGO1FBQzdGLDBCQUEwQjtRQUMxQixJQUFJLENBQUMsSUFBSSxHQUFHLFVBQVUsQ0FBQyxJQUFJLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUM7UUFDdkQsSUFBSSxDQUFDLGFBQWEsR0FBRyxVQUFVLENBQUMsYUFBYSxDQUFDO1FBQzlDLElBQUksQ0FBQyxvQkFBb0IsR0FBRyxVQUFVLENBQUMsb0JBQW9CLENBQUM7UUFDNUQsSUFBSSxDQUFDLDhCQUE4QixHQUFHLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQztRQUNoRixJQUFJLENBQUMsMkJBQTJCLEdBQUcsVUFBVSxDQUFDLDJCQUEyQixDQUFDO1FBQzFFLElBQUksQ0FBQyw2QkFBNkIsR0FBRyxVQUFVLENBQUMsNkJBQTZCLENBQUM7UUFDOUUsSUFBSSxDQUFDLGlDQUFpQyxHQUFHLFVBQVUsQ0FBQyxpQ0FBaUMsQ0FBQztRQUN0RixJQUFJLENBQUMscUJBQXFCLEdBQUcsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQzlELElBQUksQ0FBQyxlQUFlLEdBQUcsVUFBVSxDQUFDLGVBQWUsQ0FBQztRQUNsRCxJQUFJLENBQUMsVUFBVSxHQUFHLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFFeEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxVQUFVLENBQUMsU0FBUyxJQUFJLFVBQVUsQ0FBQztRQUNwRCxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMseUJBQXlCLENBQUMsS0FBSyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQW1DLENBQUMsQ0FBQztRQUVoSSxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQyxTQUFTLEtBQUssVUFBVTtZQUM5QyxDQUFDLENBQUMsSUFBSSxDQUFDLGNBQWM7WUFDckIsQ0FBQyxDQUFDLEdBQUcsSUFBSSxDQUFDLGNBQWMsS0FBSyxJQUFJLENBQUMsU0FBUyxHQUFHLENBQUM7UUFFakQsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsbUJBQW1CO1FBQy9DLElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQztLQUNwQztJQUVEOztPQUVHO0lBQ0gsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztLQUM5RDtJQUVEOztPQUVHO0lBQ0gsSUFBVyxRQUFRO1FBQ2pCLElBQUksSUFBSSxDQUFDLFNBQVMsS0FBSyxTQUFTLEVBQUU7WUFDaEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLGdCQUFnQixFQUFFLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDOUU7UUFDRCxPQUFPLElBQUksQ0FBQyxTQUFTLENBQUM7S0FDdkI7SUFFTyxnQkFBZ0I7UUFDdEIsTUFBTSxHQUFHLEdBQTJCLEVBQUUsQ0FBQztRQUN2QyxLQUFLLE1BQU0sYUFBYSxJQUFJLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMseUJBQXlCLENBQUMsVUFBVSxDQUFDLEVBQUU7WUFDbEcsS0FBSyxNQUFNLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLElBQUksRUFBRSxDQUFvQyxFQUFFO2dCQUMvRSxHQUFHLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUM7YUFDMUI7U0FDRjtRQUNELE9BQU8sR0FBRyxDQUFDO0tBQ1o7O0FBaExILGtFQWlMQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGZzIGZyb20gJ2ZzJztcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBjeHNjaGVtYSBmcm9tICcuLi8uLi8uLi9jbG91ZC1hc3NlbWJseS1zY2hlbWEnO1xuaW1wb3J0IHsgQ2xvdWRBcnRpZmFjdCB9IGZyb20gJy4uL2Nsb3VkLWFydGlmYWN0JztcbmltcG9ydCB0eXBlIHsgQ2xvdWRBc3NlbWJseSB9IGZyb20gJy4uL2Nsb3VkLWFzc2VtYmx5JztcbmltcG9ydCB7IEVudmlyb25tZW50LCBFbnZpcm9ubWVudFV0aWxzIH0gZnJvbSAnLi4vZW52aXJvbm1lbnQnO1xuXG5leHBvcnQgY2xhc3MgQ2xvdWRGb3JtYXRpb25TdGFja0FydGlmYWN0IGV4dGVuZHMgQ2xvdWRBcnRpZmFjdCB7XG4gIC8qKlxuICAgKiBUaGUgZmlsZSBuYW1lIG9mIHRoZSB0ZW1wbGF0ZS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0ZW1wbGF0ZUZpbGU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG9yaWdpbmFsIG5hbWUgYXMgZGVmaW5lZCBpbiB0aGUgQ0RLIGFwcC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBvcmlnaW5hbE5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogQW55IGFzc2V0cyBhc3NvY2lhdGVkIHdpdGggdGhpcyBzdGFjay5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhc3NldHM6IGN4c2NoZW1hLkFzc2V0TWV0YWRhdGFFbnRyeVtdO1xuXG4gIC8qKlxuICAgKiBDbG91ZEZvcm1hdGlvbiBwYXJhbWV0ZXJzIHRvIHBhc3MgdG8gdGhlIHN0YWNrLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHBhcmFtZXRlcnM6IHsgW2lkOiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogQ2xvdWRGb3JtYXRpb24gdGFncyB0byBwYXNzIHRvIHRoZSBzdGFjay5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0YWdzOiB7IFtpZDogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIFRoZSBwaHlzaWNhbCBuYW1lIG9mIHRoaXMgc3RhY2suXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhY2tOYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgc3RyaW5nIHRoYXQgcmVwcmVzZW50cyB0aGlzIHN0YWNrLiBTaG91bGQgb25seSBiZSB1c2VkIGluIHVzZXJcbiAgICogaW50ZXJmYWNlcy4gSWYgdGhlIHN0YWNrTmFtZSBoYXMgbm90IGJlZW4gc2V0IGV4cGxpY2l0bHksIG9yIGhhcyBiZWVuIHNldFxuICAgKiB0byBhcnRpZmFjdElkLCBpdCB3aWxsIHJldHVybiB0aGUgaGllcmFyY2hpY2FsSWQgb2YgdGhlIHN0YWNrLiBPdGhlcndpc2UsXG4gICAqIGl0IHdpbGwgcmV0dXJuIHNvbWV0aGluZyBsaWtlIFwiPGhpZXJhcmNoaWNhbElkPiAoPHN0YWNrTmFtZT4pXCJcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBkaXNwbGF5TmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcGh5c2ljYWwgbmFtZSBvZiB0aGlzIHN0YWNrLlxuICAgKiBAZGVwcmVjYXRlZCByZW5hbWVkIHRvIGBzdGFja05hbWVgXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgZW52aXJvbm1lbnQgaW50byB3aGljaCB0byBkZXBsb3kgdGhpcyBhcnRpZmFjdC5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBlbnZpcm9ubWVudDogRW52aXJvbm1lbnQ7XG5cbiAgLyoqXG4gICAqIFRoZSByb2xlIHRoYXQgbmVlZHMgdG8gYmUgYXNzdW1lZCB0byBkZXBsb3kgdGhlIHN0YWNrXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gcm9sZSBpcyBhc3N1bWVkIChjdXJyZW50IGNyZWRlbnRpYWxzIGFyZSB1c2VkKVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGFzc3VtZVJvbGVBcm4/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEV4dGVybmFsIElEIHRvIHVzZSB3aGVuIGFzc3VtaW5nIHJvbGUgZm9yIGNsb3VkZm9ybWF0aW9uIGRlcGxveW1lbnRzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZXh0ZXJuYWwgSURcbiAgICovXG4gIHJlYWRvbmx5IGFzc3VtZVJvbGVFeHRlcm5hbElkPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcm9sZSB0aGF0IGlzIHBhc3NlZCB0byBDbG91ZEZvcm1hdGlvbiB0byBleGVjdXRlIHRoZSBjaGFuZ2Ugc2V0XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gcm9sZSBpcyBwYXNzZWQgKGN1cnJlbnRseSBhc3N1bWVkIHJvbGUvY3JlZGVudGlhbHMgYXJlIHVzZWQpXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgY2xvdWRGb3JtYXRpb25FeGVjdXRpb25Sb2xlQXJuPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgcm9sZSB0byB1c2UgdG8gbG9vayB1cCB2YWx1ZXMgZnJvbSB0aGUgdGFyZ2V0IEFXUyBhY2NvdW50XG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gcm9sZSBpcyBhc3N1bWVkIChjdXJyZW50IGNyZWRlbnRpYWxzIGFyZSB1c2VkKVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGxvb2t1cFJvbGU/OiBjeHNjaGVtYS5Cb290c3RyYXBSb2xlO1xuXG4gIC8qKlxuICAgKiBJZiB0aGUgc3RhY2sgdGVtcGxhdGUgaGFzIGFscmVhZHkgYmVlbiBpbmNsdWRlZCBpbiB0aGUgYXNzZXQgbWFuaWZlc3QsIGl0cyBhc3NldCBVUkxcbiAgICpcbiAgICogQGRlZmF1bHQgLSBOb3QgdXBsb2FkZWQgeWV0LCB1cGxvYWQganVzdCBiZWZvcmUgZGVwbG95aW5nXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgc3RhY2tUZW1wbGF0ZUFzc2V0T2JqZWN0VXJsPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBWZXJzaW9uIG9mIGJvb3RzdHJhcCBzdGFjayByZXF1aXJlZCB0byBkZXBsb3kgdGhpcyBzdGFja1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIGJvb3RzdHJhcCBzdGFjayByZXF1aXJlZFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHJlcXVpcmVzQm9vdHN0cmFwU3RhY2tWZXJzaW9uPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBOYW1lIG9mIFNTTSBwYXJhbWV0ZXIgd2l0aCBib290c3RyYXAgc3RhY2sgdmVyc2lvblxuICAgKlxuICAgKiBAZGVmYXVsdCAtIERpc2NvdmVyIFNTTSBwYXJhbWV0ZXIgYnkgcmVhZGluZyBzdGFja1xuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGJvb3RzdHJhcFN0YWNrVmVyc2lvblNzbVBhcmFtZXRlcj86IHN0cmluZztcblxuICAvKipcbiAgICogV2hldGhlciB0ZXJtaW5hdGlvbiBwcm90ZWN0aW9uIGlzIGVuYWJsZWQgZm9yIHRoaXMgc3RhY2suXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgdGVybWluYXRpb25Qcm90ZWN0aW9uPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogV2hldGhlciB0aGlzIHN0YWNrIHNob3VsZCBiZSB2YWxpZGF0ZWQgYnkgdGhlIENMSSBhZnRlciBzeW50aGVzaXNcbiAgICpcbiAgICogQGRlZmF1bHQgLSBmYWxzZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHZhbGlkYXRlT25TeW50aD86IGJvb2xlYW47XG5cbiAgcHJpdmF0ZSBfdGVtcGxhdGU6IGFueSB8IHVuZGVmaW5lZDtcblxuICBjb25zdHJ1Y3Rvcihhc3NlbWJseTogQ2xvdWRBc3NlbWJseSwgYXJ0aWZhY3RJZDogc3RyaW5nLCBhcnRpZmFjdDogY3hzY2hlbWEuQXJ0aWZhY3RNYW5pZmVzdCkge1xuICAgIHN1cGVyKGFzc2VtYmx5LCBhcnRpZmFjdElkLCBhcnRpZmFjdCk7XG5cbiAgICBjb25zdCBwcm9wZXJ0aWVzID0gKHRoaXMubWFuaWZlc3QucHJvcGVydGllcyB8fCB7fSkgYXMgY3hzY2hlbWEuQXdzQ2xvdWRGb3JtYXRpb25TdGFja1Byb3BlcnRpZXM7XG4gICAgaWYgKCFwcm9wZXJ0aWVzLnRlbXBsYXRlRmlsZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkIENsb3VkRm9ybWF0aW9uIHN0YWNrIGFydGlmYWN0LiBNaXNzaW5nIFwidGVtcGxhdGVGaWxlXCIgcHJvcGVydHkgaW4gY2xvdWQgYXNzZW1ibHkgbWFuaWZlc3QnKTtcbiAgICB9XG4gICAgaWYgKCFhcnRpZmFjdC5lbnZpcm9ubWVudCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdJbnZhbGlkIENsb3VkRm9ybWF0aW9uIHN0YWNrIGFydGlmYWN0LiBNaXNzaW5nIGVudmlyb25tZW50Jyk7XG4gICAgfVxuICAgIHRoaXMuZW52aXJvbm1lbnQgPSBFbnZpcm9ubWVudFV0aWxzLnBhcnNlKGFydGlmYWN0LmVudmlyb25tZW50KTtcbiAgICB0aGlzLnRlbXBsYXRlRmlsZSA9IHByb3BlcnRpZXMudGVtcGxhdGVGaWxlO1xuICAgIHRoaXMucGFyYW1ldGVycyA9IHByb3BlcnRpZXMucGFyYW1ldGVycyA/PyB7fTtcblxuICAgIC8vIFdlIGdldCB0aGUgdGFncyBmcm9tICdwcm9wZXJ0aWVzJyBpZiBhdmFpbGFibGUgKGNsb3VkIGFzc2VtYmx5IGZvcm1hdCA+PSA2LjAuMCksIG90aGVyd2lzZVxuICAgIC8vIGZyb20gdGhlIHN0YWNrIG1ldGFkYXRhXG4gICAgdGhpcy50YWdzID0gcHJvcGVydGllcy50YWdzID8/IHRoaXMudGFnc0Zyb21NZXRhZGF0YSgpO1xuICAgIHRoaXMuYXNzdW1lUm9sZUFybiA9IHByb3BlcnRpZXMuYXNzdW1lUm9sZUFybjtcbiAgICB0aGlzLmFzc3VtZVJvbGVFeHRlcm5hbElkID0gcHJvcGVydGllcy5hc3N1bWVSb2xlRXh0ZXJuYWxJZDtcbiAgICB0aGlzLmNsb3VkRm9ybWF0aW9uRXhlY3V0aW9uUm9sZUFybiA9IHByb3BlcnRpZXMuY2xvdWRGb3JtYXRpb25FeGVjdXRpb25Sb2xlQXJuO1xuICAgIHRoaXMuc3RhY2tUZW1wbGF0ZUFzc2V0T2JqZWN0VXJsID0gcHJvcGVydGllcy5zdGFja1RlbXBsYXRlQXNzZXRPYmplY3RVcmw7XG4gICAgdGhpcy5yZXF1aXJlc0Jvb3RzdHJhcFN0YWNrVmVyc2lvbiA9IHByb3BlcnRpZXMucmVxdWlyZXNCb290c3RyYXBTdGFja1ZlcnNpb247XG4gICAgdGhpcy5ib290c3RyYXBTdGFja1ZlcnNpb25Tc21QYXJhbWV0ZXIgPSBwcm9wZXJ0aWVzLmJvb3RzdHJhcFN0YWNrVmVyc2lvblNzbVBhcmFtZXRlcjtcbiAgICB0aGlzLnRlcm1pbmF0aW9uUHJvdGVjdGlvbiA9IHByb3BlcnRpZXMudGVybWluYXRpb25Qcm90ZWN0aW9uO1xuICAgIHRoaXMudmFsaWRhdGVPblN5bnRoID0gcHJvcGVydGllcy52YWxpZGF0ZU9uU3ludGg7XG4gICAgdGhpcy5sb29rdXBSb2xlID0gcHJvcGVydGllcy5sb29rdXBSb2xlO1xuXG4gICAgdGhpcy5zdGFja05hbWUgPSBwcm9wZXJ0aWVzLnN0YWNrTmFtZSB8fCBhcnRpZmFjdElkO1xuICAgIHRoaXMuYXNzZXRzID0gdGhpcy5maW5kTWV0YWRhdGFCeVR5cGUoY3hzY2hlbWEuQXJ0aWZhY3RNZXRhZGF0YUVudHJ5VHlwZS5BU1NFVCkubWFwKGUgPT4gZS5kYXRhIGFzIGN4c2NoZW1hLkFzc2V0TWV0YWRhdGFFbnRyeSk7XG5cbiAgICB0aGlzLmRpc3BsYXlOYW1lID0gdGhpcy5zdGFja05hbWUgPT09IGFydGlmYWN0SWRcbiAgICAgID8gdGhpcy5oaWVyYXJjaGljYWxJZFxuICAgICAgOiBgJHt0aGlzLmhpZXJhcmNoaWNhbElkfSAoJHt0aGlzLnN0YWNrTmFtZX0pYDtcblxuICAgIHRoaXMubmFtZSA9IHRoaXMuc3RhY2tOYW1lOyAvLyBiYWNrd2FyZHMgY29tcGF0XG4gICAgdGhpcy5vcmlnaW5hbE5hbWUgPSB0aGlzLnN0YWNrTmFtZTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGdWxsIHBhdGggdG8gdGhlIHRlbXBsYXRlIGZpbGVcbiAgICovXG4gIHB1YmxpYyBnZXQgdGVtcGxhdGVGdWxsUGF0aCgpIHtcbiAgICByZXR1cm4gcGF0aC5qb2luKHRoaXMuYXNzZW1ibHkuZGlyZWN0b3J5LCB0aGlzLnRlbXBsYXRlRmlsZSk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIENsb3VkRm9ybWF0aW9uIHRlbXBsYXRlIGZvciB0aGlzIHN0YWNrLlxuICAgKi9cbiAgcHVibGljIGdldCB0ZW1wbGF0ZSgpOiBhbnkge1xuICAgIGlmICh0aGlzLl90ZW1wbGF0ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLl90ZW1wbGF0ZSA9IEpTT04ucGFyc2UoZnMucmVhZEZpbGVTeW5jKHRoaXMudGVtcGxhdGVGdWxsUGF0aCwgJ3V0Zi04JykpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5fdGVtcGxhdGU7XG4gIH1cblxuICBwcml2YXRlIHRhZ3NGcm9tTWV0YWRhdGEoKSB7XG4gICAgY29uc3QgcmV0OiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+ID0ge307XG4gICAgZm9yIChjb25zdCBtZXRhZGF0YUVudHJ5IG9mIHRoaXMuZmluZE1ldGFkYXRhQnlUeXBlKGN4c2NoZW1hLkFydGlmYWN0TWV0YWRhdGFFbnRyeVR5cGUuU1RBQ0tfVEFHUykpIHtcbiAgICAgIGZvciAoY29uc3QgdGFnIG9mIChtZXRhZGF0YUVudHJ5LmRhdGEgPz8gW10pIGFzIGN4c2NoZW1hLlN0YWNrVGFnc01ldGFkYXRhRW50cnkpIHtcbiAgICAgICAgcmV0W3RhZy5rZXldID0gdGFnLnZhbHVlO1xuICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gcmV0O1xuICB9XG59XG4iXX0=