"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetManifestArtifact = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cloud_artifact_1 = require("../cloud-artifact");
const ASSET_MANIFEST_ARTIFACT_SYM = Symbol.for('@aws-cdk/cx-api.AssetManifestArtifact');
/**
 * Asset manifest is a description of a set of assets which need to be built and published
 */
class AssetManifestArtifact extends cloud_artifact_1.CloudArtifact {
    constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
            jsiiDeprecationWarnings.monocdk_cx_api_CloudAssembly(assembly);
            jsiiDeprecationWarnings.monocdk_cloud_assembly_schema_ArtifactManifest(artifact);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetManifestArtifact);
            }
            throw error;
        }
        const properties = (this.manifest.properties || {});
        if (!properties.file) {
            throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        }
        this.file = path.resolve(this.assembly.directory, properties.file);
        this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion ?? 1;
        this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
    }
    /**
     * Checks if `art` is an instance of this class.
     *
     * Use this method instead of `instanceof` to properly detect `AssetManifestArtifact`
     * instances, even when the construct library is symlinked.
     *
     * Explanation: in JavaScript, multiple copies of the `cx-api` library on
     * disk are seen as independent, completely different libraries. As a
     * consequence, the class `AssetManifestArtifact` in each copy of the `cx-api` library
     * is seen as a different class, and an instance of one class will not test as
     * `instanceof` the other class. `npm install` will not create installations
     * like this, but users may manually symlink construct libraries together or
     * use a monorepo tool: in those cases, multiple copies of the `cx-api`
     * library can be accidentally installed, and `instanceof` will behave
     * unpredictably. It is safest to avoid using `instanceof`, and using
     * this type-testing method instead.
     */
    static isAssetManifestArtifact(art) {
        return art && typeof art === 'object' && art[ASSET_MANIFEST_ARTIFACT_SYM];
    }
}
exports.AssetManifestArtifact = AssetManifestArtifact;
_a = JSII_RTTI_SYMBOL_1;
AssetManifestArtifact[_a] = { fqn: "monocdk.cx_api.AssetManifestArtifact", version: "1.185.0" };
/**
 * Mark all instances of 'AssetManifestArtifact'
 *
 * Why not put this in the constructor? Because this is a class property,
 * not an instance property. It applies to all instances of the class.
 */
Object.defineProperty(AssetManifestArtifact.prototype, ASSET_MANIFEST_ARTIFACT_SYM, {
    value: true,
    enumerable: false,
    writable: false,
});
//# sourceMappingURL=data:application/json;base64,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