"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.calculateRetryPolicy = void 0;
const core_1 = require("../../../core");
const DEFAULT_TIMEOUT = core_1.Duration.minutes(30);
const DEFAULT_INTERVAL = core_1.Duration.seconds(5);
function calculateRetryPolicy(props = {}) {
    const totalTimeout = props.totalTimeout || DEFAULT_TIMEOUT;
    const interval = props.queryInterval || DEFAULT_INTERVAL;
    const maxAttempts = totalTimeout.toSeconds() / interval.toSeconds();
    if (Math.round(maxAttempts) !== maxAttempts) {
        throw new Error(`Cannot determine retry count since totalTimeout=${totalTimeout.toSeconds()}s is not integrally dividable by queryInterval=${interval.toSeconds()}s`);
    }
    return {
        maxAttempts,
        interval,
        backoffRate: 1,
    };
}
exports.calculateRetryPolicy = calculateRetryPolicy;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0NBQXlDO0FBRXpDLE1BQU0sZUFBZSxHQUFHLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDLENBQUM7QUFDN0MsTUFBTSxnQkFBZ0IsR0FBRyxlQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBRTdDLFNBQWdCLG9CQUFvQixDQUFDLFFBQStELEVBQUc7SUFDckcsTUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLFlBQVksSUFBSSxlQUFlLENBQUM7SUFDM0QsTUFBTSxRQUFRLEdBQUcsS0FBSyxDQUFDLGFBQWEsSUFBSSxnQkFBZ0IsQ0FBQztJQUN6RCxNQUFNLFdBQVcsR0FBRyxZQUFZLENBQUMsU0FBUyxFQUFFLEdBQUcsUUFBUSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBRXBFLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLENBQUMsS0FBSyxXQUFXLEVBQUU7UUFDM0MsTUFBTSxJQUFJLEtBQUssQ0FBQyxtREFBbUQsWUFBWSxDQUFDLFNBQVMsRUFBRSxrREFBa0QsUUFBUSxDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsQ0FBQztLQUN2SztJQUVELE9BQU87UUFDTCxXQUFXO1FBQ1gsUUFBUTtRQUNSLFdBQVcsRUFBRSxDQUFDO0tBQ2YsQ0FBQztBQUNKLENBQUM7QUFkRCxvREFjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSAnLi4vLi4vLi4vY29yZSc7XG5cbmNvbnN0IERFRkFVTFRfVElNRU9VVCA9IER1cmF0aW9uLm1pbnV0ZXMoMzApO1xuY29uc3QgREVGQVVMVF9JTlRFUlZBTCA9IER1cmF0aW9uLnNlY29uZHMoNSk7XG5cbmV4cG9ydCBmdW5jdGlvbiBjYWxjdWxhdGVSZXRyeVBvbGljeShwcm9wczogeyB0b3RhbFRpbWVvdXQ/OiBEdXJhdGlvbiwgcXVlcnlJbnRlcnZhbD86IER1cmF0aW9uIH0gPSB7IH0pIHtcbiAgY29uc3QgdG90YWxUaW1lb3V0ID0gcHJvcHMudG90YWxUaW1lb3V0IHx8IERFRkFVTFRfVElNRU9VVDtcbiAgY29uc3QgaW50ZXJ2YWwgPSBwcm9wcy5xdWVyeUludGVydmFsIHx8IERFRkFVTFRfSU5URVJWQUw7XG4gIGNvbnN0IG1heEF0dGVtcHRzID0gdG90YWxUaW1lb3V0LnRvU2Vjb25kcygpIC8gaW50ZXJ2YWwudG9TZWNvbmRzKCk7XG5cbiAgaWYgKE1hdGgucm91bmQobWF4QXR0ZW1wdHMpICE9PSBtYXhBdHRlbXB0cykge1xuICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGRldGVybWluZSByZXRyeSBjb3VudCBzaW5jZSB0b3RhbFRpbWVvdXQ9JHt0b3RhbFRpbWVvdXQudG9TZWNvbmRzKCl9cyBpcyBub3QgaW50ZWdyYWxseSBkaXZpZGFibGUgYnkgcXVlcnlJbnRlcnZhbD0ke2ludGVydmFsLnRvU2Vjb25kcygpfXNgKTtcbiAgfVxuXG4gIHJldHVybiB7XG4gICAgbWF4QXR0ZW1wdHMsXG4gICAgaW50ZXJ2YWwsXG4gICAgYmFja29mZlJhdGU6IDEsXG4gIH07XG59XG4iXX0=