import * as cxschema from '../../../cloud-assembly-schema';
import { FileAssetSource, FileAssetLocation, DockerImageAssetSource, DockerImageAssetLocation } from '../assets';
import { ISynthesisSession } from '../construct-compat';
import { Stack } from '../stack';
/**
 * Build an manifest from assets added to a stack synthesizer
 */
export declare class AssetManifestBuilder {
    private readonly files;
    private readonly dockerImages;
    addFileAssetDefault(asset: FileAssetSource, stack: Stack, bucketName: string, bucketPrefix: string, role?: RoleOptions): FileAssetLocation;
    addDockerImageAssetDefault(asset: DockerImageAssetSource, stack: Stack, repositoryName: string, dockerTagPrefix: string, role?: RoleOptions): DockerImageAssetLocation;
    /**
     * Write the manifest to disk, and add it to the synthesis session
     *
     * Reutrn the artifact Id
     */
    writeManifest(stack: Stack, session: ISynthesisSession, additionalProps?: Partial<cxschema.AssetManifestProperties>): string;
    private manifestEnvName;
}
export interface RoleOptions {
    readonly assumeRoleArn?: string;
    readonly assumeRoleExternalId?: string;
}
