"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnDeletionPolicy = void 0;
/**
 * With the DeletionPolicy attribute you can preserve or (in some cases) backup a resource when its stack is deleted.
 * You specify a DeletionPolicy attribute for each resource that you want to control. If a resource has no DeletionPolicy
 * attribute, AWS CloudFormation deletes the resource by default. Note that this capability also applies to update operations
 * that lead to resources being removed.
 */
var CfnDeletionPolicy;
(function (CfnDeletionPolicy) {
    /**
     * AWS CloudFormation deletes the resource and all its content if applicable during stack deletion. You can add this
     * deletion policy to any resource type. By default, if you don't specify a DeletionPolicy, AWS CloudFormation deletes
     * your resources. However, be aware of the following considerations:
     */
    CfnDeletionPolicy["DELETE"] = "Delete";
    /**
     * AWS CloudFormation keeps the resource without deleting the resource or its contents when its stack is deleted.
     * You can add this deletion policy to any resource type. Note that when AWS CloudFormation completes the stack deletion,
     * the stack will be in Delete_Complete state; however, resources that are retained continue to exist and continue to incur
     * applicable charges until you delete those resources.
     */
    CfnDeletionPolicy["RETAIN"] = "Retain";
    /**
     * For resources that support snapshots (AWS::EC2::Volume, AWS::ElastiCache::CacheCluster, AWS::ElastiCache::ReplicationGroup,
     * AWS::RDS::DBInstance, AWS::RDS::DBCluster, and AWS::Redshift::Cluster), AWS CloudFormation creates a snapshot for the
     * resource before deleting it. Note that when AWS CloudFormation completes the stack deletion, the stack will be in the
     * Delete_Complete state; however, the snapshots that are created with this policy continue to exist and continue to
     * incur applicable charges until you delete those snapshots.
     */
    CfnDeletionPolicy["SNAPSHOT"] = "Snapshot";
})(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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