"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaSubscription = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const sns = require("../../aws-sns");
const core_1 = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core");
/**
 * Use a Lambda function as a subscription target
 */
class LambdaSubscription {
    constructor(fn, props = {}) {
        this.fn = fn;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.monocdk_aws_sns_subscriptions_LambdaSubscriptionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaSubscription);
            }
            throw error;
        }
    }
    /**
     * Returns a configuration for a Lambda function to subscribe to an SNS topic
     */
    bind(topic) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_sns_ITopic(topic);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Create subscription under *consuming* construct to make sure it ends up
        // in the correct stack in cases of cross-stack subscriptions.
        if (!core_2.Construct.isConstruct(this.fn)) {
            throw new Error('The supplied lambda Function object must be an instance of Construct');
        }
        this.fn.addPermission(`AllowInvoke:${core_1.Names.nodeUniqueId(topic.node)}`, {
            sourceArn: topic.topicArn,
            principal: new iam.ServicePrincipal('sns.amazonaws.com'),
        });
        // if the topic and function are created in different stacks
        // then we need to make sure the topic is created first
        if (topic instanceof sns.Topic && topic.stack !== this.fn.stack) {
            this.fn.stack.addDependency(topic.stack);
        }
        return {
            subscriberScope: this.fn,
            subscriberId: topic.node.id,
            endpoint: this.fn.functionArn,
            protocol: sns.SubscriptionProtocol.LAMBDA,
            filterPolicy: this.props.filterPolicy,
            region: this.regionFromArn(topic),
            deadLetterQueue: this.props.deadLetterQueue,
        };
    }
    regionFromArn(topic) {
        // no need to specify `region` for topics defined within the same stack.
        if (topic instanceof sns.Topic) {
            if (topic.stack !== this.fn.stack) {
                // only if we know the region, will not work for
                // env agnostic stacks
                if (!core_1.Token.isUnresolved(topic.env.region) &&
                    (topic.env.region !== this.fn.env.region)) {
                    return topic.env.region;
                }
            }
            return undefined;
        }
        return core_1.Stack.of(topic).splitArn(topic.topicArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).region;
    }
}
exports.LambdaSubscription = LambdaSubscription;
_a = JSII_RTTI_SYMBOL_1;
LambdaSubscription[_a] = { fqn: "monocdk.aws_sns_subscriptions.LambdaSubscription", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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