"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("../../core");
const servicediscovery = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-servicediscovery-integ');
const namespace = new servicediscovery.PublicDnsNamespace(stack, 'Namespace', {
    name: 'foobar.com',
});
const service = namespace.createService('Service', {
    name: 'foo',
    dnsRecordType: servicediscovery.DnsRecordType.CNAME,
    dnsTtl: cdk.Duration.seconds(30),
});
service.registerCnameInstance('CnameInstance', {
    instanceCname: 'service.pizza',
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuc2VydmljZS13aXRoLWNuYW1lLXJlY29yZC5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5zZXJ2aWNlLXdpdGgtY25hbWUtcmVjb3JkLmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGtDQUFrQztBQUNsQywyQ0FBMkM7QUFFM0MsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxDQUFDLEdBQUcsRUFBRSw0QkFBNEIsQ0FBQyxDQUFDO0FBRS9ELE1BQU0sU0FBUyxHQUFHLElBQUksZ0JBQWdCLENBQUMsa0JBQWtCLENBQUMsS0FBSyxFQUFFLFdBQVcsRUFBRTtJQUM1RSxJQUFJLEVBQUUsWUFBWTtDQUNuQixDQUFDLENBQUM7QUFFSCxNQUFNLE9BQU8sR0FBRyxTQUFTLENBQUMsYUFBYSxDQUFDLFNBQVMsRUFBRTtJQUNqRCxJQUFJLEVBQUUsS0FBSztJQUNYLGFBQWEsRUFBRSxnQkFBZ0IsQ0FBQyxhQUFhLENBQUMsS0FBSztJQUNuRCxNQUFNLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO0NBQ2pDLENBQUMsQ0FBQztBQUVILE9BQU8sQ0FBQyxxQkFBcUIsQ0FBQyxlQUFlLEVBQUU7SUFDN0MsYUFBYSxFQUFFLGVBQWU7Q0FDL0IsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY2RrIGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0ICogYXMgc2VydmljZWRpc2NvdmVyeSBmcm9tICcuLi9saWInO1xuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKGFwcCwgJ2F3cy1zZXJ2aWNlZGlzY292ZXJ5LWludGVnJyk7XG5cbmNvbnN0IG5hbWVzcGFjZSA9IG5ldyBzZXJ2aWNlZGlzY292ZXJ5LlB1YmxpY0Ruc05hbWVzcGFjZShzdGFjaywgJ05hbWVzcGFjZScsIHtcbiAgbmFtZTogJ2Zvb2Jhci5jb20nLFxufSk7XG5cbmNvbnN0IHNlcnZpY2UgPSBuYW1lc3BhY2UuY3JlYXRlU2VydmljZSgnU2VydmljZScsIHtcbiAgbmFtZTogJ2ZvbycsXG4gIGRuc1JlY29yZFR5cGU6IHNlcnZpY2VkaXNjb3ZlcnkuRG5zUmVjb3JkVHlwZS5DTkFNRSxcbiAgZG5zVHRsOiBjZGsuRHVyYXRpb24uc2Vjb25kcygzMCksXG59KTtcblxuc2VydmljZS5yZWdpc3RlckNuYW1lSW5zdGFuY2UoJ0NuYW1lSW5zdGFuY2UnLCB7XG4gIGluc3RhbmNlQ25hbWU6ICdzZXJ2aWNlLnBpenphJyxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==