"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PublicDnsNamespace = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const namespace_1 = require("./namespace");
const service_1 = require("./service");
const servicediscovery_generated_1 = require("./servicediscovery.generated");
/**
 * Define a Public DNS Namespace
 */
class PublicDnsNamespace extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_servicediscovery_PublicDnsNamespaceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, PublicDnsNamespace);
            }
            throw error;
        }
        const ns = new servicediscovery_generated_1.CfnPublicDnsNamespace(this, 'Resource', {
            name: props.name,
            description: props.description,
        });
        this.namespaceName = props.name;
        this.namespaceId = ns.attrId;
        this.namespaceArn = ns.attrArn;
        this.type = namespace_1.NamespaceType.DNS_PUBLIC;
    }
    static fromPublicDnsNamespaceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_servicediscovery_PublicDnsNamespaceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromPublicDnsNamespaceAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.namespaceName = attrs.namespaceName;
                this.namespaceId = attrs.namespaceId;
                this.namespaceArn = attrs.namespaceArn;
                this.type = namespace_1.NamespaceType.DNS_PUBLIC;
            }
        }
        return new Import(scope, id);
    }
    /** @attribute */
    get publicDnsNamespaceArn() { return this.namespaceArn; }
    /** @attribute */
    get publicDnsNamespaceName() { return this.namespaceName; }
    /** @attribute */
    get publicDnsNamespaceId() { return this.namespaceId; }
    /**
     * Creates a service within the namespace
     */
    createService(id, props) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_servicediscovery_DnsServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createService);
            }
            throw error;
        }
        return new service_1.Service(this, id, {
            namespace: this,
            ...props,
        });
    }
}
exports.PublicDnsNamespace = PublicDnsNamespace;
_a = JSII_RTTI_SYMBOL_1;
PublicDnsNamespace[_a] = { fqn: "monocdk.aws_servicediscovery.PublicDnsNamespace", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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