"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const s3 = require("../../aws-s3");
const core_1 = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core");
/**
 * Use a Lambda function as a bucket notification destination
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    bind(_scope, bucket) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!core_2.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_s3_notifications.LambdaDestination", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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