"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticBeanstalkEnvironmentEndpointTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const region_info_1 = require("../../region-info");
/**
 * Use an Elastic Beanstalk environment URL as an alias record target.
 * E.g. mysampleenvironment.xyz.us-east-1.elasticbeanstalk.com
 * or mycustomcnameprefix.us-east-1.elasticbeanstalk.com
 *
 * Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 */
class ElasticBeanstalkEnvironmentEndpointTarget {
    constructor(environmentEndpoint) {
        this.environmentEndpoint = environmentEndpoint;
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (cdk.Token.isUnresolved(this.environmentEndpoint)) {
            throw new Error('Cannot use an EBS alias as `environmentEndpoint`. You must find your EBS environment endpoint via the AWS console. See the Elastic Beanstalk developer guide: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html');
        }
        const dnsName = this.environmentEndpoint;
        const subDomains = cdk.Fn.split('.', dnsName);
        const regionSubdomainIndex = subDomains.length - 3;
        const region = cdk.Fn.select(regionSubdomainIndex, subDomains);
        const { ebsEnvEndpointHostedZoneId: hostedZoneId } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Elastic Beanstalk environment target is not supported for the "${region}" region.`);
        }
        return {
            hostedZoneId,
            dnsName,
        };
    }
}
exports.ElasticBeanstalkEnvironmentEndpointTarget = ElasticBeanstalkEnvironmentEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
ElasticBeanstalkEnvironmentEndpointTarget[_a] = { fqn: "monocdk.aws_route53_targets.ElasticBeanstalkEnvironmentEndpointTarget", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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