"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayv2DomainProperties = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines an API Gateway V2 domain name as the alias target.
 */
class ApiGatewayv2DomainProperties {
    /**
     * @param regionalDomainName the domain name associated with the regional endpoint for this custom domain name.
     * @param regionalHostedZoneId the region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    constructor(regionalDomainName, regionalHostedZoneId) {
        this.regionalDomainName = regionalDomainName;
        this.regionalHostedZoneId = regionalHostedZoneId;
    }
    bind(_record, _zone) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_route53_IRecordSet(_record);
            jsiiDeprecationWarnings.monocdk_aws_route53_IHostedZone(_zone);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            dnsName: this.regionalDomainName,
            hostedZoneId: this.regionalHostedZoneId,
        };
    }
}
exports.ApiGatewayv2DomainProperties = ApiGatewayv2DomainProperties;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayv2DomainProperties[_a] = { fqn: "monocdk.aws_route53_targets.ApiGatewayv2DomainProperties", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLWdhdGV3YXl2Mi1kb21haW4tbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwaS1nYXRld2F5djItZG9tYWluLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBRUE7O0dBRUc7QUFDSCxNQUFhLDRCQUE0QjtJQUN2Qzs7O09BR0c7SUFDSCxZQUE2QixrQkFBMEIsRUFBbUIsb0JBQTRCO1FBQXpFLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBUTtRQUFtQix5QkFBb0IsR0FBcEIsb0JBQW9CLENBQVE7S0FBSztJQUVwRyxJQUFJLENBQUMsT0FBMkIsRUFBRSxLQUEyQjs7Ozs7Ozs7Ozs7UUFDbEUsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQ2hDLFlBQVksRUFBRSxJQUFJLENBQUMsb0JBQW9CO1NBQ3hDLENBQUM7S0FDSDs7QUFaSCxvRUFhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnLi4vLi4vYXdzLXJvdXRlNTMnO1xuXG4vKipcbiAqIERlZmluZXMgYW4gQVBJIEdhdGV3YXkgVjIgZG9tYWluIG5hbWUgYXMgdGhlIGFsaWFzIHRhcmdldC5cbiAqL1xuZXhwb3J0IGNsYXNzIEFwaUdhdGV3YXl2MkRvbWFpblByb3BlcnRpZXMgaW1wbGVtZW50cyByb3V0ZTUzLklBbGlhc1JlY29yZFRhcmdldCB7XG4gIC8qKlxuICAgKiBAcGFyYW0gcmVnaW9uYWxEb21haW5OYW1lIHRoZSBkb21haW4gbmFtZSBhc3NvY2lhdGVkIHdpdGggdGhlIHJlZ2lvbmFsIGVuZHBvaW50IGZvciB0aGlzIGN1c3RvbSBkb21haW4gbmFtZS5cbiAgICogQHBhcmFtIHJlZ2lvbmFsSG9zdGVkWm9uZUlkIHRoZSByZWdpb24tc3BlY2lmaWMgQW1hem9uIFJvdXRlIDUzIEhvc3RlZCBab25lIElEIG9mIHRoZSByZWdpb25hbCBlbmRwb2ludC5cbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcmVnaW9uYWxEb21haW5OYW1lOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcmVnaW9uYWxIb3N0ZWRab25lSWQ6IHN0cmluZykgeyB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0LCBfem9uZT86IHJvdXRlNTMuSUhvc3RlZFpvbmUpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgZG5zTmFtZTogdGhpcy5yZWdpb25hbERvbWFpbk5hbWUsXG4gICAgICBob3N0ZWRab25lSWQ6IHRoaXMucmVnaW9uYWxIb3N0ZWRab25lSWQsXG4gICAgfTtcbiAgfVxufVxuIl19