"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPackagingGroup = exports.CfnPackagingConfiguration = exports.CfnOriginEndpoint = exports.CfnChannel = exports.CfnAsset = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-27T19:35:17.627Z","fingerprint":"Vvm5bSVZcWf+Mj1WB9Msj1LgHWWfEIDcfPoHnejQH90="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAssetProps`
 *
 * @param properties - the TypeScript properties of a `CfnAssetProps`
 *
 * @returns the result of the validation.
 */
function CfnAssetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('packagingGroupId', cdk.requiredValidator)(properties.packagingGroupId));
    errors.collect(cdk.propertyValidator('packagingGroupId', cdk.validateString)(properties.packagingGroupId));
    errors.collect(cdk.propertyValidator('resourceId', cdk.validateString)(properties.resourceId));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.requiredValidator)(properties.sourceArn));
    errors.collect(cdk.propertyValidator('sourceArn', cdk.validateString)(properties.sourceArn));
    errors.collect(cdk.propertyValidator('sourceRoleArn', cdk.requiredValidator)(properties.sourceRoleArn));
    errors.collect(cdk.propertyValidator('sourceRoleArn', cdk.validateString)(properties.sourceRoleArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnAssetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Asset` resource
 *
 * @param properties - the TypeScript properties of a `CfnAssetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Asset` resource.
 */
// @ts-ignore TS6133
function cfnAssetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAssetPropsValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        PackagingGroupId: cdk.stringToCloudFormation(properties.packagingGroupId),
        SourceArn: cdk.stringToCloudFormation(properties.sourceArn),
        SourceRoleArn: cdk.stringToCloudFormation(properties.sourceRoleArn),
        ResourceId: cdk.stringToCloudFormation(properties.resourceId),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnAssetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('packagingGroupId', 'PackagingGroupId', cfn_parse.FromCloudFormation.getString(properties.PackagingGroupId));
    ret.addPropertyResult('sourceArn', 'SourceArn', cfn_parse.FromCloudFormation.getString(properties.SourceArn));
    ret.addPropertyResult('sourceRoleArn', 'SourceRoleArn', cfn_parse.FromCloudFormation.getString(properties.SourceRoleArn));
    ret.addPropertyResult('resourceId', 'ResourceId', properties.ResourceId != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceId) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaPackage::Asset`
 *
 * Creates an asset to ingest VOD content.
 *
 * After it's created, the asset starts ingesting content and generates playback URLs for the packaging configurations associated with it. When ingest is complete, downstream devices use the appropriate URL to request VOD content from AWS Elemental MediaPackage .
 *
 * @cloudformationResource AWS::MediaPackage::Asset
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-asset.html
 */
class CfnAsset extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaPackage::Asset`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAsset.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_mediapackage_CfnAssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAsset);
            }
            throw error;
        }
        cdk.requireProperty(props, 'id', this);
        cdk.requireProperty(props, 'packagingGroupId', this);
        cdk.requireProperty(props, 'sourceArn', this);
        cdk.requireProperty(props, 'sourceRoleArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrCreatedAt = cdk.Token.asString(this.getAtt('CreatedAt'));
        this.attrEgressEndpoints = this.getAtt('EgressEndpoints');
        this.id = props.id;
        this.packagingGroupId = props.packagingGroupId;
        this.sourceArn = props.sourceArn;
        this.sourceRoleArn = props.sourceRoleArn;
        this.resourceId = props.resourceId;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaPackage::Asset", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAssetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAsset(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAsset.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            id: this.id,
            packagingGroupId: this.packagingGroupId,
            sourceArn: this.sourceArn,
            sourceRoleArn: this.sourceRoleArn,
            resourceId: this.resourceId,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnAssetPropsToCloudFormation(props);
    }
}
exports.CfnAsset = CfnAsset;
_a = JSII_RTTI_SYMBOL_1;
CfnAsset[_a] = { fqn: "monocdk.aws_mediapackage.CfnAsset", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAsset.CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Asset";
/**
 * Determine whether the given properties match those of a `EgressEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `EgressEndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnAsset_EgressEndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('packagingConfigurationId', cdk.requiredValidator)(properties.packagingConfigurationId));
    errors.collect(cdk.propertyValidator('packagingConfigurationId', cdk.validateString)(properties.packagingConfigurationId));
    errors.collect(cdk.propertyValidator('url', cdk.requiredValidator)(properties.url));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "EgressEndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Asset.EgressEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `EgressEndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Asset.EgressEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnAssetEgressEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAsset_EgressEndpointPropertyValidator(properties).assertSuccess();
    return {
        PackagingConfigurationId: cdk.stringToCloudFormation(properties.packagingConfigurationId),
        Url: cdk.stringToCloudFormation(properties.url),
    };
}
// @ts-ignore TS6133
function CfnAssetEgressEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('packagingConfigurationId', 'PackagingConfigurationId', cfn_parse.FromCloudFormation.getString(properties.PackagingConfigurationId));
    ret.addPropertyResult('url', 'Url', cfn_parse.FromCloudFormation.getString(properties.Url));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('egressAccessLogs', CfnChannel_LogConfigurationPropertyValidator)(properties.egressAccessLogs));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('ingressAccessLogs', CfnChannel_LogConfigurationPropertyValidator)(properties.ingressAccessLogs));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Channel` resource
 *
 * @param properties - the TypeScript properties of a `CfnChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Channel` resource.
 */
// @ts-ignore TS6133
function cfnChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannelPropsValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        Description: cdk.stringToCloudFormation(properties.description),
        EgressAccessLogs: cfnChannelLogConfigurationPropertyToCloudFormation(properties.egressAccessLogs),
        IngressAccessLogs: cfnChannelLogConfigurationPropertyToCloudFormation(properties.ingressAccessLogs),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('egressAccessLogs', 'EgressAccessLogs', properties.EgressAccessLogs != null ? CfnChannelLogConfigurationPropertyFromCloudFormation(properties.EgressAccessLogs) : undefined);
    ret.addPropertyResult('ingressAccessLogs', 'IngressAccessLogs', properties.IngressAccessLogs != null ? CfnChannelLogConfigurationPropertyFromCloudFormation(properties.IngressAccessLogs) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaPackage::Channel`
 *
 * Creates a channel to receive content.
 *
 * After it's created, a channel provides static input URLs. These URLs remain the same throughout the lifetime of the channel, regardless of any failures or upgrades that might occur. Use these URLs to configure the outputs of your upstream encoder.
 *
 * @cloudformationResource AWS::MediaPackage::Channel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-channel.html
 */
class CfnChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaPackage::Channel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_mediapackage_CfnChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'id', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrHlsIngestingestEndpoints = this.getAtt('HlsIngest.ingestEndpoints');
        this.id = props.id;
        this.description = props.description;
        this.egressAccessLogs = props.egressAccessLogs;
        this.ingressAccessLogs = props.ingressAccessLogs;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaPackage::Channel", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            id: this.id,
            description: this.description,
            egressAccessLogs: this.egressAccessLogs,
            ingressAccessLogs: this.ingressAccessLogs,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnChannelPropsToCloudFormation(props);
    }
}
exports.CfnChannel = CfnChannel;
_b = JSII_RTTI_SYMBOL_1;
CfnChannel[_b] = { fqn: "monocdk.aws_mediapackage.CfnChannel", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnChannel.CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::Channel";
/**
 * Determine whether the given properties match those of a `HlsIngestProperty`
 *
 * @param properties - the TypeScript properties of a `HlsIngestProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_HlsIngestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('ingestEndpoints', cdk.listValidator(CfnChannel_IngestEndpointPropertyValidator))(properties.ingestEndpoints));
    return errors.wrap('supplied properties not correct for "HlsIngestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.HlsIngest` resource
 *
 * @param properties - the TypeScript properties of a `HlsIngestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.HlsIngest` resource.
 */
// @ts-ignore TS6133
function cfnChannelHlsIngestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_HlsIngestPropertyValidator(properties).assertSuccess();
    return {
        ingestEndpoints: cdk.listMapper(cfnChannelIngestEndpointPropertyToCloudFormation)(properties.ingestEndpoints),
    };
}
// @ts-ignore TS6133
function CfnChannelHlsIngestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('ingestEndpoints', 'ingestEndpoints', properties.ingestEndpoints != null ? cfn_parse.FromCloudFormation.getArray(CfnChannelIngestEndpointPropertyFromCloudFormation)(properties.ingestEndpoints) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IngestEndpointProperty`
 *
 * @param properties - the TypeScript properties of a `IngestEndpointProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_IngestEndpointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "IngestEndpointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.IngestEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `IngestEndpointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.IngestEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnChannelIngestEndpointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_IngestEndpointPropertyValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        Password: cdk.stringToCloudFormation(properties.password),
        Url: cdk.stringToCloudFormation(properties.url),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnChannelIngestEndpointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', properties.Id != null ? cfn_parse.FromCloudFormation.getString(properties.Id) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('url', 'Url', properties.Url != null ? cfn_parse.FromCloudFormation.getString(properties.Url) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LogConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnChannel_LogConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('logGroupName', cdk.validateString)(properties.logGroupName));
    return errors.wrap('supplied properties not correct for "LogConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.LogConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::Channel.LogConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnChannelLogConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnChannel_LogConfigurationPropertyValidator(properties).assertSuccess();
    return {
        LogGroupName: cdk.stringToCloudFormation(properties.logGroupName),
    };
}
// @ts-ignore TS6133
function CfnChannelLogConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('logGroupName', 'LogGroupName', properties.LogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.LogGroupName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnOriginEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnOriginEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authorization', CfnOriginEndpoint_AuthorizationPropertyValidator)(properties.authorization));
    errors.collect(cdk.propertyValidator('channelId', cdk.requiredValidator)(properties.channelId));
    errors.collect(cdk.propertyValidator('channelId', cdk.validateString)(properties.channelId));
    errors.collect(cdk.propertyValidator('cmafPackage', CfnOriginEndpoint_CmafPackagePropertyValidator)(properties.cmafPackage));
    errors.collect(cdk.propertyValidator('dashPackage', CfnOriginEndpoint_DashPackagePropertyValidator)(properties.dashPackage));
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('hlsPackage', CfnOriginEndpoint_HlsPackagePropertyValidator)(properties.hlsPackage));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('manifestName', cdk.validateString)(properties.manifestName));
    errors.collect(cdk.propertyValidator('mssPackage', CfnOriginEndpoint_MssPackagePropertyValidator)(properties.mssPackage));
    errors.collect(cdk.propertyValidator('origination', cdk.validateString)(properties.origination));
    errors.collect(cdk.propertyValidator('startoverWindowSeconds', cdk.validateNumber)(properties.startoverWindowSeconds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('timeDelaySeconds', cdk.validateNumber)(properties.timeDelaySeconds));
    errors.collect(cdk.propertyValidator('whitelist', cdk.listValidator(cdk.validateString))(properties.whitelist));
    return errors.wrap('supplied properties not correct for "CfnOriginEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnOriginEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpointPropsValidator(properties).assertSuccess();
    return {
        ChannelId: cdk.stringToCloudFormation(properties.channelId),
        Id: cdk.stringToCloudFormation(properties.id),
        Authorization: cfnOriginEndpointAuthorizationPropertyToCloudFormation(properties.authorization),
        CmafPackage: cfnOriginEndpointCmafPackagePropertyToCloudFormation(properties.cmafPackage),
        DashPackage: cfnOriginEndpointDashPackagePropertyToCloudFormation(properties.dashPackage),
        Description: cdk.stringToCloudFormation(properties.description),
        HlsPackage: cfnOriginEndpointHlsPackagePropertyToCloudFormation(properties.hlsPackage),
        ManifestName: cdk.stringToCloudFormation(properties.manifestName),
        MssPackage: cfnOriginEndpointMssPackagePropertyToCloudFormation(properties.mssPackage),
        Origination: cdk.stringToCloudFormation(properties.origination),
        StartoverWindowSeconds: cdk.numberToCloudFormation(properties.startoverWindowSeconds),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TimeDelaySeconds: cdk.numberToCloudFormation(properties.timeDelaySeconds),
        Whitelist: cdk.listMapper(cdk.stringToCloudFormation)(properties.whitelist),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('channelId', 'ChannelId', cfn_parse.FromCloudFormation.getString(properties.ChannelId));
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('authorization', 'Authorization', properties.Authorization != null ? CfnOriginEndpointAuthorizationPropertyFromCloudFormation(properties.Authorization) : undefined);
    ret.addPropertyResult('cmafPackage', 'CmafPackage', properties.CmafPackage != null ? CfnOriginEndpointCmafPackagePropertyFromCloudFormation(properties.CmafPackage) : undefined);
    ret.addPropertyResult('dashPackage', 'DashPackage', properties.DashPackage != null ? CfnOriginEndpointDashPackagePropertyFromCloudFormation(properties.DashPackage) : undefined);
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('hlsPackage', 'HlsPackage', properties.HlsPackage != null ? CfnOriginEndpointHlsPackagePropertyFromCloudFormation(properties.HlsPackage) : undefined);
    ret.addPropertyResult('manifestName', 'ManifestName', properties.ManifestName != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestName) : undefined);
    ret.addPropertyResult('mssPackage', 'MssPackage', properties.MssPackage != null ? CfnOriginEndpointMssPackagePropertyFromCloudFormation(properties.MssPackage) : undefined);
    ret.addPropertyResult('origination', 'Origination', properties.Origination != null ? cfn_parse.FromCloudFormation.getString(properties.Origination) : undefined);
    ret.addPropertyResult('startoverWindowSeconds', 'StartoverWindowSeconds', properties.StartoverWindowSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.StartoverWindowSeconds) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('timeDelaySeconds', 'TimeDelaySeconds', properties.TimeDelaySeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeDelaySeconds) : undefined);
    ret.addPropertyResult('whitelist', 'Whitelist', properties.Whitelist != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Whitelist) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaPackage::OriginEndpoint`
 *
 * Create an endpoint on an AWS Elemental MediaPackage channel.
 *
 * An endpoint represents a single delivery point of a channel, and defines content output handling through various components, such as packaging protocols, DRM and encryption integration, and more.
 *
 * After it's created, an endpoint provides a fixed public URL. This URL remains the same throughout the lifetime of the endpoint, regardless of any failures or upgrades that might occur. Integrate the URL with a downstream CDN (such as Amazon CloudFront) or playback device.
 *
 * @cloudformationResource AWS::MediaPackage::OriginEndpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-originendpoint.html
 */
class CfnOriginEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaPackage::OriginEndpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnOriginEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_mediapackage_CfnOriginEndpointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnOriginEndpoint);
            }
            throw error;
        }
        cdk.requireProperty(props, 'channelId', this);
        cdk.requireProperty(props, 'id', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrUrl = cdk.Token.asString(this.getAtt('Url'));
        this.channelId = props.channelId;
        this.id = props.id;
        this.authorization = props.authorization;
        this.cmafPackage = props.cmafPackage;
        this.dashPackage = props.dashPackage;
        this.description = props.description;
        this.hlsPackage = props.hlsPackage;
        this.manifestName = props.manifestName;
        this.mssPackage = props.mssPackage;
        this.origination = props.origination;
        this.startoverWindowSeconds = props.startoverWindowSeconds;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaPackage::OriginEndpoint", props.tags, { tagPropertyName: 'tags' });
        this.timeDelaySeconds = props.timeDelaySeconds;
        this.whitelist = props.whitelist;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnOriginEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnOriginEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnOriginEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            channelId: this.channelId,
            id: this.id,
            authorization: this.authorization,
            cmafPackage: this.cmafPackage,
            dashPackage: this.dashPackage,
            description: this.description,
            hlsPackage: this.hlsPackage,
            manifestName: this.manifestName,
            mssPackage: this.mssPackage,
            origination: this.origination,
            startoverWindowSeconds: this.startoverWindowSeconds,
            tags: this.tags.renderTags(),
            timeDelaySeconds: this.timeDelaySeconds,
            whitelist: this.whitelist,
        };
    }
    renderProperties(props) {
        return cfnOriginEndpointPropsToCloudFormation(props);
    }
}
exports.CfnOriginEndpoint = CfnOriginEndpoint;
_c = JSII_RTTI_SYMBOL_1;
CfnOriginEndpoint[_c] = { fqn: "monocdk.aws_mediapackage.CfnOriginEndpoint", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnOriginEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::OriginEndpoint";
/**
 * Determine whether the given properties match those of a `AuthorizationProperty`
 *
 * @param properties - the TypeScript properties of a `AuthorizationProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_AuthorizationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cdnIdentifierSecret', cdk.requiredValidator)(properties.cdnIdentifierSecret));
    errors.collect(cdk.propertyValidator('cdnIdentifierSecret', cdk.validateString)(properties.cdnIdentifierSecret));
    errors.collect(cdk.propertyValidator('secretsRoleArn', cdk.requiredValidator)(properties.secretsRoleArn));
    errors.collect(cdk.propertyValidator('secretsRoleArn', cdk.validateString)(properties.secretsRoleArn));
    return errors.wrap('supplied properties not correct for "AuthorizationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.Authorization` resource
 *
 * @param properties - the TypeScript properties of a `AuthorizationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.Authorization` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointAuthorizationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_AuthorizationPropertyValidator(properties).assertSuccess();
    return {
        CdnIdentifierSecret: cdk.stringToCloudFormation(properties.cdnIdentifierSecret),
        SecretsRoleArn: cdk.stringToCloudFormation(properties.secretsRoleArn),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointAuthorizationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cdnIdentifierSecret', 'CdnIdentifierSecret', cfn_parse.FromCloudFormation.getString(properties.CdnIdentifierSecret));
    ret.addPropertyResult('secretsRoleArn', 'SecretsRoleArn', cfn_parse.FromCloudFormation.getString(properties.SecretsRoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CmafEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `CmafEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_CmafEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constantInitializationVector', cdk.validateString)(properties.constantInitializationVector));
    errors.collect(cdk.propertyValidator('encryptionMethod', cdk.validateString)(properties.encryptionMethod));
    errors.collect(cdk.propertyValidator('keyRotationIntervalSeconds', cdk.validateNumber)(properties.keyRotationIntervalSeconds));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnOriginEndpoint_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "CmafEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.CmafEncryption` resource
 *
 * @param properties - the TypeScript properties of a `CmafEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.CmafEncryption` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointCmafEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_CmafEncryptionPropertyValidator(properties).assertSuccess();
    return {
        ConstantInitializationVector: cdk.stringToCloudFormation(properties.constantInitializationVector),
        EncryptionMethod: cdk.stringToCloudFormation(properties.encryptionMethod),
        KeyRotationIntervalSeconds: cdk.numberToCloudFormation(properties.keyRotationIntervalSeconds),
        SpekeKeyProvider: cfnOriginEndpointSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointCmafEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constantInitializationVector', 'ConstantInitializationVector', properties.ConstantInitializationVector != null ? cfn_parse.FromCloudFormation.getString(properties.ConstantInitializationVector) : undefined);
    ret.addPropertyResult('encryptionMethod', 'EncryptionMethod', properties.EncryptionMethod != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMethod) : undefined);
    ret.addPropertyResult('keyRotationIntervalSeconds', 'KeyRotationIntervalSeconds', properties.KeyRotationIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.KeyRotationIntervalSeconds) : undefined);
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnOriginEndpointSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CmafPackageProperty`
 *
 * @param properties - the TypeScript properties of a `CmafPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_CmafPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryption', CfnOriginEndpoint_CmafEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('hlsManifests', cdk.listValidator(CfnOriginEndpoint_HlsManifestPropertyValidator))(properties.hlsManifests));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('segmentPrefix', cdk.validateString)(properties.segmentPrefix));
    errors.collect(cdk.propertyValidator('streamSelection', CfnOriginEndpoint_StreamSelectionPropertyValidator)(properties.streamSelection));
    return errors.wrap('supplied properties not correct for "CmafPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.CmafPackage` resource
 *
 * @param properties - the TypeScript properties of a `CmafPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.CmafPackage` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointCmafPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_CmafPackagePropertyValidator(properties).assertSuccess();
    return {
        Encryption: cfnOriginEndpointCmafEncryptionPropertyToCloudFormation(properties.encryption),
        HlsManifests: cdk.listMapper(cfnOriginEndpointHlsManifestPropertyToCloudFormation)(properties.hlsManifests),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        SegmentPrefix: cdk.stringToCloudFormation(properties.segmentPrefix),
        StreamSelection: cfnOriginEndpointStreamSelectionPropertyToCloudFormation(properties.streamSelection),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointCmafPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnOriginEndpointCmafEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('hlsManifests', 'HlsManifests', properties.HlsManifests != null ? cfn_parse.FromCloudFormation.getArray(CfnOriginEndpointHlsManifestPropertyFromCloudFormation)(properties.HlsManifests) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('segmentPrefix', 'SegmentPrefix', properties.SegmentPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.SegmentPrefix) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnOriginEndpointStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `DashEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_DashEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('keyRotationIntervalSeconds', cdk.validateNumber)(properties.keyRotationIntervalSeconds));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnOriginEndpoint_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "DashEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.DashEncryption` resource
 *
 * @param properties - the TypeScript properties of a `DashEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.DashEncryption` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointDashEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_DashEncryptionPropertyValidator(properties).assertSuccess();
    return {
        KeyRotationIntervalSeconds: cdk.numberToCloudFormation(properties.keyRotationIntervalSeconds),
        SpekeKeyProvider: cfnOriginEndpointSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointDashEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyRotationIntervalSeconds', 'KeyRotationIntervalSeconds', properties.KeyRotationIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.KeyRotationIntervalSeconds) : undefined);
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnOriginEndpointSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashPackageProperty`
 *
 * @param properties - the TypeScript properties of a `DashPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_DashPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adTriggers', cdk.listValidator(cdk.validateString))(properties.adTriggers));
    errors.collect(cdk.propertyValidator('adsOnDeliveryRestrictions', cdk.validateString)(properties.adsOnDeliveryRestrictions));
    errors.collect(cdk.propertyValidator('encryption', CfnOriginEndpoint_DashEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('includeIframeOnlyStream', cdk.validateBoolean)(properties.includeIframeOnlyStream));
    errors.collect(cdk.propertyValidator('manifestLayout', cdk.validateString)(properties.manifestLayout));
    errors.collect(cdk.propertyValidator('manifestWindowSeconds', cdk.validateNumber)(properties.manifestWindowSeconds));
    errors.collect(cdk.propertyValidator('minBufferTimeSeconds', cdk.validateNumber)(properties.minBufferTimeSeconds));
    errors.collect(cdk.propertyValidator('minUpdatePeriodSeconds', cdk.validateNumber)(properties.minUpdatePeriodSeconds));
    errors.collect(cdk.propertyValidator('periodTriggers', cdk.listValidator(cdk.validateString))(properties.periodTriggers));
    errors.collect(cdk.propertyValidator('profile', cdk.validateString)(properties.profile));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('segmentTemplateFormat', cdk.validateString)(properties.segmentTemplateFormat));
    errors.collect(cdk.propertyValidator('streamSelection', CfnOriginEndpoint_StreamSelectionPropertyValidator)(properties.streamSelection));
    errors.collect(cdk.propertyValidator('suggestedPresentationDelaySeconds', cdk.validateNumber)(properties.suggestedPresentationDelaySeconds));
    errors.collect(cdk.propertyValidator('utcTiming', cdk.validateString)(properties.utcTiming));
    errors.collect(cdk.propertyValidator('utcTimingUri', cdk.validateString)(properties.utcTimingUri));
    return errors.wrap('supplied properties not correct for "DashPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.DashPackage` resource
 *
 * @param properties - the TypeScript properties of a `DashPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.DashPackage` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointDashPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_DashPackagePropertyValidator(properties).assertSuccess();
    return {
        AdTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.adTriggers),
        AdsOnDeliveryRestrictions: cdk.stringToCloudFormation(properties.adsOnDeliveryRestrictions),
        Encryption: cfnOriginEndpointDashEncryptionPropertyToCloudFormation(properties.encryption),
        IncludeIframeOnlyStream: cdk.booleanToCloudFormation(properties.includeIframeOnlyStream),
        ManifestLayout: cdk.stringToCloudFormation(properties.manifestLayout),
        ManifestWindowSeconds: cdk.numberToCloudFormation(properties.manifestWindowSeconds),
        MinBufferTimeSeconds: cdk.numberToCloudFormation(properties.minBufferTimeSeconds),
        MinUpdatePeriodSeconds: cdk.numberToCloudFormation(properties.minUpdatePeriodSeconds),
        PeriodTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.periodTriggers),
        Profile: cdk.stringToCloudFormation(properties.profile),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        SegmentTemplateFormat: cdk.stringToCloudFormation(properties.segmentTemplateFormat),
        StreamSelection: cfnOriginEndpointStreamSelectionPropertyToCloudFormation(properties.streamSelection),
        SuggestedPresentationDelaySeconds: cdk.numberToCloudFormation(properties.suggestedPresentationDelaySeconds),
        UtcTiming: cdk.stringToCloudFormation(properties.utcTiming),
        UtcTimingUri: cdk.stringToCloudFormation(properties.utcTimingUri),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointDashPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adTriggers', 'AdTriggers', properties.AdTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdTriggers) : undefined);
    ret.addPropertyResult('adsOnDeliveryRestrictions', 'AdsOnDeliveryRestrictions', properties.AdsOnDeliveryRestrictions != null ? cfn_parse.FromCloudFormation.getString(properties.AdsOnDeliveryRestrictions) : undefined);
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnOriginEndpointDashEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('includeIframeOnlyStream', 'IncludeIframeOnlyStream', properties.IncludeIframeOnlyStream != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeIframeOnlyStream) : undefined);
    ret.addPropertyResult('manifestLayout', 'ManifestLayout', properties.ManifestLayout != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestLayout) : undefined);
    ret.addPropertyResult('manifestWindowSeconds', 'ManifestWindowSeconds', properties.ManifestWindowSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ManifestWindowSeconds) : undefined);
    ret.addPropertyResult('minBufferTimeSeconds', 'MinBufferTimeSeconds', properties.MinBufferTimeSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinBufferTimeSeconds) : undefined);
    ret.addPropertyResult('minUpdatePeriodSeconds', 'MinUpdatePeriodSeconds', properties.MinUpdatePeriodSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinUpdatePeriodSeconds) : undefined);
    ret.addPropertyResult('periodTriggers', 'PeriodTriggers', properties.PeriodTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.PeriodTriggers) : undefined);
    ret.addPropertyResult('profile', 'Profile', properties.Profile != null ? cfn_parse.FromCloudFormation.getString(properties.Profile) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('segmentTemplateFormat', 'SegmentTemplateFormat', properties.SegmentTemplateFormat != null ? cfn_parse.FromCloudFormation.getString(properties.SegmentTemplateFormat) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnOriginEndpointStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addPropertyResult('suggestedPresentationDelaySeconds', 'SuggestedPresentationDelaySeconds', properties.SuggestedPresentationDelaySeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SuggestedPresentationDelaySeconds) : undefined);
    ret.addPropertyResult('utcTiming', 'UtcTiming', properties.UtcTiming != null ? cfn_parse.FromCloudFormation.getString(properties.UtcTiming) : undefined);
    ret.addPropertyResult('utcTimingUri', 'UtcTimingUri', properties.UtcTimingUri != null ? cfn_parse.FromCloudFormation.getString(properties.UtcTimingUri) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EncryptionContractConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EncryptionContractConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_EncryptionContractConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('presetSpeke20Audio', cdk.requiredValidator)(properties.presetSpeke20Audio));
    errors.collect(cdk.propertyValidator('presetSpeke20Audio', cdk.validateString)(properties.presetSpeke20Audio));
    errors.collect(cdk.propertyValidator('presetSpeke20Video', cdk.requiredValidator)(properties.presetSpeke20Video));
    errors.collect(cdk.propertyValidator('presetSpeke20Video', cdk.validateString)(properties.presetSpeke20Video));
    return errors.wrap('supplied properties not correct for "EncryptionContractConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.EncryptionContractConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EncryptionContractConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.EncryptionContractConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointEncryptionContractConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_EncryptionContractConfigurationPropertyValidator(properties).assertSuccess();
    return {
        PresetSpeke20Audio: cdk.stringToCloudFormation(properties.presetSpeke20Audio),
        PresetSpeke20Video: cdk.stringToCloudFormation(properties.presetSpeke20Video),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointEncryptionContractConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('presetSpeke20Audio', 'PresetSpeke20Audio', cfn_parse.FromCloudFormation.getString(properties.PresetSpeke20Audio));
    ret.addPropertyResult('presetSpeke20Video', 'PresetSpeke20Video', cfn_parse.FromCloudFormation.getString(properties.PresetSpeke20Video));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `HlsEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_HlsEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constantInitializationVector', cdk.validateString)(properties.constantInitializationVector));
    errors.collect(cdk.propertyValidator('encryptionMethod', cdk.validateString)(properties.encryptionMethod));
    errors.collect(cdk.propertyValidator('keyRotationIntervalSeconds', cdk.validateNumber)(properties.keyRotationIntervalSeconds));
    errors.collect(cdk.propertyValidator('repeatExtXKey', cdk.validateBoolean)(properties.repeatExtXKey));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnOriginEndpoint_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "HlsEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsEncryption` resource
 *
 * @param properties - the TypeScript properties of a `HlsEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsEncryption` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointHlsEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_HlsEncryptionPropertyValidator(properties).assertSuccess();
    return {
        ConstantInitializationVector: cdk.stringToCloudFormation(properties.constantInitializationVector),
        EncryptionMethod: cdk.stringToCloudFormation(properties.encryptionMethod),
        KeyRotationIntervalSeconds: cdk.numberToCloudFormation(properties.keyRotationIntervalSeconds),
        RepeatExtXKey: cdk.booleanToCloudFormation(properties.repeatExtXKey),
        SpekeKeyProvider: cfnOriginEndpointSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointHlsEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constantInitializationVector', 'ConstantInitializationVector', properties.ConstantInitializationVector != null ? cfn_parse.FromCloudFormation.getString(properties.ConstantInitializationVector) : undefined);
    ret.addPropertyResult('encryptionMethod', 'EncryptionMethod', properties.EncryptionMethod != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMethod) : undefined);
    ret.addPropertyResult('keyRotationIntervalSeconds', 'KeyRotationIntervalSeconds', properties.KeyRotationIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.KeyRotationIntervalSeconds) : undefined);
    ret.addPropertyResult('repeatExtXKey', 'RepeatExtXKey', properties.RepeatExtXKey != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RepeatExtXKey) : undefined);
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnOriginEndpointSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsManifestProperty`
 *
 * @param properties - the TypeScript properties of a `HlsManifestProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_HlsManifestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adMarkers', cdk.validateString)(properties.adMarkers));
    errors.collect(cdk.propertyValidator('adTriggers', cdk.listValidator(cdk.validateString))(properties.adTriggers));
    errors.collect(cdk.propertyValidator('adsOnDeliveryRestrictions', cdk.validateString)(properties.adsOnDeliveryRestrictions));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('includeIframeOnlyStream', cdk.validateBoolean)(properties.includeIframeOnlyStream));
    errors.collect(cdk.propertyValidator('manifestName', cdk.validateString)(properties.manifestName));
    errors.collect(cdk.propertyValidator('playlistType', cdk.validateString)(properties.playlistType));
    errors.collect(cdk.propertyValidator('playlistWindowSeconds', cdk.validateNumber)(properties.playlistWindowSeconds));
    errors.collect(cdk.propertyValidator('programDateTimeIntervalSeconds', cdk.validateNumber)(properties.programDateTimeIntervalSeconds));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "HlsManifestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsManifest` resource
 *
 * @param properties - the TypeScript properties of a `HlsManifestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsManifest` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointHlsManifestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_HlsManifestPropertyValidator(properties).assertSuccess();
    return {
        AdMarkers: cdk.stringToCloudFormation(properties.adMarkers),
        AdTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.adTriggers),
        AdsOnDeliveryRestrictions: cdk.stringToCloudFormation(properties.adsOnDeliveryRestrictions),
        Id: cdk.stringToCloudFormation(properties.id),
        IncludeIframeOnlyStream: cdk.booleanToCloudFormation(properties.includeIframeOnlyStream),
        ManifestName: cdk.stringToCloudFormation(properties.manifestName),
        PlaylistType: cdk.stringToCloudFormation(properties.playlistType),
        PlaylistWindowSeconds: cdk.numberToCloudFormation(properties.playlistWindowSeconds),
        ProgramDateTimeIntervalSeconds: cdk.numberToCloudFormation(properties.programDateTimeIntervalSeconds),
        Url: cdk.stringToCloudFormation(properties.url),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointHlsManifestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adMarkers', 'AdMarkers', properties.AdMarkers != null ? cfn_parse.FromCloudFormation.getString(properties.AdMarkers) : undefined);
    ret.addPropertyResult('adTriggers', 'AdTriggers', properties.AdTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdTriggers) : undefined);
    ret.addPropertyResult('adsOnDeliveryRestrictions', 'AdsOnDeliveryRestrictions', properties.AdsOnDeliveryRestrictions != null ? cfn_parse.FromCloudFormation.getString(properties.AdsOnDeliveryRestrictions) : undefined);
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('includeIframeOnlyStream', 'IncludeIframeOnlyStream', properties.IncludeIframeOnlyStream != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeIframeOnlyStream) : undefined);
    ret.addPropertyResult('manifestName', 'ManifestName', properties.ManifestName != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestName) : undefined);
    ret.addPropertyResult('playlistType', 'PlaylistType', properties.PlaylistType != null ? cfn_parse.FromCloudFormation.getString(properties.PlaylistType) : undefined);
    ret.addPropertyResult('playlistWindowSeconds', 'PlaylistWindowSeconds', properties.PlaylistWindowSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.PlaylistWindowSeconds) : undefined);
    ret.addPropertyResult('programDateTimeIntervalSeconds', 'ProgramDateTimeIntervalSeconds', properties.ProgramDateTimeIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProgramDateTimeIntervalSeconds) : undefined);
    ret.addPropertyResult('url', 'Url', properties.Url != null ? cfn_parse.FromCloudFormation.getString(properties.Url) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsPackageProperty`
 *
 * @param properties - the TypeScript properties of a `HlsPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_HlsPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adMarkers', cdk.validateString)(properties.adMarkers));
    errors.collect(cdk.propertyValidator('adTriggers', cdk.listValidator(cdk.validateString))(properties.adTriggers));
    errors.collect(cdk.propertyValidator('adsOnDeliveryRestrictions', cdk.validateString)(properties.adsOnDeliveryRestrictions));
    errors.collect(cdk.propertyValidator('encryption', CfnOriginEndpoint_HlsEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('includeDvbSubtitles', cdk.validateBoolean)(properties.includeDvbSubtitles));
    errors.collect(cdk.propertyValidator('includeIframeOnlyStream', cdk.validateBoolean)(properties.includeIframeOnlyStream));
    errors.collect(cdk.propertyValidator('playlistType', cdk.validateString)(properties.playlistType));
    errors.collect(cdk.propertyValidator('playlistWindowSeconds', cdk.validateNumber)(properties.playlistWindowSeconds));
    errors.collect(cdk.propertyValidator('programDateTimeIntervalSeconds', cdk.validateNumber)(properties.programDateTimeIntervalSeconds));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('streamSelection', CfnOriginEndpoint_StreamSelectionPropertyValidator)(properties.streamSelection));
    errors.collect(cdk.propertyValidator('useAudioRenditionGroup', cdk.validateBoolean)(properties.useAudioRenditionGroup));
    return errors.wrap('supplied properties not correct for "HlsPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsPackage` resource
 *
 * @param properties - the TypeScript properties of a `HlsPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.HlsPackage` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointHlsPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_HlsPackagePropertyValidator(properties).assertSuccess();
    return {
        AdMarkers: cdk.stringToCloudFormation(properties.adMarkers),
        AdTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.adTriggers),
        AdsOnDeliveryRestrictions: cdk.stringToCloudFormation(properties.adsOnDeliveryRestrictions),
        Encryption: cfnOriginEndpointHlsEncryptionPropertyToCloudFormation(properties.encryption),
        IncludeDvbSubtitles: cdk.booleanToCloudFormation(properties.includeDvbSubtitles),
        IncludeIframeOnlyStream: cdk.booleanToCloudFormation(properties.includeIframeOnlyStream),
        PlaylistType: cdk.stringToCloudFormation(properties.playlistType),
        PlaylistWindowSeconds: cdk.numberToCloudFormation(properties.playlistWindowSeconds),
        ProgramDateTimeIntervalSeconds: cdk.numberToCloudFormation(properties.programDateTimeIntervalSeconds),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        StreamSelection: cfnOriginEndpointStreamSelectionPropertyToCloudFormation(properties.streamSelection),
        UseAudioRenditionGroup: cdk.booleanToCloudFormation(properties.useAudioRenditionGroup),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointHlsPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adMarkers', 'AdMarkers', properties.AdMarkers != null ? cfn_parse.FromCloudFormation.getString(properties.AdMarkers) : undefined);
    ret.addPropertyResult('adTriggers', 'AdTriggers', properties.AdTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdTriggers) : undefined);
    ret.addPropertyResult('adsOnDeliveryRestrictions', 'AdsOnDeliveryRestrictions', properties.AdsOnDeliveryRestrictions != null ? cfn_parse.FromCloudFormation.getString(properties.AdsOnDeliveryRestrictions) : undefined);
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnOriginEndpointHlsEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('includeDvbSubtitles', 'IncludeDvbSubtitles', properties.IncludeDvbSubtitles != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeDvbSubtitles) : undefined);
    ret.addPropertyResult('includeIframeOnlyStream', 'IncludeIframeOnlyStream', properties.IncludeIframeOnlyStream != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeIframeOnlyStream) : undefined);
    ret.addPropertyResult('playlistType', 'PlaylistType', properties.PlaylistType != null ? cfn_parse.FromCloudFormation.getString(properties.PlaylistType) : undefined);
    ret.addPropertyResult('playlistWindowSeconds', 'PlaylistWindowSeconds', properties.PlaylistWindowSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.PlaylistWindowSeconds) : undefined);
    ret.addPropertyResult('programDateTimeIntervalSeconds', 'ProgramDateTimeIntervalSeconds', properties.ProgramDateTimeIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProgramDateTimeIntervalSeconds) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnOriginEndpointStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addPropertyResult('useAudioRenditionGroup', 'UseAudioRenditionGroup', properties.UseAudioRenditionGroup != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseAudioRenditionGroup) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MssEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `MssEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_MssEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnOriginEndpoint_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "MssEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.MssEncryption` resource
 *
 * @param properties - the TypeScript properties of a `MssEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.MssEncryption` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointMssEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_MssEncryptionPropertyValidator(properties).assertSuccess();
    return {
        SpekeKeyProvider: cfnOriginEndpointSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointMssEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnOriginEndpointSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MssPackageProperty`
 *
 * @param properties - the TypeScript properties of a `MssPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_MssPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryption', CfnOriginEndpoint_MssEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('manifestWindowSeconds', cdk.validateNumber)(properties.manifestWindowSeconds));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('streamSelection', CfnOriginEndpoint_StreamSelectionPropertyValidator)(properties.streamSelection));
    return errors.wrap('supplied properties not correct for "MssPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.MssPackage` resource
 *
 * @param properties - the TypeScript properties of a `MssPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.MssPackage` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointMssPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_MssPackagePropertyValidator(properties).assertSuccess();
    return {
        Encryption: cfnOriginEndpointMssEncryptionPropertyToCloudFormation(properties.encryption),
        ManifestWindowSeconds: cdk.numberToCloudFormation(properties.manifestWindowSeconds),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        StreamSelection: cfnOriginEndpointStreamSelectionPropertyToCloudFormation(properties.streamSelection),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointMssPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnOriginEndpointMssEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('manifestWindowSeconds', 'ManifestWindowSeconds', properties.ManifestWindowSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ManifestWindowSeconds) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnOriginEndpointStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SpekeKeyProviderProperty`
 *
 * @param properties - the TypeScript properties of a `SpekeKeyProviderProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_SpekeKeyProviderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    errors.collect(cdk.propertyValidator('encryptionContractConfiguration', CfnOriginEndpoint_EncryptionContractConfigurationPropertyValidator)(properties.encryptionContractConfiguration));
    errors.collect(cdk.propertyValidator('resourceId', cdk.requiredValidator)(properties.resourceId));
    errors.collect(cdk.propertyValidator('resourceId', cdk.validateString)(properties.resourceId));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('systemIds', cdk.requiredValidator)(properties.systemIds));
    errors.collect(cdk.propertyValidator('systemIds', cdk.listValidator(cdk.validateString))(properties.systemIds));
    errors.collect(cdk.propertyValidator('url', cdk.requiredValidator)(properties.url));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "SpekeKeyProviderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.SpekeKeyProvider` resource
 *
 * @param properties - the TypeScript properties of a `SpekeKeyProviderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.SpekeKeyProvider` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointSpekeKeyProviderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_SpekeKeyProviderPropertyValidator(properties).assertSuccess();
    return {
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
        EncryptionContractConfiguration: cfnOriginEndpointEncryptionContractConfigurationPropertyToCloudFormation(properties.encryptionContractConfiguration),
        ResourceId: cdk.stringToCloudFormation(properties.resourceId),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        SystemIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.systemIds),
        Url: cdk.stringToCloudFormation(properties.url),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointSpekeKeyProviderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateArn', 'CertificateArn', properties.CertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateArn) : undefined);
    ret.addPropertyResult('encryptionContractConfiguration', 'EncryptionContractConfiguration', properties.EncryptionContractConfiguration != null ? CfnOriginEndpointEncryptionContractConfigurationPropertyFromCloudFormation(properties.EncryptionContractConfiguration) : undefined);
    ret.addPropertyResult('resourceId', 'ResourceId', cfn_parse.FromCloudFormation.getString(properties.ResourceId));
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('systemIds', 'SystemIds', cfn_parse.FromCloudFormation.getStringArray(properties.SystemIds));
    ret.addPropertyResult('url', 'Url', cfn_parse.FromCloudFormation.getString(properties.Url));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StreamSelectionProperty`
 *
 * @param properties - the TypeScript properties of a `StreamSelectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnOriginEndpoint_StreamSelectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxVideoBitsPerSecond', cdk.validateNumber)(properties.maxVideoBitsPerSecond));
    errors.collect(cdk.propertyValidator('minVideoBitsPerSecond', cdk.validateNumber)(properties.minVideoBitsPerSecond));
    errors.collect(cdk.propertyValidator('streamOrder', cdk.validateString)(properties.streamOrder));
    return errors.wrap('supplied properties not correct for "StreamSelectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.StreamSelection` resource
 *
 * @param properties - the TypeScript properties of a `StreamSelectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::OriginEndpoint.StreamSelection` resource.
 */
// @ts-ignore TS6133
function cfnOriginEndpointStreamSelectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnOriginEndpoint_StreamSelectionPropertyValidator(properties).assertSuccess();
    return {
        MaxVideoBitsPerSecond: cdk.numberToCloudFormation(properties.maxVideoBitsPerSecond),
        MinVideoBitsPerSecond: cdk.numberToCloudFormation(properties.minVideoBitsPerSecond),
        StreamOrder: cdk.stringToCloudFormation(properties.streamOrder),
    };
}
// @ts-ignore TS6133
function CfnOriginEndpointStreamSelectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxVideoBitsPerSecond', 'MaxVideoBitsPerSecond', properties.MaxVideoBitsPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxVideoBitsPerSecond) : undefined);
    ret.addPropertyResult('minVideoBitsPerSecond', 'MinVideoBitsPerSecond', properties.MinVideoBitsPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinVideoBitsPerSecond) : undefined);
    ret.addPropertyResult('streamOrder', 'StreamOrder', properties.StreamOrder != null ? cfn_parse.FromCloudFormation.getString(properties.StreamOrder) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnPackagingConfigurationProps`
 *
 * @param properties - the TypeScript properties of a `CfnPackagingConfigurationProps`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfigurationPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cmafPackage', CfnPackagingConfiguration_CmafPackagePropertyValidator)(properties.cmafPackage));
    errors.collect(cdk.propertyValidator('dashPackage', CfnPackagingConfiguration_DashPackagePropertyValidator)(properties.dashPackage));
    errors.collect(cdk.propertyValidator('hlsPackage', CfnPackagingConfiguration_HlsPackagePropertyValidator)(properties.hlsPackage));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('mssPackage', CfnPackagingConfiguration_MssPackagePropertyValidator)(properties.mssPackage));
    errors.collect(cdk.propertyValidator('packagingGroupId', cdk.requiredValidator)(properties.packagingGroupId));
    errors.collect(cdk.propertyValidator('packagingGroupId', cdk.validateString)(properties.packagingGroupId));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPackagingConfigurationProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `CfnPackagingConfigurationProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfigurationPropsValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        PackagingGroupId: cdk.stringToCloudFormation(properties.packagingGroupId),
        CmafPackage: cfnPackagingConfigurationCmafPackagePropertyToCloudFormation(properties.cmafPackage),
        DashPackage: cfnPackagingConfigurationDashPackagePropertyToCloudFormation(properties.dashPackage),
        HlsPackage: cfnPackagingConfigurationHlsPackagePropertyToCloudFormation(properties.hlsPackage),
        MssPackage: cfnPackagingConfigurationMssPackagePropertyToCloudFormation(properties.mssPackage),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('packagingGroupId', 'PackagingGroupId', cfn_parse.FromCloudFormation.getString(properties.PackagingGroupId));
    ret.addPropertyResult('cmafPackage', 'CmafPackage', properties.CmafPackage != null ? CfnPackagingConfigurationCmafPackagePropertyFromCloudFormation(properties.CmafPackage) : undefined);
    ret.addPropertyResult('dashPackage', 'DashPackage', properties.DashPackage != null ? CfnPackagingConfigurationDashPackagePropertyFromCloudFormation(properties.DashPackage) : undefined);
    ret.addPropertyResult('hlsPackage', 'HlsPackage', properties.HlsPackage != null ? CfnPackagingConfigurationHlsPackagePropertyFromCloudFormation(properties.HlsPackage) : undefined);
    ret.addPropertyResult('mssPackage', 'MssPackage', properties.MssPackage != null ? CfnPackagingConfigurationMssPackagePropertyFromCloudFormation(properties.MssPackage) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`
 *
 * Creates a packaging configuration in a packaging group.
 *
 * The packaging configuration represents a single delivery point for an asset. It determines the format and setting for the egressing content. Specify only one package format per configuration, such as `HlsPackage` .
 *
 * @cloudformationResource AWS::MediaPackage::PackagingConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packagingconfiguration.html
 */
class CfnPackagingConfiguration extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaPackage::PackagingConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPackagingConfiguration.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_mediapackage_CfnPackagingConfigurationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPackagingConfiguration);
            }
            throw error;
        }
        cdk.requireProperty(props, 'id', this);
        cdk.requireProperty(props, 'packagingGroupId', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.id = props.id;
        this.packagingGroupId = props.packagingGroupId;
        this.cmafPackage = props.cmafPackage;
        this.dashPackage = props.dashPackage;
        this.hlsPackage = props.hlsPackage;
        this.mssPackage = props.mssPackage;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaPackage::PackagingConfiguration", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPackagingConfigurationPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPackagingConfiguration(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPackagingConfiguration.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            id: this.id,
            packagingGroupId: this.packagingGroupId,
            cmafPackage: this.cmafPackage,
            dashPackage: this.dashPackage,
            hlsPackage: this.hlsPackage,
            mssPackage: this.mssPackage,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPackagingConfigurationPropsToCloudFormation(props);
    }
}
exports.CfnPackagingConfiguration = CfnPackagingConfiguration;
_d = JSII_RTTI_SYMBOL_1;
CfnPackagingConfiguration[_d] = { fqn: "monocdk.aws_mediapackage.CfnPackagingConfiguration", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPackagingConfiguration.CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingConfiguration";
/**
 * Determine whether the given properties match those of a `CmafEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `CmafEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_CmafEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "CmafEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.CmafEncryption` resource
 *
 * @param properties - the TypeScript properties of a `CmafEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.CmafEncryption` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationCmafEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_CmafEncryptionPropertyValidator(properties).assertSuccess();
    return {
        SpekeKeyProvider: cfnPackagingConfigurationSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationCmafEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnPackagingConfigurationSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CmafPackageProperty`
 *
 * @param properties - the TypeScript properties of a `CmafPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_CmafPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryption', CfnPackagingConfiguration_CmafEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('hlsManifests', cdk.requiredValidator)(properties.hlsManifests));
    errors.collect(cdk.propertyValidator('hlsManifests', cdk.listValidator(CfnPackagingConfiguration_HlsManifestPropertyValidator))(properties.hlsManifests));
    errors.collect(cdk.propertyValidator('includeEncoderConfigurationInSegments', cdk.validateBoolean)(properties.includeEncoderConfigurationInSegments));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    return errors.wrap('supplied properties not correct for "CmafPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.CmafPackage` resource
 *
 * @param properties - the TypeScript properties of a `CmafPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.CmafPackage` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationCmafPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_CmafPackagePropertyValidator(properties).assertSuccess();
    return {
        Encryption: cfnPackagingConfigurationCmafEncryptionPropertyToCloudFormation(properties.encryption),
        HlsManifests: cdk.listMapper(cfnPackagingConfigurationHlsManifestPropertyToCloudFormation)(properties.hlsManifests),
        IncludeEncoderConfigurationInSegments: cdk.booleanToCloudFormation(properties.includeEncoderConfigurationInSegments),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationCmafPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnPackagingConfigurationCmafEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('hlsManifests', 'HlsManifests', cfn_parse.FromCloudFormation.getArray(CfnPackagingConfigurationHlsManifestPropertyFromCloudFormation)(properties.HlsManifests));
    ret.addPropertyResult('includeEncoderConfigurationInSegments', 'IncludeEncoderConfigurationInSegments', properties.IncludeEncoderConfigurationInSegments != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeEncoderConfigurationInSegments) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `DashEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_DashEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "DashEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashEncryption` resource
 *
 * @param properties - the TypeScript properties of a `DashEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashEncryption` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationDashEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_DashEncryptionPropertyValidator(properties).assertSuccess();
    return {
        SpekeKeyProvider: cfnPackagingConfigurationSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationDashEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnPackagingConfigurationSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashManifestProperty`
 *
 * @param properties - the TypeScript properties of a `DashManifestProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_DashManifestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('manifestLayout', cdk.validateString)(properties.manifestLayout));
    errors.collect(cdk.propertyValidator('manifestName', cdk.validateString)(properties.manifestName));
    errors.collect(cdk.propertyValidator('minBufferTimeSeconds', cdk.validateNumber)(properties.minBufferTimeSeconds));
    errors.collect(cdk.propertyValidator('profile', cdk.validateString)(properties.profile));
    errors.collect(cdk.propertyValidator('scteMarkersSource', cdk.validateString)(properties.scteMarkersSource));
    errors.collect(cdk.propertyValidator('streamSelection', CfnPackagingConfiguration_StreamSelectionPropertyValidator)(properties.streamSelection));
    return errors.wrap('supplied properties not correct for "DashManifestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashManifest` resource
 *
 * @param properties - the TypeScript properties of a `DashManifestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashManifest` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationDashManifestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_DashManifestPropertyValidator(properties).assertSuccess();
    return {
        ManifestLayout: cdk.stringToCloudFormation(properties.manifestLayout),
        ManifestName: cdk.stringToCloudFormation(properties.manifestName),
        MinBufferTimeSeconds: cdk.numberToCloudFormation(properties.minBufferTimeSeconds),
        Profile: cdk.stringToCloudFormation(properties.profile),
        ScteMarkersSource: cdk.stringToCloudFormation(properties.scteMarkersSource),
        StreamSelection: cfnPackagingConfigurationStreamSelectionPropertyToCloudFormation(properties.streamSelection),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationDashManifestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('manifestLayout', 'ManifestLayout', properties.ManifestLayout != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestLayout) : undefined);
    ret.addPropertyResult('manifestName', 'ManifestName', properties.ManifestName != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestName) : undefined);
    ret.addPropertyResult('minBufferTimeSeconds', 'MinBufferTimeSeconds', properties.MinBufferTimeSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinBufferTimeSeconds) : undefined);
    ret.addPropertyResult('profile', 'Profile', properties.Profile != null ? cfn_parse.FromCloudFormation.getString(properties.Profile) : undefined);
    ret.addPropertyResult('scteMarkersSource', 'ScteMarkersSource', properties.ScteMarkersSource != null ? cfn_parse.FromCloudFormation.getString(properties.ScteMarkersSource) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnPackagingConfigurationStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DashPackageProperty`
 *
 * @param properties - the TypeScript properties of a `DashPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_DashPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dashManifests', cdk.requiredValidator)(properties.dashManifests));
    errors.collect(cdk.propertyValidator('dashManifests', cdk.listValidator(CfnPackagingConfiguration_DashManifestPropertyValidator))(properties.dashManifests));
    errors.collect(cdk.propertyValidator('encryption', CfnPackagingConfiguration_DashEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('includeEncoderConfigurationInSegments', cdk.validateBoolean)(properties.includeEncoderConfigurationInSegments));
    errors.collect(cdk.propertyValidator('periodTriggers', cdk.listValidator(cdk.validateString))(properties.periodTriggers));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('segmentTemplateFormat', cdk.validateString)(properties.segmentTemplateFormat));
    return errors.wrap('supplied properties not correct for "DashPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashPackage` resource
 *
 * @param properties - the TypeScript properties of a `DashPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.DashPackage` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationDashPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_DashPackagePropertyValidator(properties).assertSuccess();
    return {
        DashManifests: cdk.listMapper(cfnPackagingConfigurationDashManifestPropertyToCloudFormation)(properties.dashManifests),
        Encryption: cfnPackagingConfigurationDashEncryptionPropertyToCloudFormation(properties.encryption),
        IncludeEncoderConfigurationInSegments: cdk.booleanToCloudFormation(properties.includeEncoderConfigurationInSegments),
        PeriodTriggers: cdk.listMapper(cdk.stringToCloudFormation)(properties.periodTriggers),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        SegmentTemplateFormat: cdk.stringToCloudFormation(properties.segmentTemplateFormat),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationDashPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dashManifests', 'DashManifests', cfn_parse.FromCloudFormation.getArray(CfnPackagingConfigurationDashManifestPropertyFromCloudFormation)(properties.DashManifests));
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnPackagingConfigurationDashEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('includeEncoderConfigurationInSegments', 'IncludeEncoderConfigurationInSegments', properties.IncludeEncoderConfigurationInSegments != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeEncoderConfigurationInSegments) : undefined);
    ret.addPropertyResult('periodTriggers', 'PeriodTriggers', properties.PeriodTriggers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.PeriodTriggers) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('segmentTemplateFormat', 'SegmentTemplateFormat', properties.SegmentTemplateFormat != null ? cfn_parse.FromCloudFormation.getString(properties.SegmentTemplateFormat) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EncryptionContractConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EncryptionContractConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_EncryptionContractConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('presetSpeke20Audio', cdk.requiredValidator)(properties.presetSpeke20Audio));
    errors.collect(cdk.propertyValidator('presetSpeke20Audio', cdk.validateString)(properties.presetSpeke20Audio));
    errors.collect(cdk.propertyValidator('presetSpeke20Video', cdk.requiredValidator)(properties.presetSpeke20Video));
    errors.collect(cdk.propertyValidator('presetSpeke20Video', cdk.validateString)(properties.presetSpeke20Video));
    return errors.wrap('supplied properties not correct for "EncryptionContractConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.EncryptionContractConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EncryptionContractConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.EncryptionContractConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationEncryptionContractConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_EncryptionContractConfigurationPropertyValidator(properties).assertSuccess();
    return {
        PresetSpeke20Audio: cdk.stringToCloudFormation(properties.presetSpeke20Audio),
        PresetSpeke20Video: cdk.stringToCloudFormation(properties.presetSpeke20Video),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationEncryptionContractConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('presetSpeke20Audio', 'PresetSpeke20Audio', cfn_parse.FromCloudFormation.getString(properties.PresetSpeke20Audio));
    ret.addPropertyResult('presetSpeke20Video', 'PresetSpeke20Video', cfn_parse.FromCloudFormation.getString(properties.PresetSpeke20Video));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `HlsEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_HlsEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('constantInitializationVector', cdk.validateString)(properties.constantInitializationVector));
    errors.collect(cdk.propertyValidator('encryptionMethod', cdk.validateString)(properties.encryptionMethod));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "HlsEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsEncryption` resource
 *
 * @param properties - the TypeScript properties of a `HlsEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsEncryption` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationHlsEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_HlsEncryptionPropertyValidator(properties).assertSuccess();
    return {
        ConstantInitializationVector: cdk.stringToCloudFormation(properties.constantInitializationVector),
        EncryptionMethod: cdk.stringToCloudFormation(properties.encryptionMethod),
        SpekeKeyProvider: cfnPackagingConfigurationSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationHlsEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('constantInitializationVector', 'ConstantInitializationVector', properties.ConstantInitializationVector != null ? cfn_parse.FromCloudFormation.getString(properties.ConstantInitializationVector) : undefined);
    ret.addPropertyResult('encryptionMethod', 'EncryptionMethod', properties.EncryptionMethod != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMethod) : undefined);
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnPackagingConfigurationSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsManifestProperty`
 *
 * @param properties - the TypeScript properties of a `HlsManifestProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_HlsManifestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('adMarkers', cdk.validateString)(properties.adMarkers));
    errors.collect(cdk.propertyValidator('includeIframeOnlyStream', cdk.validateBoolean)(properties.includeIframeOnlyStream));
    errors.collect(cdk.propertyValidator('manifestName', cdk.validateString)(properties.manifestName));
    errors.collect(cdk.propertyValidator('programDateTimeIntervalSeconds', cdk.validateNumber)(properties.programDateTimeIntervalSeconds));
    errors.collect(cdk.propertyValidator('repeatExtXKey', cdk.validateBoolean)(properties.repeatExtXKey));
    errors.collect(cdk.propertyValidator('streamSelection', CfnPackagingConfiguration_StreamSelectionPropertyValidator)(properties.streamSelection));
    return errors.wrap('supplied properties not correct for "HlsManifestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsManifest` resource
 *
 * @param properties - the TypeScript properties of a `HlsManifestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsManifest` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationHlsManifestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_HlsManifestPropertyValidator(properties).assertSuccess();
    return {
        AdMarkers: cdk.stringToCloudFormation(properties.adMarkers),
        IncludeIframeOnlyStream: cdk.booleanToCloudFormation(properties.includeIframeOnlyStream),
        ManifestName: cdk.stringToCloudFormation(properties.manifestName),
        ProgramDateTimeIntervalSeconds: cdk.numberToCloudFormation(properties.programDateTimeIntervalSeconds),
        RepeatExtXKey: cdk.booleanToCloudFormation(properties.repeatExtXKey),
        StreamSelection: cfnPackagingConfigurationStreamSelectionPropertyToCloudFormation(properties.streamSelection),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationHlsManifestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('adMarkers', 'AdMarkers', properties.AdMarkers != null ? cfn_parse.FromCloudFormation.getString(properties.AdMarkers) : undefined);
    ret.addPropertyResult('includeIframeOnlyStream', 'IncludeIframeOnlyStream', properties.IncludeIframeOnlyStream != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeIframeOnlyStream) : undefined);
    ret.addPropertyResult('manifestName', 'ManifestName', properties.ManifestName != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestName) : undefined);
    ret.addPropertyResult('programDateTimeIntervalSeconds', 'ProgramDateTimeIntervalSeconds', properties.ProgramDateTimeIntervalSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.ProgramDateTimeIntervalSeconds) : undefined);
    ret.addPropertyResult('repeatExtXKey', 'RepeatExtXKey', properties.RepeatExtXKey != null ? cfn_parse.FromCloudFormation.getBoolean(properties.RepeatExtXKey) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnPackagingConfigurationStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HlsPackageProperty`
 *
 * @param properties - the TypeScript properties of a `HlsPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_HlsPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryption', CfnPackagingConfiguration_HlsEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('hlsManifests', cdk.requiredValidator)(properties.hlsManifests));
    errors.collect(cdk.propertyValidator('hlsManifests', cdk.listValidator(CfnPackagingConfiguration_HlsManifestPropertyValidator))(properties.hlsManifests));
    errors.collect(cdk.propertyValidator('includeDvbSubtitles', cdk.validateBoolean)(properties.includeDvbSubtitles));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    errors.collect(cdk.propertyValidator('useAudioRenditionGroup', cdk.validateBoolean)(properties.useAudioRenditionGroup));
    return errors.wrap('supplied properties not correct for "HlsPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsPackage` resource
 *
 * @param properties - the TypeScript properties of a `HlsPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.HlsPackage` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationHlsPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_HlsPackagePropertyValidator(properties).assertSuccess();
    return {
        Encryption: cfnPackagingConfigurationHlsEncryptionPropertyToCloudFormation(properties.encryption),
        HlsManifests: cdk.listMapper(cfnPackagingConfigurationHlsManifestPropertyToCloudFormation)(properties.hlsManifests),
        IncludeDvbSubtitles: cdk.booleanToCloudFormation(properties.includeDvbSubtitles),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
        UseAudioRenditionGroup: cdk.booleanToCloudFormation(properties.useAudioRenditionGroup),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationHlsPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnPackagingConfigurationHlsEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('hlsManifests', 'HlsManifests', cfn_parse.FromCloudFormation.getArray(CfnPackagingConfigurationHlsManifestPropertyFromCloudFormation)(properties.HlsManifests));
    ret.addPropertyResult('includeDvbSubtitles', 'IncludeDvbSubtitles', properties.IncludeDvbSubtitles != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeDvbSubtitles) : undefined);
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addPropertyResult('useAudioRenditionGroup', 'UseAudioRenditionGroup', properties.UseAudioRenditionGroup != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseAudioRenditionGroup) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MssEncryptionProperty`
 *
 * @param properties - the TypeScript properties of a `MssEncryptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_MssEncryptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('spekeKeyProvider', cdk.requiredValidator)(properties.spekeKeyProvider));
    errors.collect(cdk.propertyValidator('spekeKeyProvider', CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator)(properties.spekeKeyProvider));
    return errors.wrap('supplied properties not correct for "MssEncryptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssEncryption` resource
 *
 * @param properties - the TypeScript properties of a `MssEncryptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssEncryption` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationMssEncryptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_MssEncryptionPropertyValidator(properties).assertSuccess();
    return {
        SpekeKeyProvider: cfnPackagingConfigurationSpekeKeyProviderPropertyToCloudFormation(properties.spekeKeyProvider),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationMssEncryptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('spekeKeyProvider', 'SpekeKeyProvider', CfnPackagingConfigurationSpekeKeyProviderPropertyFromCloudFormation(properties.SpekeKeyProvider));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MssManifestProperty`
 *
 * @param properties - the TypeScript properties of a `MssManifestProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_MssManifestPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('manifestName', cdk.validateString)(properties.manifestName));
    errors.collect(cdk.propertyValidator('streamSelection', CfnPackagingConfiguration_StreamSelectionPropertyValidator)(properties.streamSelection));
    return errors.wrap('supplied properties not correct for "MssManifestProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssManifest` resource
 *
 * @param properties - the TypeScript properties of a `MssManifestProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssManifest` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationMssManifestPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_MssManifestPropertyValidator(properties).assertSuccess();
    return {
        ManifestName: cdk.stringToCloudFormation(properties.manifestName),
        StreamSelection: cfnPackagingConfigurationStreamSelectionPropertyToCloudFormation(properties.streamSelection),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationMssManifestPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('manifestName', 'ManifestName', properties.ManifestName != null ? cfn_parse.FromCloudFormation.getString(properties.ManifestName) : undefined);
    ret.addPropertyResult('streamSelection', 'StreamSelection', properties.StreamSelection != null ? CfnPackagingConfigurationStreamSelectionPropertyFromCloudFormation(properties.StreamSelection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MssPackageProperty`
 *
 * @param properties - the TypeScript properties of a `MssPackageProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_MssPackagePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryption', CfnPackagingConfiguration_MssEncryptionPropertyValidator)(properties.encryption));
    errors.collect(cdk.propertyValidator('mssManifests', cdk.requiredValidator)(properties.mssManifests));
    errors.collect(cdk.propertyValidator('mssManifests', cdk.listValidator(CfnPackagingConfiguration_MssManifestPropertyValidator))(properties.mssManifests));
    errors.collect(cdk.propertyValidator('segmentDurationSeconds', cdk.validateNumber)(properties.segmentDurationSeconds));
    return errors.wrap('supplied properties not correct for "MssPackageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssPackage` resource
 *
 * @param properties - the TypeScript properties of a `MssPackageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.MssPackage` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationMssPackagePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_MssPackagePropertyValidator(properties).assertSuccess();
    return {
        Encryption: cfnPackagingConfigurationMssEncryptionPropertyToCloudFormation(properties.encryption),
        MssManifests: cdk.listMapper(cfnPackagingConfigurationMssManifestPropertyToCloudFormation)(properties.mssManifests),
        SegmentDurationSeconds: cdk.numberToCloudFormation(properties.segmentDurationSeconds),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationMssPackagePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryption', 'Encryption', properties.Encryption != null ? CfnPackagingConfigurationMssEncryptionPropertyFromCloudFormation(properties.Encryption) : undefined);
    ret.addPropertyResult('mssManifests', 'MssManifests', cfn_parse.FromCloudFormation.getArray(CfnPackagingConfigurationMssManifestPropertyFromCloudFormation)(properties.MssManifests));
    ret.addPropertyResult('segmentDurationSeconds', 'SegmentDurationSeconds', properties.SegmentDurationSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.SegmentDurationSeconds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SpekeKeyProviderProperty`
 *
 * @param properties - the TypeScript properties of a `SpekeKeyProviderProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('encryptionContractConfiguration', CfnPackagingConfiguration_EncryptionContractConfigurationPropertyValidator)(properties.encryptionContractConfiguration));
    errors.collect(cdk.propertyValidator('roleArn', cdk.requiredValidator)(properties.roleArn));
    errors.collect(cdk.propertyValidator('roleArn', cdk.validateString)(properties.roleArn));
    errors.collect(cdk.propertyValidator('systemIds', cdk.requiredValidator)(properties.systemIds));
    errors.collect(cdk.propertyValidator('systemIds', cdk.listValidator(cdk.validateString))(properties.systemIds));
    errors.collect(cdk.propertyValidator('url', cdk.requiredValidator)(properties.url));
    errors.collect(cdk.propertyValidator('url', cdk.validateString)(properties.url));
    return errors.wrap('supplied properties not correct for "SpekeKeyProviderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.SpekeKeyProvider` resource
 *
 * @param properties - the TypeScript properties of a `SpekeKeyProviderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.SpekeKeyProvider` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationSpekeKeyProviderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_SpekeKeyProviderPropertyValidator(properties).assertSuccess();
    return {
        EncryptionContractConfiguration: cfnPackagingConfigurationEncryptionContractConfigurationPropertyToCloudFormation(properties.encryptionContractConfiguration),
        RoleArn: cdk.stringToCloudFormation(properties.roleArn),
        SystemIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.systemIds),
        Url: cdk.stringToCloudFormation(properties.url),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationSpekeKeyProviderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('encryptionContractConfiguration', 'EncryptionContractConfiguration', properties.EncryptionContractConfiguration != null ? CfnPackagingConfigurationEncryptionContractConfigurationPropertyFromCloudFormation(properties.EncryptionContractConfiguration) : undefined);
    ret.addPropertyResult('roleArn', 'RoleArn', cfn_parse.FromCloudFormation.getString(properties.RoleArn));
    ret.addPropertyResult('systemIds', 'SystemIds', cfn_parse.FromCloudFormation.getStringArray(properties.SystemIds));
    ret.addPropertyResult('url', 'Url', cfn_parse.FromCloudFormation.getString(properties.Url));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StreamSelectionProperty`
 *
 * @param properties - the TypeScript properties of a `StreamSelectionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingConfiguration_StreamSelectionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('maxVideoBitsPerSecond', cdk.validateNumber)(properties.maxVideoBitsPerSecond));
    errors.collect(cdk.propertyValidator('minVideoBitsPerSecond', cdk.validateNumber)(properties.minVideoBitsPerSecond));
    errors.collect(cdk.propertyValidator('streamOrder', cdk.validateString)(properties.streamOrder));
    return errors.wrap('supplied properties not correct for "StreamSelectionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.StreamSelection` resource
 *
 * @param properties - the TypeScript properties of a `StreamSelectionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingConfiguration.StreamSelection` resource.
 */
// @ts-ignore TS6133
function cfnPackagingConfigurationStreamSelectionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingConfiguration_StreamSelectionPropertyValidator(properties).assertSuccess();
    return {
        MaxVideoBitsPerSecond: cdk.numberToCloudFormation(properties.maxVideoBitsPerSecond),
        MinVideoBitsPerSecond: cdk.numberToCloudFormation(properties.minVideoBitsPerSecond),
        StreamOrder: cdk.stringToCloudFormation(properties.streamOrder),
    };
}
// @ts-ignore TS6133
function CfnPackagingConfigurationStreamSelectionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('maxVideoBitsPerSecond', 'MaxVideoBitsPerSecond', properties.MaxVideoBitsPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxVideoBitsPerSecond) : undefined);
    ret.addPropertyResult('minVideoBitsPerSecond', 'MinVideoBitsPerSecond', properties.MinVideoBitsPerSecond != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinVideoBitsPerSecond) : undefined);
    ret.addPropertyResult('streamOrder', 'StreamOrder', properties.StreamOrder != null ? cfn_parse.FromCloudFormation.getString(properties.StreamOrder) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnPackagingGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnPackagingGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnPackagingGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authorization', CfnPackagingGroup_AuthorizationPropertyValidator)(properties.authorization));
    errors.collect(cdk.propertyValidator('egressAccessLogs', CfnPackagingGroup_LogConfigurationPropertyValidator)(properties.egressAccessLogs));
    errors.collect(cdk.propertyValidator('id', cdk.requiredValidator)(properties.id));
    errors.collect(cdk.propertyValidator('id', cdk.validateString)(properties.id));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPackagingGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnPackagingGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup` resource.
 */
// @ts-ignore TS6133
function cfnPackagingGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingGroupPropsValidator(properties).assertSuccess();
    return {
        Id: cdk.stringToCloudFormation(properties.id),
        Authorization: cfnPackagingGroupAuthorizationPropertyToCloudFormation(properties.authorization),
        EgressAccessLogs: cfnPackagingGroupLogConfigurationPropertyToCloudFormation(properties.egressAccessLogs),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPackagingGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('id', 'Id', cfn_parse.FromCloudFormation.getString(properties.Id));
    ret.addPropertyResult('authorization', 'Authorization', properties.Authorization != null ? CfnPackagingGroupAuthorizationPropertyFromCloudFormation(properties.Authorization) : undefined);
    ret.addPropertyResult('egressAccessLogs', 'EgressAccessLogs', properties.EgressAccessLogs != null ? CfnPackagingGroupLogConfigurationPropertyFromCloudFormation(properties.EgressAccessLogs) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::MediaPackage::PackagingGroup`
 *
 * Creates a packaging group.
 *
 * The packaging group holds one or more packaging configurations. When you create an asset, you specify the packaging group associated with the asset. The asset has playback endpoints for each packaging configuration within the group.
 *
 * @cloudformationResource AWS::MediaPackage::PackagingGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediapackage-packaginggroup.html
 */
class CfnPackagingGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::MediaPackage::PackagingGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPackagingGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_mediapackage_CfnPackagingGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPackagingGroup);
            }
            throw error;
        }
        cdk.requireProperty(props, 'id', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrDomainName = cdk.Token.asString(this.getAtt('DomainName'));
        this.id = props.id;
        this.authorization = props.authorization;
        this.egressAccessLogs = props.egressAccessLogs;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::MediaPackage::PackagingGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPackagingGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPackagingGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPackagingGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            id: this.id,
            authorization: this.authorization,
            egressAccessLogs: this.egressAccessLogs,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnPackagingGroupPropsToCloudFormation(props);
    }
}
exports.CfnPackagingGroup = CfnPackagingGroup;
_e = JSII_RTTI_SYMBOL_1;
CfnPackagingGroup[_e] = { fqn: "monocdk.aws_mediapackage.CfnPackagingGroup", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPackagingGroup.CFN_RESOURCE_TYPE_NAME = "AWS::MediaPackage::PackagingGroup";
/**
 * Determine whether the given properties match those of a `AuthorizationProperty`
 *
 * @param properties - the TypeScript properties of a `AuthorizationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingGroup_AuthorizationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cdnIdentifierSecret', cdk.requiredValidator)(properties.cdnIdentifierSecret));
    errors.collect(cdk.propertyValidator('cdnIdentifierSecret', cdk.validateString)(properties.cdnIdentifierSecret));
    errors.collect(cdk.propertyValidator('secretsRoleArn', cdk.requiredValidator)(properties.secretsRoleArn));
    errors.collect(cdk.propertyValidator('secretsRoleArn', cdk.validateString)(properties.secretsRoleArn));
    return errors.wrap('supplied properties not correct for "AuthorizationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup.Authorization` resource
 *
 * @param properties - the TypeScript properties of a `AuthorizationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup.Authorization` resource.
 */
// @ts-ignore TS6133
function cfnPackagingGroupAuthorizationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingGroup_AuthorizationPropertyValidator(properties).assertSuccess();
    return {
        CdnIdentifierSecret: cdk.stringToCloudFormation(properties.cdnIdentifierSecret),
        SecretsRoleArn: cdk.stringToCloudFormation(properties.secretsRoleArn),
    };
}
// @ts-ignore TS6133
function CfnPackagingGroupAuthorizationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cdnIdentifierSecret', 'CdnIdentifierSecret', cfn_parse.FromCloudFormation.getString(properties.CdnIdentifierSecret));
    ret.addPropertyResult('secretsRoleArn', 'SecretsRoleArn', cfn_parse.FromCloudFormation.getString(properties.SecretsRoleArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LogConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnPackagingGroup_LogConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('logGroupName', cdk.validateString)(properties.logGroupName));
    return errors.wrap('supplied properties not correct for "LogConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup.LogConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::MediaPackage::PackagingGroup.LogConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnPackagingGroupLogConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPackagingGroup_LogConfigurationPropertyValidator(properties).assertSuccess();
    return {
        LogGroupName: cdk.stringToCloudFormation(properties.logGroupName),
    };
}
// @ts-ignore TS6133
function CfnPackagingGroupLogConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('logGroupName', 'LogGroupName', properties.LogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.LogGroupName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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