import { Resource } from '../../core';
import { Construct } from 'constructs';
import { ILogGroup } from './log-group';
/**
 * Properties for a QueryString
 */
export interface QueryStringProps {
    /**
    * Retrieves the specified fields from log events for display.
    *
    * @default - no fields in QueryString
    */
    readonly fields?: string[];
    /**
    * Extracts data from a log field and creates one or more ephemeral fields that you can process further in the query.
    *
    * @default - no parse in QueryString
    */
    readonly parse?: string;
    /**
    * Filters the results of a query that's based on one or more conditions.
    *
    * @default - no filter in QueryString
    */
    readonly filter?: string;
    /**
    * Uses log field values to calculate aggregate statistics.
    *
    * @default - no stats in QueryString
    */
    readonly stats?: string;
    /**
    * Sorts the retrieved log events.
    *
    * @default - no sort in QueryString
    */
    readonly sort?: string;
    /**
    * Specifies the number of log events returned by the query.
    *
    * @default - no limit in QueryString
    */
    readonly limit?: Number;
    /**
    * Specifies which fields to display in the query results.
    *
    * @default - no display in QueryString
    */
    readonly display?: string;
}
/**
 * Define a QueryString
 */
export declare class QueryString {
    private readonly fields?;
    private readonly parse?;
    private readonly filter?;
    private readonly stats?;
    private readonly sort?;
    private readonly limit?;
    private readonly display?;
    constructor(props?: QueryStringProps);
    /**
    * String representation of this QueryString.
    */
    toString(): string;
}
/**
 * Properties for a QueryDefinition
 */
export interface QueryDefinitionProps {
    /**
    * Name of the query definition.
    */
    readonly queryDefinitionName: string;
    /**
     * The query string to use for this query definition.
     */
    readonly queryString: QueryString;
    /**
    * Specify certain log groups for the query definition.
    *
    * @default - no specified log groups
    */
    readonly logGroups?: ILogGroup[];
}
/**
 * Define a query definition for CloudWatch Logs Insights
 */
export declare class QueryDefinition extends Resource {
    /**
     * The ID of the query definition.
     *
     * @attribute
     */
    readonly queryDefinitionId: string;
    constructor(scope: Construct, id: string, props: QueryDefinitionProps);
}
