"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * Use a Lambda Function as the destination for a log subscription
 */
class LambdaDestination {
    /**  LambdaDestinationOptions */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.monocdk_aws_logs_destinations_LambdaDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    bind(scope, logGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_logs_ILogGroup(logGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const arn = logGroup.logGroupArn;
        if (this.options.addPermissions !== false) {
            this.fn.addPermission('CanInvokeLambda', {
                principal: new iam.ServicePrincipal('logs.amazonaws.com'),
                sourceArn: arn,
                // Using SubScription Filter as scope is okay, since every Subscription Filter has only
                // one destination.
                scope,
            });
        }
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_logs_destinations.LambdaDestination", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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