"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription
 */
class KinesisDestination {
    /**
     * @param stream The Kinesis stream to use as destination
     * @param props The Kinesis Destination properties
     *
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_kinesis_IStream(stream);
            jsiiDeprecationWarnings.monocdk_aws_logs_destinations_KinesisDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisDestination);
            }
            throw error;
        }
    }
    bind(scope, _sourceLogGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_logs_ILogGroup(_sourceLogGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = this.props.role ?? scope.node.tryFindChild(id) ?? new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
_a = JSII_RTTI_SYMBOL_1;
KinesisDestination[_a] = { fqn: "monocdk.aws_logs_destinations.KinesisDestination", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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