"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a SQS queue as a Lambda destination
 */
class SqsDestination {
    constructor(queue) {
        this.queue = queue;
        try {
            jsiiDeprecationWarnings.monocdk_aws_sqs_IQueue(queue);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.monocdk_aws_lambda_DestinationOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // deduplicated automatically
        this.queue.grantSendMessages(fn);
        return {
            destination: this.queue.queueArn,
        };
    }
}
exports.SqsDestination = SqsDestination;
_a = JSII_RTTI_SYMBOL_1;
SqsDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.SqsDestination", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3FzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3FzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUlBOztHQUVHO0FBQ0gsTUFBYSxjQUFjO0lBQ3pCLFlBQTZCLEtBQWlCO1FBQWpCLFVBQUssR0FBTCxLQUFLLENBQVk7Ozs7OzsrQ0FEbkMsY0FBYzs7OztLQUV4QjtJQUVEOztPQUVHO0lBQ0ksSUFBSSxDQUFDLE1BQWlCLEVBQUUsRUFBb0IsRUFBRSxRQUFvQzs7Ozs7Ozs7Ozs7O1FBQ3ZGLDZCQUE2QjtRQUM3QixJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLEVBQUUsQ0FBQyxDQUFDO1FBRWpDLE9BQU87WUFDTCxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRO1NBQ2pDLENBQUM7S0FDSDs7QUFkSCx3Q0FlQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICcuLi8uLi9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNxcyBmcm9tICcuLi8uLi9hd3Mtc3FzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJy4uLy4uL2NvcmUnO1xuXG4vKipcbiAqIFVzZSBhIFNRUyBxdWV1ZSBhcyBhIExhbWJkYSBkZXN0aW5hdGlvblxuICovXG5leHBvcnQgY2xhc3MgU3FzRGVzdGluYXRpb24gaW1wbGVtZW50cyBsYW1iZGEuSURlc3RpbmF0aW9uIHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBxdWV1ZTogc3FzLklRdWV1ZSkge1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSBkZXN0aW5hdGlvbiBjb25maWd1cmF0aW9uXG4gICAqL1xuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgZm46IGxhbWJkYS5JRnVuY3Rpb24sIF9vcHRpb25zPzogbGFtYmRhLkRlc3RpbmF0aW9uT3B0aW9ucyk6IGxhbWJkYS5EZXN0aW5hdGlvbkNvbmZpZyB7XG4gICAgLy8gZGVkdXBsaWNhdGVkIGF1dG9tYXRpY2FsbHlcbiAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKGZuKTtcblxuICAgIHJldHVybiB7XG4gICAgICBkZXN0aW5hdGlvbjogdGhpcy5xdWV1ZS5xdWV1ZUFybixcbiAgICB9O1xuICB9XG59XG4iXX0=