"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events");
const core_1 = require("../../core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IEventBus(eventBus);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EventBridgeDestination);
            }
            throw error;
        }
    }
    /**
     * Returns a destination configuration
     */
    bind(_scope, fn, _options) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(fn);
            jsiiDeprecationWarnings.monocdk_aws_lambda_DestinationOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.EventBridgeDestination", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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