"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehoseMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class FirehoseMetrics {
    static incomingBytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'IncomingBytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static incomingRecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'IncomingRecords',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static backupToS3BytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static backupToS3DataFreshnessAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.DataFreshness',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static backupToS3RecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static backupToS3SuccessSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.Success',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static dataReadFromKinesisStreamBytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DataReadFromKinesisStream.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static dataReadFromKinesisStreamRecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DataReadFromKinesisStream.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToElasticsearchBytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToElasticsearch.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToElasticsearchRecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToElasticsearch.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToElasticsearchSuccessSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToElasticsearch.Success',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToRedshiftBytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToRedshift.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToRedshiftRecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToRedshift.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToRedshiftSuccessSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToRedshift.Success',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToS3BytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToS3.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToS3DataFreshnessAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToS3.DataFreshness',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static deliveryToS3RecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToS3.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToS3SuccessSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToS3.Success',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToSplunkBytesSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToSplunk.Bytes',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToSplunkDataAckLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToSplunk.DataAckLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static deliveryToSplunkDataFreshnessAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToSplunk.DataFreshness',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static deliveryToSplunkRecordsSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToSplunk.Records',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static deliveryToSplunkSuccessSum(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'DeliveryToSplunk.Success',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static kinesisMillisBehindLatestAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'KinesisMillisBehindLatest',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
}
exports.FirehoseMetrics = FirehoseMetrics;
//# sourceMappingURL=data:application/json;base64,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