"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
///! show
const path = require("path");
const core = require("../../core");
const flink = require("../lib");
const cloudwatch = require("../../aws-cloudwatch");
const app = new core.App();
const stack = new core.Stack(app, 'FlinkAppTest');
const flinkApp = new flink.Application(stack, 'App', {
    code: flink.ApplicationCode.fromAsset(path.join(__dirname, 'code-asset')),
    runtime: flink.Runtime.FLINK_1_11,
});
new cloudwatch.Alarm(stack, 'Alarm', {
    metric: flinkApp.metricFullRestarts(),
    evaluationPeriods: 1,
    threshold: 3,
});
///! hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBwbGljYXRpb24ubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuYXBwbGljYXRpb24ubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsU0FBUztBQUNULDZCQUE2QjtBQUM3QixtQ0FBbUM7QUFDbkMsZ0NBQWdDO0FBQ2hDLG1EQUFtRDtBQUVuRCxNQUFNLEdBQUcsR0FBRyxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMzQixNQUFNLEtBQUssR0FBRyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLGNBQWMsQ0FBQyxDQUFDO0FBRWxELE1BQU0sUUFBUSxHQUFHLElBQUksS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO0lBQ25ELElBQUksRUFBRSxLQUFLLENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxZQUFZLENBQUMsQ0FBQztJQUN6RSxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVO0NBQ2xDLENBQUMsQ0FBQztBQUVILElBQUksVUFBVSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO0lBQ25DLE1BQU0sRUFBRSxRQUFRLENBQUMsa0JBQWtCLEVBQUU7SUFDckMsaUJBQWlCLEVBQUUsQ0FBQztJQUNwQixTQUFTLEVBQUUsQ0FBQztDQUNiLENBQUMsQ0FBQztBQUNILFNBQVM7QUFFVCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLy8hIHNob3dcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBjb3JlIGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0ICogYXMgZmxpbmsgZnJvbSAnLi4vbGliJztcbmltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSAnLi4vLi4vYXdzLWNsb3Vkd2F0Y2gnO1xuXG5jb25zdCBhcHAgPSBuZXcgY29yZS5BcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IGNvcmUuU3RhY2soYXBwLCAnRmxpbmtBcHBUZXN0Jyk7XG5cbmNvbnN0IGZsaW5rQXBwID0gbmV3IGZsaW5rLkFwcGxpY2F0aW9uKHN0YWNrLCAnQXBwJywge1xuICBjb2RlOiBmbGluay5BcHBsaWNhdGlvbkNvZGUuZnJvbUFzc2V0KHBhdGguam9pbihfX2Rpcm5hbWUsICdjb2RlLWFzc2V0JykpLFxuICBydW50aW1lOiBmbGluay5SdW50aW1lLkZMSU5LXzFfMTEsXG59KTtcblxubmV3IGNsb3Vkd2F0Y2guQWxhcm0oc3RhY2ssICdBbGFybScsIHtcbiAgbWV0cmljOiBmbGlua0FwcC5tZXRyaWNGdWxsUmVzdGFydHMoKSxcbiAgZXZhbHVhdGlvblBlcmlvZHM6IDEsXG4gIHRocmVzaG9sZDogMyxcbn0pO1xuLy8vISBoaWRlXG5cbmFwcC5zeW50aCgpO1xuIl19