"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const assets = require("../../aws-s3-assets");
const core = require("../../core");
const flink = require("../lib");
const app = new core.App();
const stack = new core.Stack(app, 'FlinkAppCodeFromBucketTest');
const asset = new assets.Asset(stack, 'CodeAsset', {
    path: path.join(__dirname, 'code-asset'),
});
const bucket = asset.bucket;
const fileKey = asset.s3ObjectKey;
///! show
new flink.Application(stack, 'App', {
    code: flink.ApplicationCode.fromBucket(bucket, fileKey),
    runtime: flink.Runtime.FLINK_1_11,
});
///! hide
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBwbGljYXRpb24tY29kZS1mcm9tLWJ1Y2tldC5saXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnRlZy5hcHBsaWNhdGlvbi1jb2RlLWZyb20tYnVja2V0LmxpdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDZCQUE2QjtBQUM3Qiw4Q0FBOEM7QUFDOUMsbUNBQW1DO0FBQ25DLGdDQUFnQztBQUVoQyxNQUFNLEdBQUcsR0FBRyxJQUFJLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQztBQUMzQixNQUFNLEtBQUssR0FBRyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLDRCQUE0QixDQUFDLENBQUM7QUFFaEUsTUFBTSxLQUFLLEdBQUcsSUFBSSxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssRUFBRSxXQUFXLEVBQUU7SUFDakQsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFlBQVksQ0FBQztDQUN6QyxDQUFDLENBQUM7QUFDSCxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO0FBQzVCLE1BQU0sT0FBTyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7QUFFbEMsU0FBUztBQUNULElBQUksS0FBSyxDQUFDLFdBQVcsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO0lBQ2xDLElBQUksRUFBRSxLQUFLLENBQUMsZUFBZSxDQUFDLFVBQVUsQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDO0lBQ3ZELE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxDQUFDLFVBQVU7Q0FDbEMsQ0FBQyxDQUFDO0FBQ0gsU0FBUztBQUVULEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBhc3NldHMgZnJvbSAnLi4vLi4vYXdzLXMzLWFzc2V0cyc7XG5pbXBvcnQgKiBhcyBjb3JlIGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0ICogYXMgZmxpbmsgZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IGNvcmUuQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBjb3JlLlN0YWNrKGFwcCwgJ0ZsaW5rQXBwQ29kZUZyb21CdWNrZXRUZXN0Jyk7XG5cbmNvbnN0IGFzc2V0ID0gbmV3IGFzc2V0cy5Bc3NldChzdGFjaywgJ0NvZGVBc3NldCcsIHtcbiAgcGF0aDogcGF0aC5qb2luKF9fZGlybmFtZSwgJ2NvZGUtYXNzZXQnKSxcbn0pO1xuY29uc3QgYnVja2V0ID0gYXNzZXQuYnVja2V0O1xuY29uc3QgZmlsZUtleSA9IGFzc2V0LnMzT2JqZWN0S2V5O1xuXG4vLy8hIHNob3dcbm5ldyBmbGluay5BcHBsaWNhdGlvbihzdGFjaywgJ0FwcCcsIHtcbiAgY29kZTogZmxpbmsuQXBwbGljYXRpb25Db2RlLmZyb21CdWNrZXQoYnVja2V0LCBmaWxlS2V5KSxcbiAgcnVudGltZTogZmxpbmsuUnVudGltZS5GTElOS18xXzExLFxufSk7XG4vLy8hIGhpZGVcblxuYXBwLnN5bnRoKCk7XG4iXX0=