"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetVariableAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to create a variable with a specified value.
 */
class SetVariableAction {
    /**
     * @param variableName the name of the variable
     * @param value the new value of the variable
     */
    constructor(variableName, value) {
        this.variableName = variableName;
        this.value = value;
        try {
            jsiiDeprecationWarnings.monocdk_aws_iotevents_Expression(value);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SetVariableAction);
            }
            throw error;
        }
    }
    bind(_scope, _options) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iotevents_ActionBindOptions(_options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        return {
            configuration: {
                setVariable: {
                    variableName: this.variableName,
                    value: this.value.evaluate(),
                },
            },
        };
    }
}
exports.SetVariableAction = SetVariableAction;
_a = JSII_RTTI_SYMBOL_1;
SetVariableAction[_a] = { fqn: "monocdk.aws_iotevents_actions.SetVariableAction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2V0LXZhcmlhYmxlLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInNldC12YXJpYWJsZS1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLGlCQUFpQjtJQUM1Qjs7O09BR0c7SUFDSCxZQUE2QixZQUFvQixFQUFtQixLQUEyQjtRQUFsRSxpQkFBWSxHQUFaLFlBQVksQ0FBUTtRQUFtQixVQUFLLEdBQUwsS0FBSyxDQUFzQjs7Ozs7OytDQUxwRixpQkFBaUI7Ozs7S0FNM0I7SUFFRCxJQUFJLENBQUMsTUFBaUIsRUFBRSxRQUFxQzs7Ozs7Ozs7OztRQUMzRCxPQUFPO1lBQ0wsYUFBYSxFQUFFO2dCQUNiLFdBQVcsRUFBRTtvQkFDWCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVk7b0JBQy9CLEtBQUssRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRTtpQkFDN0I7YUFDRjtTQUNGLENBQUM7S0FDSDs7QUFqQkgsOENBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaW90ZXZlbnRzIGZyb20gJy4uLy4uL2F3cy1pb3RldmVudHMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogVGhlIGFjdGlvbiB0byBjcmVhdGUgYSB2YXJpYWJsZSB3aXRoIGEgc3BlY2lmaWVkIHZhbHVlLlxuICovXG5leHBvcnQgY2xhc3MgU2V0VmFyaWFibGVBY3Rpb24gaW1wbGVtZW50cyBpb3RldmVudHMuSUFjdGlvbiB7XG4gIC8qKlxuICAgKiBAcGFyYW0gdmFyaWFibGVOYW1lIHRoZSBuYW1lIG9mIHRoZSB2YXJpYWJsZVxuICAgKiBAcGFyYW0gdmFsdWUgdGhlIG5ldyB2YWx1ZSBvZiB0aGUgdmFyaWFibGVcbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgdmFyaWFibGVOYW1lOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgdmFsdWU6IGlvdGV2ZW50cy5FeHByZXNzaW9uKSB7XG4gIH1cblxuICBiaW5kKF9zY29wZTogQ29uc3RydWN0LCBfb3B0aW9uczogaW90ZXZlbnRzLkFjdGlvbkJpbmRPcHRpb25zKTogaW90ZXZlbnRzLkFjdGlvbkNvbmZpZyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgc2V0VmFyaWFibGU6IHtcbiAgICAgICAgICB2YXJpYWJsZU5hbWU6IHRoaXMudmFyaWFibGVOYW1lLFxuICAgICAgICAgIHZhbHVlOiB0aGlzLnZhbHVlLmV2YWx1YXRlKCksXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cbiJdfQ==