import * as iot from '../../aws-iot';
import * as sqs from '../../aws-sqs';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for SQS.
 */
export interface SqsQueueActionProps extends CommonActionProps {
    /**
     * Specifies whether to use Base64 encoding.
     *
     * @default false
     */
    readonly useBase64?: boolean;
}
/**
 * The action to write the data from an MQTT message to an Amazon SQS queue.
 */
export declare class SqsQueueAction implements iot.IAction {
    private readonly role?;
    private readonly queue;
    private readonly useBase64?;
    /**
     * @param queue The Amazon SQS queue to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(queue: sqs.IQueue, props?: SqsQueueActionProps);
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
