"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(func);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaFunctionAction);
            }
            throw error;
        }
    }
    bind(topicRule) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iot_ITopicRule(topicRule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        this.func.addPermission(`${core_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "monocdk.aws_iot_actions.LambdaFunctionAction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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