"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchSetAlarmStateAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const role_1 = require("./private/role");
/**
 * The action to change the state of an Amazon CloudWatch alarm.
 */
class CloudWatchSetAlarmStateAction {
    constructor(alarm, props) {
        this.alarm = alarm;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_cloudwatch_IAlarm(alarm);
            jsiiDeprecationWarnings.monocdk_aws_iot_actions_CloudWatchSetAlarmStateActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchSetAlarmStateAction);
            }
            throw error;
        }
    }
    bind(topicRule) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_iot_ITopicRule(topicRule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const role = this.props.role ?? role_1.singletonActionRole(topicRule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['cloudwatch:SetAlarmState'],
            resources: [this.alarm.alarmArn],
        }));
        return {
            configuration: {
                cloudwatchAlarm: {
                    alarmName: this.alarm.alarmName,
                    roleArn: role.roleArn,
                    stateReason: this.props.reason ?? `Set state of '${this.alarm.alarmName}' to '${this.props.alarmStateToSet}'`,
                    stateValue: this.props.alarmStateToSet,
                },
            },
        };
    }
}
exports.CloudWatchSetAlarmStateAction = CloudWatchSetAlarmStateAction;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchSetAlarmStateAction[_a] = { fqn: "monocdk.aws_iot_actions.CloudWatchSetAlarmStateAction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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