"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("../../../core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Resource {
    constructor(scope, id, role, addGrantsToResources) {
        super(scope, id, {
            account: role.env.account,
            region: role.env.region,
        });
        this.role = role;
        this.addGrantsToResources = addGrantsToResources;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.principalAccount = this.role.principalAccount;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
    }
    addManagedPolicy(_policy) {
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // If we return `false`, the grants will try to add the statement to the resource
        // (if possible).
        const pretendSuccess = !this.addGrantsToResources;
        return { statementAdded: pretendSuccess, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
    grantAssumeRole(identity) {
        return this.role.grantAssumeRole(identity);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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