"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class CfnEipEndpoint {
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ec2_CfnEIP(eip);
            jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_endpoints_CfnEipEndpointProps(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnEipEndpoint);
            }
            throw error;
        }
        _util_1.validateWeight(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
exports.CfnEipEndpoint = CfnEipEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.CfnEipEndpoint", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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