"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-12-27T19:34:44.288Z","fingerprint":"RnolWh0li4U+B14B37MO8aEXBDNcB1T3gE2M/6XZbvE="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_fms_CfnNotificationChannelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnNotificationChannel);
            }
            throw error;
        }
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
exports.CfnNotificationChannel = CfnNotificationChannel;
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "monocdk.aws_fms.CfnNotificationChannel", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', CfnPolicy_SecurityServicePolicyDataPropertyValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        SecurityServicePolicyData: cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('resourceType', 'ResourceType', cfn_parse.FromCloudFormation.getString(properties.ResourceType));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_fms_CfnPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnPolicy);
            }
            throw error;
        }
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.resourceType = props.resourceType;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceTags = props.resourceTags;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        try {
            jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.inspect);
            }
            throw error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            resourceType: this.resourceType,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceTags: this.resourceTags,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
exports.CfnPolicy = CfnPolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "monocdk.aws_fms.CfnPolicy", version: "1.185.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "NetworkFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `NetworkFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.NetworkFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_NetworkFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyOptionProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyOptionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('networkFirewallPolicy', CfnPolicy_NetworkFirewallPolicyPropertyValidator)(properties.networkFirewallPolicy));
    errors.collect(cdk.propertyValidator('thirdPartyFirewallPolicy', CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator)(properties.thirdPartyFirewallPolicy));
    return errors.wrap('supplied properties not correct for "PolicyOptionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource
 *
 * @param properties - the TypeScript properties of a `PolicyOptionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyOption` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyOptionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyOptionPropertyValidator(properties).assertSuccess();
    return {
        NetworkFirewallPolicy: cfnPolicyNetworkFirewallPolicyPropertyToCloudFormation(properties.networkFirewallPolicy),
        ThirdPartyFirewallPolicy: cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties.thirdPartyFirewallPolicy),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyOptionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('networkFirewallPolicy', 'NetworkFirewallPolicy', properties.NetworkFirewallPolicy != null ? CfnPolicyNetworkFirewallPolicyPropertyFromCloudFormation(properties.NetworkFirewallPolicy) : undefined);
    ret.addPropertyResult('thirdPartyFirewallPolicy', 'ThirdPartyFirewallPolicy', properties.ThirdPartyFirewallPolicy != null ? CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties.ThirdPartyFirewallPolicy) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SecurityServicePolicyDataProperty`
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('managedServiceData', cdk.validateString)(properties.managedServiceData));
    errors.collect(cdk.propertyValidator('policyOption', CfnPolicy_PolicyOptionPropertyValidator)(properties.policyOption));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "SecurityServicePolicyDataProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource
 *
 * @param properties - the TypeScript properties of a `SecurityServicePolicyDataProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.SecurityServicePolicyData` resource.
 */
// @ts-ignore TS6133
function cfnPolicySecurityServicePolicyDataPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_SecurityServicePolicyDataPropertyValidator(properties).assertSuccess();
    return {
        ManagedServiceData: cdk.stringToCloudFormation(properties.managedServiceData),
        PolicyOption: cfnPolicyPolicyOptionPropertyToCloudFormation(properties.policyOption),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnPolicySecurityServicePolicyDataPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('managedServiceData', 'ManagedServiceData', properties.ManagedServiceData != null ? cfn_parse.FromCloudFormation.getString(properties.ManagedServiceData) : undefined);
    ret.addPropertyResult('policyOption', 'PolicyOption', properties.PolicyOption != null ? CfnPolicyPolicyOptionPropertyFromCloudFormation(properties.PolicyOption) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ThirdPartyFirewallPolicyProperty`
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.requiredValidator)(properties.firewallDeploymentModel));
    errors.collect(cdk.propertyValidator('firewallDeploymentModel', cdk.validateString)(properties.firewallDeploymentModel));
    return errors.wrap('supplied properties not correct for "ThirdPartyFirewallPolicyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource
 *
 * @param properties - the TypeScript properties of a `ThirdPartyFirewallPolicyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ThirdPartyFirewallPolicy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyThirdPartyFirewallPolicyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ThirdPartyFirewallPolicyPropertyValidator(properties).assertSuccess();
    return {
        FirewallDeploymentModel: cdk.stringToCloudFormation(properties.firewallDeploymentModel),
    };
}
// @ts-ignore TS6133
function CfnPolicyThirdPartyFirewallPolicyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('firewallDeploymentModel', 'FirewallDeploymentModel', cfn_parse.FromCloudFormation.getString(properties.FirewallDeploymentModel));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZm1zLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImZtcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsK0VBQStFO0FBQy9FLCtEQUErRDtBQUMvRCw4RkFBOEY7QUFDOUYsc0hBQXNIO0FBRXRILDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixrQ0FBa0M7QUFDbEMsNkRBQTZEO0FBMkI3RDs7Ozs7O0dBTUc7QUFDSCxTQUFTLG9DQUFvQyxDQUFDLFVBQWU7SUFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxtRUFBbUUsQ0FBQyxDQUFDO0FBQzVGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUywyQ0FBMkMsQ0FBQyxVQUFlO0lBQ2hFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxvQ0FBb0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNqRSxPQUFPO1FBQ0gsV0FBVyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDO1FBQy9ELFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztLQUNsRSxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDZDQUE2QyxDQUFDLFVBQWU7SUFDbEUsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBK0IsQ0FBQztJQUMxRixHQUFHLENBQUMsaUJBQWlCLENBQUMsYUFBYSxFQUFFLGFBQWEsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ3BILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEgsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7OztHQVdHO0FBQ0gsTUFBYSxzQkFBdUIsU0FBUSxHQUFHLENBQUMsV0FBVztJQXVDdkQ7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFrQztRQUM1RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxzQkFBc0IsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQzs7Ozs7OzsrQ0EvQ3hGLHNCQUFzQjs7OztRQWdEM0IsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ2hELEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUVoRCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7UUFDckMsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO0tBQ3hDO0lBL0NEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRyw2Q0FBNkMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ3RGLE1BQU0sR0FBRyxHQUFHLElBQUksc0JBQXNCLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDckUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBZ0NEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOzs7Ozs7Ozs7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsc0JBQXNCLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNyRyxTQUFTLENBQUMsWUFBWSxDQUFDLDhCQUE4QixFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUM5RTtJQUVELElBQWMsYUFBYTtRQUN2QixPQUFPO1lBQ0gsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztTQUNoQyxDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLDJDQUEyQyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzdEOztBQTNFTCx3REE0RUM7OztBQTNFRzs7R0FFRztBQUNvQiw2Q0FBc0IsR0FBRywrQkFBK0IsQ0FBQztBQXdQcEY7Ozs7OztHQU1HO0FBQ0gsU0FBUyx1QkFBdUIsQ0FBQyxVQUFlO0lBQzVDLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQztJQUM1SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsZ0NBQWdDLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUM3RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ3BILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxlQUFlLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO0lBQ2xILE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxnQ0FBZ0MsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQzdHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztJQUNsRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQy9GLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDbEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDaEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsc0NBQXNDLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQzFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN0RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDO0lBQ25HLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM5SCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsZUFBZSxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM1RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywyQkFBMkIsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUMsQ0FBQyxDQUFDO0lBQ2hJLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLDJCQUEyQixFQUFFLG9EQUFvRCxDQUFDLENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQztJQUMvSixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLGFBQWEsQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDeEgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHNEQUFzRCxDQUFDLENBQUM7QUFDL0UsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDhCQUE4QixDQUFDLFVBQWU7SUFDbkQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ3BELE9BQU87UUFDSCxtQkFBbUIsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDO1FBQ2hGLFVBQVUsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUM3RCxrQkFBa0IsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzlFLFlBQVksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNqRSx5QkFBeUIsRUFBRSwwREFBMEQsQ0FBQyxVQUFVLENBQUMseUJBQXlCLENBQUM7UUFDM0gsd0JBQXdCLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztRQUMxRixVQUFVLEVBQUUsc0NBQXNDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUN6RSxVQUFVLEVBQUUsc0NBQXNDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQztRQUN6RSxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsdUJBQXVCLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDO1FBQzFFLFlBQVksRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLDRDQUE0QyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQztRQUNuRyxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RixJQUFJLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQywwQ0FBMEMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7S0FDcEYsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyxnQ0FBZ0MsQ0FBQyxVQUFlO0lBQ3JELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWtCLENBQUM7SUFDN0UsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLHFCQUFxQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUM3SSxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLFlBQVksRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2pILEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxvQkFBb0IsRUFBRSxvQkFBb0IsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDMUksR0FBRyxDQUFDLGlCQUFpQixDQUFDLGNBQWMsRUFBRSxjQUFjLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQztJQUN2SCxHQUFHLENBQUMsaUJBQWlCLENBQUMsMkJBQTJCLEVBQUUsMkJBQTJCLEVBQUUsNERBQTRELENBQUMsVUFBVSxDQUFDLHlCQUF5QixDQUFDLENBQUMsQ0FBQztJQUNwTCxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdE4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdDQUF3QyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDL0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxZQUFZLEVBQUUsVUFBVSxDQUFDLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdDQUF3QyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDL0osR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFVBQVUsQ0FBQyxnQkFBZ0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3RMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLDhDQUE4QyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUNwTixHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsa0JBQWtCLEVBQUUsVUFBVSxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMUwsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxDQUFDLElBQUksSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxRQUFRLENBQUMsNENBQTRDLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQWdCLENBQUMsQ0FBQztJQUN6TCxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FzQkc7QUFDSCxNQUFhLFNBQVUsU0FBUSxHQUFHLENBQUMsV0FBVztJQXdNMUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFxQjtRQUMvRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxTQUFTLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7Ozs7Ozs7K0NBaE4zRSxTQUFTOzs7O1FBaU5kLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLHFCQUFxQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3hELEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMvQyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxvQkFBb0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUN2RCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxjQUFjLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDakQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsMkJBQTJCLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDOUQsSUFBSSxDQUFDLE9BQU8sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7UUFDdEQsSUFBSSxDQUFDLE1BQU0sR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFFcEQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQyxtQkFBbUIsQ0FBQztRQUNyRCxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQztRQUNuRCxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLHlCQUF5QixHQUFHLEtBQUssQ0FBQyx5QkFBeUIsQ0FBQztRQUNqRSxJQUFJLENBQUMsd0JBQXdCLEdBQUcsS0FBSyxDQUFDLHdCQUF3QixDQUFDO1FBQy9ELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7UUFDbkMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUM7UUFDdkMsSUFBSSxDQUFDLGdCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztRQUMvQyxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7S0FDMUI7SUEvTkQ7Ozs7OztPQU1HO0lBQ0ksTUFBTSxDQUFDLG1CQUFtQixDQUFDLEtBQW9CLEVBQUUsRUFBVSxFQUFFLGtCQUF1QixFQUFFLE9BQTRDO1FBQ3JJLGtCQUFrQixHQUFHLGtCQUFrQixJQUFJLEVBQUUsQ0FBQztRQUM5QyxNQUFNLGtCQUFrQixHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3BGLE1BQU0sV0FBVyxHQUFHLGdDQUFnQyxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDekUsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDeEQsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBZ05EOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOzs7Ozs7Ozs7O1FBQ3ZDLFNBQVMsQ0FBQyxZQUFZLENBQUMsNkJBQTZCLEVBQUUsU0FBUyxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDeEYsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILG1CQUFtQixFQUFFLElBQUksQ0FBQyxtQkFBbUI7WUFDN0MsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7WUFDM0MsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLHlCQUF5QixFQUFFLElBQUksQ0FBQyx5QkFBeUI7WUFDekQsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLHdCQUF3QjtZQUN2RCxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsVUFBVSxFQUFFLElBQUksQ0FBQyxVQUFVO1lBQzNCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1lBQy9CLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7WUFDdkMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJO1NBQ2xCLENBQUM7S0FDTDtJQUVTLGdCQUFnQixDQUFDLEtBQTJCO1FBQ2xELE9BQU8sOEJBQThCLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDaEQ7O0FBclFMLDhCQXNRQzs7O0FBclFHOztHQUVHO0FBQ29CLGdDQUFzQixHQUFHLGtCQUFrQixDQUFDO0FBcVN2RTs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdDQUFnQyxDQUFDLFVBQWU7SUFDckQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFNBQVMsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQzVHLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO0FBQzlFLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyxzQ0FBc0MsQ0FBQyxVQUFlO0lBQzNELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUM3RCxPQUFPO1FBQ0gsT0FBTyxFQUFFLEdBQUcsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLHNCQUFzQixDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQztRQUN2RSxPQUFPLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDO0tBQzFFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsd0NBQXdDLENBQUMsVUFBZTtJQUM3RCxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMkIsQ0FBQztJQUN0RixHQUFHLENBQUMsaUJBQWlCLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxVQUFVLENBQUMsT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3RKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLEVBQUUsU0FBUyxFQUFFLFVBQVUsQ0FBQyxPQUFPLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDdEosR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXFCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGdEQUFnRCxDQUFDLFVBQWU7SUFDckUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDNUgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHFFQUFxRSxDQUFDLENBQUM7QUFDOUYsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHNEQUFzRCxDQUFDLFVBQWU7SUFDM0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELGdEQUFnRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQzdFLE9BQU87UUFDSCx1QkFBdUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO0tBQzFGLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsd0RBQXdELENBQUMsVUFBZTtJQUM3RSxJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBMkMsQ0FBQztJQUN0RyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3hKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyx1Q0FBdUMsQ0FBQyxVQUFlO0lBQzVELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyx1QkFBdUIsRUFBRSxnREFBZ0QsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUM7SUFDbkosTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsbURBQW1ELENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDO0lBQzVKLE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyw0REFBNEQsQ0FBQyxDQUFDO0FBQ3JGLENBQUM7QUFFRDs7Ozs7O0dBTUc7QUFDSCxvQkFBb0I7QUFDcEIsU0FBUyw2Q0FBNkMsQ0FBQyxVQUFlO0lBQ2xFLElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxVQUFVLENBQUM7S0FBRTtJQUN2RCx1Q0FBdUMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNwRSxPQUFPO1FBQ0gscUJBQXFCLEVBQUUsc0RBQXNELENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDO1FBQy9HLHdCQUF3QixFQUFFLHlEQUF5RCxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQztLQUMzSCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLCtDQUErQyxDQUFDLFVBQWU7SUFDcEUsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQWtDLENBQUM7SUFDN0YsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHVCQUF1QixFQUFFLHVCQUF1QixFQUFFLFVBQVUsQ0FBQyxxQkFBcUIsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLHdEQUF3RCxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUMzTixHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsMkRBQTJELENBQUMsVUFBVSxDQUFDLHdCQUF3QixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzFPLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUM7QUEyQkQ7Ozs7OztHQU1HO0FBQ0gsU0FBUyxvQ0FBb0MsQ0FBQyxVQUFlO0lBQ3pELElBQUksQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQUUsT0FBTyxHQUFHLENBQUMsa0JBQWtCLENBQUM7S0FBRTtJQUNuRSxNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNDLElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxHQUFHLENBQUMsZ0JBQWdCLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0c7SUFDRCxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDcEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztJQUNqRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUM7SUFDeEYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMseURBQXlELENBQUMsQ0FBQztBQUNsRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsb0NBQW9DLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDakUsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw0Q0FBNEMsQ0FBQyxVQUFlO0lBQ2pFLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUErQixDQUFDO0lBQzFGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNsRyxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBMkJEOzs7Ozs7R0FNRztBQUNILFNBQVMsc0NBQXNDLENBQUMsVUFBZTtJQUMzRCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBQ3BGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDakYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztJQUNyRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsMkRBQTJELENBQUMsQ0FBQztBQUNwRixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsNENBQTRDLENBQUMsVUFBZTtJQUNqRSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsc0NBQXNDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDbkUsT0FBTztRQUNILEdBQUcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQztRQUMvQyxLQUFLLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUM7S0FDdEQsQ0FBQztBQUNOLENBQUM7QUFFRCxvQkFBb0I7QUFDcEIsU0FBUyw4Q0FBOEMsQ0FBQyxVQUFlO0lBQ25FLElBQUksR0FBRyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxFQUFFO1FBQ3BDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUFpQyxDQUFDO0lBQzVGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7SUFDNUYsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE9BQU8sRUFBRSxPQUFPLEVBQUUsVUFBVSxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN6SSxHQUFHLENBQUMsZ0NBQWdDLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDakQsT0FBTyxHQUFHLENBQUM7QUFDZixDQUFDO0FBZ0hEOzs7Ozs7R0FNRztBQUNILFNBQVMsb0RBQW9ELENBQUMsVUFBZTtJQUN6RSxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sR0FBRyxDQUFDLGtCQUFrQixDQUFDO0tBQUU7SUFDbkUsTUFBTSxNQUFNLEdBQUcsSUFBSSxHQUFHLENBQUMsaUJBQWlCLEVBQUUsQ0FBQztJQUMzQyxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9HO0lBQ0QsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDLENBQUM7SUFDL0csTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsY0FBYyxFQUFFLHVDQUF1QyxDQUFDLENBQUMsVUFBVSxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUM7SUFDeEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO0lBQ3RGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLE1BQU0sRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDbkYsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHlFQUF5RSxDQUFDLENBQUM7QUFDbEcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLDBEQUEwRCxDQUFDLFVBQWU7SUFDL0UsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG9EQUFvRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2pGLE9BQU87UUFDSCxrQkFBa0IsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDO1FBQzdFLFlBQVksRUFBRSw2Q0FBNkMsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDO1FBQ3BGLElBQUksRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQztLQUNwRCxDQUFDO0FBQ04sQ0FBQztBQUVELG9CQUFvQjtBQUNwQixTQUFTLDREQUE0RCxDQUFDLFVBQWU7SUFDakYsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFDcEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELFVBQVUsR0FBRyxVQUFVLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQztJQUNsRCxJQUFJLE9BQU8sVUFBVSxLQUFLLFFBQVEsRUFBRTtRQUNoQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFTLENBQUMsZ0NBQWdDLEVBQStDLENBQUM7SUFDMUcsR0FBRyxDQUFDLGlCQUFpQixDQUFDLG9CQUFvQixFQUFFLG9CQUFvQixFQUFFLFVBQVUsQ0FBQyxrQkFBa0IsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzdMLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLFVBQVUsQ0FBQyxZQUFZLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQywrQ0FBK0MsQ0FBQyxVQUFVLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQzlLLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0YsR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQXFCRDs7Ozs7O0dBTUc7QUFDSCxTQUFTLG1EQUFtRCxDQUFDLFVBQWU7SUFDeEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHlCQUF5QixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDNUgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDLENBQUM7SUFDekgsT0FBTyxNQUFNLENBQUMsSUFBSSxDQUFDLHdFQUF3RSxDQUFDLENBQUM7QUFDakcsQ0FBQztBQUVEOzs7Ozs7R0FNRztBQUNILG9CQUFvQjtBQUNwQixTQUFTLHlEQUF5RCxDQUFDLFVBQWU7SUFDOUUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLFVBQVUsQ0FBQztLQUFFO0lBQ3ZELG1EQUFtRCxDQUFDLFVBQVUsQ0FBQyxDQUFDLGFBQWEsRUFBRSxDQUFDO0lBQ2hGLE9BQU87UUFDSCx1QkFBdUIsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLHVCQUF1QixDQUFDO0tBQzFGLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMkRBQTJELENBQUMsVUFBZTtJQUNoRixJQUFJLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUNwQyxPQUFPLElBQUksU0FBUyxDQUFDLHdCQUF3QixDQUFDLFVBQVUsQ0FBQyxDQUFDO0tBQzdEO0lBQ0QsVUFBVSxHQUFHLFVBQVUsSUFBSSxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDO0lBQ2xELElBQUksT0FBTyxVQUFVLEtBQUssUUFBUSxFQUFFO1FBQ2hDLE9BQU8sSUFBSSxTQUFTLENBQUMsd0JBQXdCLENBQUMsVUFBVSxDQUFDLENBQUM7S0FDN0Q7SUFDRCxNQUFNLEdBQUcsR0FBRyxJQUFJLFNBQVMsQ0FBQyxnQ0FBZ0MsRUFBOEMsQ0FBQztJQUN6RyxHQUFHLENBQUMsaUJBQWlCLENBQUMseUJBQXlCLEVBQUUseUJBQXlCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsdUJBQXVCLENBQUMsQ0FBQyxDQUFDO0lBQ3hKLEdBQUcsQ0FBQyxnQ0FBZ0MsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNqRCxPQUFPLEdBQUcsQ0FBQztBQUNmLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxMi0yMDIyIEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIFJlc291cmNlIFNwZWNpZmljYXRpb25cbi8vIFNlZTogZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2Nmbi1yZXNvdXJjZS1zcGVjaWZpY2F0aW9uLmh0bWxcbi8vIEBjZm4ydHM6bWV0YUAge1wiZ2VuZXJhdGVkXCI6XCIyMDIyLTEyLTI3VDE5OjM0OjQ0LjI4OFpcIixcImZpbmdlcnByaW50XCI6XCJSbm9sV2gwbGk0VStCMTRCMzdNTzhhRVhCRE5jQjFUM2dFMk0vNlhaYnZFPVwifVxuXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuICovIC8vIFRoaXMgaXMgZ2VuZXJhdGVkIGNvZGUgLSBsaW5lIGxlbmd0aHMgYXJlIGRpZmZpY3VsdCB0byBjb250cm9sXG5cbmltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCAqIGFzIGNmbl9wYXJzZSBmcm9tICcuLi8uLi9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBDZm5Ob3RpZmljYXRpb25DaGFubmVsYFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC5odG1sXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzIHtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgSUFNIHJvbGUgdGhhdCBhbGxvd3MgQW1hem9uIFNOUyB0byByZWNvcmQgQVdTIEZpcmV3YWxsIE1hbmFnZXIgYWN0aXZpdHkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC5odG1sI2Nmbi1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC1zbnNyb2xlbmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNuc1JvbGVOYW1lOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIFNOUyB0b3BpYyB0aGF0IGNvbGxlY3RzIG5vdGlmaWNhdGlvbnMgZnJvbSBBV1MgRmlyZXdhbGwgTWFuYWdlciAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC5odG1sI2Nmbi1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC1zbnN0b3BpY2FyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNuc1RvcGljQXJuOiBzdHJpbmc7XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzYFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBDZm5Ob3RpZmljYXRpb25DaGFubmVsUHJvcHNgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc25zUm9sZU5hbWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc25zUm9sZU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Nuc1JvbGVOYW1lJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnNuc1JvbGVOYW1lKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzbnNUb3BpY0FybicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zbnNUb3BpY0FybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc25zVG9waWNBcm4nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuc25zVG9waWNBcm4pKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzXCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6Ok5vdGlmaWNhdGlvbkNoYW5uZWxgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmbk5vdGlmaWNhdGlvbkNoYW5uZWxQcm9wc2BcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpOb3RpZmljYXRpb25DaGFubmVsYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmbk5vdGlmaWNhdGlvbkNoYW5uZWxQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBTbnNSb2xlTmFtZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zbnNSb2xlTmFtZSksXG4gICAgICAgIFNuc1RvcGljQXJuOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnNuc1RvcGljQXJuKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzPiB7XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Ob3RpZmljYXRpb25DaGFubmVsUHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzbnNSb2xlTmFtZScsICdTbnNSb2xlTmFtZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuU25zUm9sZU5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Nuc1RvcGljQXJuJywgJ1Nuc1RvcGljQXJuJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TbnNUb3BpY0FybikpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6Rk1TOjpOb3RpZmljYXRpb25DaGFubmVsYFxuICpcbiAqIERlc2lnbmF0ZXMgdGhlIElBTSByb2xlIGFuZCBBbWF6b24gU2ltcGxlIE5vdGlmaWNhdGlvbiBTZXJ2aWNlIChTTlMpIHRvcGljIHRvIHVzZSB0byByZWNvcmQgU05TIGxvZ3MuXG4gKlxuICogVG8gcGVyZm9ybSB0aGlzIGFjdGlvbiBvdXRzaWRlIG9mIHRoZSBjb25zb2xlLCB5b3UgbXVzdCBjb25maWd1cmUgdGhlIFNOUyB0b3BpYyB0byBhbGxvdyB0aGUgcm9sZSBgQVdTU2VydmljZVJvbGVGb3JGTVNgIHRvIHB1Ymxpc2ggU05TIGxvZ3MuIEZvciBtb3JlIGluZm9ybWF0aW9uLCBzZWUgW0ZpcmV3YWxsIE1hbmFnZXIgcmVxdWlyZWQgcGVybWlzc2lvbnMgZm9yIEFQSSBhY3Rpb25zXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd2FmL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9mbXMtYXBpLXBlcm1pc3Npb25zLXJlZi5odG1sKSBpbiB0aGUgKkFXUyBGaXJld2FsbCBNYW5hZ2VyIERldmVsb3BlciBHdWlkZSogLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6Rk1TOjpOb3RpZmljYXRpb25DaGFubmVsXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLW5vdGlmaWNhdGlvbmNoYW5uZWwuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbCBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkZNUzo6Tm90aWZpY2F0aW9uQ2hhbm5lbFwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbCB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbFByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5Ob3RpZmljYXRpb25DaGFubmVsKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgSUFNIHJvbGUgdGhhdCBhbGxvd3MgQW1hem9uIFNOUyB0byByZWNvcmQgQVdTIEZpcmV3YWxsIE1hbmFnZXIgYWN0aXZpdHkuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC5odG1sI2Nmbi1mbXMtbm90aWZpY2F0aW9uY2hhbm5lbC1zbnNyb2xlbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyBzbnNSb2xlTmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIEFtYXpvbiBSZXNvdXJjZSBOYW1lIChBUk4pIG9mIHRoZSBTTlMgdG9waWMgdGhhdCBjb2xsZWN0cyBub3RpZmljYXRpb25zIGZyb20gQVdTIEZpcmV3YWxsIE1hbmFnZXIgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLW5vdGlmaWNhdGlvbmNoYW5uZWwuaHRtbCNjZm4tZm1zLW5vdGlmaWNhdGlvbmNoYW5uZWwtc25zdG9waWNhcm5cbiAgICAgKi9cbiAgICBwdWJsaWMgc25zVG9waWNBcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQVdTOjpGTVM6Ok5vdGlmaWNhdGlvbkNoYW5uZWxgLlxuICAgICAqXG4gICAgICogQHBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIEBwYXJhbSBwcm9wcyAtIHJlc291cmNlIHByb3BlcnRpZXNcbiAgICAgKi9cbiAgICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IENmbk5vdGlmaWNhdGlvbkNoYW5uZWxQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiBwcm9wcyB9KTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3Nuc1JvbGVOYW1lJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzbnNUb3BpY0FybicsIHRoaXMpO1xuXG4gICAgICAgIHRoaXMuc25zUm9sZU5hbWUgPSBwcm9wcy5zbnNSb2xlTmFtZTtcbiAgICAgICAgdGhpcy5zbnNUb3BpY0FybiA9IHByb3BzLnNuc1RvcGljQXJuO1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIEV4YW1pbmVzIHRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSBhbmQgZGlzY2xvc2VzIGF0dHJpYnV0ZXMuXG4gICAgICpcbiAgICAgKiBAcGFyYW0gaW5zcGVjdG9yIC0gdHJlZSBpbnNwZWN0b3IgdG8gY29sbGVjdCBhbmQgcHJvY2VzcyBhdHRyaWJ1dGVzXG4gICAgICpcbiAgICAgKi9cbiAgICBwdWJsaWMgaW5zcGVjdChpbnNwZWN0b3I6IGNkay5UcmVlSW5zcGVjdG9yKSB7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnR5cGVcIiwgQ2ZuTm90aWZpY2F0aW9uQ2hhbm5lbC5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgc25zUm9sZU5hbWU6IHRoaXMuc25zUm9sZU5hbWUsXG4gICAgICAgICAgICBzbnNUb3BpY0FybjogdGhpcy5zbnNUb3BpY0FybixcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5Ob3RpZmljYXRpb25DaGFubmVsUHJvcHNUb0Nsb3VkRm9ybWF0aW9uKHByb3BzKTtcbiAgICB9XG59XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuUG9saWN5YFxuICpcbiAqIEBzdHJ1Y3RcbiAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAqXG4gKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWxcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5Qb2xpY3lQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBVc2VkIG9ubHkgd2hlbiB0YWdzIGFyZSBzcGVjaWZpZWQgaW4gdGhlIGBSZXNvdXJjZVRhZ3NgIHByb3BlcnR5LiBJZiB0aGlzIHByb3BlcnR5IGlzIGBUcnVlYCAsIHJlc291cmNlcyB3aXRoIHRoZSBzcGVjaWZpZWQgdGFncyBhcmUgbm90IGluIHNjb3BlIG9mIHRoZSBwb2xpY3kuIElmIGl0J3MgYEZhbHNlYCAsIG9ubHkgcmVzb3VyY2VzIHdpdGggdGhlIHNwZWNpZmllZCB0YWdzIGFyZSBpbiBzY29wZSBvZiB0aGUgcG9saWN5LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LWV4Y2x1ZGVyZXNvdXJjZXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSBleGNsdWRlUmVzb3VyY2VUYWdzOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEFXUyBGaXJld2FsbCBNYW5hZ2VyIHBvbGljeS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1wb2xpY3luYW1lXG4gICAgICovXG4gICAgcmVhZG9ubHkgcG9saWN5TmFtZTogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIGlmIHRoZSBwb2xpY3kgc2hvdWxkIGJlIGF1dG9tYXRpY2FsbHkgYXBwbGllZCB0byBuZXcgcmVzb3VyY2VzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LXJlbWVkaWF0aW9uZW5hYmxlZFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlbWVkaWF0aW9uRW5hYmxlZDogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSB0eXBlIG9mIHJlc291cmNlIHByb3RlY3RlZCBieSBvciBpbiBzY29wZSBvZiB0aGUgcG9saWN5LiBUaGlzIGlzIGluIHRoZSBmb3JtYXQgc2hvd24gaW4gdGhlIFtBV1MgUmVzb3VyY2UgVHlwZXMgUmVmZXJlbmNlXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtdGVtcGxhdGUtcmVzb3VyY2UtdHlwZS1yZWYuaHRtbCkgLiBUbyBhcHBseSB0aGlzIHBvbGljeSB0byBtdWx0aXBsZSByZXNvdXJjZSB0eXBlcywgc3BlY2lmeSBhIHJlc291cmNlIHR5cGUgb2YgYFJlc291cmNlVHlwZUxpc3RgIGFuZCB0aGVuIHNwZWNpZnkgdGhlIHJlc291cmNlIHR5cGVzIGluIGEgYFJlc291cmNlVHlwZUxpc3RgIC5cbiAgICAgKlxuICAgICAqIEZvciBBV1MgV0FGIGFuZCBTaGllbGQgQWR2YW5jZWQsIGV4YW1wbGUgcmVzb3VyY2UgdHlwZXMgaW5jbHVkZSBgQVdTOjpFbGFzdGljTG9hZEJhbGFuY2luZ1YyOjpMb2FkQmFsYW5jZXJgIGFuZCBgQVdTOjpDbG91ZEZyb250OjpEaXN0cmlidXRpb25gIC4gRm9yIGEgc2VjdXJpdHkgZ3JvdXAgY29tbW9uIHBvbGljeSwgdmFsaWQgdmFsdWVzIGFyZSBgQVdTOjpFQzI6Ok5ldHdvcmtJbnRlcmZhY2VgIGFuZCBgQVdTOjpFQzI6Okluc3RhbmNlYCAuIEZvciBhIHNlY3VyaXR5IGdyb3VwIGNvbnRlbnQgYXVkaXQgcG9saWN5LCB2YWxpZCB2YWx1ZXMgYXJlIGBBV1M6OkVDMjo6U2VjdXJpdHlHcm91cGAgLCBgQVdTOjpFQzI6Ok5ldHdvcmtJbnRlcmZhY2VgICwgYW5kIGBBV1M6OkVDMjo6SW5zdGFuY2VgIC4gRm9yIGEgc2VjdXJpdHkgZ3JvdXAgdXNhZ2UgYXVkaXQgcG9saWN5LCB0aGUgdmFsdWUgaXMgYEFXUzo6RUMyOjpTZWN1cml0eUdyb3VwYCAuIEZvciBhbiBBV1MgTmV0d29yayBGaXJld2FsbCBwb2xpY3kgb3IgRE5TIEZpcmV3YWxsIHBvbGljeSwgdGhlIHZhbHVlIGlzIGBBV1M6OkVDMjo6VlBDYCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktcmVzb3VyY2V0eXBlXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzb3VyY2VUeXBlOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBEZXRhaWxzIGFib3V0IHRoZSBzZWN1cml0eSBzZXJ2aWNlIHRoYXQgaXMgYmVpbmcgdXNlZCB0byBwcm90ZWN0IHRoZSByZXNvdXJjZXMuXG4gICAgICpcbiAgICAgKiBUaGlzIGNvbnRhaW5zIHRoZSBmb2xsb3dpbmcgc2V0dGluZ3M6XG4gICAgICpcbiAgICAgKiAtIFR5cGUgLSBJbmRpY2F0ZXMgdGhlIHNlcnZpY2UgdHlwZSB0aGF0IHRoZSBwb2xpY3kgdXNlcyB0byBwcm90ZWN0IHRoZSByZXNvdXJjZS4gRm9yIHNlY3VyaXR5IGdyb3VwIHBvbGljaWVzLCBGaXJld2FsbCBNYW5hZ2VyIHN1cHBvcnRzIG9uZSBzZWN1cml0eSBncm91cCBmb3IgZWFjaCBjb21tb24gcG9saWN5IGFuZCBmb3IgZWFjaCBjb250ZW50IGF1ZGl0IHBvbGljeS4gVGhpcyBpcyBhbiBhZGp1c3RhYmxlIGxpbWl0IHRoYXQgeW91IGNhbiBpbmNyZWFzZSBieSBjb250YWN0aW5nIEFXUyBTdXBwb3J0IC5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlczogYEROU19GSVJFV0FMTGAgfCBgTkVUV09SS19GSVJFV0FMTGAgfCBgU0VDVVJJVFlfR1JPVVBTX0NPTU1PTmAgfCBgU0VDVVJJVFlfR1JPVVBTX0NPTlRFTlRfQVVESVRgIHwgYFNFQ1VSSVRZX0dST1VQU19VU0FHRV9BVURJVGAgfCBgU0hJRUxEX0FEVkFOQ0VEYCB8IGBXQUZWMmAgfCBgV0FGYFxuICAgICAqIC0gTWFuYWdlZFNlcnZpY2VEYXRhIC0gRGV0YWlscyBhYm91dCB0aGUgc2VydmljZSB0aGF0IGFyZSBzcGVjaWZpYyB0byB0aGUgc2VydmljZSB0eXBlLCBpbiBKU09OIGZvcm1hdC5cbiAgICAgKlxuICAgICAqIC0gRXhhbXBsZTogYEROU19GSVJFV0FMTGBcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcInsgXFxcInR5cGVcXFwiOiBcXFwiRE5TX0ZJUkVXQUxMXFxcIiwgXFxcInByZVByb2Nlc3NSdWxlR3JvdXBzXFxcIjogW3tcXFwicnVsZUdyb3VwSWRcXFwiOiBcXFwicnNsdnItZnJnLTEyMzQ1NlxcXCIsIFxcXCJwcmlvcml0eVxcXCI6IDExfV0sIFxcXCJwb3N0UHJvY2Vzc1J1bGVHcm91cHNcXFwiOiBbe1xcXCJydWxlR3JvdXBJZFxcXCI6IFxcXCJyc2x2ci1mcmctMTIzNDU2XFxcIiwgXFxcInByaW9yaXR5XFxcIjogOTkwMn1dfVwiYFxuICAgICAqIC0gRXhhbXBsZTogYE5FVFdPUktfRklSRVdBTExgXG4gICAgICpcbiAgICAgKiBgXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIk5FVFdPUktfRklSRVdBTExcXFwiLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MDAwMDAwMDAwMDAwOnN0YXRlbGVzcy1ydWxlZ3JvdXBcXC9leGFtcGxlXFxcIixcXFwicHJpb3JpdHlcXFwiOjF9XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmRyb3BcXFwiLFxcXCJleGFtcGxlXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0ZyYWdtZW50RGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmRyb3BcXFwiLFxcXCJleGFtcGxlXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0N1c3RvbUFjdGlvbnNcXFwiOlt7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJleGFtcGxlXFxcIixcXFwiYWN0aW9uRGVmaW5pdGlvblxcXCI6e1xcXCJwdWJsaXNoTWV0cmljQWN0aW9uXFxcIjp7XFxcImRpbWVuc2lvbnNcXFwiOlt7XFxcInZhbHVlXFxcIjpcXFwiZXhhbXBsZVxcXCJ9XX19fV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlZnVsUnVsZUdyb3VwUmVmZXJlbmNlc1xcXCI6W3tcXFwicmVzb3VyY2VBUk5cXFwiOlxcXCJhcm46YXdzOm5ldHdvcmstZmlyZXdhbGw6dXMtZWFzdC0xOjAwMDAwMDAwMDAwMDpzdGF0ZWZ1bC1ydWxlZ3JvdXBcXC9leGFtcGxlXFxcIn1dLFxcXCJuZXR3b3JrRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXFxcIjp7XFxcInNpbmdsZUZpcmV3YWxsRW5kcG9pbnRQZXJWUENcXFwiOmZhbHNlLFxcXCJhbGxvd2VkSVBWNENpZHJMaXN0XFxcIjpbXX19XCJgXG4gICAgICogLSBFeGFtcGxlOiBgU0VDVVJJVFlfR1JPVVBTX0NPTU1PTmBcbiAgICAgKlxuICAgICAqIGBcIlNlY3VyaXR5U2VydmljZVBvbGljeURhdGFcIjp7XCJUeXBlXCI6XCJTRUNVUklUWV9HUk9VUFNfQ09NTU9OXCIsXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIlNFQ1VSSVRZX0dST1VQU19DT01NT05cXFwiLFxcXCJyZXZlcnRNYW51YWxTZWN1cml0eUdyb3VwQ2hhbmdlc1xcXCI6ZmFsc2UsXFxcImV4Y2x1c2l2ZVJlc291cmNlU2VjdXJpdHlHcm91cE1hbmFnZW1lbnRcXFwiOmZhbHNlLFxcXCJzZWN1cml0eUdyb3Vwc1xcXCI6W3tcXFwiaWRcXFwiOlxcXCIgc2ctMDAwZTU1OTk1ZDYxYTA2YmRcXFwifV19XCJ9LFwiUmVtZWRpYXRpb25FbmFibGVkXCI6ZmFsc2UsXCJSZXNvdXJjZVR5cGVcIjpcIkFXUzo6RUMyOjpOZXR3b3JrSW50ZXJmYWNlXCJ9YFxuICAgICAqIC0gRXhhbXBsZTogYFNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUYFxuICAgICAqXG4gICAgICogYFwiU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVwiOntcIlR5cGVcIjpcIlNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUXCIsXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIlNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUXFxcIixcXFwic2VjdXJpdHlHcm91cHNcXFwiOlt7XFxcImlkXFxcIjpcXFwiIHNnLTAwMGU1NTk5NWQ2MWEwNmJkIFxcXCJ9XSxcXFwic2VjdXJpdHlHcm91cEFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiQUxMT1dcXFwifX1cIn0sXCJSZW1lZGlhdGlvbkVuYWJsZWRcIjpmYWxzZSxcIlJlc291cmNlVHlwZVwiOlwiQVdTOjpFQzI6Ok5ldHdvcmtJbnRlcmZhY2VcIn1gXG4gICAgICpcbiAgICAgKiBUaGUgc2VjdXJpdHkgZ3JvdXAgYWN0aW9uIGZvciBjb250ZW50IGF1ZGl0IGNhbiBiZSBgQUxMT1dgIG9yIGBERU5ZYCAuIEZvciBgQUxMT1dgICwgYWxsIGluLXNjb3BlIHNlY3VyaXR5IGdyb3VwIHJ1bGVzIG11c3QgYmUgd2l0aGluIHRoZSBhbGxvd2VkIHJhbmdlIG9mIHRoZSBwb2xpY3kncyBzZWN1cml0eSBncm91cCBydWxlcy4gRm9yIGBERU5ZYCAsIGFsbCBpbi1zY29wZSBzZWN1cml0eSBncm91cCBydWxlcyBtdXN0IG5vdCBjb250YWluIGEgdmFsdWUgb3IgYSByYW5nZSB0aGF0IG1hdGNoZXMgYSBydWxlIHZhbHVlIG9yIHJhbmdlIGluIHRoZSBwb2xpY3kgc2VjdXJpdHkgZ3JvdXAuXG4gICAgICogLSBFeGFtcGxlOiBgU0VDVVJJVFlfR1JPVVBTX1VTQUdFX0FVRElUYFxuICAgICAqXG4gICAgICogYFwiU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVwiOntcIlR5cGVcIjpcIlNFQ1VSSVRZX0dST1VQU19VU0FHRV9BVURJVFwiLFwiTWFuYWdlZFNlcnZpY2VEYXRhXCI6XCJ7XFxcInR5cGVcXFwiOlxcXCJTRUNVUklUWV9HUk9VUFNfVVNBR0VfQVVESVRcXFwiLFxcXCJkZWxldGVVbnVzZWRTZWN1cml0eUdyb3Vwc1xcXCI6dHJ1ZSxcXFwiY29hbGVzY2VSZWR1bmRhbnRTZWN1cml0eUdyb3Vwc1xcXCI6dHJ1ZX1cIn0sXCJSZW1lZGlhdGlvbkVuYWJsZWRcIjpmYWxzZSxcIlJlc291IHJjZVR5cGVcIjpcIkFXUzo6RUMyOjpTZWN1cml0eUdyb3VwXCJ9YFxuICAgICAqIC0gU3BlY2lmaWNhdGlvbiBmb3IgYFNISUVMRF9BRFZBTkNFRGAgZm9yIEFtYXpvbiBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbnNcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcIntcXFwidHlwZVxcXCI6IFxcXCJTSElFTERfQURWQU5DRURcXFwiLCBcXFwiYXV0b21hdGljUmVzcG9uc2VDb25maWd1cmF0aW9uXFxcIjoge1xcXCJhdXRvbWF0aWNSZXNwb25zZVN0YXR1c1xcXCI6XFxcIkVOQUJMRUR8SUdOT1JFRHxESVNBQkxFRFxcXCIsIFxcXCJhdXRvbWF0aWNSZXNwb25zZUFjdGlvblxcXCI6XFxcIkJMT0NLfENPVU5UXFxcIn0sIFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViYWNsQ2xhc3NpY1xcXCI6dHJ1ZXxmYWxzZX1cImBcbiAgICAgKlxuICAgICAqIEZvciBleGFtcGxlOiBgXCJNYW5hZ2VkU2VydmljZURhdGFcIjogXCJ7XFxcInR5cGVcXFwiOlxcXCJTSElFTERfQURWQU5DRURcXFwiLFxcXCJhdXRvbWF0aWNSZXNwb25zZUNvbmZpZ3VyYXRpb25cXFwiOiB7XFxcImF1dG9tYXRpY1Jlc3BvbnNlU3RhdHVzXFxcIjpcXFwiRU5BQkxFRFxcXCIsIFxcXCJhdXRvbWF0aWNSZXNwb25zZUFjdGlvblxcXCI6XFxcIkNPVU5UXFxcIn19XCJgXG4gICAgICpcbiAgICAgKiBUaGUgZGVmYXVsdCB2YWx1ZSBmb3IgYGF1dG9tYXRpY1Jlc3BvbnNlU3RhdHVzYCBpcyBgSUdOT1JFRGAgLiBUaGUgdmFsdWUgZm9yIGBhdXRvbWF0aWNSZXNwb25zZUFjdGlvbmAgaXMgb25seSByZXF1aXJlZCB3aGVuIGBhdXRvbWF0aWNSZXNwb25zZVN0YXR1c2AgaXMgc2V0IHRvIGBFTkFCTEVEYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGZvciBgb3ZlcnJpZGVDdXN0b21lcldlYmFjbENsYXNzaWNgIGlzIGBmYWxzZWAgLlxuICAgICAqXG4gICAgICogRm9yIG90aGVyIHJlc291cmNlIHR5cGVzIHRoYXQgeW91IGNhbiBwcm90ZWN0IHdpdGggYSBTaGllbGQgQWR2YW5jZWQgcG9saWN5LCB0aGlzIGBNYW5hZ2VkU2VydmljZURhdGFgIGNvbmZpZ3VyYXRpb24gaXMgYW4gZW1wdHkgc3RyaW5nLlxuICAgICAqIC0gRXhhbXBsZTogYFdBRlYyYFxuICAgICAqXG4gICAgICogYFwiTWFuYWdlZFNlcnZpY2VEYXRhXCI6IFwie1xcXCJ0eXBlXFxcIjpcXFwiV0FGVjJcXFwiLFxcXCJwcmVQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W3tcXFwicnVsZUdyb3VwQXJuXFxcIjpudWxsLFxcXCJvdmVycmlkZUFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiTk9ORVxcXCJ9LFxcXCJtYW5hZ2VkUnVsZUdyb3VwSWRlbnRpZmllclxcXCI6e1xcXCJ2ZXJzaW9uXFxcIjpudWxsLFxcXCJ2ZW5kb3JOYW1lXFxcIjpcXFwiQVdTXFxcIixcXFwibWFuYWdlZFJ1bGVHcm91cE5hbWVcXFwiOlxcXCJBV1NNYW5hZ2VkUnVsZXNBbWF6b25JcFJlcHV0YXRpb25MaXN0XFxcIn0sXFxcInJ1bGVHcm91cFR5cGVcXFwiOlxcXCJNYW5hZ2VkUnVsZUdyb3VwXFxcIixcXFwiZXhjbHVkZVJ1bGVzXFxcIjpbXX1dLFxcXCJwb3N0UHJvY2Vzc1J1bGVHcm91cHNcXFwiOltdLFxcXCJkZWZhdWx0QWN0aW9uXFxcIjp7XFxcInR5cGVcXFwiOlxcXCJBTExPV1xcXCJ9LFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViQUNMQXNzb2NpYXRpb25cXFwiOmZhbHNlLFxcXCJsb2dnaW5nQ29uZmlndXJhdGlvblxcXCI6e1xcXCJsb2dEZXN0aW5hdGlvbkNvbmZpZ3NcXFwiOltcXFwiYXJuOmF3czpmaXJlaG9zZTp1cy13ZXN0LTI6MTIzNDU2Nzg5MTI6ZGVsaXZlcnlzdHJlYW0vYXdzLXdhZi1sb2dzLWZtcy1hZG1pbi1kZXN0aW5hdGlvblxcXCJdLFxcXCJyZWRhY3RlZEZpZWxkc1xcXCI6W3tcXFwicmVkYWN0ZWRGaWVsZFR5cGVcXFwiOlxcXCJTaW5nbGVIZWFkZXJcXFwiLFxcXCJyZWRhY3RlZEZpZWxkVmFsdWVcXFwiOlxcXCJDb29raWVzXFxcIn0se1xcXCJyZWRhY3RlZEZpZWxkVHlwZVxcXCI6XFxcIk1ldGhvZFxcXCJ9XX19XCJgXG4gICAgICpcbiAgICAgKiBJbiB0aGUgYGxvZ2dpbmdDb25maWd1cmF0aW9uYCAsIHlvdSBjYW4gc3BlY2lmeSBvbmUgYGxvZ0Rlc3RpbmF0aW9uQ29uZmlnc2AgLCB5b3UgY2FuIG9wdGlvbmFsbHkgcHJvdmlkZSB1cCB0byAyMCBgcmVkYWN0ZWRGaWVsZHNgICwgYW5kIHRoZSBgUmVkYWN0ZWRGaWVsZFR5cGVgIG11c3QgYmUgb25lIG9mIGBVUklgICwgYFFVRVJZX1NUUklOR2AgLCBgSEVBREVSYCAsIG9yIGBNRVRIT0RgIC5cbiAgICAgKiAtIEV4YW1wbGU6IGBXQUYgQ2xhc3NpY2BcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcIntcXFwidHlwZVxcXCI6IFxcXCJXQUZcXFwiLCBcXFwicnVsZUdyb3Vwc1xcXCI6IFt7XFxcImlkXFxcIjpcXFwiMTIzNDU2NzgtMWJjZC05MDEyLWVmZ2EtMDk4NzY1NDMyMWFiXFxcIiwgXFxcIm92ZXJyaWRlQWN0aW9uXFxcIiA6IHtcXFwidHlwZVxcXCI6IFxcXCJDT1VOVFxcXCJ9fV0sXFxcImRlZmF1bHRBY3Rpb25cXFwiOiB7XFxcInR5cGVcXFwiOiBcXFwiQkxPQ0tcXFwifX1gXG4gICAgICpcbiAgICAgKiBBV1MgV0FGIENsYXNzaWMgZG9lc24ndCBzdXBwb3J0IHJ1bGUgZ3JvdXBzIGluIENsb3VkRnJvbnQgLiBUbyBjcmVhdGUgYSBXQUYgQ2xhc3NpYyBwb2xpY3kgdGhyb3VnaCBDbG91ZEZvcm1hdGlvbiwgY3JlYXRlIHlvdXIgcnVsZSBncm91cHMgb3V0c2lkZSBvZiBDbG91ZEZyb250ICwgdGhlbiBwcm92aWRlIHRoZSBydWxlIGdyb3VwIElEcyBpbiB0aGUgV0FGIG1hbmFnZWQgc2VydmljZSBkYXRhIHNwZWNpZmljYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktc2VjdXJpdHlzZXJ2aWNlcG9saWN5ZGF0YVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY3VyaXR5U2VydmljZVBvbGljeURhdGE6IENmblBvbGljeS5TZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBVc2VkIHdoZW4gZGVsZXRpbmcgYSBwb2xpY3kuIElmIGB0cnVlYCAsIEZpcmV3YWxsIE1hbmFnZXIgcGVyZm9ybXMgY2xlYW51cCBhY2NvcmRpbmcgdG8gdGhlIHBvbGljeSB0eXBlLlxuICAgICAqXG4gICAgICogRm9yIEFXUyBXQUYgYW5kIFNoaWVsZCBBZHZhbmNlZCBwb2xpY2llcywgRmlyZXdhbGwgTWFuYWdlciBkb2VzIHRoZSBmb2xsb3dpbmc6XG4gICAgICpcbiAgICAgKiAtIERlbGV0ZXMgcnVsZSBncm91cHMgY3JlYXRlZCBieSBGaXJld2FsbCBNYW5hZ2VyXG4gICAgICogLSBSZW1vdmVzIHdlYiBBQ0xzIGZyb20gaW4tc2NvcGUgcmVzb3VyY2VzXG4gICAgICogLSBEZWxldGVzIHdlYiBBQ0xzIHRoYXQgY29udGFpbiBubyBydWxlcyBvciBydWxlIGdyb3Vwc1xuICAgICAqXG4gICAgICogRm9yIHNlY3VyaXR5IGdyb3VwIHBvbGljaWVzLCBGaXJld2FsbCBNYW5hZ2VyIGRvZXMgdGhlIGZvbGxvd2luZyBmb3IgZWFjaCBzZWN1cml0eSBncm91cCBpbiB0aGUgcG9saWN5OlxuICAgICAqXG4gICAgICogLSBEaXNhc3NvY2lhdGVzIHRoZSBzZWN1cml0eSBncm91cCBmcm9tIGluLXNjb3BlIHJlc291cmNlc1xuICAgICAqIC0gRGVsZXRlcyB0aGUgc2VjdXJpdHkgZ3JvdXAgaWYgaXQgd2FzIGNyZWF0ZWQgdGhyb3VnaCBGaXJld2FsbCBNYW5hZ2VyIGFuZCBpZiBpdCdzIG5vIGxvbmdlciBhc3NvY2lhdGVkIHdpdGggYW55IHJlc291cmNlcyB0aHJvdWdoIGFub3RoZXIgcG9saWN5XG4gICAgICpcbiAgICAgKiBBZnRlciB0aGUgY2xlYW51cCwgaW4tc2NvcGUgcmVzb3VyY2VzIGFyZSBubyBsb25nZXIgcHJvdGVjdGVkIGJ5IHdlYiBBQ0xzIGluIHRoaXMgcG9saWN5LiBQcm90ZWN0aW9uIG9mIG91dC1vZi1zY29wZSByZXNvdXJjZXMgcmVtYWlucyB1bmNoYW5nZWQuIFNjb3BlIGlzIGRldGVybWluZWQgYnkgdGFncyB0aGF0IHlvdSBjcmVhdGUgYW5kIGFjY291bnRzIHRoYXQgeW91IGFzc29jaWF0ZSB3aXRoIHRoZSBwb2xpY3kuIFdoZW4gY3JlYXRpbmcgdGhlIHBvbGljeSwgaWYgeW91IHNwZWNpZnkgdGhhdCBvbmx5IHJlc291cmNlcyBpbiBzcGVjaWZpYyBhY2NvdW50cyBvciB3aXRoIHNwZWNpZmljIHRhZ3MgYXJlIGluIHNjb3BlIG9mIHRoZSBwb2xpY3ksIHRob3NlIGFjY291bnRzIGFuZCByZXNvdXJjZXMgYXJlIGhhbmRsZWQgYnkgdGhlIHBvbGljeS4gQWxsIG90aGVycyBhcmUgb3V0IG9mIHNjb3BlLiBJZiB5b3UgZG9uJ3Qgc3BlY2lmeSB0YWdzIG9yIGFjY291bnRzLCBhbGwgcmVzb3VyY2VzIGFyZSBpbiBzY29wZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1kZWxldGVhbGxwb2xpY3lyZXNvdXJjZXNcbiAgICAgKi9cbiAgICByZWFkb25seSBkZWxldGVBbGxQb2xpY3lSZXNvdXJjZXM/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogU3BlY2lmaWVzIHRoZSBBV1MgYWNjb3VudCBJRHMgYW5kIEFXUyBPcmdhbml6YXRpb25zIG9yZ2FuaXphdGlvbmFsIHVuaXRzIChPVXMpIHRvIGV4Y2x1ZGUgZnJvbSB0aGUgcG9saWN5LiBTcGVjaWZ5aW5nIGFuIE9VIGlzIHRoZSBlcXVpdmFsZW50IG9mIHNwZWNpZnlpbmcgYWxsIGFjY291bnRzIGluIHRoZSBPVSBhbmQgaW4gYW55IG9mIGl0cyBjaGlsZCBPVXMsIGluY2x1ZGluZyBhbnkgY2hpbGQgT1VzIGFuZCBhY2NvdW50cyB0aGF0IGFyZSBhZGRlZCBhdCBhIGxhdGVyIHRpbWUuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIHNwZWNpZnkgaW5jbHVzaW9ucyBvciBleGNsdXNpb25zLCBidXQgbm90IGJvdGguIElmIHlvdSBzcGVjaWZ5IGFuIGBJbmNsdWRlTWFwYCAsIEFXUyBGaXJld2FsbCBNYW5hZ2VyIGFwcGxpZXMgdGhlIHBvbGljeSB0byBhbGwgYWNjb3VudHMgc3BlY2lmaWVkIGJ5IHRoZSBgSW5jbHVkZU1hcGAgLCBhbmQgZG9lcyBub3QgZXZhbHVhdGUgYW55IGBFeGNsdWRlTWFwYCBzcGVjaWZpY2F0aW9ucy4gSWYgeW91IGRvIG5vdCBzcGVjaWZ5IGFuIGBJbmNsdWRlTWFwYCAsIHRoZW4gRmlyZXdhbGwgTWFuYWdlciBhcHBsaWVzIHRoZSBwb2xpY3kgdG8gYWxsIGFjY291bnRzIGV4Y2VwdCBmb3IgdGhvc2Ugc3BlY2lmaWVkIGJ5IHRoZSBgRXhjbHVkZU1hcGAgLlxuICAgICAqXG4gICAgICogWW91IGNhbiBzcGVjaWZ5IGFjY291bnQgSURzLCBPVXMsIG9yIGEgY29tYmluYXRpb246XG4gICAgICpcbiAgICAgKiAtIFNwZWNpZnkgYWNjb3VudCBJRHMgYnkgc2V0dGluZyB0aGUga2V5IHRvIGBBQ0NPVU5UYCAuIEZvciBleGFtcGxlLCB0aGUgZm9sbG93aW5nIGlzIGEgdmFsaWQgbWFwOiBge+KAnEFDQ09VTlTigJ0gOiBb4oCcYWNjb3VudElEMeKAnSwg4oCcYWNjb3VudElEMuKAnV19YCAuXG4gICAgICogLSBTcGVjaWZ5IE9VcyBieSBzZXR0aW5nIHRoZSBrZXkgdG8gYE9SR1VOSVRgIC4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcT1JHVU5JVOKAnSA6IFvigJxvdWlkMTEx4oCdLCDigJxvdWlkMTEy4oCdXX1gIC5cbiAgICAgKiAtIFNwZWNpZnkgYWNjb3VudHMgYW5kIE9VcyB0b2dldGhlciBpbiBhIHNpbmdsZSBtYXAsIHNlcGFyYXRlZCB3aXRoIGEgY29tbWEuIEZvciBleGFtcGxlLCB0aGUgZm9sbG93aW5nIGlzIGEgdmFsaWQgbWFwOiBge+KAnEFDQ09VTlTigJ0gOiBb4oCcYWNjb3VudElEMeKAnSwg4oCcYWNjb3VudElEMuKAnV0sIOKAnE9SR1VOSVTigJ0gOiBb4oCcb3VpZDExMeKAnSwg4oCcb3VpZDExMuKAnV19YCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktZXhjbHVkZW1hcFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGV4Y2x1ZGVNYXA/OiBDZm5Qb2xpY3kuSUVNYXBQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQVdTIGFjY291bnQgSURzIGFuZCBBV1MgT3JnYW5pemF0aW9ucyBvcmdhbml6YXRpb25hbCB1bml0cyAoT1VzKSB0byBpbmNsdWRlIGluIHRoZSBwb2xpY3kuIFNwZWNpZnlpbmcgYW4gT1UgaXMgdGhlIGVxdWl2YWxlbnQgb2Ygc3BlY2lmeWluZyBhbGwgYWNjb3VudHMgaW4gdGhlIE9VIGFuZCBpbiBhbnkgb2YgaXRzIGNoaWxkIE9VcywgaW5jbHVkaW5nIGFueSBjaGlsZCBPVXMgYW5kIGFjY291bnRzIHRoYXQgYXJlIGFkZGVkIGF0IGEgbGF0ZXIgdGltZS5cbiAgICAgKlxuICAgICAqIFlvdSBjYW4gc3BlY2lmeSBpbmNsdXNpb25zIG9yIGV4Y2x1c2lvbnMsIGJ1dCBub3QgYm90aC4gSWYgeW91IHNwZWNpZnkgYW4gYEluY2x1ZGVNYXBgICwgQVdTIEZpcmV3YWxsIE1hbmFnZXIgYXBwbGllcyB0aGUgcG9saWN5IHRvIGFsbCBhY2NvdW50cyBzcGVjaWZpZWQgYnkgdGhlIGBJbmNsdWRlTWFwYCAsIGFuZCBkb2VzIG5vdCBldmFsdWF0ZSBhbnkgYEV4Y2x1ZGVNYXBgIHNwZWNpZmljYXRpb25zLiBJZiB5b3UgZG8gbm90IHNwZWNpZnkgYW4gYEluY2x1ZGVNYXBgICwgdGhlbiBGaXJld2FsbCBNYW5hZ2VyIGFwcGxpZXMgdGhlIHBvbGljeSB0byBhbGwgYWNjb3VudHMgZXhjZXB0IGZvciB0aG9zZSBzcGVjaWZpZWQgYnkgdGhlIGBFeGNsdWRlTWFwYCAuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIHNwZWNpZnkgYWNjb3VudCBJRHMsIE9Vcywgb3IgYSBjb21iaW5hdGlvbjpcbiAgICAgKlxuICAgICAqIC0gU3BlY2lmeSBhY2NvdW50IElEcyBieSBzZXR0aW5nIHRoZSBrZXkgdG8gYEFDQ09VTlRgIC4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcQUNDT1VOVOKAnSA6IFvigJxhY2NvdW50SUQx4oCdLCDigJxhY2NvdW50SUQy4oCdXX1gIC5cbiAgICAgKiAtIFNwZWNpZnkgT1VzIGJ5IHNldHRpbmcgdGhlIGtleSB0byBgT1JHVU5JVGAgLiBGb3IgZXhhbXBsZSwgdGhlIGZvbGxvd2luZyBpcyBhIHZhbGlkIG1hcDogYHvigJxPUkdVTklU4oCdIDogW+KAnG91aWQxMTHigJ0sIOKAnG91aWQxMTLigJ1dfWAgLlxuICAgICAqIC0gU3BlY2lmeSBhY2NvdW50cyBhbmQgT1VzIHRvZ2V0aGVyIGluIGEgc2luZ2xlIG1hcCwgc2VwYXJhdGVkIHdpdGggYSBjb21tYS4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcQUNDT1VOVOKAnSA6IFvigJxhY2NvdW50SUQx4oCdLCDigJxhY2NvdW50SUQy4oCdXSwg4oCcT1JHVU5JVOKAnSA6IFvigJxvdWlkMTEx4oCdLCDigJxvdWlkMTEy4oCdXX1gIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1pbmNsdWRlbWFwXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5jbHVkZU1hcD86IENmblBvbGljeS5JRU1hcFByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogSW5kaWNhdGVzIHdoZXRoZXIgQVdTIEZpcmV3YWxsIE1hbmFnZXIgc2hvdWxkIGF1dG9tYXRpY2FsbHkgcmVtb3ZlIHByb3RlY3Rpb25zIGZyb20gcmVzb3VyY2VzIHRoYXQgbGVhdmUgdGhlIHBvbGljeSBzY29wZSBhbmQgY2xlYW4gdXAgcmVzb3VyY2VzIHRoYXQgRmlyZXdhbGwgTWFuYWdlciBpcyBtYW5hZ2luZyBmb3IgYWNjb3VudHMgd2hlbiB0aG9zZSBhY2NvdW50cyBsZWF2ZSBwb2xpY3kgc2NvcGUuIEZvciBleGFtcGxlLCBGaXJld2FsbCBNYW5hZ2VyIHdpbGwgZGlzYXNzb2NpYXRlIGEgRmlyZXdhbGwgTWFuYWdlciBtYW5hZ2VkIHdlYiBBQ0wgZnJvbSBhIHByb3RlY3RlZCBjdXN0b21lciByZXNvdXJjZSB3aGVuIHRoZSBjdXN0b21lciByZXNvdXJjZSBsZWF2ZXMgcG9saWN5IHNjb3BlLlxuICAgICAqXG4gICAgICogQnkgZGVmYXVsdCwgRmlyZXdhbGwgTWFuYWdlciBkb2Vzbid0IHJlbW92ZSBwcm90ZWN0aW9ucyBvciBkZWxldGUgRmlyZXdhbGwgTWFuYWdlciBtYW5hZ2VkIHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIFRoaXMgb3B0aW9uIGlzIG5vdCBhdmFpbGFibGUgZm9yIFNoaWVsZCBBZHZhbmNlZCBvciBBV1MgV0FGIENsYXNzaWMgcG9saWNpZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktcmVzb3VyY2VzY2xlYW51cFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlc0NsZWFuVXA/OiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogQW4gYXJyYXkgb2YgYFJlc291cmNlVGFnYCBvYmplY3RzLCB1c2VkIHRvIGV4cGxpY2l0bHkgaW5jbHVkZSByZXNvdXJjZXMgaW4gdGhlIHBvbGljeSBzY29wZSBvciBleHBsaWNpdGx5IGV4Y2x1ZGUgdGhlbS4gSWYgdGhpcyBpc24ndCBzZXQsIHRoZW4gdGFncyBhcmVuJ3QgdXNlZCB0byBtb2RpZnkgcG9saWN5IHNjb3BlLiBTZWUgYWxzbyBgRXhjbHVkZVJlc291cmNlVGFnc2AgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LXJlc291cmNldGFnc1xuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlc291cmNlVGFncz86IEFycmF5PENmblBvbGljeS5SZXNvdXJjZVRhZ1Byb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIEFuIGFycmF5IG9mIGBSZXNvdXJjZVR5cGVgIG9iamVjdHMuIFVzZSB0aGlzIG9ubHkgdG8gc3BlY2lmeSBtdWx0aXBsZSByZXNvdXJjZSB0eXBlcy4gVG8gc3BlY2lmeSBhIHNpbmdsZSByZXNvdXJjZSB0eXBlLCB1c2UgYFJlc291cmNlVHlwZWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LXJlc291cmNldHlwZWxpc3RcbiAgICAgKi9cbiAgICByZWFkb25seSByZXNvdXJjZVR5cGVMaXN0Pzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBBIGNvbGxlY3Rpb24gb2Yga2V5OnZhbHVlIHBhaXJzIGFzc29jaWF0ZWQgd2l0aCBhbiBBV1MgcmVzb3VyY2UuIFRoZSBrZXk6dmFsdWUgcGFpciBjYW4gYmUgYW55dGhpbmcgeW91IGRlZmluZS4gVHlwaWNhbGx5LCB0aGUgdGFnIGtleSByZXByZXNlbnRzIGEgY2F0ZWdvcnkgKHN1Y2ggYXMgXCJlbnZpcm9ubWVudFwiKSBhbmQgdGhlIHRhZyB2YWx1ZSByZXByZXNlbnRzIGEgc3BlY2lmaWMgdmFsdWUgd2l0aGluIHRoYXQgY2F0ZWdvcnkgKHN1Y2ggYXMgXCJ0ZXN0LFwiIFwiZGV2ZWxvcG1lbnQsXCIgb3IgXCJwcm9kdWN0aW9uXCIpLiBZb3UgY2FuIGFkZCB1cCB0byA1MCB0YWdzIHRvIGVhY2ggQVdTIHJlc291cmNlLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LXRhZ3NcbiAgICAgKi9cbiAgICByZWFkb25seSB0YWdzPzogQ2ZuUG9saWN5LlBvbGljeVRhZ1Byb3BlcnR5W107XG59XG5cbi8qKlxuICogRGV0ZXJtaW5lIHdoZXRoZXIgdGhlIGdpdmVuIHByb3BlcnRpZXMgbWF0Y2ggdGhvc2Ugb2YgYSBgQ2ZuUG9saWN5UHJvcHNgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblBvbGljeVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblBvbGljeVByb3BzVmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5kZWxldGVBbGxQb2xpY3lSZXNvdXJjZXMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2V4Y2x1ZGVNYXAnLCBDZm5Qb2xpY3lfSUVNYXBQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5leGNsdWRlTWFwKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdleGNsdWRlUmVzb3VyY2VUYWdzJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmV4Y2x1ZGVSZXNvdXJjZVRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2V4Y2x1ZGVSZXNvdXJjZVRhZ3MnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLmV4Y2x1ZGVSZXNvdXJjZVRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2luY2x1ZGVNYXAnLCBDZm5Qb2xpY3lfSUVNYXBQcm9wZXJ0eVZhbGlkYXRvcikocHJvcGVydGllcy5pbmNsdWRlTWFwKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb2xpY3lOYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnBvbGljeU5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3BvbGljeU5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucG9saWN5TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVtZWRpYXRpb25FbmFibGVkJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJlbWVkaWF0aW9uRW5hYmxlZCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVtZWRpYXRpb25FbmFibGVkJywgY2RrLnZhbGlkYXRlQm9vbGVhbikocHJvcGVydGllcy5yZW1lZGlhdGlvbkVuYWJsZWQpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlVGFncycsIGNkay5saXN0VmFsaWRhdG9yKENmblBvbGljeV9SZXNvdXJjZVRhZ1Byb3BlcnR5VmFsaWRhdG9yKSkocHJvcGVydGllcy5yZXNvdXJjZVRhZ3MpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlVHlwZScsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5yZXNvdXJjZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlVHlwZScsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5yZXNvdXJjZVR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlVHlwZUxpc3QnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLnJlc291cmNlVHlwZUxpc3QpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3Jlc291cmNlc0NsZWFuVXAnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLnJlc291cmNlc0NsZWFuVXApKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3NlY3VyaXR5U2VydmljZVBvbGljeURhdGEnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YScsIENmblBvbGljeV9TZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMuc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGFncycsIGNkay5saXN0VmFsaWRhdG9yKENmblBvbGljeV9Qb2xpY3lUYWdQcm9wZXJ0eVZhbGlkYXRvcikpKHByb3BlcnRpZXMudGFncykpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5Qb2xpY3lQcm9wc1wiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpQb2xpY3lgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYENmblBvbGljeVByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Qb2xpY3lQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuUG9saWN5UHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIEV4Y2x1ZGVSZXNvdXJjZVRhZ3M6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmV4Y2x1ZGVSZXNvdXJjZVRhZ3MpLFxuICAgICAgICBQb2xpY3lOYW1lOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvbGljeU5hbWUpLFxuICAgICAgICBSZW1lZGlhdGlvbkVuYWJsZWQ6IGNkay5ib29sZWFuVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnJlbWVkaWF0aW9uRW5hYmxlZCksXG4gICAgICAgIFJlc291cmNlVHlwZTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yZXNvdXJjZVR5cGUpLFxuICAgICAgICBTZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhOiBjZm5Qb2xpY3lTZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YSksXG4gICAgICAgIERlbGV0ZUFsbFBvbGljeVJlc291cmNlczogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzKSxcbiAgICAgICAgRXhjbHVkZU1hcDogY2ZuUG9saWN5SUVNYXBQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5leGNsdWRlTWFwKSxcbiAgICAgICAgSW5jbHVkZU1hcDogY2ZuUG9saWN5SUVNYXBQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5pbmNsdWRlTWFwKSxcbiAgICAgICAgUmVzb3VyY2VzQ2xlYW5VcDogY2RrLmJvb2xlYW5Ub0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVzb3VyY2VzQ2xlYW5VcCksXG4gICAgICAgIFJlc291cmNlVGFnczogY2RrLmxpc3RNYXBwZXIoY2ZuUG9saWN5UmVzb3VyY2VUYWdQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMucmVzb3VyY2VUYWdzKSxcbiAgICAgICAgUmVzb3VyY2VUeXBlTGlzdDogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMucmVzb3VyY2VUeXBlTGlzdCksXG4gICAgICAgIFRhZ3M6IGNkay5saXN0TWFwcGVyKGNmblBvbGljeVBvbGljeVRhZ1Byb3BlcnR5VG9DbG91ZEZvcm1hdGlvbikocHJvcGVydGllcy50YWdzKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuUG9saWN5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Qb2xpY3lQcm9wcz4ge1xuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuUG9saWN5UHJvcHM+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdleGNsdWRlUmVzb3VyY2VUYWdzJywgJ0V4Y2x1ZGVSZXNvdXJjZVRhZ3MnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5FeGNsdWRlUmVzb3VyY2VUYWdzKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdwb2xpY3lOYW1lJywgJ1BvbGljeU5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlBvbGljeU5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JlbWVkaWF0aW9uRW5hYmxlZCcsICdSZW1lZGlhdGlvbkVuYWJsZWQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5SZW1lZGlhdGlvbkVuYWJsZWQpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Jlc291cmNlVHlwZScsICdSZXNvdXJjZVR5cGUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJlc291cmNlVHlwZSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YScsICdTZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhJywgQ2ZuUG9saWN5U2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YSkpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzJywgJ0RlbGV0ZUFsbFBvbGljeVJlc291cmNlcycsIHByb3BlcnRpZXMuRGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEJvb2xlYW4ocHJvcGVydGllcy5EZWxldGVBbGxQb2xpY3lSZXNvdXJjZXMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2V4Y2x1ZGVNYXAnLCAnRXhjbHVkZU1hcCcsIHByb3BlcnRpZXMuRXhjbHVkZU1hcCAhPSBudWxsID8gQ2ZuUG9saWN5SUVNYXBQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkV4Y2x1ZGVNYXApIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2luY2x1ZGVNYXAnLCAnSW5jbHVkZU1hcCcsIHByb3BlcnRpZXMuSW5jbHVkZU1hcCAhPSBudWxsID8gQ2ZuUG9saWN5SUVNYXBQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLkluY2x1ZGVNYXApIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3Jlc291cmNlc0NsZWFuVXAnLCAnUmVzb3VyY2VzQ2xlYW5VcCcsIHByb3BlcnRpZXMuUmVzb3VyY2VzQ2xlYW5VcCAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRCb29sZWFuKHByb3BlcnRpZXMuUmVzb3VyY2VzQ2xlYW5VcCkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgncmVzb3VyY2VUYWdzJywgJ1Jlc291cmNlVGFncycsIHByb3BlcnRpZXMuUmVzb3VyY2VUYWdzICE9IG51bGwgPyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldEFycmF5KENmblBvbGljeVJlc291cmNlVGFnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuUmVzb3VyY2VUYWdzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyZXNvdXJjZVR5cGVMaXN0JywgJ1Jlc291cmNlVHlwZUxpc3QnLCBwcm9wZXJ0aWVzLlJlc291cmNlVHlwZUxpc3QgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5SZXNvdXJjZVR5cGVMaXN0KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0YWdzJywgJ1RhZ3MnLCBwcm9wZXJ0aWVzLlRhZ3MgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0QXJyYXkoQ2ZuUG9saWN5UG9saWN5VGFnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuVGFncykgOiB1bmRlZmluZWQgYXMgYW55KTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuLyoqXG4gKiBBIENsb3VkRm9ybWF0aW9uIGBBV1M6OkZNUzo6UG9saWN5YFxuICpcbiAqIEFuIEFXUyBGaXJld2FsbCBNYW5hZ2VyIHBvbGljeS5cbiAqXG4gKiBGaXJld2FsbCBNYW5hZ2VyIHByb3ZpZGVzIHRoZSBmb2xsb3dpbmcgdHlwZXMgb2YgcG9saWNpZXM6XG4gKlxuICogLSBBbiBBV1MgU2hpZWxkIEFkdmFuY2VkIHBvbGljeSwgd2hpY2ggYXBwbGllcyBTaGllbGQgQWR2YW5jZWQgcHJvdGVjdGlvbiB0byBzcGVjaWZpZWQgYWNjb3VudHMgYW5kIHJlc291cmNlcy5cbiAqIC0gQW4gQVdTIFdBRiBwb2xpY3kgKHR5cGUgV0FGVjIpLCB3aGljaCBkZWZpbmVzIHJ1bGUgZ3JvdXBzIHRvIHJ1biBmaXJzdCBpbiB0aGUgY29ycmVzcG9uZGluZyBBV1MgV0FGIHdlYiBBQ0wgYW5kIHJ1bGUgZ3JvdXBzIHRvIHJ1biBsYXN0IGluIHRoZSB3ZWIgQUNMLlxuICogLSBBbiBBV1MgV0FGIENsYXNzaWMgcG9saWN5LCB3aGljaCBkZWZpbmVzIGEgcnVsZSBncm91cC4gQVdTIFdBRiBDbGFzc2ljIGRvZXNuJ3Qgc3VwcG9ydCBydWxlIGdyb3VwcyBpbiBBbWF6b24gQ2xvdWRGcm9udCAsIHNvLCB0byBjcmVhdGUgQVdTIFdBRiBDbGFzc2ljIHBvbGljaWVzIHRocm91Z2ggQ2xvdWRGcm9udCAsIHlvdSBmaXJzdCBuZWVkIHRvIGNyZWF0ZSB5b3VyIHJ1bGUgZ3JvdXBzIG91dHNpZGUgb2YgQ2xvdWRGcm9udCAuXG4gKiAtIEEgc2VjdXJpdHkgZ3JvdXAgcG9saWN5LCB3aGljaCBtYW5hZ2VzIFZQQyBzZWN1cml0eSBncm91cHMgYWNyb3NzIHlvdXIgQVdTIG9yZ2FuaXphdGlvbi5cbiAqIC0gQW4gQVdTIE5ldHdvcmsgRmlyZXdhbGwgcG9saWN5LCB3aGljaCBwcm92aWRlcyBmaXJld2FsbCBydWxlcyB0byBmaWx0ZXIgbmV0d29yayB0cmFmZmljIGluIHNwZWNpZmllZCBBbWF6b24gVlBDcy5cbiAqIC0gQSBETlMgRmlyZXdhbGwgcG9saWN5LCB3aGljaCBwcm92aWRlcyBBbWF6b24gUm91dGXCoDUzIFJlc29sdmVyIEROUyBGaXJld2FsbCBydWxlcyB0byBmaWx0ZXIgRE5TIHF1ZXJpZXMgZm9yIHNwZWNpZmllZCBBbWF6b24gVlBDcy5cbiAqXG4gKiBFYWNoIHBvbGljeSBpcyBzcGVjaWZpYyB0byBvbmUgb2YgdGhlIHR5cGVzLiBJZiB5b3Ugd2FudCB0byBlbmZvcmNlIG1vcmUgdGhhbiBvbmUgcG9saWN5IHR5cGUgYWNyb3NzIGFjY291bnRzLCBjcmVhdGUgbXVsdGlwbGUgcG9saWNpZXMuIFlvdSBjYW4gY3JlYXRlIG11bHRpcGxlIHBvbGljaWVzIGZvciBlYWNoIHR5cGUuXG4gKlxuICogVGhlc2UgcG9saWNpZXMgcmVxdWlyZSBzb21lIHNldHVwIHRvIHVzZS4gRm9yIG1vcmUgaW5mb3JtYXRpb24sIHNlZSB0aGUgc2VjdGlvbnMgb24gcHJlcmVxdWlzaXRlcyBhbmQgZ2V0dGluZyBzdGFydGVkIHVuZGVyIFtBV1MgRmlyZXdhbGwgTWFuYWdlcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dhZi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZm1zLXByZXJlcS5odG1sKSAuXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQVdTOjpGTVM6OlBvbGljeVxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICpcbiAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuUG9saWN5IGV4dGVuZHMgY2RrLkNmblJlc291cmNlIGltcGxlbWVudHMgY2RrLklJbnNwZWN0YWJsZSB7XG4gICAgLyoqXG4gICAgICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IENGTl9SRVNPVVJDRV9UWVBFX05BTUUgPSBcIkFXUzo6Rk1TOjpQb2xpY3lcIjtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAgICogVXNlZCBpbiB0aGUgQGF3cy1jZGsvY2xvdWRmb3JtYXRpb24taW5jbHVkZSBtb2R1bGUuXG4gICAgICpcbiAgICAgKiBAaW50ZXJuYWxcbiAgICAgKi9cbiAgICBwdWJsaWMgc3RhdGljIF9mcm9tQ2xvdWRGb3JtYXRpb24oc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHJlc291cmNlQXR0cmlidXRlczogYW55LCBvcHRpb25zOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uT3B0aW9ucyk6IENmblBvbGljeSB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuUG9saWN5UHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocmVzb3VyY2VQcm9wZXJ0aWVzKTtcbiAgICAgICAgY29uc3QgcmV0ID0gbmV3IENmblBvbGljeShzY29wZSwgaWQsIHByb3BzUmVzdWx0LnZhbHVlKTtcbiAgICAgICAgZm9yIChjb25zdCBbcHJvcEtleSwgcHJvcFZhbF0gb2YgT2JqZWN0LmVudHJpZXMocHJvcHNSZXN1bHQuZXh0cmFQcm9wZXJ0aWVzKSkgIHtcbiAgICAgICAgICAgIHJldC5hZGRQcm9wZXJ0eU92ZXJyaWRlKHByb3BLZXksIHByb3BWYWwpO1xuICAgICAgICB9XG4gICAgICAgIG9wdGlvbnMucGFyc2VyLmhhbmRsZUF0dHJpYnV0ZXMocmV0LCByZXNvdXJjZUF0dHJpYnV0ZXMsIGlkKTtcbiAgICAgICAgcmV0dXJuIHJldDtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIHBvbGljeS5cbiAgICAgKiBAY2xvdWRmb3JtYXRpb25BdHRyaWJ1dGUgQXJuXG4gICAgICovXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBcm46IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBJRCBvZiB0aGUgcG9saWN5LlxuICAgICAqIEBjbG91ZGZvcm1hdGlvbkF0dHJpYnV0ZSBJZFxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRySWQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFVzZWQgb25seSB3aGVuIHRhZ3MgYXJlIHNwZWNpZmllZCBpbiB0aGUgYFJlc291cmNlVGFnc2AgcHJvcGVydHkuIElmIHRoaXMgcHJvcGVydHkgaXMgYFRydWVgICwgcmVzb3VyY2VzIHdpdGggdGhlIHNwZWNpZmllZCB0YWdzIGFyZSBub3QgaW4gc2NvcGUgb2YgdGhlIHBvbGljeS4gSWYgaXQncyBgRmFsc2VgICwgb25seSByZXNvdXJjZXMgd2l0aCB0aGUgc3BlY2lmaWVkIHRhZ3MgYXJlIGluIHNjb3BlIG9mIHRoZSBwb2xpY3kuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktZXhjbHVkZXJlc291cmNldGFnc1xuICAgICAqL1xuICAgIHB1YmxpYyBleGNsdWRlUmVzb3VyY2VUYWdzOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIEFXUyBGaXJld2FsbCBNYW5hZ2VyIHBvbGljeS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1wb2xpY3luYW1lXG4gICAgICovXG4gICAgcHVibGljIHBvbGljeU5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyBpZiB0aGUgcG9saWN5IHNob3VsZCBiZSBhdXRvbWF0aWNhbGx5IGFwcGxpZWQgdG8gbmV3IHJlc291cmNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1yZW1lZGlhdGlvbmVuYWJsZWRcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVtZWRpYXRpb25FbmFibGVkOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHR5cGUgb2YgcmVzb3VyY2UgcHJvdGVjdGVkIGJ5IG9yIGluIHNjb3BlIG9mIHRoZSBwb2xpY3kuIFRoaXMgaXMgaW4gdGhlIGZvcm1hdCBzaG93biBpbiB0aGUgW0FXUyBSZXNvdXJjZSBUeXBlcyBSZWZlcmVuY2VdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy10ZW1wbGF0ZS1yZXNvdXJjZS10eXBlLXJlZi5odG1sKSAuIFRvIGFwcGx5IHRoaXMgcG9saWN5IHRvIG11bHRpcGxlIHJlc291cmNlIHR5cGVzLCBzcGVjaWZ5IGEgcmVzb3VyY2UgdHlwZSBvZiBgUmVzb3VyY2VUeXBlTGlzdGAgYW5kIHRoZW4gc3BlY2lmeSB0aGUgcmVzb3VyY2UgdHlwZXMgaW4gYSBgUmVzb3VyY2VUeXBlTGlzdGAgLlxuICAgICAqXG4gICAgICogRm9yIEFXUyBXQUYgYW5kIFNoaWVsZCBBZHZhbmNlZCwgZXhhbXBsZSByZXNvdXJjZSB0eXBlcyBpbmNsdWRlIGBBV1M6OkVsYXN0aWNMb2FkQmFsYW5jaW5nVjI6OkxvYWRCYWxhbmNlcmAgYW5kIGBBV1M6OkNsb3VkRnJvbnQ6OkRpc3RyaWJ1dGlvbmAgLiBGb3IgYSBzZWN1cml0eSBncm91cCBjb21tb24gcG9saWN5LCB2YWxpZCB2YWx1ZXMgYXJlIGBBV1M6OkVDMjo6TmV0d29ya0ludGVyZmFjZWAgYW5kIGBBV1M6OkVDMjo6SW5zdGFuY2VgIC4gRm9yIGEgc2VjdXJpdHkgZ3JvdXAgY29udGVudCBhdWRpdCBwb2xpY3ksIHZhbGlkIHZhbHVlcyBhcmUgYEFXUzo6RUMyOjpTZWN1cml0eUdyb3VwYCAsIGBBV1M6OkVDMjo6TmV0d29ya0ludGVyZmFjZWAgLCBhbmQgYEFXUzo6RUMyOjpJbnN0YW5jZWAgLiBGb3IgYSBzZWN1cml0eSBncm91cCB1c2FnZSBhdWRpdCBwb2xpY3ksIHRoZSB2YWx1ZSBpcyBgQVdTOjpFQzI6OlNlY3VyaXR5R3JvdXBgIC4gRm9yIGFuIEFXUyBOZXR3b3JrIEZpcmV3YWxsIHBvbGljeSBvciBETlMgRmlyZXdhbGwgcG9saWN5LCB0aGUgdmFsdWUgaXMgYEFXUzo6RUMyOjpWUENgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1yZXNvdXJjZXR5cGVcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVzb3VyY2VUeXBlOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBEZXRhaWxzIGFib3V0IHRoZSBzZWN1cml0eSBzZXJ2aWNlIHRoYXQgaXMgYmVpbmcgdXNlZCB0byBwcm90ZWN0IHRoZSByZXNvdXJjZXMuXG4gICAgICpcbiAgICAgKiBUaGlzIGNvbnRhaW5zIHRoZSBmb2xsb3dpbmcgc2V0dGluZ3M6XG4gICAgICpcbiAgICAgKiAtIFR5cGUgLSBJbmRpY2F0ZXMgdGhlIHNlcnZpY2UgdHlwZSB0aGF0IHRoZSBwb2xpY3kgdXNlcyB0byBwcm90ZWN0IHRoZSByZXNvdXJjZS4gRm9yIHNlY3VyaXR5IGdyb3VwIHBvbGljaWVzLCBGaXJld2FsbCBNYW5hZ2VyIHN1cHBvcnRzIG9uZSBzZWN1cml0eSBncm91cCBmb3IgZWFjaCBjb21tb24gcG9saWN5IGFuZCBmb3IgZWFjaCBjb250ZW50IGF1ZGl0IHBvbGljeS4gVGhpcyBpcyBhbiBhZGp1c3RhYmxlIGxpbWl0IHRoYXQgeW91IGNhbiBpbmNyZWFzZSBieSBjb250YWN0aW5nIEFXUyBTdXBwb3J0IC5cbiAgICAgKlxuICAgICAqIFZhbGlkIHZhbHVlczogYEROU19GSVJFV0FMTGAgfCBgTkVUV09SS19GSVJFV0FMTGAgfCBgU0VDVVJJVFlfR1JPVVBTX0NPTU1PTmAgfCBgU0VDVVJJVFlfR1JPVVBTX0NPTlRFTlRfQVVESVRgIHwgYFNFQ1VSSVRZX0dST1VQU19VU0FHRV9BVURJVGAgfCBgU0hJRUxEX0FEVkFOQ0VEYCB8IGBXQUZWMmAgfCBgV0FGYFxuICAgICAqIC0gTWFuYWdlZFNlcnZpY2VEYXRhIC0gRGV0YWlscyBhYm91dCB0aGUgc2VydmljZSB0aGF0IGFyZSBzcGVjaWZpYyB0byB0aGUgc2VydmljZSB0eXBlLCBpbiBKU09OIGZvcm1hdC5cbiAgICAgKlxuICAgICAqIC0gRXhhbXBsZTogYEROU19GSVJFV0FMTGBcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcInsgXFxcInR5cGVcXFwiOiBcXFwiRE5TX0ZJUkVXQUxMXFxcIiwgXFxcInByZVByb2Nlc3NSdWxlR3JvdXBzXFxcIjogW3tcXFwicnVsZUdyb3VwSWRcXFwiOiBcXFwicnNsdnItZnJnLTEyMzQ1NlxcXCIsIFxcXCJwcmlvcml0eVxcXCI6IDExfV0sIFxcXCJwb3N0UHJvY2Vzc1J1bGVHcm91cHNcXFwiOiBbe1xcXCJydWxlR3JvdXBJZFxcXCI6IFxcXCJyc2x2ci1mcmctMTIzNDU2XFxcIiwgXFxcInByaW9yaXR5XFxcIjogOTkwMn1dfVwiYFxuICAgICAqIC0gRXhhbXBsZTogYE5FVFdPUktfRklSRVdBTExgXG4gICAgICpcbiAgICAgKiBgXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIk5FVFdPUktfRklSRVdBTExcXFwiLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MDAwMDAwMDAwMDAwOnN0YXRlbGVzcy1ydWxlZ3JvdXBcXC9leGFtcGxlXFxcIixcXFwicHJpb3JpdHlcXFwiOjF9XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmRyb3BcXFwiLFxcXCJleGFtcGxlXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0ZyYWdtZW50RGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmRyb3BcXFwiLFxcXCJleGFtcGxlXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0N1c3RvbUFjdGlvbnNcXFwiOlt7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJleGFtcGxlXFxcIixcXFwiYWN0aW9uRGVmaW5pdGlvblxcXCI6e1xcXCJwdWJsaXNoTWV0cmljQWN0aW9uXFxcIjp7XFxcImRpbWVuc2lvbnNcXFwiOlt7XFxcInZhbHVlXFxcIjpcXFwiZXhhbXBsZVxcXCJ9XX19fV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlZnVsUnVsZUdyb3VwUmVmZXJlbmNlc1xcXCI6W3tcXFwicmVzb3VyY2VBUk5cXFwiOlxcXCJhcm46YXdzOm5ldHdvcmstZmlyZXdhbGw6dXMtZWFzdC0xOjAwMDAwMDAwMDAwMDpzdGF0ZWZ1bC1ydWxlZ3JvdXBcXC9leGFtcGxlXFxcIn1dLFxcXCJuZXR3b3JrRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXFxcIjp7XFxcInNpbmdsZUZpcmV3YWxsRW5kcG9pbnRQZXJWUENcXFwiOmZhbHNlLFxcXCJhbGxvd2VkSVBWNENpZHJMaXN0XFxcIjpbXX19XCJgXG4gICAgICogLSBFeGFtcGxlOiBgU0VDVVJJVFlfR1JPVVBTX0NPTU1PTmBcbiAgICAgKlxuICAgICAqIGBcIlNlY3VyaXR5U2VydmljZVBvbGljeURhdGFcIjp7XCJUeXBlXCI6XCJTRUNVUklUWV9HUk9VUFNfQ09NTU9OXCIsXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIlNFQ1VSSVRZX0dST1VQU19DT01NT05cXFwiLFxcXCJyZXZlcnRNYW51YWxTZWN1cml0eUdyb3VwQ2hhbmdlc1xcXCI6ZmFsc2UsXFxcImV4Y2x1c2l2ZVJlc291cmNlU2VjdXJpdHlHcm91cE1hbmFnZW1lbnRcXFwiOmZhbHNlLFxcXCJzZWN1cml0eUdyb3Vwc1xcXCI6W3tcXFwiaWRcXFwiOlxcXCIgc2ctMDAwZTU1OTk1ZDYxYTA2YmRcXFwifV19XCJ9LFwiUmVtZWRpYXRpb25FbmFibGVkXCI6ZmFsc2UsXCJSZXNvdXJjZVR5cGVcIjpcIkFXUzo6RUMyOjpOZXR3b3JrSW50ZXJmYWNlXCJ9YFxuICAgICAqIC0gRXhhbXBsZTogYFNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUYFxuICAgICAqXG4gICAgICogYFwiU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVwiOntcIlR5cGVcIjpcIlNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUXCIsXCJNYW5hZ2VkU2VydmljZURhdGFcIjpcIntcXFwidHlwZVxcXCI6XFxcIlNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUXFxcIixcXFwic2VjdXJpdHlHcm91cHNcXFwiOlt7XFxcImlkXFxcIjpcXFwiIHNnLTAwMGU1NTk5NWQ2MWEwNmJkIFxcXCJ9XSxcXFwic2VjdXJpdHlHcm91cEFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiQUxMT1dcXFwifX1cIn0sXCJSZW1lZGlhdGlvbkVuYWJsZWRcIjpmYWxzZSxcIlJlc291cmNlVHlwZVwiOlwiQVdTOjpFQzI6Ok5ldHdvcmtJbnRlcmZhY2VcIn1gXG4gICAgICpcbiAgICAgKiBUaGUgc2VjdXJpdHkgZ3JvdXAgYWN0aW9uIGZvciBjb250ZW50IGF1ZGl0IGNhbiBiZSBgQUxMT1dgIG9yIGBERU5ZYCAuIEZvciBgQUxMT1dgICwgYWxsIGluLXNjb3BlIHNlY3VyaXR5IGdyb3VwIHJ1bGVzIG11c3QgYmUgd2l0aGluIHRoZSBhbGxvd2VkIHJhbmdlIG9mIHRoZSBwb2xpY3kncyBzZWN1cml0eSBncm91cCBydWxlcy4gRm9yIGBERU5ZYCAsIGFsbCBpbi1zY29wZSBzZWN1cml0eSBncm91cCBydWxlcyBtdXN0IG5vdCBjb250YWluIGEgdmFsdWUgb3IgYSByYW5nZSB0aGF0IG1hdGNoZXMgYSBydWxlIHZhbHVlIG9yIHJhbmdlIGluIHRoZSBwb2xpY3kgc2VjdXJpdHkgZ3JvdXAuXG4gICAgICogLSBFeGFtcGxlOiBgU0VDVVJJVFlfR1JPVVBTX1VTQUdFX0FVRElUYFxuICAgICAqXG4gICAgICogYFwiU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVwiOntcIlR5cGVcIjpcIlNFQ1VSSVRZX0dST1VQU19VU0FHRV9BVURJVFwiLFwiTWFuYWdlZFNlcnZpY2VEYXRhXCI6XCJ7XFxcInR5cGVcXFwiOlxcXCJTRUNVUklUWV9HUk9VUFNfVVNBR0VfQVVESVRcXFwiLFxcXCJkZWxldGVVbnVzZWRTZWN1cml0eUdyb3Vwc1xcXCI6dHJ1ZSxcXFwiY29hbGVzY2VSZWR1bmRhbnRTZWN1cml0eUdyb3Vwc1xcXCI6dHJ1ZX1cIn0sXCJSZW1lZGlhdGlvbkVuYWJsZWRcIjpmYWxzZSxcIlJlc291IHJjZVR5cGVcIjpcIkFXUzo6RUMyOjpTZWN1cml0eUdyb3VwXCJ9YFxuICAgICAqIC0gU3BlY2lmaWNhdGlvbiBmb3IgYFNISUVMRF9BRFZBTkNFRGAgZm9yIEFtYXpvbiBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbnNcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcIntcXFwidHlwZVxcXCI6IFxcXCJTSElFTERfQURWQU5DRURcXFwiLCBcXFwiYXV0b21hdGljUmVzcG9uc2VDb25maWd1cmF0aW9uXFxcIjoge1xcXCJhdXRvbWF0aWNSZXNwb25zZVN0YXR1c1xcXCI6XFxcIkVOQUJMRUR8SUdOT1JFRHxESVNBQkxFRFxcXCIsIFxcXCJhdXRvbWF0aWNSZXNwb25zZUFjdGlvblxcXCI6XFxcIkJMT0NLfENPVU5UXFxcIn0sIFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViYWNsQ2xhc3NpY1xcXCI6dHJ1ZXxmYWxzZX1cImBcbiAgICAgKlxuICAgICAqIEZvciBleGFtcGxlOiBgXCJNYW5hZ2VkU2VydmljZURhdGFcIjogXCJ7XFxcInR5cGVcXFwiOlxcXCJTSElFTERfQURWQU5DRURcXFwiLFxcXCJhdXRvbWF0aWNSZXNwb25zZUNvbmZpZ3VyYXRpb25cXFwiOiB7XFxcImF1dG9tYXRpY1Jlc3BvbnNlU3RhdHVzXFxcIjpcXFwiRU5BQkxFRFxcXCIsIFxcXCJhdXRvbWF0aWNSZXNwb25zZUFjdGlvblxcXCI6XFxcIkNPVU5UXFxcIn19XCJgXG4gICAgICpcbiAgICAgKiBUaGUgZGVmYXVsdCB2YWx1ZSBmb3IgYGF1dG9tYXRpY1Jlc3BvbnNlU3RhdHVzYCBpcyBgSUdOT1JFRGAgLiBUaGUgdmFsdWUgZm9yIGBhdXRvbWF0aWNSZXNwb25zZUFjdGlvbmAgaXMgb25seSByZXF1aXJlZCB3aGVuIGBhdXRvbWF0aWNSZXNwb25zZVN0YXR1c2AgaXMgc2V0IHRvIGBFTkFCTEVEYCAuIFRoZSBkZWZhdWx0IHZhbHVlIGZvciBgb3ZlcnJpZGVDdXN0b21lcldlYmFjbENsYXNzaWNgIGlzIGBmYWxzZWAgLlxuICAgICAqXG4gICAgICogRm9yIG90aGVyIHJlc291cmNlIHR5cGVzIHRoYXQgeW91IGNhbiBwcm90ZWN0IHdpdGggYSBTaGllbGQgQWR2YW5jZWQgcG9saWN5LCB0aGlzIGBNYW5hZ2VkU2VydmljZURhdGFgIGNvbmZpZ3VyYXRpb24gaXMgYW4gZW1wdHkgc3RyaW5nLlxuICAgICAqIC0gRXhhbXBsZTogYFdBRlYyYFxuICAgICAqXG4gICAgICogYFwiTWFuYWdlZFNlcnZpY2VEYXRhXCI6IFwie1xcXCJ0eXBlXFxcIjpcXFwiV0FGVjJcXFwiLFxcXCJwcmVQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W3tcXFwicnVsZUdyb3VwQXJuXFxcIjpudWxsLFxcXCJvdmVycmlkZUFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiTk9ORVxcXCJ9LFxcXCJtYW5hZ2VkUnVsZUdyb3VwSWRlbnRpZmllclxcXCI6e1xcXCJ2ZXJzaW9uXFxcIjpudWxsLFxcXCJ2ZW5kb3JOYW1lXFxcIjpcXFwiQVdTXFxcIixcXFwibWFuYWdlZFJ1bGVHcm91cE5hbWVcXFwiOlxcXCJBV1NNYW5hZ2VkUnVsZXNBbWF6b25JcFJlcHV0YXRpb25MaXN0XFxcIn0sXFxcInJ1bGVHcm91cFR5cGVcXFwiOlxcXCJNYW5hZ2VkUnVsZUdyb3VwXFxcIixcXFwiZXhjbHVkZVJ1bGVzXFxcIjpbXX1dLFxcXCJwb3N0UHJvY2Vzc1J1bGVHcm91cHNcXFwiOltdLFxcXCJkZWZhdWx0QWN0aW9uXFxcIjp7XFxcInR5cGVcXFwiOlxcXCJBTExPV1xcXCJ9LFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViQUNMQXNzb2NpYXRpb25cXFwiOmZhbHNlLFxcXCJsb2dnaW5nQ29uZmlndXJhdGlvblxcXCI6e1xcXCJsb2dEZXN0aW5hdGlvbkNvbmZpZ3NcXFwiOltcXFwiYXJuOmF3czpmaXJlaG9zZTp1cy13ZXN0LTI6MTIzNDU2Nzg5MTI6ZGVsaXZlcnlzdHJlYW0vYXdzLXdhZi1sb2dzLWZtcy1hZG1pbi1kZXN0aW5hdGlvblxcXCJdLFxcXCJyZWRhY3RlZEZpZWxkc1xcXCI6W3tcXFwicmVkYWN0ZWRGaWVsZFR5cGVcXFwiOlxcXCJTaW5nbGVIZWFkZXJcXFwiLFxcXCJyZWRhY3RlZEZpZWxkVmFsdWVcXFwiOlxcXCJDb29raWVzXFxcIn0se1xcXCJyZWRhY3RlZEZpZWxkVHlwZVxcXCI6XFxcIk1ldGhvZFxcXCJ9XX19XCJgXG4gICAgICpcbiAgICAgKiBJbiB0aGUgYGxvZ2dpbmdDb25maWd1cmF0aW9uYCAsIHlvdSBjYW4gc3BlY2lmeSBvbmUgYGxvZ0Rlc3RpbmF0aW9uQ29uZmlnc2AgLCB5b3UgY2FuIG9wdGlvbmFsbHkgcHJvdmlkZSB1cCB0byAyMCBgcmVkYWN0ZWRGaWVsZHNgICwgYW5kIHRoZSBgUmVkYWN0ZWRGaWVsZFR5cGVgIG11c3QgYmUgb25lIG9mIGBVUklgICwgYFFVRVJZX1NUUklOR2AgLCBgSEVBREVSYCAsIG9yIGBNRVRIT0RgIC5cbiAgICAgKiAtIEV4YW1wbGU6IGBXQUYgQ2xhc3NpY2BcbiAgICAgKlxuICAgICAqIGBcIk1hbmFnZWRTZXJ2aWNlRGF0YVwiOiBcIntcXFwidHlwZVxcXCI6IFxcXCJXQUZcXFwiLCBcXFwicnVsZUdyb3Vwc1xcXCI6IFt7XFxcImlkXFxcIjpcXFwiMTIzNDU2NzgtMWJjZC05MDEyLWVmZ2EtMDk4NzY1NDMyMWFiXFxcIiwgXFxcIm92ZXJyaWRlQWN0aW9uXFxcIiA6IHtcXFwidHlwZVxcXCI6IFxcXCJDT1VOVFxcXCJ9fV0sXFxcImRlZmF1bHRBY3Rpb25cXFwiOiB7XFxcInR5cGVcXFwiOiBcXFwiQkxPQ0tcXFwifX1gXG4gICAgICpcbiAgICAgKiBBV1MgV0FGIENsYXNzaWMgZG9lc24ndCBzdXBwb3J0IHJ1bGUgZ3JvdXBzIGluIENsb3VkRnJvbnQgLiBUbyBjcmVhdGUgYSBXQUYgQ2xhc3NpYyBwb2xpY3kgdGhyb3VnaCBDbG91ZEZvcm1hdGlvbiwgY3JlYXRlIHlvdXIgcnVsZSBncm91cHMgb3V0c2lkZSBvZiBDbG91ZEZyb250ICwgdGhlbiBwcm92aWRlIHRoZSBydWxlIGdyb3VwIElEcyBpbiB0aGUgV0FGIG1hbmFnZWQgc2VydmljZSBkYXRhIHNwZWNpZmljYXRpb24uXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktc2VjdXJpdHlzZXJ2aWNlcG9saWN5ZGF0YVxuICAgICAqL1xuICAgIHB1YmxpYyBzZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhOiBDZm5Qb2xpY3kuU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVXNlZCB3aGVuIGRlbGV0aW5nIGEgcG9saWN5LiBJZiBgdHJ1ZWAgLCBGaXJld2FsbCBNYW5hZ2VyIHBlcmZvcm1zIGNsZWFudXAgYWNjb3JkaW5nIHRvIHRoZSBwb2xpY3kgdHlwZS5cbiAgICAgKlxuICAgICAqIEZvciBBV1MgV0FGIGFuZCBTaGllbGQgQWR2YW5jZWQgcG9saWNpZXMsIEZpcmV3YWxsIE1hbmFnZXIgZG9lcyB0aGUgZm9sbG93aW5nOlxuICAgICAqXG4gICAgICogLSBEZWxldGVzIHJ1bGUgZ3JvdXBzIGNyZWF0ZWQgYnkgRmlyZXdhbGwgTWFuYWdlclxuICAgICAqIC0gUmVtb3ZlcyB3ZWIgQUNMcyBmcm9tIGluLXNjb3BlIHJlc291cmNlc1xuICAgICAqIC0gRGVsZXRlcyB3ZWIgQUNMcyB0aGF0IGNvbnRhaW4gbm8gcnVsZXMgb3IgcnVsZSBncm91cHNcbiAgICAgKlxuICAgICAqIEZvciBzZWN1cml0eSBncm91cCBwb2xpY2llcywgRmlyZXdhbGwgTWFuYWdlciBkb2VzIHRoZSBmb2xsb3dpbmcgZm9yIGVhY2ggc2VjdXJpdHkgZ3JvdXAgaW4gdGhlIHBvbGljeTpcbiAgICAgKlxuICAgICAqIC0gRGlzYXNzb2NpYXRlcyB0aGUgc2VjdXJpdHkgZ3JvdXAgZnJvbSBpbi1zY29wZSByZXNvdXJjZXNcbiAgICAgKiAtIERlbGV0ZXMgdGhlIHNlY3VyaXR5IGdyb3VwIGlmIGl0IHdhcyBjcmVhdGVkIHRocm91Z2ggRmlyZXdhbGwgTWFuYWdlciBhbmQgaWYgaXQncyBubyBsb25nZXIgYXNzb2NpYXRlZCB3aXRoIGFueSByZXNvdXJjZXMgdGhyb3VnaCBhbm90aGVyIHBvbGljeVxuICAgICAqXG4gICAgICogQWZ0ZXIgdGhlIGNsZWFudXAsIGluLXNjb3BlIHJlc291cmNlcyBhcmUgbm8gbG9uZ2VyIHByb3RlY3RlZCBieSB3ZWIgQUNMcyBpbiB0aGlzIHBvbGljeS4gUHJvdGVjdGlvbiBvZiBvdXQtb2Ytc2NvcGUgcmVzb3VyY2VzIHJlbWFpbnMgdW5jaGFuZ2VkLiBTY29wZSBpcyBkZXRlcm1pbmVkIGJ5IHRhZ3MgdGhhdCB5b3UgY3JlYXRlIGFuZCBhY2NvdW50cyB0aGF0IHlvdSBhc3NvY2lhdGUgd2l0aCB0aGUgcG9saWN5LiBXaGVuIGNyZWF0aW5nIHRoZSBwb2xpY3ksIGlmIHlvdSBzcGVjaWZ5IHRoYXQgb25seSByZXNvdXJjZXMgaW4gc3BlY2lmaWMgYWNjb3VudHMgb3Igd2l0aCBzcGVjaWZpYyB0YWdzIGFyZSBpbiBzY29wZSBvZiB0aGUgcG9saWN5LCB0aG9zZSBhY2NvdW50cyBhbmQgcmVzb3VyY2VzIGFyZSBoYW5kbGVkIGJ5IHRoZSBwb2xpY3kuIEFsbCBvdGhlcnMgYXJlIG91dCBvZiBzY29wZS4gSWYgeW91IGRvbid0IHNwZWNpZnkgdGFncyBvciBhY2NvdW50cywgYWxsIHJlc291cmNlcyBhcmUgaW4gc2NvcGUuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktZGVsZXRlYWxscG9saWN5cmVzb3VyY2VzXG4gICAgICovXG4gICAgcHVibGljIGRlbGV0ZUFsbFBvbGljeVJlc291cmNlczogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQVdTIGFjY291bnQgSURzIGFuZCBBV1MgT3JnYW5pemF0aW9ucyBvcmdhbml6YXRpb25hbCB1bml0cyAoT1VzKSB0byBleGNsdWRlIGZyb20gdGhlIHBvbGljeS4gU3BlY2lmeWluZyBhbiBPVSBpcyB0aGUgZXF1aXZhbGVudCBvZiBzcGVjaWZ5aW5nIGFsbCBhY2NvdW50cyBpbiB0aGUgT1UgYW5kIGluIGFueSBvZiBpdHMgY2hpbGQgT1VzLCBpbmNsdWRpbmcgYW55IGNoaWxkIE9VcyBhbmQgYWNjb3VudHMgdGhhdCBhcmUgYWRkZWQgYXQgYSBsYXRlciB0aW1lLlxuICAgICAqXG4gICAgICogWW91IGNhbiBzcGVjaWZ5IGluY2x1c2lvbnMgb3IgZXhjbHVzaW9ucywgYnV0IG5vdCBib3RoLiBJZiB5b3Ugc3BlY2lmeSBhbiBgSW5jbHVkZU1hcGAgLCBBV1MgRmlyZXdhbGwgTWFuYWdlciBhcHBsaWVzIHRoZSBwb2xpY3kgdG8gYWxsIGFjY291bnRzIHNwZWNpZmllZCBieSB0aGUgYEluY2x1ZGVNYXBgICwgYW5kIGRvZXMgbm90IGV2YWx1YXRlIGFueSBgRXhjbHVkZU1hcGAgc3BlY2lmaWNhdGlvbnMuIElmIHlvdSBkbyBub3Qgc3BlY2lmeSBhbiBgSW5jbHVkZU1hcGAgLCB0aGVuIEZpcmV3YWxsIE1hbmFnZXIgYXBwbGllcyB0aGUgcG9saWN5IHRvIGFsbCBhY2NvdW50cyBleGNlcHQgZm9yIHRob3NlIHNwZWNpZmllZCBieSB0aGUgYEV4Y2x1ZGVNYXBgIC5cbiAgICAgKlxuICAgICAqIFlvdSBjYW4gc3BlY2lmeSBhY2NvdW50IElEcywgT1VzLCBvciBhIGNvbWJpbmF0aW9uOlxuICAgICAqXG4gICAgICogLSBTcGVjaWZ5IGFjY291bnQgSURzIGJ5IHNldHRpbmcgdGhlIGtleSB0byBgQUNDT1VOVGAgLiBGb3IgZXhhbXBsZSwgdGhlIGZvbGxvd2luZyBpcyBhIHZhbGlkIG1hcDogYHvigJxBQ0NPVU5U4oCdIDogW+KAnGFjY291bnRJRDHigJ0sIOKAnGFjY291bnRJRDLigJ1dfWAgLlxuICAgICAqIC0gU3BlY2lmeSBPVXMgYnkgc2V0dGluZyB0aGUga2V5IHRvIGBPUkdVTklUYCAuIEZvciBleGFtcGxlLCB0aGUgZm9sbG93aW5nIGlzIGEgdmFsaWQgbWFwOiBge+KAnE9SR1VOSVTigJ0gOiBb4oCcb3VpZDExMeKAnSwg4oCcb3VpZDExMuKAnV19YCAuXG4gICAgICogLSBTcGVjaWZ5IGFjY291bnRzIGFuZCBPVXMgdG9nZXRoZXIgaW4gYSBzaW5nbGUgbWFwLCBzZXBhcmF0ZWQgd2l0aCBhIGNvbW1hLiBGb3IgZXhhbXBsZSwgdGhlIGZvbGxvd2luZyBpcyBhIHZhbGlkIG1hcDogYHvigJxBQ0NPVU5U4oCdIDogW+KAnGFjY291bnRJRDHigJ0sIOKAnGFjY291bnRJRDLigJ1dLCDigJxPUkdVTklU4oCdIDogW+KAnG91aWQxMTHigJ0sIOKAnG91aWQxMTLigJ1dfWAgLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LWV4Y2x1ZGVtYXBcbiAgICAgKi9cbiAgICBwdWJsaWMgZXhjbHVkZU1hcDogQ2ZuUG9saWN5LklFTWFwUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBTcGVjaWZpZXMgdGhlIEFXUyBhY2NvdW50IElEcyBhbmQgQVdTIE9yZ2FuaXphdGlvbnMgb3JnYW5pemF0aW9uYWwgdW5pdHMgKE9VcykgdG8gaW5jbHVkZSBpbiB0aGUgcG9saWN5LiBTcGVjaWZ5aW5nIGFuIE9VIGlzIHRoZSBlcXVpdmFsZW50IG9mIHNwZWNpZnlpbmcgYWxsIGFjY291bnRzIGluIHRoZSBPVSBhbmQgaW4gYW55IG9mIGl0cyBjaGlsZCBPVXMsIGluY2x1ZGluZyBhbnkgY2hpbGQgT1VzIGFuZCBhY2NvdW50cyB0aGF0IGFyZSBhZGRlZCBhdCBhIGxhdGVyIHRpbWUuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIHNwZWNpZnkgaW5jbHVzaW9ucyBvciBleGNsdXNpb25zLCBidXQgbm90IGJvdGguIElmIHlvdSBzcGVjaWZ5IGFuIGBJbmNsdWRlTWFwYCAsIEFXUyBGaXJld2FsbCBNYW5hZ2VyIGFwcGxpZXMgdGhlIHBvbGljeSB0byBhbGwgYWNjb3VudHMgc3BlY2lmaWVkIGJ5IHRoZSBgSW5jbHVkZU1hcGAgLCBhbmQgZG9lcyBub3QgZXZhbHVhdGUgYW55IGBFeGNsdWRlTWFwYCBzcGVjaWZpY2F0aW9ucy4gSWYgeW91IGRvIG5vdCBzcGVjaWZ5IGFuIGBJbmNsdWRlTWFwYCAsIHRoZW4gRmlyZXdhbGwgTWFuYWdlciBhcHBsaWVzIHRoZSBwb2xpY3kgdG8gYWxsIGFjY291bnRzIGV4Y2VwdCBmb3IgdGhvc2Ugc3BlY2lmaWVkIGJ5IHRoZSBgRXhjbHVkZU1hcGAgLlxuICAgICAqXG4gICAgICogWW91IGNhbiBzcGVjaWZ5IGFjY291bnQgSURzLCBPVXMsIG9yIGEgY29tYmluYXRpb246XG4gICAgICpcbiAgICAgKiAtIFNwZWNpZnkgYWNjb3VudCBJRHMgYnkgc2V0dGluZyB0aGUga2V5IHRvIGBBQ0NPVU5UYCAuIEZvciBleGFtcGxlLCB0aGUgZm9sbG93aW5nIGlzIGEgdmFsaWQgbWFwOiBge+KAnEFDQ09VTlTigJ0gOiBb4oCcYWNjb3VudElEMeKAnSwg4oCcYWNjb3VudElEMuKAnV19YCAuXG4gICAgICogLSBTcGVjaWZ5IE9VcyBieSBzZXR0aW5nIHRoZSBrZXkgdG8gYE9SR1VOSVRgIC4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcT1JHVU5JVOKAnSA6IFvigJxvdWlkMTEx4oCdLCDigJxvdWlkMTEy4oCdXX1gIC5cbiAgICAgKiAtIFNwZWNpZnkgYWNjb3VudHMgYW5kIE9VcyB0b2dldGhlciBpbiBhIHNpbmdsZSBtYXAsIHNlcGFyYXRlZCB3aXRoIGEgY29tbWEuIEZvciBleGFtcGxlLCB0aGUgZm9sbG93aW5nIGlzIGEgdmFsaWQgbWFwOiBge+KAnEFDQ09VTlTigJ0gOiBb4oCcYWNjb3VudElEMeKAnSwg4oCcYWNjb3VudElEMuKAnV0sIOKAnE9SR1VOSVTigJ0gOiBb4oCcb3VpZDExMeKAnSwg4oCcb3VpZDExMuKAnV19YCAuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1mbXMtcG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktaW5jbHVkZW1hcFxuICAgICAqL1xuICAgIHB1YmxpYyBpbmNsdWRlTWFwOiBDZm5Qb2xpY3kuSUVNYXBQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEluZGljYXRlcyB3aGV0aGVyIEFXUyBGaXJld2FsbCBNYW5hZ2VyIHNob3VsZCBhdXRvbWF0aWNhbGx5IHJlbW92ZSBwcm90ZWN0aW9ucyBmcm9tIHJlc291cmNlcyB0aGF0IGxlYXZlIHRoZSBwb2xpY3kgc2NvcGUgYW5kIGNsZWFuIHVwIHJlc291cmNlcyB0aGF0IEZpcmV3YWxsIE1hbmFnZXIgaXMgbWFuYWdpbmcgZm9yIGFjY291bnRzIHdoZW4gdGhvc2UgYWNjb3VudHMgbGVhdmUgcG9saWN5IHNjb3BlLiBGb3IgZXhhbXBsZSwgRmlyZXdhbGwgTWFuYWdlciB3aWxsIGRpc2Fzc29jaWF0ZSBhIEZpcmV3YWxsIE1hbmFnZXIgbWFuYWdlZCB3ZWIgQUNMIGZyb20gYSBwcm90ZWN0ZWQgY3VzdG9tZXIgcmVzb3VyY2Ugd2hlbiB0aGUgY3VzdG9tZXIgcmVzb3VyY2UgbGVhdmVzIHBvbGljeSBzY29wZS5cbiAgICAgKlxuICAgICAqIEJ5IGRlZmF1bHQsIEZpcmV3YWxsIE1hbmFnZXIgZG9lc24ndCByZW1vdmUgcHJvdGVjdGlvbnMgb3IgZGVsZXRlIEZpcmV3YWxsIE1hbmFnZXIgbWFuYWdlZCByZXNvdXJjZXMuXG4gICAgICpcbiAgICAgKiBUaGlzIG9wdGlvbiBpcyBub3QgYXZhaWxhYmxlIGZvciBTaGllbGQgQWR2YW5jZWQgb3IgQVdTIFdBRiBDbGFzc2ljIHBvbGljaWVzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtZm1zLXBvbGljeS5odG1sI2Nmbi1mbXMtcG9saWN5LXJlc291cmNlc2NsZWFudXBcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVzb3VyY2VzQ2xlYW5VcDogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIEFuIGFycmF5IG9mIGBSZXNvdXJjZVRhZ2Agb2JqZWN0cywgdXNlZCB0byBleHBsaWNpdGx5IGluY2x1ZGUgcmVzb3VyY2VzIGluIHRoZSBwb2xpY3kgc2NvcGUgb3IgZXhwbGljaXRseSBleGNsdWRlIHRoZW0uIElmIHRoaXMgaXNuJ3Qgc2V0LCB0aGVuIHRhZ3MgYXJlbid0IHVzZWQgdG8gbW9kaWZ5IHBvbGljeSBzY29wZS4gU2VlIGFsc28gYEV4Y2x1ZGVSZXNvdXJjZVRhZ3NgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1yZXNvdXJjZXRhZ3NcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVzb3VyY2VUYWdzOiBBcnJheTxDZm5Qb2xpY3kuUmVzb3VyY2VUYWdQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4gfCBjZGsuSVJlc29sdmFibGUgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBBbiBhcnJheSBvZiBgUmVzb3VyY2VUeXBlYCBvYmplY3RzLiBVc2UgdGhpcyBvbmx5IHRvIHNwZWNpZnkgbXVsdGlwbGUgcmVzb3VyY2UgdHlwZXMuIFRvIHNwZWNpZnkgYSBzaW5nbGUgcmVzb3VyY2UgdHlwZSwgdXNlIGBSZXNvdXJjZVR5cGVgIC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS1yZXNvdXJjZXR5cGVsaXN0XG4gICAgICovXG4gICAgcHVibGljIHJlc291cmNlVHlwZUxpc3Q6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBjb2xsZWN0aW9uIG9mIGtleTp2YWx1ZSBwYWlycyBhc3NvY2lhdGVkIHdpdGggYW4gQVdTIHJlc291cmNlLiBUaGUga2V5OnZhbHVlIHBhaXIgY2FuIGJlIGFueXRoaW5nIHlvdSBkZWZpbmUuIFR5cGljYWxseSwgdGhlIHRhZyBrZXkgcmVwcmVzZW50cyBhIGNhdGVnb3J5IChzdWNoIGFzIFwiZW52aXJvbm1lbnRcIikgYW5kIHRoZSB0YWcgdmFsdWUgcmVwcmVzZW50cyBhIHNwZWNpZmljIHZhbHVlIHdpdGhpbiB0aGF0IGNhdGVnb3J5IChzdWNoIGFzIFwidGVzdCxcIiBcImRldmVsb3BtZW50LFwiIG9yIFwicHJvZHVjdGlvblwiKS4gWW91IGNhbiBhZGQgdXAgdG8gNTAgdGFncyB0byBlYWNoIEFXUyByZXNvdXJjZS5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWZtcy1wb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS10YWdzXG4gICAgICovXG4gICAgcHVibGljIHRhZ3M6IENmblBvbGljeS5Qb2xpY3lUYWdQcm9wZXJ0eVtdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBV1M6OkZNUzo6UG9saWN5YC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5Qb2xpY3lQcm9wcykge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuUG9saWN5LkNGTl9SRVNPVVJDRV9UWVBFX05BTUUsIHByb3BlcnRpZXM6IHByb3BzIH0pO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnZXhjbHVkZVJlc291cmNlVGFncycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAncG9saWN5TmFtZScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAncmVtZWRpYXRpb25FbmFibGVkJywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdyZXNvdXJjZVR5cGUnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3NlY3VyaXR5U2VydmljZVBvbGljeURhdGEnLCB0aGlzKTtcbiAgICAgICAgdGhpcy5hdHRyQXJuID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdBcm4nKSk7XG4gICAgICAgIHRoaXMuYXR0cklkID0gY2RrLlRva2VuLmFzU3RyaW5nKHRoaXMuZ2V0QXR0KCdJZCcpKTtcblxuICAgICAgICB0aGlzLmV4Y2x1ZGVSZXNvdXJjZVRhZ3MgPSBwcm9wcy5leGNsdWRlUmVzb3VyY2VUYWdzO1xuICAgICAgICB0aGlzLnBvbGljeU5hbWUgPSBwcm9wcy5wb2xpY3lOYW1lO1xuICAgICAgICB0aGlzLnJlbWVkaWF0aW9uRW5hYmxlZCA9IHByb3BzLnJlbWVkaWF0aW9uRW5hYmxlZDtcbiAgICAgICAgdGhpcy5yZXNvdXJjZVR5cGUgPSBwcm9wcy5yZXNvdXJjZVR5cGU7XG4gICAgICAgIHRoaXMuc2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YSA9IHByb3BzLnNlY3VyaXR5U2VydmljZVBvbGljeURhdGE7XG4gICAgICAgIHRoaXMuZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzID0gcHJvcHMuZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzO1xuICAgICAgICB0aGlzLmV4Y2x1ZGVNYXAgPSBwcm9wcy5leGNsdWRlTWFwO1xuICAgICAgICB0aGlzLmluY2x1ZGVNYXAgPSBwcm9wcy5pbmNsdWRlTWFwO1xuICAgICAgICB0aGlzLnJlc291cmNlc0NsZWFuVXAgPSBwcm9wcy5yZXNvdXJjZXNDbGVhblVwO1xuICAgICAgICB0aGlzLnJlc291cmNlVGFncyA9IHByb3BzLnJlc291cmNlVGFncztcbiAgICAgICAgdGhpcy5yZXNvdXJjZVR5cGVMaXN0ID0gcHJvcHMucmVzb3VyY2VUeXBlTGlzdDtcbiAgICAgICAgdGhpcy50YWdzID0gcHJvcHMudGFncztcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmblBvbGljeS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FKTtcbiAgICAgICAgaW5zcGVjdG9yLmFkZEF0dHJpYnV0ZShcImF3czpjZGs6Y2xvdWRmb3JtYXRpb246cHJvcHNcIiwgdGhpcy5jZm5Qcm9wZXJ0aWVzKTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgZ2V0IGNmblByb3BlcnRpZXMoKTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgZXhjbHVkZVJlc291cmNlVGFnczogdGhpcy5leGNsdWRlUmVzb3VyY2VUYWdzLFxuICAgICAgICAgICAgcG9saWN5TmFtZTogdGhpcy5wb2xpY3lOYW1lLFxuICAgICAgICAgICAgcmVtZWRpYXRpb25FbmFibGVkOiB0aGlzLnJlbWVkaWF0aW9uRW5hYmxlZCxcbiAgICAgICAgICAgIHJlc291cmNlVHlwZTogdGhpcy5yZXNvdXJjZVR5cGUsXG4gICAgICAgICAgICBzZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhOiB0aGlzLnNlY3VyaXR5U2VydmljZVBvbGljeURhdGEsXG4gICAgICAgICAgICBkZWxldGVBbGxQb2xpY3lSZXNvdXJjZXM6IHRoaXMuZGVsZXRlQWxsUG9saWN5UmVzb3VyY2VzLFxuICAgICAgICAgICAgZXhjbHVkZU1hcDogdGhpcy5leGNsdWRlTWFwLFxuICAgICAgICAgICAgaW5jbHVkZU1hcDogdGhpcy5pbmNsdWRlTWFwLFxuICAgICAgICAgICAgcmVzb3VyY2VzQ2xlYW5VcDogdGhpcy5yZXNvdXJjZXNDbGVhblVwLFxuICAgICAgICAgICAgcmVzb3VyY2VUYWdzOiB0aGlzLnJlc291cmNlVGFncyxcbiAgICAgICAgICAgIHJlc291cmNlVHlwZUxpc3Q6IHRoaXMucmVzb3VyY2VUeXBlTGlzdCxcbiAgICAgICAgICAgIHRhZ3M6IHRoaXMudGFncyxcbiAgICAgICAgfTtcbiAgICB9XG5cbiAgICBwcm90ZWN0ZWQgcmVuZGVyUHJvcGVydGllcyhwcm9wczoge1trZXk6IHN0cmluZ106IGFueX0pOiB7IFtrZXk6IHN0cmluZ106IGFueSB9ICB7XG4gICAgICAgIHJldHVybiBjZm5Qb2xpY3lQcm9wc1RvQ2xvdWRGb3JtYXRpb24ocHJvcHMpO1xuICAgIH1cbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Qb2xpY3kge1xuICAgIC8qKlxuICAgICAqIFNwZWNpZmllcyB0aGUgQVdTIGFjY291bnQgSURzIGFuZCBBV1MgT3JnYW5pemF0aW9ucyBvcmdhbml6YXRpb25hbCB1bml0cyAoT1VzKSB0byBpbmNsdWRlIGluIG9yIGV4Y2x1ZGUgZnJvbSB0aGUgcG9saWN5LiBTcGVjaWZ5aW5nIGFuIE9VIGlzIHRoZSBlcXVpdmFsZW50IG9mIHNwZWNpZnlpbmcgYWxsIGFjY291bnRzIGluIHRoZSBPVSBhbmQgaW4gYW55IG9mIGl0cyBjaGlsZCBPVXMsIGluY2x1ZGluZyBhbnkgY2hpbGQgT1VzIGFuZCBhY2NvdW50cyB0aGF0IGFyZSBhZGRlZCBhdCBhIGxhdGVyIHRpbWUuXG4gICAgICpcbiAgICAgKiBUaGlzIGlzIHVzZWQgZm9yIHRoZSBwb2xpY3kncyBgSW5jbHVkZU1hcGAgYW5kIGBFeGNsdWRlTWFwYCAuXG4gICAgICpcbiAgICAgKiBZb3UgY2FuIHNwZWNpZnkgYWNjb3VudCBJRHMsIE9Vcywgb3IgYSBjb21iaW5hdGlvbjpcbiAgICAgKlxuICAgICAqIC0gU3BlY2lmeSBhY2NvdW50IElEcyBieSBzZXR0aW5nIHRoZSBrZXkgdG8gYEFDQ09VTlRgIC4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcQUNDT1VOVOKAnSA6IFvigJxhY2NvdW50SUQx4oCdLCDigJxhY2NvdW50SUQy4oCdXX1gIC5cbiAgICAgKiAtIFNwZWNpZnkgT1VzIGJ5IHNldHRpbmcgdGhlIGtleSB0byBgT1JHVU5JVGAgLiBGb3IgZXhhbXBsZSwgdGhlIGZvbGxvd2luZyBpcyBhIHZhbGlkIG1hcDogYHvigJxPUkdVTklU4oCdIDogW+KAnG91aWQxMTHigJ0sIOKAnG91aWQxMTLigJ1dfWAgLlxuICAgICAqIC0gU3BlY2lmeSBhY2NvdW50cyBhbmQgT1VzIHRvZ2V0aGVyIGluIGEgc2luZ2xlIG1hcCwgc2VwYXJhdGVkIHdpdGggYSBjb21tYS4gRm9yIGV4YW1wbGUsIHRoZSBmb2xsb3dpbmcgaXMgYSB2YWxpZCBtYXA6IGB74oCcQUNDT1VOVOKAnSA6IFvigJxhY2NvdW50SUQx4oCdLCDigJxhY2NvdW50SUQy4oCdXSwg4oCcT1JHVU5JVOKAnSA6IFvigJxvdWlkMTEx4oCdLCDigJxvdWlkMTEy4oCdXX1gIC5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktaWVtYXAuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgSUVNYXBQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgYWNjb3VudCBsaXN0IGZvciB0aGUgbWFwLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktaWVtYXAuaHRtbCNjZm4tZm1zLXBvbGljeS1pZW1hcC1hY2NvdW50XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBhY2NvdW50Pzogc3RyaW5nW107XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgb3JnYW5pemF0aW9uYWwgdW5pdCBsaXN0IGZvciB0aGUgbWFwLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktaWVtYXAuaHRtbCNjZm4tZm1zLXBvbGljeS1pZW1hcC1vcmd1bml0XG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBvcmd1bml0Pzogc3RyaW5nW107XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYElFTWFwUHJvcGVydHlgXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYElFTWFwUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuUG9saWN5X0lFTWFwUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdhY2NvdW50JywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5hY2NvdW50KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdvcmd1bml0JywgY2RrLmxpc3RWYWxpZGF0b3IoY2RrLnZhbGlkYXRlU3RyaW5nKSkocHJvcGVydGllcy5vcmd1bml0KSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIklFTWFwUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkZNUzo6UG9saWN5LklFTWFwYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBJRU1hcFByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeS5JRU1hcGAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Qb2xpY3lJRU1hcFByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Qb2xpY3lfSUVNYXBQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgQUNDT1VOVDogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWNjb3VudCksXG4gICAgICAgIE9SR1VOSVQ6IGNkay5saXN0TWFwcGVyKGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKShwcm9wZXJ0aWVzLm9yZ3VuaXQpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Qb2xpY3lJRU1hcFByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuUG9saWN5LklFTWFwUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuUG9saWN5LklFTWFwUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhY2NvdW50JywgJ0FDQ09VTlQnLCBwcm9wZXJ0aWVzLkFDQ09VTlQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BQ0NPVU5UKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdvcmd1bml0JywgJ09SR1VOSVQnLCBwcm9wZXJ0aWVzLk9SR1VOSVQgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5PUkdVTklUKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBDb25maWd1cmVzIHRoZSBmaXJld2FsbCBwb2xpY3kgZGVwbG95bWVudCBtb2RlbCBvZiBBV1MgTmV0d29yayBGaXJld2FsbCAuIEZvciBpbmZvcm1hdGlvbiBhYm91dCBOZXR3b3JrIEZpcmV3YWxsIGRlcGxveW1lbnQgbW9kZWxzLCBzZWUgW0FXUyBOZXR3b3JrIEZpcmV3YWxsIGV4YW1wbGUgYXJjaGl0ZWN0dXJlcyB3aXRoIHJvdXRpbmddKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9uZXR3b3JrLWZpcmV3YWxsL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hcmNoaXRlY3R1cmVzLmh0bWwpIGluIHRoZSAqTmV0d29yayBGaXJld2FsbCBEZXZlbG9wZXIgR3VpZGUqIC5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktbmV0d29ya2ZpcmV3YWxscG9saWN5Lmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIE5ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIERlZmluZXMgdGhlIGRlcGxveW1lbnQgbW9kZWwgdG8gdXNlIGZvciB0aGUgZmlyZXdhbGwgcG9saWN5LiBUbyB1c2UgYSBkaXN0cmlidXRlZCBtb2RlbCwgc2V0IFtQb2xpY3lPcHRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9mbXMvMjAxOC0wMS0wMS9BUElSZWZlcmVuY2UvQVBJX1BvbGljeU9wdGlvbi5odG1sKSB0byBgTlVMTGAgLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktbmV0d29ya2ZpcmV3YWxscG9saWN5Lmh0bWwjY2ZuLWZtcy1wb2xpY3ktbmV0d29ya2ZpcmV3YWxscG9saWN5LWZpcmV3YWxsZGVwbG95bWVudG1vZGVsXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBmaXJld2FsbERlcGxveW1lbnRNb2RlbDogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBOZXR3b3JrRmlyZXdhbGxQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgTmV0d29ya0ZpcmV3YWxsUG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuUG9saWN5X05ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZmlyZXdhbGxEZXBsb3ltZW50TW9kZWwnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZmlyZXdhbGxEZXBsb3ltZW50TW9kZWwpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2ZpcmV3YWxsRGVwbG95bWVudE1vZGVsJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmZpcmV3YWxsRGVwbG95bWVudE1vZGVsKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIk5ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeS5OZXR3b3JrRmlyZXdhbGxQb2xpY3lgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYE5ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeS5OZXR3b3JrRmlyZXdhbGxQb2xpY3lgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuUG9saWN5TmV0d29ya0ZpcmV3YWxsUG9saWN5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblBvbGljeV9OZXR3b3JrRmlyZXdhbGxQb2xpY3lQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgRmlyZXdhbGxEZXBsb3ltZW50TW9kZWw6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuZmlyZXdhbGxEZXBsb3ltZW50TW9kZWwpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Qb2xpY3lOZXR3b3JrRmlyZXdhbGxQb2xpY3lQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblBvbGljeS5OZXR3b3JrRmlyZXdhbGxQb2xpY3lQcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Qb2xpY3kuTmV0d29ya0ZpcmV3YWxsUG9saWN5UHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdmaXJld2FsbERlcGxveW1lbnRNb2RlbCcsICdGaXJld2FsbERlcGxveW1lbnRNb2RlbCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRmlyZXdhbGxEZXBsb3ltZW50TW9kZWwpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Qb2xpY3kge1xuICAgIC8qKlxuICAgICAqIENvbnRhaW5zIHRoZSBBV1MgTmV0d29yayBGaXJld2FsbCBmaXJld2FsbCBwb2xpY3kgb3B0aW9ucyB0byBjb25maWd1cmUgdGhlIHBvbGljeSdzIGRlcGxveW1lbnQgbW9kZWwgYW5kIHRoaXJkLXBhcnR5IGZpcmV3YWxsIHBvbGljeSBzZXR0aW5ncy5cbiAgICAgKlxuICAgICAqIEBzdHJ1Y3RcbiAgICAgKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktcG9saWN5b3B0aW9uLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFBvbGljeU9wdGlvblByb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIERlZmluZXMgdGhlIGRlcGxveW1lbnQgbW9kZWwgdG8gdXNlIGZvciB0aGUgZmlyZXdhbGwgcG9saWN5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktcG9saWN5b3B0aW9uLmh0bWwjY2ZuLWZtcy1wb2xpY3ktcG9saWN5b3B0aW9uLW5ldHdvcmtmaXJld2FsbHBvbGljeVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgbmV0d29ya0ZpcmV3YWxsUG9saWN5PzogQ2ZuUG9saWN5Lk5ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgICAgICAvKipcbiAgICAgICAgICogRGVmaW5lcyB0aGUgcG9saWN5IG9wdGlvbnMgZm9yIGEgdGhpcmQtcGFydHkgZmlyZXdhbGwgcG9saWN5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktcG9saWN5b3B0aW9uLmh0bWwjY2ZuLWZtcy1wb2xpY3ktcG9saWN5b3B0aW9uLXRoaXJkcGFydHlmaXJld2FsbHBvbGljeVxuICAgICAgICAgKi9cbiAgICAgICAgcmVhZG9ubHkgdGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5PzogQ2ZuUG9saWN5LlRoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQb2xpY3lPcHRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUG9saWN5T3B0aW9uUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuUG9saWN5X1BvbGljeU9wdGlvblByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignbmV0d29ya0ZpcmV3YWxsUG9saWN5JywgQ2ZuUG9saWN5X05ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLm5ldHdvcmtGaXJld2FsbFBvbGljeSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5JywgQ2ZuUG9saWN5X1RoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5VmFsaWRhdG9yKShwcm9wZXJ0aWVzLnRoaXJkUGFydHlGaXJld2FsbFBvbGljeSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJQb2xpY3lPcHRpb25Qcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpQb2xpY3kuUG9saWN5T3B0aW9uYCByZXNvdXJjZVxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBQb2xpY3lPcHRpb25Qcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpQb2xpY3kuUG9saWN5T3B0aW9uYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblBvbGljeVBvbGljeU9wdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5Qb2xpY3lfUG9saWN5T3B0aW9uUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE5ldHdvcmtGaXJld2FsbFBvbGljeTogY2ZuUG9saWN5TmV0d29ya0ZpcmV3YWxsUG9saWN5UHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMubmV0d29ya0ZpcmV3YWxsUG9saWN5KSxcbiAgICAgICAgVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5OiBjZm5Qb2xpY3lUaGlyZFBhcnR5RmlyZXdhbGxQb2xpY3lQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy50aGlyZFBhcnR5RmlyZXdhbGxQb2xpY3kpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Qb2xpY3lQb2xpY3lPcHRpb25Qcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblBvbGljeS5Qb2xpY3lPcHRpb25Qcm9wZXJ0eSB8IGNkay5JUmVzb2x2YWJsZT4ge1xuICAgIGlmIChjZGsuaXNSZXNvbHZhYmxlT2JqZWN0KHByb3BlcnRpZXMpKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgcHJvcGVydGllcyA9IHByb3BlcnRpZXMgPT0gbnVsbCA/IHt9IDogcHJvcGVydGllcztcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIHJldHVybiBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdChwcm9wZXJ0aWVzKTtcbiAgICB9XG4gICAgY29uc3QgcmV0ID0gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25Qcm9wZXJ0eU9iamVjdDxDZm5Qb2xpY3kuUG9saWN5T3B0aW9uUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCduZXR3b3JrRmlyZXdhbGxQb2xpY3knLCAnTmV0d29ya0ZpcmV3YWxsUG9saWN5JywgcHJvcGVydGllcy5OZXR3b3JrRmlyZXdhbGxQb2xpY3kgIT0gbnVsbCA/IENmblBvbGljeU5ldHdvcmtGaXJld2FsbFBvbGljeVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuTmV0d29ya0ZpcmV3YWxsUG9saWN5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd0aGlyZFBhcnR5RmlyZXdhbGxQb2xpY3knLCAnVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5JywgcHJvcGVydGllcy5UaGlyZFBhcnR5RmlyZXdhbGxQb2xpY3kgIT0gbnVsbCA/IENmblBvbGljeVRoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5KSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFVucmVjb2duaXplZFByb3BlcnRpZXNBc0V4dHJhKHByb3BlcnRpZXMpO1xuICAgIHJldHVybiByZXQ7XG59XG5cbmV4cG9ydCBuYW1lc3BhY2UgQ2ZuUG9saWN5IHtcbiAgICAvKipcbiAgICAgKiBBIGNvbGxlY3Rpb24gb2Yga2V5OnZhbHVlIHBhaXJzIGFzc29jaWF0ZWQgd2l0aCBhbiBBV1MgcmVzb3VyY2UuIFRoZSBrZXk6dmFsdWUgcGFpciBjYW4gYmUgYW55dGhpbmcgeW91IGRlZmluZS4gVHlwaWNhbGx5LCB0aGUgdGFnIGtleSByZXByZXNlbnRzIGEgY2F0ZWdvcnkgKHN1Y2ggYXMgXCJlbnZpcm9ubWVudFwiKSBhbmQgdGhlIHRhZyB2YWx1ZSByZXByZXNlbnRzIGEgc3BlY2lmaWMgdmFsdWUgd2l0aGluIHRoYXQgY2F0ZWdvcnkgKHN1Y2ggYXMgXCJ0ZXN0LFwiIFwiZGV2ZWxvcG1lbnQsXCIgb3IgXCJwcm9kdWN0aW9uXCIpLiBZb3UgY2FuIGFkZCB1cCB0byA1MCB0YWdzIHRvIGVhY2ggQVdTIHJlc291cmNlLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS1wb2xpY3l0YWcuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgUG9saWN5VGFnUHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogUGFydCBvZiB0aGUga2V5OnZhbHVlIHBhaXIgdGhhdCBkZWZpbmVzIGEgdGFnLiBZb3UgY2FuIHVzZSBhIHRhZyBrZXkgdG8gZGVzY3JpYmUgYSBjYXRlZ29yeSBvZiBpbmZvcm1hdGlvbiwgc3VjaCBhcyBcImN1c3RvbWVyLlwiIFRhZyBrZXlzIGFyZSBjYXNlLXNlbnNpdGl2ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1mbXMtcG9saWN5LXBvbGljeXRhZy5odG1sI2Nmbi1mbXMtcG9saWN5LXBvbGljeXRhZy1rZXlcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGtleTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogUGFydCBvZiB0aGUga2V5OnZhbHVlIHBhaXIgdGhhdCBkZWZpbmVzIGEgdGFnLiBZb3UgY2FuIHVzZSBhIHRhZyB2YWx1ZSB0byBkZXNjcmliZSBhIHNwZWNpZmljIHZhbHVlIHdpdGhpbiBhIGNhdGVnb3J5LCBzdWNoIGFzIFwiY29tcGFueUFcIiBvciBcImNvbXBhbnlCLlwiIFRhZyB2YWx1ZXMgYXJlIGNhc2Utc2Vuc2l0aXZlLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktcG9saWN5dGFnLmh0bWwjY2ZuLWZtcy1wb2xpY3ktcG9saWN5dGFnLXZhbHVlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB2YWx1ZTogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBQb2xpY3lUYWdQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgUG9saWN5VGFnUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIHJlc3VsdCBvZiB0aGUgdmFsaWRhdGlvbi5cbiAqL1xuZnVuY3Rpb24gQ2ZuUG9saWN5X1BvbGljeVRhZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmFsdWUnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMudmFsdWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3ZhbHVlJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnZhbHVlKSk7XG4gICAgcmV0dXJuIGVycm9ycy53cmFwKCdzdXBwbGllZCBwcm9wZXJ0aWVzIG5vdCBjb3JyZWN0IGZvciBcIlBvbGljeVRhZ1Byb3BlcnR5XCInKTtcbn1cblxuLyoqXG4gKiBSZW5kZXJzIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeS5Qb2xpY3lUYWdgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFBvbGljeVRhZ1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpGTVM6OlBvbGljeS5Qb2xpY3lUYWdgIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuUG9saWN5UG9saWN5VGFnUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblBvbGljeV9Qb2xpY3lUYWdQcm9wZXJ0eVZhbGlkYXRvcihwcm9wZXJ0aWVzKS5hc3NlcnRTdWNjZXNzKCk7XG4gICAgcmV0dXJuIHtcbiAgICAgICAgS2V5OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmtleSksXG4gICAgICAgIFZhbHVlOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnZhbHVlKSxcbiAgICB9O1xufVxuXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gQ2ZuUG9saWN5UG9saWN5VGFnUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5Qb2xpY3kuUG9saWN5VGFnUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuUG9saWN5LlBvbGljeVRhZ1Byb3BlcnR5PigpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgna2V5JywgJ0tleScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuS2V5KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCd2YWx1ZScsICdWYWx1ZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVmFsdWUpKTtcbiAgICByZXQuYWRkVW5yZWNvZ25pemVkUHJvcGVydGllc0FzRXh0cmEocHJvcGVydGllcyk7XG4gICAgcmV0dXJuIHJldDtcbn1cblxuZXhwb3J0IG5hbWVzcGFjZSBDZm5Qb2xpY3kge1xuICAgIC8qKlxuICAgICAqIFRoZSByZXNvdXJjZSB0YWdzIHRoYXQgQVdTIEZpcmV3YWxsIE1hbmFnZXIgdXNlcyB0byBkZXRlcm1pbmUgaWYgYSBwYXJ0aWN1bGFyIHJlc291cmNlIHNob3VsZCBiZSBpbmNsdWRlZCBvciBleGNsdWRlZCBmcm9tIHRoZSBBV1MgRmlyZXdhbGwgTWFuYWdlciBwb2xpY3kuIFRhZ3MgZW5hYmxlIHlvdSB0byBjYXRlZ29yaXplIHlvdXIgQVdTIHJlc291cmNlcyBpbiBkaWZmZXJlbnQgd2F5cywgZm9yIGV4YW1wbGUsIGJ5IHB1cnBvc2UsIG93bmVyLCBvciBlbnZpcm9ubWVudC4gRWFjaCB0YWcgY29uc2lzdHMgb2YgYSBrZXkgYW5kIGFuIG9wdGlvbmFsIHZhbHVlLiBGaXJld2FsbCBNYW5hZ2VyIGNvbWJpbmVzIHRoZSB0YWdzIHdpdGggXCJBTkRcIiBzbyB0aGF0LCBpZiB5b3UgYWRkIG1vcmUgdGhhbiBvbmUgdGFnIHRvIGEgcG9saWN5IHNjb3BlLCBhIHJlc291cmNlIG11c3QgaGF2ZSBhbGwgdGhlIHNwZWNpZmllZCB0YWdzIHRvIGJlIGluY2x1ZGVkIG9yIGV4Y2x1ZGVkLiBGb3IgbW9yZSBpbmZvcm1hdGlvbiwgc2VlIFtXb3JraW5nIHdpdGggVGFnIEVkaXRvcl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2F3c2NvbnNvbGVoZWxwZG9jcy9sYXRlc3QvZ3NnL3RhZy1lZGl0b3IuaHRtbCkgLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS1yZXNvdXJjZXRhZy5odG1sXG4gICAgICovXG4gICAgZXhwb3J0IGludGVyZmFjZSBSZXNvdXJjZVRhZ1Byb3BlcnR5IHtcbiAgICAgICAgLyoqXG4gICAgICAgICAqIFRoZSByZXNvdXJjZSB0YWcga2V5LlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktcmVzb3VyY2V0YWcuaHRtbCNjZm4tZm1zLXBvbGljeS1yZXNvdXJjZXRhZy1rZXlcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGtleTogc3RyaW5nO1xuICAgICAgICAvKipcbiAgICAgICAgICogVGhlIHJlc291cmNlIHRhZyB2YWx1ZS5cbiAgICAgICAgICpcbiAgICAgICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcHJvcGVydGllcy1mbXMtcG9saWN5LXJlc291cmNldGFnLmh0bWwjY2ZuLWZtcy1wb2xpY3ktcmVzb3VyY2V0YWctdmFsdWVcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IHZhbHVlPzogc3RyaW5nO1xuICAgIH1cbn1cblxuLyoqXG4gKiBEZXRlcm1pbmUgd2hldGhlciB0aGUgZ2l2ZW4gcHJvcGVydGllcyBtYXRjaCB0aG9zZSBvZiBhIGBSZXNvdXJjZVRhZ1Byb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBSZXNvdXJjZVRhZ1Byb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblBvbGljeV9SZXNvdXJjZVRhZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXM6IGFueSk6IGNkay5WYWxpZGF0aW9uUmVzdWx0IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBjZGsuVkFMSURBVElPTl9TVUNDRVNTOyB9XG4gICAgY29uc3QgZXJyb3JzID0gbmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0cygpO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgZXJyb3JzLmNvbGxlY3QobmV3IGNkay5WYWxpZGF0aW9uUmVzdWx0KCdFeHBlY3RlZCBhbiBvYmplY3QsIGJ1dCByZWNlaXZlZDogJyArIEpTT04uc3RyaW5naWZ5KHByb3BlcnRpZXMpKSk7XG4gICAgfVxuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigna2V5JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmtleSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigndmFsdWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudmFsdWUpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiUmVzb3VyY2VUYWdQcm9wZXJ0eVwiJyk7XG59XG5cbi8qKlxuICogUmVuZGVycyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpQb2xpY3kuUmVzb3VyY2VUYWdgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFJlc291cmNlVGFnUHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkZNUzo6UG9saWN5LlJlc291cmNlVGFnYCByZXNvdXJjZS5cbiAqL1xuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIGNmblBvbGljeVJlc291cmNlVGFnUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblBvbGljeV9SZXNvdXJjZVRhZ1Byb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBLZXk6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMua2V5KSxcbiAgICAgICAgVmFsdWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudmFsdWUpLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5Qb2xpY3lSZXNvdXJjZVRhZ1Byb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuUG9saWN5LlJlc291cmNlVGFnUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuUG9saWN5LlJlc291cmNlVGFnUHJvcGVydHk+KCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdrZXknLCAnS2V5JywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5LZXkpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3ZhbHVlJywgJ1ZhbHVlJywgcHJvcGVydGllcy5WYWx1ZSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5WYWx1ZSkgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblBvbGljeSB7XG4gICAgLyoqXG4gICAgICogRGV0YWlscyBhYm91dCB0aGUgc2VjdXJpdHkgc2VydmljZSB0aGF0IGlzIGJlaW5nIHVzZWQgdG8gcHJvdGVjdCB0aGUgcmVzb3VyY2VzLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS1zZWN1cml0eXNlcnZpY2Vwb2xpY3lkYXRhLmh0bWxcbiAgICAgKi9cbiAgICBleHBvcnQgaW50ZXJmYWNlIFNlY3VyaXR5U2VydmljZVBvbGljeURhdGFQcm9wZXJ0eSB7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBEZXRhaWxzIGFib3V0IHRoZSBzZXJ2aWNlIHRoYXQgYXJlIHNwZWNpZmljIHRvIHRoZSBzZXJ2aWNlIHR5cGUsIGluIEpTT04gZm9ybWF0LlxuICAgICAgICAgKlxuICAgICAgICAgKiAtIEV4YW1wbGU6IGBETlNfRklSRVdBTExgXG4gICAgICAgICAqXG4gICAgICAgICAqIGBcIntcXFwidHlwZVxcXCI6XFxcIkROU19GSVJFV0FMTFxcXCIsXFxcInByZVByb2Nlc3NSdWxlR3JvdXBzXFxcIjpbe1xcXCJydWxlR3JvdXBJZFxcXCI6XFxcInJzbHZyLWZyZy0xXFxcIixcXFwicHJpb3JpdHlcXFwiOjEwfV0sXFxcInBvc3RQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W3tcXFwicnVsZUdyb3VwSWRcXFwiOlxcXCJyc2x2ci1mcmctMlxcXCIsXFxcInByaW9yaXR5XFxcIjo5OTExfV19XCJgXG4gICAgICAgICAqXG4gICAgICAgICAqID4gVmFsaWQgdmFsdWVzIGZvciBgcHJlUHJvY2Vzc1J1bGVHcm91cHNgIGFyZSBiZXR3ZWVuIDEgYW5kIDk5LiBWYWxpZCB2YWx1ZXMgZm9yIGBwb3N0UHJvY2Vzc1J1bGVHcm91cHNgIGFyZSBiZXR3ZWVuIDk5MDEgYW5kIDEwMDAwLlxuICAgICAgICAgKiAtIEV4YW1wbGU6IGBORVRXT1JLX0ZJUkVXQUxMYCAtIENlbnRyYWxpemVkIGRlcGxveW1lbnQgbW9kZWxcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiTkVUV09SS19GSVJFV0FMTFxcXCIsXFxcImF3c05ldHdvcmtGaXJld2FsbENvbmZpZ1xcXCI6e1xcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MTIzNDU2Nzg5MDExOnN0YXRlbGVzcy1ydWxlZ3JvdXAvdGVzdFxcXCIsXFxcInByaW9yaXR5XFxcIjoxfV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0RlZmF1bHRBY3Rpb25zXFxcIjpbXFxcImF3czpmb3J3YXJkX3RvX3NmZVxcXCIsXFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiXSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRnJhZ21lbnREZWZhdWx0QWN0aW9uc1xcXCI6W1xcXCJhd3M6Zm9yd2FyZF90b19zZmVcXFwiLFxcXCJjdXN0b21BY3Rpb25OYW1lXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0N1c3RvbUFjdGlvbnNcXFwiOlt7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJjdXN0b21BY3Rpb25OYW1lXFxcIixcXFwiYWN0aW9uRGVmaW5pdGlvblxcXCI6e1xcXCJwdWJsaXNoTWV0cmljQWN0aW9uXFxcIjp7XFxcImRpbWVuc2lvbnNcXFwiOlt7XFxcInZhbHVlXFxcIjpcXFwibWV0cmljZGltZW5zaW9udmFsdWVcXFwifV19fX1dLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWZ1bFJ1bGVHcm91cFJlZmVyZW5jZXNcXFwiOlt7XFxcInJlc291cmNlQVJOXFxcIjpcXFwiYXJuOmF3czpuZXR3b3JrLWZpcmV3YWxsOnVzLWVhc3QtMToxMjM0NTY3ODkwMTE6c3RhdGVmdWwtcnVsZWdyb3VwL3Rlc3RcXFwifV0sXFxcIm5ldHdvcmtGaXJld2FsbExvZ2dpbmdDb25maWd1cmF0aW9uXFxcIjp7XFxcImxvZ0Rlc3RpbmF0aW9uQ29uZmlnc1xcXCI6W3tcXFwibG9nRGVzdGluYXRpb25UeXBlXFxcIjpcXFwiUzNcXFwiLFxcXCJsb2dUeXBlXFxcIjpcXFwiQUxFUlRcXFwiLFxcXCJsb2dEZXN0aW5hdGlvblxcXCI6e1xcXCJidWNrZXROYW1lXFxcIjpcXFwiczMtYnVja2V0LW5hbWVcXFwifX0se1xcXCJsb2dEZXN0aW5hdGlvblR5cGVcXFwiOlxcXCJTM1xcXCIsXFxcImxvZ1R5cGVcXFwiOlxcXCJGTE9XXFxcIixcXFwibG9nRGVzdGluYXRpb25cXFwiOntcXFwiYnVja2V0TmFtZVxcXCI6XFxcInMzLWJ1Y2tldC1uYW1lXFxcIn19XSxcXFwib3ZlcnJpZGVFeGlzdGluZ0NvbmZpZ1xcXCI6dHJ1ZX19LFxcXCJmaXJld2FsbERlcGxveW1lbnRNb2RlbFxcXCI6e1xcXCJjZW50cmFsaXplZEZpcmV3YWxsRGVwbG95bWVudE1vZGVsXFxcIjp7XFxcImNlbnRyYWxpemVkRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXFxcIjp7XFxcImluc3BlY3Rpb25WcGNJZHNcXFwiOlt7XFxcInJlc291cmNlSWRcXFwiOlxcXCJ2cGMtMTIzNFxcXCIsXFxcImFjY291bnRJZFxcXCI6XFxcIjEyMzQ1Njc4OTAxMVxcXCJ9XSxcXFwiZmlyZXdhbGxDcmVhdGlvbkNvbmZpZ1xcXCI6e1xcXCJlbmRwb2ludExvY2F0aW9uXFxcIjp7XFxcImF2YWlsYWJpbGl0eVpvbmVDb25maWdMaXN0XFxcIjpbe1xcXCJhdmFpbGFiaWxpdHlab25lSWRcXFwiOm51bGwsXFxcImF2YWlsYWJpbGl0eVpvbmVOYW1lXFxcIjpcXFwidXMtZWFzdC0xYVxcXCIsXFxcImFsbG93ZWRJUFY0Q2lkckxpc3RcXFwiOltcXFwiMTAuMC4wLjAvMjhcXFwiXX1dfX0sXFxcImFsbG93ZWRJUFY0Q2lkckxpc3RcXFwiOltdfX19fVwiYFxuICAgICAgICAgKlxuICAgICAgICAgKiBUbyB1c2UgdGhlIGNlbnRyYWxpemVkIGRlcGxveW1lbnQgbW9kZWwsIHlvdSBtdXN0IHNldCBbUG9saWN5T3B0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZm1zLzIwMTgtMDEtMDEvQVBJUmVmZXJlbmNlL0FQSV9Qb2xpY3lPcHRpb24uaHRtbCkgdG8gYENFTlRSQUxJWkVEYCAuXG4gICAgICAgICAqIC0gRXhhbXBsZTogYE5FVFdPUktfRklSRVdBTExgIC0gRGlzdHJpYnV0ZWQgZGVwbG95bWVudCBtb2RlbCB3aXRoIGF1dG9tYXRpYyBBdmFpbGFiaWxpdHkgWm9uZSBjb25maWd1cmF0aW9uXG4gICAgICAgICAqXG4gICAgICAgICAqIGBcIntcXFwidHlwZVxcXCI6XFxcIk5FVFdPUktfRklSRVdBTExcXFwiLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MTIzNDU2Nzg5MDExOnN0YXRlbGVzcy1ydWxlZ3JvdXAvdGVzdFxcXCIsXFxcInByaW9yaXR5XFxcIjoxfV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0RlZmF1bHRBY3Rpb25zXFxcIjpbXFxcImF3czpmb3J3YXJkX3RvX3NmZVxcXCIsXFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiXSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRnJhZ21lbnREZWZhdWx0QWN0aW9uc1xcXCI6W1xcXCJhd3M6Zm9yd2FyZF90b19zZmVcXFwiLFxcXCJjdXN0b21BY3Rpb25OYW1lXFxcIl0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0N1c3RvbUFjdGlvbnNcXFwiOlt7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJjdXN0b21BY3Rpb25OYW1lXFxcIixcXFwiYWN0aW9uRGVmaW5pdGlvblxcXCI6e1xcXCJwdWJsaXNoTWV0cmljQWN0aW9uXFxcIjp7XFxcImRpbWVuc2lvbnNcXFwiOlt7XFxcInZhbHVlXFxcIjpcXFwibWV0cmljZGltZW5zaW9udmFsdWVcXFwifV19fX1dLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWZ1bFJ1bGVHcm91cFJlZmVyZW5jZXNcXFwiOlt7XFxcInJlc291cmNlQVJOXFxcIjpcXFwiYXJuOmF3czpuZXR3b3JrLWZpcmV3YWxsOnVzLWVhc3QtMToxMjM0NTY3ODkwMTE6c3RhdGVmdWwtcnVsZWdyb3VwL3Rlc3RcXFwifV0sXFxcIm5ldHdvcmtGaXJld2FsbE9yY2hlc3RyYXRpb25Db25maWdcXFwiOntcXFwic2luZ2xlRmlyZXdhbGxFbmRwb2ludFBlclZQQ1xcXCI6ZmFsc2UsXFxcImFsbG93ZWRJUFY0Q2lkckxpc3RcXFwiOltcXFwiMTAuMC4wLjAvMjhcXFwiLFxcXCIxOTIuMTY4LjAuMC8yOFxcXCJdLFxcXCJyb3V0ZU1hbmFnZW1lbnRBY3Rpb25cXFwiOlxcXCJPRkZcXFwifSxcXFwibmV0d29ya0ZpcmV3YWxsTG9nZ2luZ0NvbmZpZ3VyYXRpb25cXFwiOntcXFwibG9nRGVzdGluYXRpb25Db25maWdzXFxcIjpbe1xcXCJsb2dEZXN0aW5hdGlvblR5cGVcXFwiOlxcXCJTM1xcXCIsXFxcImxvZ1R5cGVcXFwiOlxcXCJBTEVSVFxcXCIsXFxcImxvZ0Rlc3RpbmF0aW9uXFxcIjp7XFxcImJ1Y2tldE5hbWVcXFwiOlxcXCJzMy1idWNrZXQtbmFtZVxcXCJ9fSx7XFxcImxvZ0Rlc3RpbmF0aW9uVHlwZVxcXCI6XFxcIlMzXFxcIixcXFwibG9nVHlwZVxcXCI6XFxcIkZMT1dcXFwiLFxcXCJsb2dEZXN0aW5hdGlvblxcXCI6e1xcXCJidWNrZXROYW1lXFxcIjpcXFwiczMtYnVja2V0LW5hbWVcXFwifX1dLFxcXCJvdmVycmlkZUV4aXN0aW5nQ29uZmlnXFxcIjp0cnVlfX1cImBcbiAgICAgICAgICpcbiAgICAgICAgICogV2l0aCBhdXRvbWF0aWMgQXZhaWxiaWxpdHkgWm9uZSBjb25maWd1cmF0aW9uLCBGaXJld2FsbCBNYW5hZ2VyIGNob29zZXMgd2hpY2ggQXZhaWxhYmlsaXR5IFpvbmVzIHRvIGNyZWF0ZSB0aGUgZW5kcG9pbnRzIGluLiBUbyB1c2UgdGhlIGRpc3RyaWJ1dGVkIGRlcGxveW1lbnQgbW9kZWwsIHlvdSBtdXN0IHNldCBbUG9saWN5T3B0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZm1zLzIwMTgtMDEtMDEvQVBJUmVmZXJlbmNlL0FQSV9Qb2xpY3lPcHRpb24uaHRtbCkgdG8gYE5VTExgIC5cbiAgICAgICAgICogLSBFeGFtcGxlOiBgTkVUV09SS19GSVJFV0FMTGAgLSBEaXN0cmlidXRlZCBkZXBsb3ltZW50IG1vZGVsIHdpdGggYXV0b21hdGljIEF2YWlsYWJpbGl0eSBab25lIGNvbmZpZ3VyYXRpb24gYW5kIHJvdXRlIG1hbmFnZW1lbnRcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiTkVUV09SS19GSVJFV0FMTFxcXCIsXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc1J1bGVHcm91cFJlZmVyZW5jZXNcXFwiOlt7XFxcInJlc291cmNlQVJOXFxcIjpcXFwiYXJuOmF3czpuZXR3b3JrLWZpcmV3YWxsOnVzLWVhc3QtMToxMjM0NTY3ODkwMTE6c3RhdGVsZXNzLXJ1bGVncm91cC90ZXN0XFxcIixcXFwicHJpb3JpdHlcXFwiOjF9XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmZvcndhcmRfdG9fc2ZlXFxcIixcXFwiY3VzdG9tQWN0aW9uTmFtZVxcXCJdLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NGcmFnbWVudERlZmF1bHRBY3Rpb25zXFxcIjpbXFxcImF3czpmb3J3YXJkX3RvX3NmZVxcXCIsXFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiXSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzQ3VzdG9tQWN0aW9uc1xcXCI6W3tcXFwiYWN0aW9uTmFtZVxcXCI6XFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiLFxcXCJhY3Rpb25EZWZpbml0aW9uXFxcIjp7XFxcInB1Ymxpc2hNZXRyaWNBY3Rpb25cXFwiOntcXFwiZGltZW5zaW9uc1xcXCI6W3tcXFwidmFsdWVcXFwiOlxcXCJtZXRyaWNkaW1lbnNpb252YWx1ZVxcXCJ9XX19fV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlZnVsUnVsZUdyb3VwUmVmZXJlbmNlc1xcXCI6W3tcXFwicmVzb3VyY2VBUk5cXFwiOlxcXCJhcm46YXdzOm5ldHdvcmstZmlyZXdhbGw6dXMtZWFzdC0xOjEyMzQ1Njc4OTAxMTpzdGF0ZWZ1bC1ydWxlZ3JvdXAvdGVzdFxcXCJ9XSxcXFwibmV0d29ya0ZpcmV3YWxsT3JjaGVzdHJhdGlvbkNvbmZpZ1xcXCI6e1xcXCJzaW5nbGVGaXJld2FsbEVuZHBvaW50UGVyVlBDXFxcIjpmYWxzZSxcXFwiYWxsb3dlZElQVjRDaWRyTGlzdFxcXCI6W1xcXCIxMC4wLjAuMC8yOFxcXCIsXFxcIjE5Mi4xNjguMC4wLzI4XFxcIl0sXFxcInJvdXRlTWFuYWdlbWVudEFjdGlvblxcXCI6XFxcIk1PTklUT1JcXFwiLFxcXCJyb3V0ZU1hbmFnZW1lbnRUYXJnZXRUeXBlc1xcXCI6W1xcXCJJbnRlcm5ldEdhdGV3YXlcXFwiXX0sXFxcIm5ldHdvcmtGaXJld2FsbExvZ2dpbmdDb25maWd1cmF0aW9uXFxcIjp7XFxcImxvZ0Rlc3RpbmF0aW9uQ29uZmlnc1xcXCI6W3tcXFwibG9nRGVzdGluYXRpb25UeXBlXFxcIjpcXFwiUzNcXFwiLFxcXCJsb2dUeXBlXFxcIjpcXFwiQUxFUlRcXFwiLFxcXCJsb2dEZXN0aW5hdGlvblxcXCI6e1xcXCJidWNrZXROYW1lXFxcIjpcXFwiczMtYnVja2V0LW5hbWVcXFwifX0se1xcXCJsb2dEZXN0aW5hdGlvblR5cGVcXFwiOlxcXCJTM1xcXCIsXFxcImxvZ1R5cGVcXFwiOiBcXFwiRkxPV1xcXCIsXFxcImxvZ0Rlc3RpbmF0aW9uXFxcIjp7XFxcImJ1Y2tldE5hbWVcXFwiOlxcXCJzMy1idWNrZXQtbmFtZVxcXCJ9fV0sXFxcIm92ZXJyaWRlRXhpc3RpbmdDb25maWdcXFwiOnRydWV9fVwiYFxuICAgICAgICAgKlxuICAgICAgICAgKiBUbyB1c2UgdGhlIGRpc3RyaWJ1dGVkIGRlcGxveW1lbnQgbW9kZWwsIHlvdSBtdXN0IHNldCBbUG9saWN5T3B0aW9uXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vZm1zLzIwMTgtMDEtMDEvQVBJUmVmZXJlbmNlL0FQSV9Qb2xpY3lPcHRpb24uaHRtbCkgdG8gYE5VTExgIC5cbiAgICAgICAgICogLSBFeGFtcGxlOiBgTkVUV09SS19GSVJFV0FMTGAgLSBEaXN0cmlidXRlZCBkZXBsb3ltZW50IG1vZGVsIHdpdGggY3VzdG9tIEF2YWlsYWJpbGl0eSBab25lIGNvbmZpZ3VyYXRpb25cbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiTkVUV09SS19GSVJFV0FMTFxcXCIsXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc1J1bGVHcm91cFJlZmVyZW5jZXNcXFwiOlt7XFxcInJlc291cmNlQVJOXFxcIjpcXFwiYXJuOmF3czpuZXR3b3JrLWZpcmV3YWxsOnVzLWVhc3QtMToxMjM0NTY3ODkwMTE6c3RhdGVsZXNzLXJ1bGVncm91cC90ZXN0XFxcIixcXFwicHJpb3JpdHlcXFwiOjF9XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRGVmYXVsdEFjdGlvbnNcXFwiOltcXFwiYXdzOmZvcndhcmRfdG9fc2ZlXFxcIixcXFwiY3VzdG9tQWN0aW9uTmFtZVxcXCJdLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NGcmFnbWVudERlZmF1bHRBY3Rpb25zXFxcIjpbXFxcImF3czpmb3J3YXJkX3RvX3NmZVxcXCIsXFxcImZyYWdtZW50Y3VzdG9tYWN0aW9ubmFtZVxcXCJdLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NDdXN0b21BY3Rpb25zXFxcIjpbe1xcXCJhY3Rpb25OYW1lXFxcIjpcXFwiY3VzdG9tQWN0aW9uTmFtZVxcXCIsIFxcXCJhY3Rpb25EZWZpbml0aW9uXFxcIjp7XFxcInB1Ymxpc2hNZXRyaWNBY3Rpb25cXFwiOntcXFwiZGltZW5zaW9uc1xcXCI6W3tcXFwidmFsdWVcXFwiOlxcXCJtZXRyaWNkaW1lbnNpb252YWx1ZVxcXCJ9XX19fSx7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJmcmFnbWVudGN1c3RvbWFjdGlvbm5hbWVcXFwiLFxcXCJhY3Rpb25EZWZpbml0aW9uXFxcIjp7XFxcInB1Ymxpc2hNZXRyaWNBY3Rpb25cXFwiOntcXFwiZGltZW5zaW9uc1xcXCI6W3tcXFwidmFsdWVcXFwiOlxcXCJmcmFnbWVudG1ldHJpY2RpbWVuc2lvbnZhbHVlXFxcIn1dfX19XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVmdWxSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MTIzNDU2Nzg5MDExOnN0YXRlZnVsLXJ1bGVncm91cC90ZXN0XFxcIn1dLFxcXCJuZXR3b3JrRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXFxcIjp7XFxcImZpcmV3YWxsQ3JlYXRpb25Db25maWdcXFwiOnsgXFxcImVuZHBvaW50TG9jYXRpb25cXFwiOntcXFwiYXZhaWxhYmlsaXR5Wm9uZUNvbmZpZ0xpc3RcXFwiOlt7XFxcImF2YWlsYWJpbGl0eVpvbmVOYW1lXFxcIjpcXFwidXMtZWFzdC0xYVxcXCIsXFxcImFsbG93ZWRJUFY0Q2lkckxpc3RcXFwiOltcXFwiMTAuMC4wLjAvMjhcXFwiXX0se1xcXCJhdmFpbGFiaWxpdHlab25lTmFtZVxcXCI6XFxcInVzLWVhc3QtMWJcXFwiLFxcXCJhbGxvd2VkSVBWNENpZHJMaXN0XFxcIjpbIFxcXCIxMC4wLjAuMC8yOFxcXCJdfV19IH0sXFxcInNpbmdsZUZpcmV3YWxsRW5kcG9pbnRQZXJWUENcXFwiOmZhbHNlLFxcXCJhbGxvd2VkSVBWNENpZHJMaXN0XFxcIjpudWxsLFxcXCJyb3V0ZU1hbmFnZW1lbnRBY3Rpb25cXFwiOlxcXCJPRkZcXFwiLFxcXCJuZXR3b3JrRmlyZXdhbGxMb2dnaW5nQ29uZmlndXJhdGlvblxcXCI6e1xcXCJsb2dEZXN0aW5hdGlvbkNvbmZpZ3NcXFwiOlt7XFxcImxvZ0Rlc3RpbmF0aW9uVHlwZVxcXCI6XFxcIlMzXFxcIixcXFwibG9nVHlwZVxcXCI6XFxcIkFMRVJUXFxcIixcXFwibG9nRGVzdGluYXRpb25cXFwiOntcXFwiYnVja2V0TmFtZVxcXCI6XFxcInMzLWJ1Y2tldC1uYW1lXFxcIn19LHtcXFwibG9nRGVzdGluYXRpb25UeXBlXFxcIjpcXFwiUzNcXFwiLFxcXCJsb2dUeXBlXFxcIjpcXFwiRkxPV1xcXCIsXFxcImxvZ0Rlc3RpbmF0aW9uXFxcIjp7XFxcImJ1Y2tldE5hbWVcXFwiOlxcXCJzMy1idWNrZXQtbmFtZVxcXCJ9fV0sXFxcIm92ZXJyaWRlRXhpc3RpbmdDb25maWdcXFwiOmJvb2xlYW59fVwiYFxuICAgICAgICAgKlxuICAgICAgICAgKiBXaXRoIGN1c3RvbSBBdmFpbGFiaWxpdHkgWm9uZSBjb25maWd1cmF0aW9uLCB5b3UgZGVmaW5lIHdoaWNoIHNwZWNpZmljIEF2YWlsYWJpbGl0eSBab25lcyB0byBjcmVhdGUgZW5kcG9pbnRzIGluIGJ5IGNvbmZpZ3VyaW5nIGBmaXJld2FsbENyZWF0aW9uQ29uZmlnYCAuIFRvIGNvbmZpZ3VyZSB0aGUgQXZhaWxhYmlsaXR5IFpvbmVzIGluIGBmaXJld2FsbENyZWF0aW9uQ29uZmlnYCAsIHNwZWNpZnkgZWl0aGVyIHRoZSBgYXZhaWxhYmlsaXR5Wm9uZU5hbWVgIG9yIGBhdmFpbGFiaWxpdHlab25lSWRgIHBhcmFtZXRlciwgbm90IGJvdGggcGFyYW1ldGVycy5cbiAgICAgICAgICpcbiAgICAgICAgICogVG8gdXNlIHRoZSBkaXN0cmlidXRlZCBkZXBsb3ltZW50IG1vZGVsLCB5b3UgbXVzdCBzZXQgW1BvbGljeU9wdGlvbl0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Ztcy8yMDE4LTAxLTAxL0FQSVJlZmVyZW5jZS9BUElfUG9saWN5T3B0aW9uLmh0bWwpIHRvIGBOVUxMYCAuXG4gICAgICAgICAqIC0gRXhhbXBsZTogYE5FVFdPUktfRklSRVdBTExgIC0gRGlzdHJpYnV0ZWQgZGVwbG95bWVudCBtb2RlbCB3aXRoIGN1c3RvbSBBdmFpbGFiaWxpdHkgWm9uZSBjb25maWd1cmF0aW9uIGFuZCByb3V0ZSBtYW5hZ2VtZW50XG4gICAgICAgICAqXG4gICAgICAgICAqIGBcIntcXFwidHlwZVxcXCI6XFxcIk5FVFdPUktfRklSRVdBTExcXFwiLFxcXCJuZXR3b3JrRmlyZXdhbGxTdGF0ZWxlc3NSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MTIzNDU2Nzg5MDExOnN0YXRlbGVzcy1ydWxlZ3JvdXAvdGVzdFxcXCIsXFxcInByaW9yaXR5XFxcIjoxfV0sXFxcIm5ldHdvcmtGaXJld2FsbFN0YXRlbGVzc0RlZmF1bHRBY3Rpb25zXFxcIjpbXFxcImF3czpmb3J3YXJkX3RvX3NmZVxcXCIsXFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiXSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzRnJhZ21lbnREZWZhdWx0QWN0aW9uc1xcXCI6W1xcXCJhd3M6Zm9yd2FyZF90b19zZmVcXFwiLFxcXCJmcmFnbWVudGN1c3RvbWFjdGlvbm5hbWVcXFwiXSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVsZXNzQ3VzdG9tQWN0aW9uc1xcXCI6W3tcXFwiYWN0aW9uTmFtZVxcXCI6XFxcImN1c3RvbUFjdGlvbk5hbWVcXFwiLFxcXCJhY3Rpb25EZWZpbml0aW9uXFxcIjp7XFxcInB1Ymxpc2hNZXRyaWNBY3Rpb25cXFwiOntcXFwiZGltZW5zaW9uc1xcXCI6W3tcXFwidmFsdWVcXFwiOlxcXCJtZXRyaWNkaW1lbnNpb252YWx1ZVxcXCJ9XX19fSx7XFxcImFjdGlvbk5hbWVcXFwiOlxcXCJmcmFnbWVudGN1c3RvbWFjdGlvbm5hbWVcXFwiLFxcXCJhY3Rpb25EZWZpbml0aW9uXFxcIjp7XFxcInB1Ymxpc2hNZXRyaWNBY3Rpb25cXFwiOntcXFwiZGltZW5zaW9uc1xcXCI6W3tcXFwidmFsdWVcXFwiOlxcXCJmcmFnbWVudG1ldHJpY2RpbWVuc2lvbnZhbHVlXFxcIn1dfX19XSxcXFwibmV0d29ya0ZpcmV3YWxsU3RhdGVmdWxSdWxlR3JvdXBSZWZlcmVuY2VzXFxcIjpbe1xcXCJyZXNvdXJjZUFSTlxcXCI6XFxcImFybjphd3M6bmV0d29yay1maXJld2FsbDp1cy1lYXN0LTE6MTIzNDU2Nzg5MDExOnN0YXRlZnVsLXJ1bGVncm91cC90ZXN0XFxcIn1dLFxcXCJuZXR3b3JrRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXFxcIjp7XFxcImZpcmV3YWxsQ3JlYXRpb25Db25maWdcXFwiOntcXFwiZW5kcG9pbnRMb2NhdGlvblxcXCI6e1xcXCJhdmFpbGFiaWxpdHlab25lQ29uZmlnTGlzdFxcXCI6W3tcXFwiYXZhaWxhYmlsaXR5Wm9uZU5hbWVcXFwiOlxcXCJ1cy1lYXN0LTFhXFxcIixcXFwiYWxsb3dlZElQVjRDaWRyTGlzdFxcXCI6W1xcXCIxMC4wLjAuMC8yOFxcXCJdfSx7XFxcImF2YWlsYWJpbGl0eVpvbmVOYW1lXFxcIjpcXFwidXMtZWFzdC0xYlxcXCIsXFxcImFsbG93ZWRJUFY0Q2lkckxpc3RcXFwiOltcXFwiMTAuMC4wLjAvMjhcXFwiXX1dfX0sXFxcInNpbmdsZUZpcmV3YWxsRW5kcG9pbnRQZXJWUENcXFwiOmZhbHNlLFxcXCJhbGxvd2VkSVBWNENpZHJMaXN0XFxcIjpudWxsLFxcXCJyb3V0ZU1hbmFnZW1lbnRBY3Rpb25cXFwiOlxcXCJNT05JVE9SXFxcIixcXFwicm91dGVNYW5hZ2VtZW50VGFyZ2V0VHlwZXNcXFwiOltcXFwiSW50ZXJuZXRHYXRld2F5XFxcIl0sXFxcInJvdXRlTWFuYWdlbWVudENvbmZpZ1xcXCI6e1xcXCJhbGxvd0Nyb3NzQVpUcmFmZmljSWZOb0VuZHBvaW50XFxcIjp0cnVlfX0sXFxcIm5ldHdvcmtGaXJld2FsbExvZ2dpbmdDb25maWd1cmF0aW9uXFxcIjp7XFxcImxvZ0Rlc3RpbmF0aW9uQ29uZmlnc1xcXCI6W3tcXFwibG9nRGVzdGluYXRpb25UeXBlXFxcIjpcXFwiUzNcXFwiLFxcXCJsb2dUeXBlXFxcIjpcXFwiQUxFUlRcXFwiLFxcXCJsb2dEZXN0aW5hdGlvblxcXCI6e1xcXCJidWNrZXROYW1lXFxcIjpcXFwiczMtYnVja2V0LW5hbWVcXFwifX0se1xcXCJsb2dEZXN0aW5hdGlvblR5cGVcXFwiOlxcXCJTM1xcXCIsXFxcImxvZ1R5cGVcXFwiOlxcXCJGTE9XXFxcIixcXFwibG9nRGVzdGluYXRpb25cXFwiOntcXFwiYnVja2V0TmFtZVxcXCI6XFxcInMzLWJ1Y2tldC1uYW1lXFxcIn19XSxcXFwib3ZlcnJpZGVFeGlzdGluZ0NvbmZpZ1xcXCI6Ym9vbGVhbn19XCJgXG4gICAgICAgICAqXG4gICAgICAgICAqIFRvIHVzZSB0aGUgZGlzdHJpYnV0ZWQgZGVwbG95bWVudCBtb2RlbCwgeW91IG11c3Qgc2V0IFtQb2xpY3lPcHRpb25dKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9mbXMvMjAxOC0wMS0wMS9BUElSZWZlcmVuY2UvQVBJX1BvbGljeU9wdGlvbi5odG1sKSB0byBgTlVMTGAgLlxuICAgICAgICAgKiAtIEV4YW1wbGU6IGBUSElSRF9QQVJUWV9GSVJFV0FMTGBcbiAgICAgICAgICpcbiAgICAgICAgICogYFwieyBcInR5cGVcIjpcIlRISVJEX1BBUlRZX0ZJUkVXQUxMXCIsIFwidGhpcmRQYXJ0eUZpcmV3YWxsXCI6XCJQQUxPX0FMVE9fTkVUV09SS1NfQ0xPVURfTkdGV1wiLCBcInRoaXJkUGFydHlGaXJld2FsbENvbmZpZ1wiOnsgXCJ0aGlyZFBhcnR5RmlyZXdhbGxQb2xpY3lMaXN0XCI6W1wiZ2xvYmFsLTFcIl0gfSwgXCJmaXJld2FsbERlcGxveW1lbnRNb2RlbFwiOnsgXCJkaXN0cmlidXRlZEZpcmV3YWxsRGVwbG95bWVudE1vZGVsXCI6eyBcImRpc3RyaWJ1dGVkRmlyZXdhbGxPcmNoZXN0cmF0aW9uQ29uZmlnXCI6eyBcImZpcmV3YWxsQ3JlYXRpb25Db25maWdcIjp7IFwiZW5kcG9pbnRMb2NhdGlvblwiOnsgXCJhdmFpbGFiaWxpdHlab25lQ29uZmlnTGlzdFwiOlsgeyBcImF2YWlsYWJpbGl0eVpvbmVOYW1lXCI6XCIke0F2YWlsYWJpbGl0eVpvbmV9XCIgfSBdIH0gfSwgXCJhbGxvd2VkSVBWNENpZHJMaXN0XCI6WyBdIH0gfSB9IH1cImBcbiAgICAgICAgICogLSBFeGFtcGxlOiBgU0VDVVJJVFlfR1JPVVBTX0NPTU1PTmBcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiU0VDVVJJVFlfR1JPVVBTX0NPTU1PTlxcXCIsXFxcInJldmVydE1hbnVhbFNlY3VyaXR5R3JvdXBDaGFuZ2VzXFxcIjpmYWxzZSxcXFwiZXhjbHVzaXZlUmVzb3VyY2VTZWN1cml0eUdyb3VwTWFuYWdlbWVudFxcXCI6ZmFsc2UsIFxcXCJhcHBseVRvQWxsRUMySW5zdGFuY2VFTklzXFxcIjpmYWxzZSxcXFwic2VjdXJpdHlHcm91cHNcXFwiOlt7XFxcImlkXFxcIjpcXFwiIHNnLTAwMGU1NTk5NWQ2MWEwNmJkXFxcIn1dfVwiYFxuICAgICAgICAgKiAtIEV4YW1wbGU6IGBTRUNVUklUWV9HUk9VUFNfQ09NTU9OYCAtIFNlY3VyaXR5IGdyb3VwIHRhZyBkaXN0cmlidXRpb25cbiAgICAgICAgICpcbiAgICAgICAgICogYFwiXCJ7XFxcInR5cGVcXFwiOlxcXCJTRUNVUklUWV9HUk9VUFNfQ09NTU9OXFxcIixcXFwic2VjdXJpdHlHcm91cHNcXFwiOlt7XFxcImlkXFxcIjpcXFwic2ctMDAwZTU1OTk1ZDYxYTA2YmRcXFwifV0sXFxcInJldmVydE1hbnVhbFNlY3VyaXR5R3JvdXBDaGFuZ2VzXFxcIjp0cnVlLFxcXCJleGNsdXNpdmVSZXNvdXJjZVNlY3VyaXR5R3JvdXBNYW5hZ2VtZW50XFxcIjpmYWxzZSxcXFwiYXBwbHlUb0FsbEVDMkluc3RhbmNlRU5Jc1xcXCI6ZmFsc2UsXFxcImluY2x1ZGVTaGFyZWRWUENcXFwiOmZhbHNlLFxcXCJlbmFibGVUYWdEaXN0cmlidXRpb25cXFwiOnRydWV9XCJcImBcbiAgICAgICAgICpcbiAgICAgICAgICogRmlyZXdhbGwgTWFuYWdlciBhdXRvbWF0aWNhbGx5IGRpc3RyaWJ1dGVzIHRhZ3MgZnJvbSB0aGUgcHJpbWFyeSBncm91cCB0byB0aGUgc2VjdXJpdHkgZ3JvdXBzIGNyZWF0ZWQgYnkgdGhpcyBwb2xpY3kuIFRvIHVzZSBzZWN1cml0eSBncm91cCB0YWcgZGlzdHJpYnV0aW9uLCB5b3UgbXVzdCBhbHNvIHNldCBgcmV2ZXJ0TWFudWFsU2VjdXJpdHlHcm91cENoYW5nZXNgIHRvIGB0cnVlYCAsIG90aGVyd2lzZSBGaXJld2FsbCBNYW5hZ2VyIHdvbid0IGJlIGFibGUgdG8gY3JlYXRlIHRoZSBwb2xpY3kuIFdoZW4geW91IGVuYWJsZSBgcmV2ZXJ0TWFudWFsU2VjdXJpdHlHcm91cENoYW5nZXNgICwgRmlyZXdhbGwgTWFuYWdlciBpZGVudGlmaWVzIGFuZCByZXBvcnRzIHdoZW4gdGhlIHNlY3VyaXR5IGdyb3VwcyBjcmVhdGVkIGJ5IHRoaXMgcG9saWN5IGJlY29tZSBub24tY29tcGxpYW50LlxuICAgICAgICAgKlxuICAgICAgICAgKiBGaXJld2FsbCBNYW5hZ2VyIHdvbid0IGRpc3RydWJ1dGUgc3lzdGVtIHRhZ3MgYWRkZWQgYnkgQVdTIHNlcnZpY2VzIGludG8gdGhlIHJlcGxpY2Egc2VjdXJpdHkgZ3JvdXBzLiBTeXN0ZW0gdGFncyBiZWdpbiB3aXRoIHRoZSBgYXdzOmAgcHJlZml4LlxuICAgICAgICAgKiAtIEV4YW1wbGU6IFNoYXJlZCBWUENzLiBBcHBseSB0aGUgcHJlY2VkaW5nIHBvbGljeSB0byByZXNvdXJjZXMgaW4gc2hhcmVkIFZQQ3MgYXMgd2VsbCBhcyB0byB0aG9zZSBpbiBWUENzIHRoYXQgdGhlIGFjY291bnQgb3duc1xuICAgICAgICAgKlxuICAgICAgICAgKiBgXCJ7XFxcInR5cGVcXFwiOlxcXCJTRUNVUklUWV9HUk9VUFNfQ09NTU9OXFxcIixcXFwicmV2ZXJ0TWFudWFsU2VjdXJpdHlHcm91cENoYW5nZXNcXFwiOmZhbHNlLFxcXCJleGNsdXNpdmVSZXNvdXJjZVNlY3VyaXR5R3JvdXBNYW5hZ2VtZW50XFxcIjpmYWxzZSwgXFxcImFwcGx5VG9BbGxFQzJJbnN0YW5jZUVOSXNcXFwiOmZhbHNlLFxcXCJpbmNsdWRlU2hhcmVkVlBDXFxcIjp0cnVlLFxcXCJzZWN1cml0eUdyb3Vwc1xcXCI6W3tcXFwiaWRcXFwiOlxcXCIgc2ctMDAwZTU1OTk1ZDYxYTA2YmRcXFwifV19XCJgXG4gICAgICAgICAqIC0gRXhhbXBsZTogYFNFQ1VSSVRZX0dST1VQU19DT05URU5UX0FVRElUYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgXCJ7XFxcInR5cGVcXFwiOlxcXCJTRUNVUklUWV9HUk9VUFNfQ09OVEVOVF9BVURJVFxcXCIsXFxcInNlY3VyaXR5R3JvdXBzXFxcIjpbe1xcXCJpZFxcXCI6XFxcInNnLTAwMGU1NTk5NWQ2MWEwNmJkXFxcIn1dLFxcXCJzZWN1cml0eUdyb3VwQWN0aW9uXFxcIjp7XFxcInR5cGVcXFwiOlxcXCJBTExPV1xcXCJ9fVwiYFxuICAgICAgICAgKlxuICAgICAgICAgKiBUaGUgc2VjdXJpdHkgZ3JvdXAgYWN0aW9uIGZvciBjb250ZW50IGF1ZGl0IGNhbiBiZSBgQUxMT1dgIG9yIGBERU5ZYCAuIEZvciBgQUxMT1dgICwgYWxsIGluLXNjb3BlIHNlY3VyaXR5IGdyb3VwIHJ1bGVzIG11c3QgYmUgd2l0aGluIHRoZSBhbGxvd2VkIHJhbmdlIG9mIHRoZSBwb2xpY3kncyBzZWN1cml0eSBncm91cCBydWxlcy4gRm9yIGBERU5ZYCAsIGFsbCBpbi1zY29wZSBzZWN1cml0eSBncm91cCBydWxlcyBtdXN0IG5vdCBjb250YWluIGEgdmFsdWUgb3IgYSByYW5nZSB0aGF0IG1hdGNoZXMgYSBydWxlIHZhbHVlIG9yIHJhbmdlIGluIHRoZSBwb2xpY3kgc2VjdXJpdHkgZ3JvdXAuXG4gICAgICAgICAqIC0gRXhhbXBsZTogYFNFQ1VSSVRZX0dST1VQU19VU0FHRV9BVURJVGBcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiU0VDVVJJVFlfR1JPVVBTX1VTQUdFX0FVRElUXFxcIixcXFwiZGVsZXRlVW51c2VkU2VjdXJpdHlHcm91cHNcXFwiOnRydWUsXFxcImNvYWxlc2NlUmVkdW5kYW50U2VjdXJpdHlHcm91cHNcXFwiOnRydWV9XCJgXG4gICAgICAgICAqIC0gU3BlY2lmaWNhdGlvbiBmb3IgYFNISUVMRF9BRFZBTkNFRGAgZm9yIEFtYXpvbiBDbG91ZEZyb250IGRpc3RyaWJ1dGlvbnNcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiU0hJRUxEX0FEVkFOQ0VEXFxcIixcXFwiYXV0b21hdGljUmVzcG9uc2VDb25maWd1cmF0aW9uXFxcIjoge1xcXCJhdXRvbWF0aWNSZXNwb25zZVN0YXR1c1xcXCI6XFxcIkVOQUJMRUR8SUdOT1JFRHxESVNBQkxFRFxcXCIsIFxcXCJhdXRvbWF0aWNSZXNwb25zZUFjdGlvblxcXCI6XFxcIkJMT0NLfENPVU5UXFxcIn0sIFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViYWNsQ2xhc3NpY1xcXCI6dHJ1ZXxmYWxzZX1cImBcbiAgICAgICAgICpcbiAgICAgICAgICogRm9yIGV4YW1wbGU6IGBcIntcXFwidHlwZVxcXCI6XFxcIlNISUVMRF9BRFZBTkNFRFxcXCIsXFxcImF1dG9tYXRpY1Jlc3BvbnNlQ29uZmlndXJhdGlvblxcXCI6IHtcXFwiYXV0b21hdGljUmVzcG9uc2VTdGF0dXNcXFwiOlxcXCJFTkFCTEVEXFxcIiwgXFxcImF1dG9tYXRpY1Jlc3BvbnNlQWN0aW9uXFxcIjpcXFwiQ09VTlRcXFwifX1cImBcbiAgICAgICAgICpcbiAgICAgICAgICogVGhlIGRlZmF1bHQgdmFsdWUgZm9yIGBhdXRvbWF0aWNSZXNwb25zZVN0YXR1c2AgaXMgYElHTk9SRURgIC4gVGhlIHZhbHVlIGZvciBgYXV0b21hdGljUmVzcG9uc2VBY3Rpb25gIGlzIG9ubHkgcmVxdWlyZWQgd2hlbiBgYXV0b21hdGljUmVzcG9uc2VTdGF0dXNgIGlzIHNldCB0byBgRU5BQkxFRGAgLiBUaGUgZGVmYXVsdCB2YWx1ZSBmb3IgYG92ZXJyaWRlQ3VzdG9tZXJXZWJhY2xDbGFzc2ljYCBpcyBgZmFsc2VgIC5cbiAgICAgICAgICpcbiAgICAgICAgICogRm9yIG90aGVyIHJlc291cmNlIHR5cGVzIHRoYXQgeW91IGNhbiBwcm90ZWN0IHdpdGggYSBTaGllbGQgQWR2YW5jZWQgcG9saWN5LCB0aGlzIGBNYW5hZ2VkU2VydmljZURhdGFgIGNvbmZpZ3VyYXRpb24gaXMgYW4gZW1wdHkgc3RyaW5nLlxuICAgICAgICAgKiAtIEV4YW1wbGU6IGBXQUZWMmBcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiV0FGVjJcXFwiLFxcXCJwcmVQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W3tcXFwicnVsZUdyb3VwQXJuXFxcIjpudWxsLFxcXCJvdmVycmlkZUFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiTk9ORVxcXCJ9LFxcXCJtYW5hZ2VkUnVsZUdyb3VwSWRlbnRpZmllclxcXCI6e1xcXCJ2ZXJzaW9uXFxcIjpudWxsLFxcXCJ2ZW5kb3JOYW1lXFxcIjpcXFwiQVdTXFxcIixcXFwibWFuYWdlZFJ1bGVHcm91cE5hbWVcXFwiOlxcXCJBV1NNYW5hZ2VkUnVsZXNBbWF6b25JcFJlcHV0YXRpb25MaXN0XFxcIn0sXFxcInJ1bGVHcm91cFR5cGVcXFwiOlxcXCJNYW5hZ2VkUnVsZUdyb3VwXFxcIixcXFwiZXhjbHVkZVJ1bGVzXFxcIjpbe1xcXCJuYW1lXFxcIjpcXFwiTm9Vc2VyQWdlbnRfSEVBREVSXFxcIn1dfV0sXFxcInBvc3RQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W10sXFxcImRlZmF1bHRBY3Rpb25cXFwiOntcXFwidHlwZVxcXCI6XFxcIkFMTE9XXFxcIn0sXFxcIm92ZXJyaWRlQ3VzdG9tZXJXZWJBQ0xBc3NvY2lhdGlvblxcXCI6ZmFsc2UsXFxcImxvZ2dpbmdDb25maWd1cmF0aW9uXFxcIjp7XFxcImxvZ0Rlc3RpbmF0aW9uQ29uZmlnc1xcXCI6W1xcXCJhcm46YXdzOmZpcmVob3NlOnVzLXdlc3QtMjoxMjM0NTY3ODkxMjpkZWxpdmVyeXN0cmVhbS9hd3Mtd2FmLWxvZ3MtZm1zLWFkbWluLWRlc3RpbmF0aW9uXFxcIl0sXFxcInJlZGFjdGVkRmllbGRzXFxcIjpbe1xcXCJyZWRhY3RlZEZpZWxkVHlwZVxcXCI6XFxcIlNpbmdsZUhlYWRlclxcXCIsXFxcInJlZGFjdGVkRmllbGRWYWx1ZVxcXCI6XFxcIkNvb2tpZXNcXFwifSx7XFxcInJlZGFjdGVkRmllbGRUeXBlXFxcIjpcXFwiTWV0aG9kXFxcIn1dfX1cImBcbiAgICAgICAgICpcbiAgICAgICAgICogSW4gdGhlIGBsb2dnaW5nQ29uZmlndXJhdGlvbmAgLCB5b3UgY2FuIHNwZWNpZnkgb25lIGBsb2dEZXN0aW5hdGlvbkNvbmZpZ3NgICwgeW91IGNhbiBvcHRpb25hbGx5IHByb3ZpZGUgdXAgdG8gMjAgYHJlZGFjdGVkRmllbGRzYCAsIGFuZCB0aGUgYFJlZGFjdGVkRmllbGRUeXBlYCBtdXN0IGJlIG9uZSBvZiBgVVJJYCAsIGBRVUVSWV9TVFJJTkdgICwgYEhFQURFUmAgLCBvciBgTUVUSE9EYCAuXG4gICAgICAgICAqIC0gRXhhbXBsZTogYFdBRlYyYCAtIEFXUyBGaXJld2FsbCBNYW5hZ2VyIHN1cHBvcnQgZm9yIEFXUyBXQUYgbWFuYWdlZCBydWxlIGdyb3VwIHZlcnNpb25pbmdcbiAgICAgICAgICpcbiAgICAgICAgICogYFwie1xcXCJ0eXBlXFxcIjpcXFwiV0FGVjJcXFwiLFxcXCJwcmVQcm9jZXNzUnVsZUdyb3Vwc1xcXCI6W3tcXFwicnVsZUdyb3VwQXJuXFxcIjpudWxsLFxcXCJvdmVycmlkZUFjdGlvblxcXCI6e1xcXCJ0eXBlXFxcIjpcXFwiTk9ORVxcXCJ9LFxcXCJtYW5hZ2VkUnVsZUdyb3VwSWRlbnRpZmllclxcXCI6e1xcXCJ2ZXJzaW9uRW5hYmxlZFxcXCI6dHJ1ZSxcXFwidmVyc2lvblxcXCI6XFxcIlZlcnNpb25fMi4wXFxcIixcXFwidmVuZG9yTmFtZVxcXCI6XFxcIkFXU1xcXCIsXFxcIm1hbmFnZWRSdWxlR3JvdXBOYW1lXFxcIjpcXFwiQVdTTWFuYWdlZFJ1bGVzQ29tbW9uUnVsZVNldFxcXCJ9LFxcXCJydWxlR3JvdXBUeXBlXFxcIjpcXFwiTWFuYWdlZFJ1bGVHcm91cFxcXCIsXFxcImV4Y2x1ZGVSdWxlc1xcXCI6W3tcXFwibmFtZVxcXCI6XFxcIk5vVXNlckFnZW50X0hFQURFUlxcXCJ9XX1dLFxcXCJwb3N0UHJvY2Vzc1J1bGVHcm91cHNcXFwiOltdLFxcXCJkZWZhdWx0QWN0aW9uXFxcIjp7XFxcInR5cGVcXFwiOlxcXCJBTExPV1xcXCJ9LFxcXCJvdmVycmlkZUN1c3RvbWVyV2ViQUNMQXNzb2NpYXRpb25cXFwiOmZhbHNlLFxcXCJsb2dnaW5nQ29uZmlndXJhdGlvblxcXCI6e1xcXCJsb2dEZXN0aW5hdGlvbkNvbmZpZ3NcXFwiOltcXFwiYXJuOmF3czpmaXJlaG9zZTp1cy13ZXN0LTI6MTIzNDU2Nzg5MTI6ZGVsaXZlcnlzdHJlYW0vYXdzLXdhZi1sb2dzLWZtcy1hZG1pbi1kZXN0aW5hdGlvblxcXCJdLFxcXCJyZWRhY3RlZEZpZWxkc1xcXCI6W3tcXFwicmVkYWN0ZWRGaWVsZFR5cGVcXFwiOlxcXCJTaW5nbGVIZWFkZXJcXFwiLFxcXCJyZWRhY3RlZEZpZWxkVmFsdWVcXFwiOlxcXCJDb29raWVzXFxcIn0se1xcXCJyZWRhY3RlZEZpZWxkVHlwZVxcXCI6XFxcIk1ldGhvZFxcXCJ9XX19XCJgXG4gICAgICAgICAqXG4gICAgICAgICAqIFRvIHVzZSBhIHNwZWNpZmljIHZlcnNpb24gb2YgYSBBV1MgV0FGIG1hbmFnZWQgcnVsZSBncm91cCBpbiB5b3VyIEZpcmV3YWxsIE1hbmFnZXIgcG9saWN5LCB5b3UgbXVzdCBzZXQgYHZlcnNpb25FbmFibGVkYCB0byBgdHJ1ZWAgLCBhbmQgc2V0IGB2ZXJzaW9uYCB0byB0aGUgdmVyc2lvbiB5b3UnZCBsaWtlIHRvIHVzZS4gSWYgeW91IGRvbid0IHNldCBgdmVyc2lvbkVuYWJsZWRgIHRvIGB0cnVlYCAsIG9yIGlmIHlvdSBvbWl0IGB2ZXJzaW9uRW5hYmxlZGAgLCB0aGVuIEZpcmV3YWxsIE1hbmFnZXIgdXNlcyB0aGUgZGVmYXVsdCB2ZXJzaW9uIG9mIHRoZSBBV1MgV0FGIG1hbmFnZWQgcnVsZSBncm91cC5cbiAgICAgICAgICogLSBFeGFtcGxlOiBgQVdTIFdBRiBDbGFzc2ljYFxuICAgICAgICAgKlxuICAgICAgICAgKiBgXCJ7XFxcInR5cGVcXFwiOiBcXFwiV0FGXFxcIiwgXFxcInJ1bGVHcm91cHNcXFwiOiBbe1xcXCJpZFxcXCI6XFxcIjEyMzQ1Njc4LTFiY2QtOTAxMi1lZmdhLTA5ODc2NTQzMjFhYlxcXCIsIFxcXCJvdmVycmlkZUFjdGlvblxcXCIgOiB7XFxcInR5cGVcXFwiOiBcXFwiQ09VTlRcXFwifX1dLCBcXFwiZGVmYXVsdEFjdGlvblxcXCI6IHtcXFwidHlwZVxcXCI6IFxcXCJCTE9DS1xcXCJ9fVwiYFxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktc2VjdXJpdHlzZXJ2aWNlcG9saWN5ZGF0YS5odG1sI2Nmbi1mbXMtcG9saWN5LXNlY3VyaXR5c2VydmljZXBvbGljeWRhdGEtbWFuYWdlZHNlcnZpY2VkYXRhXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBtYW5hZ2VkU2VydmljZURhdGE/OiBzdHJpbmc7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBDb250YWlucyB0aGUgTmV0d29yayBGaXJld2FsbCBmaXJld2FsbCBwb2xpY3kgb3B0aW9ucyB0byBjb25maWd1cmUgYSBjZW50cmFsaXplZCBkZXBsb3ltZW50IG1vZGVsLlxuICAgICAgICAgKlxuICAgICAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1wcm9wZXJ0aWVzLWZtcy1wb2xpY3ktc2VjdXJpdHlzZXJ2aWNlcG9saWN5ZGF0YS5odG1sI2Nmbi1mbXMtcG9saWN5LXNlY3VyaXR5c2VydmljZXBvbGljeWRhdGEtcG9saWN5b3B0aW9uXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSBwb2xpY3lPcHRpb24/OiBDZm5Qb2xpY3kuUG9saWN5T3B0aW9uUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU7XG4gICAgICAgIC8qKlxuICAgICAgICAgKiBUaGUgc2VydmljZSB0aGF0IHRoZSBwb2xpY3kgaXMgdXNpbmcgdG8gcHJvdGVjdCB0aGUgcmVzb3VyY2VzLiBUaGlzIHNwZWNpZmllcyB0aGUgdHlwZSBvZiBwb2xpY3kgdGhhdCBpcyBjcmVhdGVkLCBlaXRoZXIgYW4gQVdTIFdBRiBwb2xpY3ksIGEgU2hpZWxkIEFkdmFuY2VkIHBvbGljeSwgb3IgYSBzZWN1cml0eSBncm91cCBwb2xpY3kuIEZvciBzZWN1cml0eSBncm91cCBwb2xpY2llcywgRmlyZXdhbGwgTWFuYWdlciBzdXBwb3J0cyBvbmUgc2VjdXJpdHkgZ3JvdXAgZm9yIGVhY2ggY29tbW9uIHBvbGljeSBhbmQgZm9yIGVhY2ggY29udGVudCBhdWRpdCBwb2xpY3kuIFRoaXMgaXMgYW4gYWRqdXN0YWJsZSBsaW1pdCB0aGF0IHlvdSBjYW4gaW5jcmVhc2UgYnkgY29udGFjdGluZyBBV1MgU3VwcG9ydCAuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS1zZWN1cml0eXNlcnZpY2Vwb2xpY3lkYXRhLmh0bWwjY2ZuLWZtcy1wb2xpY3ktc2VjdXJpdHlzZXJ2aWNlcG9saWN5ZGF0YS10eXBlXG4gICAgICAgICAqL1xuICAgICAgICByZWFkb25seSB0eXBlOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFNlY3VyaXR5U2VydmljZVBvbGljeURhdGFQcm9wZXJ0eWBcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YVByb3BlcnR5YFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblBvbGljeV9TZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdtYW5hZ2VkU2VydmljZURhdGEnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMubWFuYWdlZFNlcnZpY2VEYXRhKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdwb2xpY3lPcHRpb24nLCBDZm5Qb2xpY3lfUG9saWN5T3B0aW9uUHJvcGVydHlWYWxpZGF0b3IpKHByb3BlcnRpZXMucG9saWN5T3B0aW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0eXBlJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnR5cGUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3R5cGUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMudHlwZSkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJTZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkZNUzo6UG9saWN5LlNlY3VyaXR5U2VydmljZVBvbGljeURhdGFgIHJlc291cmNlXG4gKlxuICogQHBhcmFtIHByb3BlcnRpZXMgLSB0aGUgVHlwZVNjcmlwdCBwcm9wZXJ0aWVzIG9mIGEgYFNlY3VyaXR5U2VydmljZVBvbGljeURhdGFQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgQVdTIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgYW4gYEFXUzo6Rk1TOjpQb2xpY3kuU2VjdXJpdHlTZXJ2aWNlUG9saWN5RGF0YWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Qb2xpY3lTZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGFueSB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gcHJvcGVydGllczsgfVxuICAgIENmblBvbGljeV9TZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIE1hbmFnZWRTZXJ2aWNlRGF0YTogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5tYW5hZ2VkU2VydmljZURhdGEpLFxuICAgICAgICBQb2xpY3lPcHRpb246IGNmblBvbGljeVBvbGljeU9wdGlvblByb3BlcnR5VG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnBvbGljeU9wdGlvbiksXG4gICAgICAgIFR5cGU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMudHlwZSksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblBvbGljeVNlY3VyaXR5U2VydmljZVBvbGljeURhdGFQcm9wZXJ0eUZyb21DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0PENmblBvbGljeS5TZWN1cml0eVNlcnZpY2VQb2xpY3lEYXRhUHJvcGVydHkgfCBjZGsuSVJlc29sdmFibGU+IHtcbiAgICBpZiAoY2RrLmlzUmVzb2x2YWJsZU9iamVjdChwcm9wZXJ0aWVzKSkge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIHByb3BlcnRpZXMgPSBwcm9wZXJ0aWVzID09IG51bGwgPyB7fSA6IHByb3BlcnRpZXM7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICByZXR1cm4gbmV3IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQocHJvcGVydGllcyk7XG4gICAgfVxuICAgIGNvbnN0IHJldCA9IG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUHJvcGVydHlPYmplY3Q8Q2ZuUG9saWN5LlNlY3VyaXR5U2VydmljZVBvbGljeURhdGFQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ21hbmFnZWRTZXJ2aWNlRGF0YScsICdNYW5hZ2VkU2VydmljZURhdGEnLCBwcm9wZXJ0aWVzLk1hbmFnZWRTZXJ2aWNlRGF0YSAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5NYW5hZ2VkU2VydmljZURhdGEpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3BvbGljeU9wdGlvbicsICdQb2xpY3lPcHRpb24nLCBwcm9wZXJ0aWVzLlBvbGljeU9wdGlvbiAhPSBudWxsID8gQ2ZuUG9saWN5UG9saWN5T3B0aW9uUHJvcGVydHlGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5Qb2xpY3lPcHRpb24pIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3R5cGUnLCAnVHlwZScsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuVHlwZSkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG5leHBvcnQgbmFtZXNwYWNlIENmblBvbGljeSB7XG4gICAgLyoqXG4gICAgICogQ29uZmlndXJlcyB0aGUgZGVwbG95bWVudCBtb2RlbCBmb3IgdGhlIHRoaXJkLXBhcnR5IGZpcmV3YWxsLlxuICAgICAqXG4gICAgICogQHN0cnVjdFxuICAgICAqIEBzdGFiaWxpdHkgZXh0ZXJuYWxcbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS10aGlyZHBhcnR5ZmlyZXdhbGxwb2xpY3kuaHRtbFxuICAgICAqL1xuICAgIGV4cG9ydCBpbnRlcmZhY2UgVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5UHJvcGVydHkge1xuICAgICAgICAvKipcbiAgICAgICAgICogRGVmaW5lcyB0aGUgZGVwbG95bWVudCBtb2RlbCB0byB1c2UgZm9yIHRoZSB0aGlyZC1wYXJ0eSBmaXJld2FsbCBwb2xpY3kuXG4gICAgICAgICAqXG4gICAgICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXByb3BlcnRpZXMtZm1zLXBvbGljeS10aGlyZHBhcnR5ZmlyZXdhbGxwb2xpY3kuaHRtbCNjZm4tZm1zLXBvbGljeS10aGlyZHBhcnR5ZmlyZXdhbGxwb2xpY3ktZmlyZXdhbGxkZXBsb3ltZW50bW9kZWxcbiAgICAgICAgICovXG4gICAgICAgIHJlYWRvbmx5IGZpcmV3YWxsRGVwbG95bWVudE1vZGVsOiBzdHJpbmc7XG4gICAgfVxufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYFRoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5YFxuICpcbiAqIEBwYXJhbSBwcm9wZXJ0aWVzIC0gdGhlIFR5cGVTY3JpcHQgcHJvcGVydGllcyBvZiBhIGBUaGlyZFBhcnR5RmlyZXdhbGxQb2xpY3lQcm9wZXJ0eWBcbiAqXG4gKiBAcmV0dXJucyB0aGUgcmVzdWx0IG9mIHRoZSB2YWxpZGF0aW9uLlxuICovXG5mdW5jdGlvbiBDZm5Qb2xpY3lfVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5UHJvcGVydHlWYWxpZGF0b3IocHJvcGVydGllczogYW55KTogY2RrLlZhbGlkYXRpb25SZXN1bHQge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIGNkay5WQUxJREFUSU9OX1NVQ0NFU1M7IH1cbiAgICBjb25zdCBlcnJvcnMgPSBuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHRzKCk7XG4gICAgaWYgKHR5cGVvZiBwcm9wZXJ0aWVzICE9PSAnb2JqZWN0Jykge1xuICAgICAgICBlcnJvcnMuY29sbGVjdChuZXcgY2RrLlZhbGlkYXRpb25SZXN1bHQoJ0V4cGVjdGVkIGFuIG9iamVjdCwgYnV0IHJlY2VpdmVkOiAnICsgSlNPTi5zdHJpbmdpZnkocHJvcGVydGllcykpKTtcbiAgICB9XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdmaXJld2FsbERlcGxveW1lbnRNb2RlbCcsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5maXJld2FsbERlcGxveW1lbnRNb2RlbCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignZmlyZXdhbGxEZXBsb3ltZW50TW9kZWwnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZmlyZXdhbGxEZXBsb3ltZW50TW9kZWwpKTtcbiAgICByZXR1cm4gZXJyb3JzLndyYXAoJ3N1cHBsaWVkIHByb3BlcnRpZXMgbm90IGNvcnJlY3QgZm9yIFwiVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5UHJvcGVydHlcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkZNUzo6UG9saWN5LlRoaXJkUGFydHlGaXJld2FsbFBvbGljeWAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgVGhpcmRQYXJ0eUZpcmV3YWxsUG9saWN5UHJvcGVydHlgXG4gKlxuICogQHJldHVybnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkZNUzo6UG9saWN5LlRoaXJkUGFydHlGaXJld2FsbFBvbGljeWAgcmVzb3VyY2UuXG4gKi9cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBjZm5Qb2xpY3lUaGlyZFBhcnR5RmlyZXdhbGxQb2xpY3lQcm9wZXJ0eVRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogYW55IHtcbiAgICBpZiAoIWNkay5jYW5JbnNwZWN0KHByb3BlcnRpZXMpKSB7IHJldHVybiBwcm9wZXJ0aWVzOyB9XG4gICAgQ2ZuUG9saWN5X1RoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5VmFsaWRhdG9yKHByb3BlcnRpZXMpLmFzc2VydFN1Y2Nlc3MoKTtcbiAgICByZXR1cm4ge1xuICAgICAgICBGaXJld2FsbERlcGxveW1lbnRNb2RlbDogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5maXJld2FsbERlcGxveW1lbnRNb2RlbCksXG4gICAgfTtcbn1cblxuLy8gQHRzLWlnbm9yZSBUUzYxMzNcbmZ1bmN0aW9uIENmblBvbGljeVRoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5RnJvbUNsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXM6IGFueSk6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25SZXN1bHQ8Q2ZuUG9saWN5LlRoaXJkUGFydHlGaXJld2FsbFBvbGljeVByb3BlcnR5IHwgY2RrLklSZXNvbHZhYmxlPiB7XG4gICAgaWYgKGNkay5pc1Jlc29sdmFibGVPYmplY3QocHJvcGVydGllcykpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblBvbGljeS5UaGlyZFBhcnR5RmlyZXdhbGxQb2xpY3lQcm9wZXJ0eT4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2ZpcmV3YWxsRGVwbG95bWVudE1vZGVsJywgJ0ZpcmV3YWxsRGVwbG95bWVudE1vZGVsJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5GaXJld2FsbERlcGxveW1lbnRNb2RlbCkpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuIl19