"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 */
class SfnStateMachine {
    constructor(machine, props = {}) {
        this.machine = machine;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_stepfunctions_IStateMachine(machine);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_SfnStateMachineProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SfnStateMachine);
            }
            throw error;
        }
        // no statements are passed because we are configuring permissions by using grant* helper below
        this.role = props.role ?? util_1.singletonEventRole(machine);
        machine.grantStartExecution(this.role);
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.machine.stateMachineArn,
            role: this.role,
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
_a = JSII_RTTI_SYMBOL_1;
SfnStateMachine[_a] = { fqn: "monocdk.aws_events_targets.SfnStateMachine", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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