"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const util_1 = require("./util");
/**
 * Use an AWS Lambda function as an event rule target.
 */
class LambdaFunction {
    constructor(handler, props = {}) {
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_lambda_IFunction(handler);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_LambdaFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaFunction);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Lambda as a
     * result from an EventBridge event.
     */
    bind(rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, this.handler);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.handler.functionArn,
            input: this.props.event,
            targetResource: this.handler,
        };
    }
}
exports.LambdaFunction = LambdaFunction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunction[_a] = { fqn: "monocdk.aws_events_targets.LambdaFunction", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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