"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BatchJob = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const core_1 = require("../../core");
const util_1 = require("./util");
/**
 * Use an AWS Batch Job / Queue as an event rule target.
 * Most likely the code will look something like this:
 * `new BatchJob(jobQueue.jobQueueArn, jobQueue, jobDefinition.jobDefinitionArn, jobDefinition)`
 *
 * In the future this API will be improved to be fully typed
 */
class BatchJob {
    constructor(
    /**
     * The JobQueue arn
     */
    jobQueueArn, 
    /**
     * The JobQueue Resource
     */
    jobQueueScope, 
    /**
     * The jobDefinition arn
     */
    jobDefinitionArn, 
    /**
     * The JobQueue Resource
     */
    jobDefinitionScope, props = {}) {
        this.jobQueueArn = jobQueueArn;
        this.jobQueueScope = jobQueueScope;
        this.jobDefinitionArn = jobDefinitionArn;
        this.jobDefinitionScope = jobDefinitionScope;
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_IConstruct(jobQueueScope);
            jsiiDeprecationWarnings.monocdk_IConstruct(jobDefinitionScope);
            jsiiDeprecationWarnings.monocdk_aws_events_targets_BatchJobProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, BatchJob);
            }
            throw error;
        }
    }
    /**
     * Returns a RuleTarget that can be used to trigger queue this batch job as a
     * result from an EventBridge event.
     */
    bind(rule, _id) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const batchParameters = {
            jobDefinition: this.jobDefinitionArn,
            jobName: this.props.jobName ?? core_1.Names.nodeUniqueId(rule.node),
            arrayProperties: this.props.size ? { size: this.props.size } : undefined,
            retryStrategy: this.props.attempts ? { attempts: this.props.attempts } : undefined,
        };
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        // When scoping resource-level access for job submission, you must provide both job queue and job definition resource types.
        // https://docs.aws.amazon.com/batch/latest/userguide/ExamplePolicies_BATCH.html#iam-example-restrict-job-def
        const role = util_1.singletonEventRole(this.jobDefinitionScope);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['batch:SubmitJob'],
            resources: [
                this.jobDefinitionArn,
                this.jobQueueArn,
            ],
        }));
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.jobQueueArn,
            role,
            input: this.props.event,
            targetResource: this.jobQueueScope,
            batchParameters,
        };
    }
}
exports.BatchJob = BatchJob;
_a = JSII_RTTI_SYMBOL_1;
BatchJob[_a] = { fqn: "monocdk.aws_events_targets.BatchJob", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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