"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListenerCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * A certificate source for an ELBv2 listener
 */
class ListenerCertificate {
    constructor(certificateArn) {
        this.certificateArn = certificateArn;
    }
    /**
     * Use an ACM certificate as a listener certificate
     */
    static fromCertificateManager(acmCertificate) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_certificatemanager_ICertificate(acmCertificate);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromCertificateManager);
            }
            throw error;
        }
        return new ListenerCertificate(acmCertificate.certificateArn);
    }
    /**
     * Use any certificate, identified by its ARN, as a listener certificate
     */
    static fromArn(certificateArn) {
        return new ListenerCertificate(certificateArn);
    }
}
exports.ListenerCertificate = ListenerCertificate;
_a = JSII_RTTI_SYMBOL_1;
ListenerCertificate[_a] = { fqn: "monocdk.aws_elasticloadbalancingv2.ListenerCertificate", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlzdGVuZXItY2VydGlmaWNhdGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaXN0ZW5lci1jZXJ0aWZpY2F0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFZQTs7R0FFRztBQUNILE1BQWEsbUJBQW1CO0lBb0I5QixZQUFzQixjQUFzQjtRQUMxQyxJQUFJLENBQUMsY0FBYyxHQUFHLGNBQWMsQ0FBQztLQUN0QztJQXJCRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxjQUFnQzs7Ozs7Ozs7OztRQUNuRSxPQUFPLElBQUksbUJBQW1CLENBQUMsY0FBYyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0tBQy9EO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLGNBQXNCO1FBQzFDLE9BQU8sSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztLQUNoRDs7QUFiSCxrREF1QkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhY20gZnJvbSAnLi4vLi4vLi4vYXdzLWNlcnRpZmljYXRlbWFuYWdlcic7XG5cbi8qKlxuICogQSBjZXJ0aWZpY2F0ZSBzb3VyY2UgZm9yIGFuIEVMQnYyIGxpc3RlbmVyXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUxpc3RlbmVyQ2VydGlmaWNhdGUge1xuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgY2VydGlmaWNhdGUgdG8gdXNlXG4gICAqL1xuICByZWFkb25seSBjZXJ0aWZpY2F0ZUFybjogc3RyaW5nO1xufVxuXG4vKipcbiAqIEEgY2VydGlmaWNhdGUgc291cmNlIGZvciBhbiBFTEJ2MiBsaXN0ZW5lclxuICovXG5leHBvcnQgY2xhc3MgTGlzdGVuZXJDZXJ0aWZpY2F0ZSBpbXBsZW1lbnRzIElMaXN0ZW5lckNlcnRpZmljYXRlIHtcbiAgLyoqXG4gICAqIFVzZSBhbiBBQ00gY2VydGlmaWNhdGUgYXMgYSBsaXN0ZW5lciBjZXJ0aWZpY2F0ZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQ2VydGlmaWNhdGVNYW5hZ2VyKGFjbUNlcnRpZmljYXRlOiBhY20uSUNlcnRpZmljYXRlKSB7XG4gICAgcmV0dXJuIG5ldyBMaXN0ZW5lckNlcnRpZmljYXRlKGFjbUNlcnRpZmljYXRlLmNlcnRpZmljYXRlQXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBVc2UgYW55IGNlcnRpZmljYXRlLCBpZGVudGlmaWVkIGJ5IGl0cyBBUk4sIGFzIGEgbGlzdGVuZXIgY2VydGlmaWNhdGVcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUFybihjZXJ0aWZpY2F0ZUFybjogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBMaXN0ZW5lckNlcnRpZmljYXRlKGNlcnRpZmljYXRlQXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgQVJOIG9mIHRoZSBjZXJ0aWZpY2F0ZSB0byB1c2VcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBjZXJ0aWZpY2F0ZUFybjogc3RyaW5nO1xuXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3RvcihjZXJ0aWZpY2F0ZUFybjogc3RyaW5nKSB7XG4gICAgdGhpcy5jZXJ0aWZpY2F0ZUFybiA9IGNlcnRpZmljYXRlQXJuO1xuICB9XG59XG4iXX0=