"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTargetGroupBase = void 0;
const cdk = require("../../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../../core");
/**
 * Base internal class for existing target groups
 */
class ImportedTargetGroupBase extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Return an object to depend on the listeners added to this target group
         */
        this.loadBalancerAttached = new cdk.ConcreteDependable();
        this.targetGroupArn = props.targetGroupArn;
        this.targetGroupName = cdk.Stack.of(scope).splitArn(props.targetGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME).resourceName.split('/')[0];
        this.loadBalancerArns = props.loadBalancerArns || cdk.Aws.NO_VALUE;
    }
}
exports.ImportedTargetGroupBase = ImportedTargetGroupBase;
//# sourceMappingURL=data:application/json;base64,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