"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkListenerCertificate = void 0;
const elasticloadbalancingv2_generated_1 = require("../elasticloadbalancingv2.generated");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../../core");
/**
 * Add certificates to a listener
 */
class NetworkListenerCertificate extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const certificates = [
            ...(props.certificates || []).map(c => ({ certificateArn: c.certificateArn })),
        ];
        new elasticloadbalancingv2_generated_1.CfnListenerCertificate(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            certificates,
        });
    }
}
exports.NetworkListenerCertificate = NetworkListenerCertificate;
//# sourceMappingURL=data:application/json;base64,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