"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbTarget = exports.AlbArnTarget = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const elbv2 = require("../../aws-elasticloadbalancingv2");
/**
 * A single Application Load Balancer as the target for load balancing.
 */
class AlbArnTarget {
    /**
     * Create a new alb target
     *
     * @param albArn The ARN of the application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(albArn, port) {
        this.albArn = albArn;
        this.port = port;
    }
    /**
     * Register this alb target with a load balancer
     *
     * Don't call this, it is called automatically when you add the target to a
     * load balancer.
     */
    attachToNetworkTargetGroup(targetGroup) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkTargetGroup(targetGroup);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.attachToNetworkTargetGroup);
            }
            throw error;
        }
        return this.attach(targetGroup);
    }
    attach(_targetGroup) {
        return {
            targetType: elbv2.TargetType.ALB,
            targetJson: { id: this.albArn, port: this.port },
        };
    }
}
exports.AlbArnTarget = AlbArnTarget;
_a = JSII_RTTI_SYMBOL_1;
AlbArnTarget[_a] = { fqn: "monocdk.aws_elasticloadbalancingv2_targets.AlbArnTarget", version: "1.185.0" };
/**
 * A single Application Load Balancer as the target for load balancing.
 */
class AlbTarget extends AlbArnTarget {
    /**
     * @param alb The application load balancer to load balance to
     * @param port The port on which the target is listening
     */
    constructor(alb, port) {
        super(alb.loadBalancerArn, port);
        try {
            jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_ApplicationLoadBalancer(alb);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AlbTarget);
            }
            throw error;
        }
    }
}
exports.AlbTarget = AlbTarget;
_b = JSII_RTTI_SYMBOL_1;
AlbTarget[_b] = { fqn: "monocdk.aws_elasticloadbalancingv2_targets.AlbTarget", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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