"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelmChart = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("../../aws-lambda");
const core_1 = require("../../core");
const kubectl_layer_1 = require("./kubectl-layer");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core");
/**
 * Represents a helm chart within the Kubernetes system.
 *
 * Applies/deletes the resources using `kubectl` in sync with the resource.
 */
class HelmChart extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_Construct(scope);
            jsiiDeprecationWarnings.monocdk_aws_eks_legacy_HelmChartProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HelmChart);
            }
            throw error;
        }
        const stack = core_1.Stack.of(this);
        // we maintain a single manifest custom resource handler for each cluster
        const handler = this.getOrCreateHelmChartHandler(props.cluster);
        if (!handler) {
            throw new Error('Cannot define a Helm chart on a cluster with kubectl disabled');
        }
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: handler.functionArn,
            resourceType: HelmChart.RESOURCE_TYPE,
            properties: {
                Release: props.release || core_1.Names.uniqueId(this).slice(-63).toLowerCase(),
                Chart: props.chart,
                Version: props.version,
                Values: (props.values ? stack.toJsonString(props.values) : undefined),
                Namespace: props.namespace || 'default',
                Repository: props.repository,
            },
        });
    }
    getOrCreateHelmChartHandler(cluster) {
        if (!cluster.kubectlEnabled) {
            return undefined;
        }
        let handler = cluster.node.tryFindChild('HelmChartHandler');
        if (!handler) {
            handler = new lambda.Function(cluster, 'HelmChartHandler', {
                code: lambda.Code.fromAsset(path.join(__dirname, 'helm-chart')),
                runtime: lambda.Runtime.PYTHON_3_7,
                handler: 'index.handler',
                timeout: core_1.Duration.minutes(15),
                layers: [kubectl_layer_1.KubectlLayer.getOrCreate(this, { version: '2.0.0-beta1' })],
                memorySize: 256,
                environment: {
                    CLUSTER_NAME: cluster.clusterName,
                },
                // NOTE: we must use the default IAM role that's mapped to "system:masters"
                // as the execution role of this custom resource handler. This is the only
                // way to be able to interact with the cluster after it's been created.
                role: cluster._defaultMastersRole,
            });
        }
        return handler;
    }
}
exports.HelmChart = HelmChart;
_a = JSII_RTTI_SYMBOL_1;
HelmChart[_a] = { fqn: "monocdk.aws_eks_legacy.HelmChart", version: "1.185.0" };
/**
 * The CloudFormation reosurce type.
 */
HelmChart.RESOURCE_TYPE = 'Custom::AWSCDK-EKS-HelmChart';
//# sourceMappingURL=data:application/json;base64,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