"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const efs_generated_1 = require("./efs.generated");
class AccessPointBase extends core_1.Resource {
}
/**
 * Represents the AccessPoint
 */
class AccessPoint extends AccessPointBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings.monocdk_aws_efs_AccessPointProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AccessPoint);
            }
            throw error;
        }
        const resource = new efs_generated_1.CfnAccessPoint(this, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
        this.fileSystem = props.fileSystem;
    }
    /**
     * Import an existing Access Point by attributes
     */
    static fromAccessPointAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings.monocdk_aws_efs_AccessPointAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAccessPointAttributes);
            }
            throw error;
        }
        return new ImportedAccessPoint(scope, id, attrs);
    }
    /**
     * Import an existing Access Point by id
     */
    static fromAccessPointId(scope, id, accessPointId) {
        return new ImportedAccessPoint(scope, id, {
            accessPointId: accessPointId,
        });
    }
}
exports.AccessPoint = AccessPoint;
_a = JSII_RTTI_SYMBOL_1;
AccessPoint[_a] = { fqn: "monocdk.aws_efs.AccessPoint", version: "1.185.0" };
class ImportedAccessPoint extends AccessPointBase {
    constructor(scope, id, attrs) {
        super(scope, id);
        if (!attrs.accessPointId) {
            if (!attrs.accessPointArn) {
                throw new Error('One of accessPointId or AccessPointArn is required!');
            }
            this.accessPointArn = attrs.accessPointArn;
            let maybeApId = core_1.Stack.of(scope).splitArn(attrs.accessPointArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            if (!maybeApId) {
                throw new Error('ARN for AccessPoint must provide the resource name.');
            }
            this.accessPointId = maybeApId;
        }
        else {
            if (attrs.accessPointArn) {
                throw new Error('Only one of accessPointId or AccessPointArn can be provided!');
            }
            this.accessPointId = attrs.accessPointId;
            this.accessPointArn = core_1.Stack.of(scope).formatArn({
                service: 'elasticfilesystem',
                resource: 'access-point',
                resourceName: attrs.accessPointId,
            });
        }
        this._fileSystem = attrs.fileSystem;
    }
    get fileSystem() {
        if (!this._fileSystem) {
            throw new Error("fileSystem is only available if 'fromAccessPointAttributes()' is used and a fileSystem is passed in as an attribute.");
        }
        return this._fileSystem;
    }
}
//# sourceMappingURL=data:application/json;base64,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