"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppMeshProxyConfiguration = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const proxy_configuration_1 = require("./proxy-configuration");
/**
 * The class for App Mesh proxy configurations.
 *
 * For tasks using the EC2 launch type, the container instances require at least version 1.26.0 of the container agent and at least version
 * 1.26.0-1 of the ecs-init package to enable a proxy configuration. If your container instances are launched from the Amazon ECS-optimized
 * AMI version 20190301 or later, then they contain the required versions of the container agent and ecs-init.
 * For more information, see [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 *
 * For tasks using the Fargate launch type, the task or service requires platform version 1.3.0 or later.
 */
class AppMeshProxyConfiguration extends proxy_configuration_1.ProxyConfiguration {
    /**
     * Constructs a new instance of the AppMeshProxyConfiguration class.
     */
    constructor(props) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_AppMeshProxyConfigurationConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AppMeshProxyConfiguration);
            }
            throw error;
        }
        if (props.properties) {
            if (!props.properties.ignoredUID && !props.properties.ignoredGID) {
                throw new Error('At least one of ignoredUID or ignoredGID should be specified.');
            }
        }
    }
    /**
     * Called when the proxy configuration is configured on a task definition.
     */
    bind(_scope, _taskDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_TaskDefinition(_taskDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const configProps = this.props.properties;
        const configType = 'APPMESH';
        return {
            containerName: this.props.containerName,
            proxyConfigurationProperties: renderProperties(configProps),
            type: configType,
        };
    }
}
exports.AppMeshProxyConfiguration = AppMeshProxyConfiguration;
_a = JSII_RTTI_SYMBOL_1;
AppMeshProxyConfiguration[_a] = { fqn: "monocdk.aws_ecs.AppMeshProxyConfiguration", version: "1.185.0" };
function renderProperties(props) {
    const ret = new Array();
    for (const [k, v] of Object.entries(props)) {
        const key = String(k);
        const value = String(v);
        if (value !== 'undefined' && value !== '') {
            const capitalizedKey = key.charAt(0).toUpperCase() + key.slice(1);
            ret.push({ ['name']: capitalizedKey, ['value']: value });
        }
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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