"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplunkLogDriver = exports.SplunkLogFormat = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * Log Message Format
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * A log driver that sends log information to splunk Logs.
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        try {
            jsiiDeprecationWarnings.monocdk_aws_ecs_SplunkLogDriverProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SplunkLogDriver);
            }
            throw error;
        }
        if (!props.token && !props.secretToken) {
            throw new Error('Please provide either token or secretToken.');
        }
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        try {
            jsiiDeprecationWarnings.monocdk_Construct(_scope);
            jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        const options = utils_1.stringifyOptions({
            'splunk-token': this.props.token?.unsafeUnwrap(),
            'splunk-url': this.props.url,
            'splunk-source': this.props.source,
            'splunk-sourcetype': this.props.sourceType,
            'splunk-index': this.props.index,
            'splunk-capath': this.props.caPath,
            'splunk-caname': this.props.caName,
            'splunk-insecureskipverify': this.props.insecureSkipVerify,
            'splunk-format': this.props.format,
            'splunk-verify-connection': this.props.verifyConnection,
            'splunk-gzip': this.props.gzip,
            'splunk-gzip-level': this.props.gzipLevel,
            ...utils_1.renderCommonLogDriverOptions(this.props),
        });
        return {
            logDriver: 'splunk',
            options,
            secretOptions: this.props.secretToken && utils_1.renderLogDriverSecretOptions({ 'splunk-token': this.props.secretToken }, _containerDefinition.taskDefinition),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
_a = JSII_RTTI_SYMBOL_1;
SplunkLogDriver[_a] = { fqn: "monocdk.aws_ecs.SplunkLogDriver", version: "1.185.0" };
//# sourceMappingURL=data:application/json;base64,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